package org.cloudfoundry.client.v3.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response payload for the apply manifest operation
 */
@Generated(from = "_ApplyManifestRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplyManifestRequest extends org.cloudfoundry.client.v3.spaces._ApplyManifestRequest {
  private final byte[] manifest;
  private final String spaceId;

  private ApplyManifestRequest(ApplyManifestRequest.Builder builder) {
    this.manifest = builder.manifest;
    this.spaceId = builder.spaceId;
  }

  /**
   * The manifest to apply
   */
  @JsonProperty("manifest")
  @JsonIgnore
  @Override
  public byte[] getManifest() {
    return manifest.clone();
  }

  /**
   * The space id
   */
  @JsonProperty("spaceId")
  @JsonIgnore
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code ApplyManifestRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplyManifestRequest
        && equalTo(0, (ApplyManifestRequest) another);
  }

  private boolean equalTo(int synthetic, ApplyManifestRequest another) {
    return Arrays.equals(manifest, another.manifest)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code manifest}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(manifest);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplyManifestRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplyManifestRequest{"
        + "manifest=" + Arrays.toString(manifest)
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ApplyManifestRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.spaces._ApplyManifestRequest {
    byte[] manifest;
    String spaceId;
    @JsonProperty("manifest")
    @JsonIgnore
    public void setManifest(byte[] manifest) {
      this.manifest = manifest;
    }
    @JsonProperty("spaceId")
    @JsonIgnore
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @Override
    public byte[] getManifest() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplyManifestRequest fromJson(Json json) {
    ApplyManifestRequest.Builder builder = ApplyManifestRequest.builder();
    if (json.manifest != null) {
      builder.manifest(json.manifest);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplyManifestRequest ApplyManifestRequest}.
   * <pre>
   * ApplyManifestRequest.builder()
   *    .manifest(byte) // required {@link ApplyManifestRequest#getManifest() manifest}
   *    .spaceId(String) // required {@link ApplyManifestRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new ApplyManifestRequest builder
   */
  public static ApplyManifestRequest.Builder builder() {
    return new ApplyManifestRequest.Builder();
  }

  /**
   * Builds instances of type {@link ApplyManifestRequest ApplyManifestRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplyManifestRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MANIFEST = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private byte[] manifest;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplyManifestRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplyManifestRequest instance) {
      return from((_ApplyManifestRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ApplyManifestRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplyManifestRequest instance) {
      Objects.requireNonNull(instance, "instance");
      manifest(instance.getManifest());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link ApplyManifestRequest#getManifest() manifest} attribute.
     * @param manifest The elements for manifest
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manifest(byte... manifest) {
      this.manifest = manifest.clone();
      initBits &= ~INIT_BIT_MANIFEST;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplyManifestRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link ApplyManifestRequest ApplyManifestRequest}.
     * @return An immutable instance of ApplyManifestRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplyManifestRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplyManifestRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANIFEST) != 0) attributes.add("manifest");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build ApplyManifestRequest, some of required attributes are not set " + attributes;
    }
  }
}
