package org.cloudfoundry.client.v3.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Unmapped Routes operation
 */
@Generated(from = "_DeleteUnmappedRoutesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteUnmappedRoutesRequest
    extends org.cloudfoundry.client.v3.spaces._DeleteUnmappedRoutesRequest {
  private final String spaceId;

  private DeleteUnmappedRoutesRequest(DeleteUnmappedRoutesRequest.Builder builder) {
    this.spaceId = builder.spaceId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteUnmappedRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteUnmappedRoutesRequest
        && equalTo(0, (DeleteUnmappedRoutesRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteUnmappedRoutesRequest another) {
    return spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteUnmappedRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteUnmappedRoutesRequest{"
        + "spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteUnmappedRoutesRequest DeleteUnmappedRoutesRequest}.
   * <pre>
   * DeleteUnmappedRoutesRequest.builder()
   *    .spaceId(String) // required {@link DeleteUnmappedRoutesRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new DeleteUnmappedRoutesRequest builder
   */
  public static DeleteUnmappedRoutesRequest.Builder builder() {
    return new DeleteUnmappedRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteUnmappedRoutesRequest DeleteUnmappedRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteUnmappedRoutesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteUnmappedRoutesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteUnmappedRoutesRequest instance) {
      return from((_DeleteUnmappedRoutesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteUnmappedRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteUnmappedRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteUnmappedRoutesRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteUnmappedRoutesRequest DeleteUnmappedRoutesRequest}.
     * @return An immutable instance of DeleteUnmappedRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteUnmappedRoutesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteUnmappedRoutesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build DeleteUnmappedRoutesRequest, some of required attributes are not set " + attributes;
    }
  }
}
