package org.cloudfoundry.client.v3.stacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Stack operation
 */
@Generated(from = "_DeleteStackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteStackRequest extends org.cloudfoundry.client.v3.stacks._DeleteStackRequest {
  private final String stackId;

  private DeleteStackRequest(DeleteStackRequest.Builder builder) {
    this.stackId = builder.stackId;
  }

  /**
   * The stack id
   */
  @Override
  public String getStackId() {
    return stackId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteStackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteStackRequest
        && equalTo(0, (DeleteStackRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteStackRequest another) {
    return stackId.equals(another.stackId);
  }

  /**
   * Computes a hash code from attributes: {@code stackId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + stackId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteStackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteStackRequest{"
        + "stackId=" + stackId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteStackRequest DeleteStackRequest}.
   * <pre>
   * DeleteStackRequest.builder()
   *    .stackId(String) // required {@link DeleteStackRequest#getStackId() stackId}
   *    .build();
   * </pre>
   * @return A new DeleteStackRequest builder
   */
  public static DeleteStackRequest.Builder builder() {
    return new DeleteStackRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteStackRequest DeleteStackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteStackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_STACK_ID = 0x1L;
    private long initBits = 0x1L;

    private String stackId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteStackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteStackRequest instance) {
      return from((_DeleteStackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteStackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteStackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      stackId(instance.getStackId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteStackRequest#getStackId() stackId} attribute.
     * @param stackId The value for stackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(String stackId) {
      this.stackId = Objects.requireNonNull(stackId, "stackId");
      initBits &= ~INIT_BIT_STACK_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteStackRequest DeleteStackRequest}.
     * @return An immutable instance of DeleteStackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteStackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteStackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STACK_ID) != 0) attributes.add("stackId");
      return "Cannot build DeleteStackRequest, some of required attributes are not set " + attributes;
    }
  }
}
