package org.cloudfoundry.client.v3.stacks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Stack operation
 */
@Generated(from = "_UpdateStackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateStackRequest extends org.cloudfoundry.client.v3.stacks._UpdateStackRequest {
  private final @Nullable Metadata metadata;
  private final String stackId;

  private UpdateStackRequest(UpdateStackRequest.Builder builder) {
    this.metadata = builder.metadata;
    this.stackId = builder.stackId;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The stack id
   */
  @JsonProperty("stackId")
  @JsonIgnore
  @Override
  public String getStackId() {
    return stackId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateStackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateStackRequest
        && equalTo(0, (UpdateStackRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateStackRequest another) {
    return Objects.equals(metadata, another.metadata)
        && stackId.equals(another.stackId);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}, {@code stackId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + stackId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateStackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateStackRequest{"
        + "metadata=" + metadata
        + ", stackId=" + stackId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateStackRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.stacks._UpdateStackRequest {
    Metadata metadata;
    String stackId;
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("stackId")
    @JsonIgnore
    public void setStackId(String stackId) {
      this.stackId = stackId;
    }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getStackId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateStackRequest fromJson(Json json) {
    UpdateStackRequest.Builder builder = UpdateStackRequest.builder();
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.stackId != null) {
      builder.stackId(json.stackId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateStackRequest UpdateStackRequest}.
   * <pre>
   * UpdateStackRequest.builder()
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link UpdateStackRequest#getMetadata() metadata}
   *    .stackId(String) // required {@link UpdateStackRequest#getStackId() stackId}
   *    .build();
   * </pre>
   * @return A new UpdateStackRequest builder
   */
  public static UpdateStackRequest.Builder builder() {
    return new UpdateStackRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateStackRequest UpdateStackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateStackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_STACK_ID = 0x1L;
    private long initBits = 0x1L;

    private Metadata metadata;
    private String stackId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateStackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateStackRequest instance) {
      return from((_UpdateStackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateStackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateStackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      stackId(instance.getStackId());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateStackRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateStackRequest#getStackId() stackId} attribute.
     * @param stackId The value for stackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(String stackId) {
      this.stackId = Objects.requireNonNull(stackId, "stackId");
      initBits &= ~INIT_BIT_STACK_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateStackRequest UpdateStackRequest}.
     * @return An immutable instance of UpdateStackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateStackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateStackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STACK_ID) != 0) attributes.add("stackId");
      return "Cannot build UpdateStackRequest, some of required attributes are not set " + attributes;
    }
  }
}
