package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Task endpoint
 */
@Generated(from = "_CreateTaskRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateTaskRequest extends org.cloudfoundry.client.v3.tasks._CreateTaskRequest {
  private final String applicationId;
  private final String command;
  private final @Nullable Integer diskInMb;
  private final @Nullable String dropletId;
  private final @Nullable Integer memoryInMb;
  private final @Nullable String name;

  private CreateTaskRequest(CreateTaskRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.command = builder.command;
    this.diskInMb = builder.diskInMb;
    this.dropletId = builder.dropletId;
    this.memoryInMb = builder.memoryInMb;
    this.name = builder.name;
  }

  /**
   * The application id
   */
  @JsonProperty("applicationId")
  @JsonIgnore
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The command that will be executed
   */
  @JsonProperty("command")
  @Override
  public String getCommand() {
    return command;
  }

  /**
   * Amount of disk to allocate for the task in MB
   */
  @JsonProperty("disk_in_mb")
  @Override
  public @Nullable Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The id of the droplet that will be used to run the command
   */
  @JsonProperty("droplet_guid")
  @Override
  public @Nullable String getDropletId() {
    return dropletId;
  }

  /**
   * The amount of memory to allocate for the task in MB
   */
  @JsonProperty("memory_in_mb")
  @Override
  public @Nullable Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The name of the task
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code CreateTaskRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateTaskRequest
        && equalTo(0, (CreateTaskRequest) another);
  }

  private boolean equalTo(int synthetic, CreateTaskRequest another) {
    return applicationId.equals(another.applicationId)
        && command.equals(another.command)
        && Objects.equals(diskInMb, another.diskInMb)
        && Objects.equals(dropletId, another.dropletId)
        && Objects.equals(memoryInMb, another.memoryInMb)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code command}, {@code diskInMb}, {@code dropletId}, {@code memoryInMb}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + command.hashCode();
    h += (h << 5) + Objects.hashCode(diskInMb);
    h += (h << 5) + Objects.hashCode(dropletId);
    h += (h << 5) + Objects.hashCode(memoryInMb);
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateTaskRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateTaskRequest{"
        + "applicationId=" + applicationId
        + ", command=" + command
        + ", diskInMb=" + diskInMb
        + ", dropletId=" + dropletId
        + ", memoryInMb=" + memoryInMb
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateTaskRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.tasks._CreateTaskRequest {
    String applicationId;
    String command;
    Integer diskInMb;
    String dropletId;
    Integer memoryInMb;
    String name;
    @JsonProperty("applicationId")
    @JsonIgnore
    public void setApplicationId(String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("command")
    public void setCommand(String command) {
      this.command = command;
    }
    @JsonProperty("disk_in_mb")
    public void setDiskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
    }
    @JsonProperty("droplet_guid")
    public void setDropletId(@Nullable String dropletId) {
      this.dropletId = dropletId;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public String getDropletId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateTaskRequest fromJson(Json json) {
    CreateTaskRequest.Builder builder = CreateTaskRequest.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.diskInMb != null) {
      builder.diskInMb(json.diskInMb);
    }
    if (json.dropletId != null) {
      builder.dropletId(json.dropletId);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateTaskRequest CreateTaskRequest}.
   * <pre>
   * CreateTaskRequest.builder()
   *    .applicationId(String) // required {@link CreateTaskRequest#getApplicationId() applicationId}
   *    .command(String) // required {@link CreateTaskRequest#getCommand() command}
   *    .diskInMb(Integer | null) // nullable {@link CreateTaskRequest#getDiskInMb() diskInMb}
   *    .dropletId(String | null) // nullable {@link CreateTaskRequest#getDropletId() dropletId}
   *    .memoryInMb(Integer | null) // nullable {@link CreateTaskRequest#getMemoryInMb() memoryInMb}
   *    .name(String | null) // nullable {@link CreateTaskRequest#getName() name}
   *    .build();
   * </pre>
   * @return A new CreateTaskRequest builder
   */
  public static CreateTaskRequest.Builder builder() {
    return new CreateTaskRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateTaskRequest CreateTaskRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateTaskRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_COMMAND = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String command;
    private Integer diskInMb;
    private String dropletId;
    private Integer memoryInMb;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateTaskRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateTaskRequest instance) {
      return from((_CreateTaskRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateTaskRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateTaskRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      command(instance.getCommand());
      Integer diskInMbValue = instance.getDiskInMb();
      if (diskInMbValue != null) {
        diskInMb(diskInMbValue);
      }
      String dropletIdValue = instance.getDropletId();
      if (dropletIdValue != null) {
        dropletId(dropletIdValue);
      }
      Integer memoryInMbValue = instance.getMemoryInMb();
      if (memoryInMbValue != null) {
        memoryInMb(memoryInMbValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateTaskRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateTaskRequest#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateTaskRequest#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateTaskRequest#getDropletId() dropletId} attribute.
     * @param dropletId The value for dropletId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(@Nullable String dropletId) {
      this.dropletId = dropletId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateTaskRequest#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateTaskRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link CreateTaskRequest CreateTaskRequest}.
     * @return An immutable instance of CreateTaskRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateTaskRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateTaskRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      return "Cannot build CreateTaskRequest, some of required attributes are not set " + attributes;
    }
  }
}
