package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Task endpoint
 */
@Generated(from = "_GetTaskRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetTaskRequest extends org.cloudfoundry.client.v3.tasks._GetTaskRequest {
  private final String taskId;

  private GetTaskRequest(GetTaskRequest.Builder builder) {
    this.taskId = builder.taskId;
  }

  /**
   * The task id
   */
  @Override
  public String getTaskId() {
    return taskId;
  }

  /**
   * This instance is equal to all instances of {@code GetTaskRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTaskRequest
        && equalTo(0, (GetTaskRequest) another);
  }

  private boolean equalTo(int synthetic, GetTaskRequest another) {
    return taskId.equals(another.taskId);
  }

  /**
   * Computes a hash code from attributes: {@code taskId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + taskId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTaskRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTaskRequest{"
        + "taskId=" + taskId
        + "}";
  }

  /**
   * Creates a builder for {@link GetTaskRequest GetTaskRequest}.
   * <pre>
   * GetTaskRequest.builder()
   *    .taskId(String) // required {@link GetTaskRequest#getTaskId() taskId}
   *    .build();
   * </pre>
   * @return A new GetTaskRequest builder
   */
  public static GetTaskRequest.Builder builder() {
    return new GetTaskRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetTaskRequest GetTaskRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetTaskRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TASK_ID = 0x1L;
    private long initBits = 0x1L;

    private String taskId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTaskRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTaskRequest instance) {
      return from((_GetTaskRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetTaskRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTaskRequest instance) {
      Objects.requireNonNull(instance, "instance");
      taskId(instance.getTaskId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetTaskRequest#getTaskId() taskId} attribute.
     * @param taskId The value for taskId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskId(String taskId) {
      this.taskId = Objects.requireNonNull(taskId, "taskId");
      initBits &= ~INIT_BIT_TASK_ID;
      return this;
    }

    /**
     * Builds a new {@link GetTaskRequest GetTaskRequest}.
     * @return An immutable instance of GetTaskRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTaskRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTaskRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TASK_ID) != 0) attributes.add("taskId");
      return "Cannot build GetTaskRequest, some of required attributes are not set " + attributes;
    }
  }
}
