package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Applications operation
 */
@Generated(from = "_ListTasksRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListTasksRequest extends org.cloudfoundry.client.v3.tasks._ListTasksRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> applicationIds;
  private final List<String> names;
  private final List<String> organizationIds;
  private final List<String> spaceIds;
  private final List<TaskState> states;
  private final List<String> taskIds;

  private ListTasksRequest(ListTasksRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.applicationIds = createUnmodifiableList(true, builder.applicationIds);
    this.names = createUnmodifiableList(true, builder.names);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.states = createUnmodifiableList(true, builder.states);
    this.taskIds = createUnmodifiableList(true, builder.taskIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The application ids
   */
  @Override
  public List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The names
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The states
   */
  @Override
  public List<TaskState> getStates() {
    return states;
  }

  /**
   * The ids
   */
  @Override
  public List<String> getTaskIds() {
    return taskIds;
  }

  /**
   * This instance is equal to all instances of {@code ListTasksRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListTasksRequest
        && equalTo(0, (ListTasksRequest) another);
  }

  private boolean equalTo(int synthetic, ListTasksRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && applicationIds.equals(another.applicationIds)
        && names.equals(another.names)
        && organizationIds.equals(another.organizationIds)
        && spaceIds.equals(another.spaceIds)
        && states.equals(another.states)
        && taskIds.equals(another.taskIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code applicationIds}, {@code names}, {@code organizationIds}, {@code spaceIds}, {@code states}, {@code taskIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + applicationIds.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    h += (h << 5) + states.hashCode();
    h += (h << 5) + taskIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListTasksRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListTasksRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", applicationIds=" + applicationIds
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", states=" + states
        + ", taskIds=" + taskIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListTasksRequest ListTasksRequest}.
   * <pre>
   * ListTasksRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListTasksRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListTasksRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListTasksRequest#getPerPage() perPage}
   *    .applicationId|addAllApplicationIds(String) // {@link ListTasksRequest#getApplicationIds() applicationIds} elements
   *    .name|addAllNames(String) // {@link ListTasksRequest#getNames() names} elements
   *    .organizationId|addAllOrganizationIds(String) // {@link ListTasksRequest#getOrganizationIds() organizationIds} elements
   *    .spaceId|addAllSpaceIds(String) // {@link ListTasksRequest#getSpaceIds() spaceIds} elements
   *    .state|addAllStates(org.cloudfoundry.client.v3.tasks.TaskState) // {@link ListTasksRequest#getStates() states} elements
   *    .taskId|addAllTaskIds(String) // {@link ListTasksRequest#getTaskIds() taskIds} elements
   *    .build();
   * </pre>
   * @return A new ListTasksRequest builder
   */
  public static ListTasksRequest.Builder builder() {
    return new ListTasksRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListTasksRequest ListTasksRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListTasksRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> applicationIds = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private List<TaskState> states = new ArrayList<TaskState>();
    private List<String> taskIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListTasksRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListTasksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListTasksRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListTasksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.tasks._ListTasksRequest) {
        org.cloudfoundry.client.v3.tasks._ListTasksRequest instance = (org.cloudfoundry.client.v3.tasks._ListTasksRequest) object;
        addAllNames(instance.getNames());
        addAllSpaceIds(instance.getSpaceIds());
        addAllTaskIds(instance.getTaskIds());
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllApplicationIds(instance.getApplicationIds());
        addAllStates(instance.getStates());
      }
    }

    /**
     * Initializes the value for the {@link ListTasksRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListTasksRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListTasksRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(Iterable<String> elements) {
      this.applicationIds.clear();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListTasksRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListTasksRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListTasksRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListTasksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListTasksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListTasksRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListTasksRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListTasksRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(TaskState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListTasksRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(TaskState... elements) {
      for (TaskState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListTasksRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends TaskState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListTasksRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends TaskState> elements) {
      for (TaskState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListTasksRequest#getTaskIds() taskIds} list.
     * @param element A taskIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskId(String element) {
      this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListTasksRequest#getTaskIds() taskIds} list.
     * @param elements An array of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskIds(String... elements) {
      for (String element : elements) {
        this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListTasksRequest#getTaskIds() taskIds} list.
     * @param elements An iterable of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskIds(Iterable<String> elements) {
      this.taskIds.clear();
      return addAllTaskIds(elements);
    }

    /**
     * Adds elements to {@link ListTasksRequest#getTaskIds() taskIds} list.
     * @param elements An iterable of taskIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTaskIds(Iterable<String> elements) {
      for (String element : elements) {
        this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListTasksRequest ListTasksRequest}.
     * @return An immutable instance of ListTasksRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListTasksRequest build() {
      return new ListTasksRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
