package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Records resource usage of an application in a container
 */
@Generated(from = "_ContainerMetric", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ContainerMetric extends org.cloudfoundry.doppler._ContainerMetric {
  private final String applicationId;
  private final Double cpuPercentage;
  private final Long diskBytes;
  private final @Nullable Long diskBytesQuota;
  private final Integer instanceIndex;
  private final Long memoryBytes;
  private final @Nullable Long memoryBytesQuota;

  private ContainerMetric(ContainerMetric.Builder builder) {
    this.applicationId = builder.applicationId;
    this.cpuPercentage = builder.cpuPercentage;
    this.diskBytes = builder.diskBytes;
    this.diskBytesQuota = builder.diskBytesQuota;
    this.instanceIndex = builder.instanceIndex;
    this.memoryBytes = builder.memoryBytes;
    this.memoryBytesQuota = builder.memoryBytesQuota;
  }

  /**
   * The ID of the contained application
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The CPU used, on a scale of 0 to 100
   */
  @Override
  public Double getCpuPercentage() {
    return cpuPercentage;
  }

  /**
   * The bytes of disk used
   */
  @Override
  public Long getDiskBytes() {
    return diskBytes;
  }

  /**
   * The maximum bytes of disk allocated to container
   */
  @Override
  public @Nullable Long getDiskBytesQuota() {
    return diskBytesQuota;
  }

  /**
   * The instance index of the contained application. (This, with applicationId, should uniquely identify a container.)
   */
  @Override
  public Integer getInstanceIndex() {
    return instanceIndex;
  }

  /**
   * The bytes of memory used
   */
  @Override
  public Long getMemoryBytes() {
    return memoryBytes;
  }

  /**
   * The maximum bytes of memory allocated to container
   */
  @Override
  public @Nullable Long getMemoryBytesQuota() {
    return memoryBytesQuota;
  }

  /**
   * This instance is equal to all instances of {@code ContainerMetric} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ContainerMetric
        && equalTo(0, (ContainerMetric) another);
  }

  private boolean equalTo(int synthetic, ContainerMetric another) {
    return applicationId.equals(another.applicationId)
        && cpuPercentage.equals(another.cpuPercentage)
        && diskBytes.equals(another.diskBytes)
        && Objects.equals(diskBytesQuota, another.diskBytesQuota)
        && instanceIndex.equals(another.instanceIndex)
        && memoryBytes.equals(another.memoryBytes)
        && Objects.equals(memoryBytesQuota, another.memoryBytesQuota);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code cpuPercentage}, {@code diskBytes}, {@code diskBytesQuota}, {@code instanceIndex}, {@code memoryBytes}, {@code memoryBytesQuota}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + cpuPercentage.hashCode();
    h += (h << 5) + diskBytes.hashCode();
    h += (h << 5) + Objects.hashCode(diskBytesQuota);
    h += (h << 5) + instanceIndex.hashCode();
    h += (h << 5) + memoryBytes.hashCode();
    h += (h << 5) + Objects.hashCode(memoryBytesQuota);
    return h;
  }

  /**
   * Prints the immutable value {@code ContainerMetric} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContainerMetric{"
        + "applicationId=" + applicationId
        + ", cpuPercentage=" + cpuPercentage
        + ", diskBytes=" + diskBytes
        + ", diskBytesQuota=" + diskBytesQuota
        + ", instanceIndex=" + instanceIndex
        + ", memoryBytes=" + memoryBytes
        + ", memoryBytesQuota=" + memoryBytesQuota
        + "}";
  }

  /**
   * Creates a builder for {@link ContainerMetric ContainerMetric}.
   * <pre>
   * ContainerMetric.builder()
   *    .applicationId(String) // required {@link ContainerMetric#getApplicationId() applicationId}
   *    .cpuPercentage(Double) // required {@link ContainerMetric#getCpuPercentage() cpuPercentage}
   *    .diskBytes(Long) // required {@link ContainerMetric#getDiskBytes() diskBytes}
   *    .diskBytesQuota(Long | null) // nullable {@link ContainerMetric#getDiskBytesQuota() diskBytesQuota}
   *    .instanceIndex(Integer) // required {@link ContainerMetric#getInstanceIndex() instanceIndex}
   *    .memoryBytes(Long) // required {@link ContainerMetric#getMemoryBytes() memoryBytes}
   *    .memoryBytesQuota(Long | null) // nullable {@link ContainerMetric#getMemoryBytesQuota() memoryBytesQuota}
   *    .build();
   * </pre>
   * @return A new ContainerMetric builder
   */
  public static ContainerMetric.Builder builder() {
    return new ContainerMetric.Builder();
  }

  /**
   * Builds instances of type {@link ContainerMetric ContainerMetric}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ContainerMetric", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_CPU_PERCENTAGE = 0x2L;
    private static final long INIT_BIT_DISK_BYTES = 0x4L;
    private static final long INIT_BIT_INSTANCE_INDEX = 0x8L;
    private static final long INIT_BIT_MEMORY_BYTES = 0x10L;
    private long initBits = 0x1fL;

    private String applicationId;
    private Double cpuPercentage;
    private Long diskBytes;
    private Long diskBytesQuota;
    private Integer instanceIndex;
    private Long memoryBytes;
    private Long memoryBytesQuota;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContainerMetric} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContainerMetric instance) {
      return from((_ContainerMetric) instance);
    }

    /**
     * Copy abstract value type {@code _ContainerMetric} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ContainerMetric instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      cpuPercentage(instance.getCpuPercentage());
      diskBytes(instance.getDiskBytes());
      Long diskBytesQuotaValue = instance.getDiskBytesQuota();
      if (diskBytesQuotaValue != null) {
        diskBytesQuota(diskBytesQuotaValue);
      }
      instanceIndex(instance.getInstanceIndex());
      memoryBytes(instance.getMemoryBytes());
      Long memoryBytesQuotaValue = instance.getMemoryBytesQuota();
      if (memoryBytesQuotaValue != null) {
        memoryBytesQuota(memoryBytesQuotaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMetric#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMetric#getCpuPercentage() cpuPercentage} attribute.
     * @param cpuPercentage The value for cpuPercentage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cpuPercentage(Double cpuPercentage) {
      this.cpuPercentage = Objects.requireNonNull(cpuPercentage, "cpuPercentage");
      initBits &= ~INIT_BIT_CPU_PERCENTAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMetric#getDiskBytes() diskBytes} attribute.
     * @param diskBytes The value for diskBytes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskBytes(Long diskBytes) {
      this.diskBytes = Objects.requireNonNull(diskBytes, "diskBytes");
      initBits &= ~INIT_BIT_DISK_BYTES;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMetric#getDiskBytesQuota() diskBytesQuota} attribute.
     * @param diskBytesQuota The value for diskBytesQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskBytesQuota(@Nullable Long diskBytesQuota) {
      this.diskBytesQuota = diskBytesQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMetric#getInstanceIndex() instanceIndex} attribute.
     * @param instanceIndex The value for instanceIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceIndex(Integer instanceIndex) {
      this.instanceIndex = Objects.requireNonNull(instanceIndex, "instanceIndex");
      initBits &= ~INIT_BIT_INSTANCE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMetric#getMemoryBytes() memoryBytes} attribute.
     * @param memoryBytes The value for memoryBytes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryBytes(Long memoryBytes) {
      this.memoryBytes = Objects.requireNonNull(memoryBytes, "memoryBytes");
      initBits &= ~INIT_BIT_MEMORY_BYTES;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMetric#getMemoryBytesQuota() memoryBytesQuota} attribute.
     * @param memoryBytesQuota The value for memoryBytesQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryBytesQuota(@Nullable Long memoryBytesQuota) {
      this.memoryBytesQuota = memoryBytesQuota;
      return this;
    }

    /**
     * Builds a new {@link ContainerMetric ContainerMetric}.
     * @return An immutable instance of ContainerMetric
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ContainerMetric build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ContainerMetric(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_CPU_PERCENTAGE) != 0) attributes.add("cpuPercentage");
      if ((initBits & INIT_BIT_DISK_BYTES) != 0) attributes.add("diskBytes");
      if ((initBits & INIT_BIT_INSTANCE_INDEX) != 0) attributes.add("instanceIndex");
      if ((initBits & INIT_BIT_MEMORY_BYTES) != 0) attributes.add("memoryBytes");
      return "Cannot build ContainerMetric, some of required attributes are not set " + attributes;
    }
  }
}
