package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * An Error event represents an error in the originating process
 */
@Generated(from = "_Error", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Error extends org.cloudfoundry.doppler._Error {
  private final Integer code;
  private final String message;
  private final String source;

  private Error(Error.Builder builder) {
    this.code = builder.code;
    this.message = builder.message;
    this.source = builder.source;
  }

  /**
   * The numeric error code. This is provided for programmatic responses to the error.
   */
  @Override
  public Integer getCode() {
    return code;
  }

  /**
   * The error description (preferably human-readable)
   */
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * The source of the error
   */
  @Override
  public String getSource() {
    return source;
  }

  /**
   * This instance is equal to all instances of {@code Error} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Error
        && equalTo(0, (Error) another);
  }

  private boolean equalTo(int synthetic, Error another) {
    return code.equals(another.code)
        && message.equals(another.message)
        && source.equals(another.source);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code message}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + code.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + source.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Error{"
        + "code=" + code
        + ", message=" + message
        + ", source=" + source
        + "}";
  }

  /**
   * Creates a builder for {@link Error Error}.
   * <pre>
   * Error.builder()
   *    .code(Integer) // required {@link Error#getCode() code}
   *    .message(String) // required {@link Error#getMessage() message}
   *    .source(String) // required {@link Error#getSource() source}
   *    .build();
   * </pre>
   * @return A new Error builder
   */
  public static Error.Builder builder() {
    return new Error.Builder();
  }

  /**
   * Builds instances of type {@link Error Error}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Error", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CODE = 0x1L;
    private static final long INIT_BIT_MESSAGE = 0x2L;
    private static final long INIT_BIT_SOURCE = 0x4L;
    private long initBits = 0x7L;

    private Integer code;
    private String message;
    private String source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Error} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Error instance) {
      return from((_Error) instance);
    }

    /**
     * Copy abstract value type {@code _Error} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Error instance) {
      Objects.requireNonNull(instance, "instance");
      code(instance.getCode());
      message(instance.getMessage());
      source(instance.getSource());
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getCode() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder code(Integer code) {
      this.code = Objects.requireNonNull(code, "code");
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link Error#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Builds a new {@link Error Error}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Error build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Error(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      return "Cannot build Error, some of required attributes are not set " + attributes;
    }
  }
}
