package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Contains a "log line" and associated metadata.
 */
@Generated(from = "_LogMessage", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class LogMessage extends org.cloudfoundry.doppler._LogMessage {
  private final @Nullable String applicationId;
  private final String message;
  private final MessageType messageType;
  private final @Nullable String sourceInstance;
  private final @Nullable String sourceType;
  private final Long timestamp;

  private LogMessage(LogMessage.Builder builder) {
    this.applicationId = builder.applicationId;
    this.message = builder.message;
    this.messageType = builder.messageType;
    this.sourceInstance = builder.sourceInstance;
    this.sourceType = builder.sourceType;
    this.timestamp = builder.timestamp;
  }

  /**
   * The application that emitted the message (or to which the application is related)
   */
  @Override
  public @Nullable String getApplicationId() {
    return applicationId;
  }

  /**
   * The log message
   */
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * The type of the message
   */
  @Override
  public MessageType getMessageType() {
    return messageType;
  }

  /**
   * The instance that emitted the message
   */
  @Override
  public @Nullable String getSourceInstance() {
    return sourceInstance;
  }

  /**
   * The source of the message. For Cloud Foundry, this can be {@code APPLICATION}, {@code RTR}, {@code DEA}, {@code STG}, etc.
   */
  @Override
  public @Nullable String getSourceType() {
    return sourceType;
  }

  /**
   * The UNIX timestamp (in nanoseconds) when the log was written
   */
  @Override
  public Long getTimestamp() {
    return timestamp;
  }

  /**
   * This instance is equal to all instances of {@code LogMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof LogMessage
        && equalTo(0, (LogMessage) another);
  }

  private boolean equalTo(int synthetic, LogMessage another) {
    return Objects.equals(applicationId, another.applicationId)
        && message.equals(another.message)
        && messageType.equals(another.messageType)
        && Objects.equals(sourceInstance, another.sourceInstance)
        && Objects.equals(sourceType, another.sourceType)
        && timestamp.equals(another.timestamp);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code message}, {@code messageType}, {@code sourceInstance}, {@code sourceType}, {@code timestamp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationId);
    h += (h << 5) + message.hashCode();
    h += (h << 5) + messageType.hashCode();
    h += (h << 5) + Objects.hashCode(sourceInstance);
    h += (h << 5) + Objects.hashCode(sourceType);
    h += (h << 5) + timestamp.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LogMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LogMessage{"
        + "applicationId=" + applicationId
        + ", message=" + message
        + ", messageType=" + messageType
        + ", sourceInstance=" + sourceInstance
        + ", sourceType=" + sourceType
        + ", timestamp=" + timestamp
        + "}";
  }

  /**
   * Creates a builder for {@link LogMessage LogMessage}.
   * <pre>
   * LogMessage.builder()
   *    .applicationId(String | null) // nullable {@link LogMessage#getApplicationId() applicationId}
   *    .message(String) // required {@link LogMessage#getMessage() message}
   *    .messageType(org.cloudfoundry.doppler.MessageType) // required {@link LogMessage#getMessageType() messageType}
   *    .sourceInstance(String | null) // nullable {@link LogMessage#getSourceInstance() sourceInstance}
   *    .sourceType(String | null) // nullable {@link LogMessage#getSourceType() sourceType}
   *    .timestamp(Long) // required {@link LogMessage#getTimestamp() timestamp}
   *    .build();
   * </pre>
   * @return A new LogMessage builder
   */
  public static LogMessage.Builder builder() {
    return new LogMessage.Builder();
  }

  /**
   * Builds instances of type {@link LogMessage LogMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_LogMessage", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE = 0x1L;
    private static final long INIT_BIT_MESSAGE_TYPE = 0x2L;
    private static final long INIT_BIT_TIMESTAMP = 0x4L;
    private long initBits = 0x7L;

    private String applicationId;
    private String message;
    private MessageType messageType;
    private String sourceInstance;
    private String sourceType;
    private Long timestamp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LogMessage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LogMessage instance) {
      return from((_LogMessage) instance);
    }

    /**
     * Copy abstract value type {@code _LogMessage} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_LogMessage instance) {
      Objects.requireNonNull(instance, "instance");
      String applicationIdValue = instance.getApplicationId();
      if (applicationIdValue != null) {
        applicationId(applicationIdValue);
      }
      message(instance.getMessage());
      messageType(instance.getMessageType());
      String sourceInstanceValue = instance.getSourceInstance();
      if (sourceInstanceValue != null) {
        sourceInstance(sourceInstanceValue);
      }
      String sourceTypeValue = instance.getSourceType();
      if (sourceTypeValue != null) {
        sourceType(sourceTypeValue);
      }
      timestamp(instance.getTimestamp());
      return this;
    }

    /**
     * Initializes the value for the {@link LogMessage#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link LogMessage#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link LogMessage#getMessageType() messageType} attribute.
     * @param messageType The value for messageType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder messageType(MessageType messageType) {
      this.messageType = Objects.requireNonNull(messageType, "messageType");
      initBits &= ~INIT_BIT_MESSAGE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link LogMessage#getSourceInstance() sourceInstance} attribute.
     * @param sourceInstance The value for sourceInstance (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceInstance(@Nullable String sourceInstance) {
      this.sourceInstance = sourceInstance;
      return this;
    }

    /**
     * Initializes the value for the {@link LogMessage#getSourceType() sourceType} attribute.
     * @param sourceType The value for sourceType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceType(@Nullable String sourceType) {
      this.sourceType = sourceType;
      return this;
    }

    /**
     * Initializes the value for the {@link LogMessage#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(Long timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Builds a new {@link LogMessage LogMessage}.
     * @return An immutable instance of LogMessage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LogMessage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new LogMessage(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_MESSAGE_TYPE) != 0) attributes.add("messageType");
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      return "Cannot build LogMessage, some of required attributes are not set " + attributes;
    }
  }
}
