package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Log}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Log.builder()}.
 */
@Generated(from = "_Log", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Log extends org.cloudfoundry.logcache.v1._Log {
  private final @Nullable String payload;
  private final @Nullable LogType type;

  private Log(Log.Builder builder) {
    this.payload = builder.payload;
    this.type = builder.type;
  }

  /**
   * The log payload
   */
  @JsonProperty("payload")
  @Override
  public @Nullable String getPayload() {
    return payload;
  }

  /**
   * The log type
   */
  @JsonProperty("type")
  @Override
  public @Nullable LogType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Log} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Log
        && equalTo(0, (Log) another);
  }

  private boolean equalTo(int synthetic, Log another) {
    return Objects.equals(payload, another.payload)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code payload}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(payload);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Log} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Log{"
        + "payload=" + payload
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Log", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Log {
    String payload;
    LogType type;
    @JsonProperty("payload")
    public void setPayload(@Nullable String payload) {
      this.payload = payload;
    }
    @JsonProperty("type")
    public void setType(@Nullable LogType type) {
      this.type = type;
    }
    @Override
    public String getPayload() { throw new UnsupportedOperationException(); }
    @Override
    public LogType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Log fromJson(Json json) {
    Log.Builder builder = Log.builder();
    if (json.payload != null) {
      builder.payload(json.payload);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Log Log}.
   * <pre>
   * Log.builder()
   *    .payload(String | null) // nullable {@link Log#getPayload() payload}
   *    .type(org.cloudfoundry.logcache.v1.LogType | null) // nullable {@link Log#getType() type}
   *    .build();
   * </pre>
   * @return A new Log builder
   */
  public static Log.Builder builder() {
    return new Log.Builder();
  }

  /**
   * Builds instances of type {@link Log Log}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Log", generator = "Immutables")
  public static final class Builder {
    private String payload;
    private LogType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Log} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Log instance) {
      return from((_Log) instance);
    }

    /**
     * Copy abstract value type {@code _Log} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Log instance) {
      Objects.requireNonNull(instance, "instance");
      String payloadValue = instance.getPayload();
      if (payloadValue != null) {
        payload(payloadValue);
      }
      LogType typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Log#getPayload() payload} attribute.
     * @param payload The value for payload (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("payload")
    public final Builder payload(@Nullable String payload) {
      this.payload = payload;
      return this;
    }

    /**
     * Initializes the value for the {@link Log#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable LogType type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link Log Log}.
     * @return An immutable instance of Log
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Log build() {
      return new Log(this);
    }
  }
}
