package org.cloudfoundry.networking.v1.tags;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for Tag responses
 */
@Generated(from = "_Tag", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Tag extends org.cloudfoundry.networking.v1.tags._Tag {
  private final String id;
  private final String tag;
  private final @Nullable String type;

  private Tag(Tag.Builder builder) {
    this.id = builder.id;
    this.tag = builder.tag;
    this.type = builder.type;
  }

  /**
   * Id for the policy group
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Tag for the policy group
   */
  @JsonProperty("tag")
  @Override
  public String getTag() {
    return tag;
  }

  /**
   * Type for the policy group
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Tag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Tag
        && equalTo(0, (Tag) another);
  }

  private boolean equalTo(int synthetic, Tag another) {
    return id.equals(another.id)
        && tag.equals(another.tag)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code tag}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + tag.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Tag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Tag{"
        + "id=" + id
        + ", tag=" + tag
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Tag", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.networking.v1.tags._Tag {
    String id;
    String tag;
    String type;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("tag")
    public void setTag(String tag) {
      this.tag = tag;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTag() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Tag fromJson(Json json) {
    Tag.Builder builder = Tag.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.tag != null) {
      builder.tag(json.tag);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Tag Tag}.
   * <pre>
   * Tag.builder()
   *    .id(String) // required {@link Tag#getId() id}
   *    .tag(String) // required {@link Tag#getTag() tag}
   *    .type(String | null) // nullable {@link Tag#getType() type}
   *    .build();
   * </pre>
   * @return A new Tag builder
   */
  public static Tag.Builder builder() {
    return new Tag.Builder();
  }

  /**
   * Builds instances of type {@link Tag Tag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Tag", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TAG = 0x2L;
    private long initBits = 0x3L;

    private String id;
    private String tag;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Tag} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Tag instance) {
      return from((_Tag) instance);
    }

    /**
     * Copy abstract value type {@code _Tag} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Tag instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      tag(instance.getTag());
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#getTag() tag} attribute.
     * @param tag The value for tag 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tag")
    public final Builder tag(String tag) {
      this.tag = Objects.requireNonNull(tag, "tag");
      initBits &= ~INIT_BIT_TAG;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link Tag Tag}.
     * @return An immutable instance of Tag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Tag build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Tag(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TAG) != 0) attributes.add("tag");
      return "Cannot build Tag, some of required attributes are not set " + attributes;
    }
  }
}
