package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.routing.v1.ModificationTag;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _TcpRouteEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code TcpRouteEvent.builder()}.
 */
@Generated(from = "_TcpRouteEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class TcpRouteEvent extends org.cloudfoundry.routing.v1.tcproutes._TcpRouteEvent {
  private final String backendIp;
  private final Integer backendPort;
  private final @Nullable String isolationSegment;
  private final ModificationTag modificationTag;
  private final Integer port;
  private final String routerGroupId;
  private final Integer ttl;
  private final EventType eventType;

  private TcpRouteEvent(TcpRouteEvent.Builder builder) {
    this.backendIp = builder.backendIp;
    this.backendPort = builder.backendPort;
    this.isolationSegment = builder.isolationSegment;
    this.modificationTag = builder.modificationTag;
    this.port = builder.port;
    this.routerGroupId = builder.routerGroupId;
    this.ttl = builder.ttl;
    this.eventType = builder.eventType;
  }

  /**
   * IP address of backend.
   */
  @JsonProperty("backend_ip")
  @Override
  public String getBackendIp() {
    return backendIp;
  }

  /**
   * Backend port.
   */
  @JsonProperty("backend_port")
  @Override
  public Integer getBackendPort() {
    return backendPort;
  }

  /**
   * The isolation segment
   */
  @JsonProperty("isolation_segment")
  @Override
  public @Nullable String getIsolationSegment() {
    return isolationSegment;
  }

  /**
   * Modification Tag for the route.
   */
  @JsonProperty("modification_tag")
  @Override
  public ModificationTag getModificationTag() {
    return modificationTag;
  }

  /**
   * External facing port for the TCP route.
   */
  @JsonProperty("port")
  @Override
  public Integer getPort() {
    return port;
  }

  /**
   * ID of the router group associated with this route.
   */
  @JsonProperty("router_group_guid")
  @Override
  public String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * Time to live, in seconds.
   */
  @JsonProperty("ttl")
  @Override
  public Integer getTtl() {
    return ttl;
  }

  /**
   * The event type
   */
  @JsonProperty("eventType")
  @Override
  public EventType getEventType() {
    return eventType;
  }

  /**
   * This instance is equal to all instances of {@code TcpRouteEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TcpRouteEvent
        && equalTo(0, (TcpRouteEvent) another);
  }

  private boolean equalTo(int synthetic, TcpRouteEvent another) {
    return backendIp.equals(another.backendIp)
        && backendPort.equals(another.backendPort)
        && Objects.equals(isolationSegment, another.isolationSegment)
        && modificationTag.equals(another.modificationTag)
        && port.equals(another.port)
        && routerGroupId.equals(another.routerGroupId)
        && ttl.equals(another.ttl)
        && eventType.equals(another.eventType);
  }

  /**
   * Computes a hash code from attributes: {@code backendIp}, {@code backendPort}, {@code isolationSegment}, {@code modificationTag}, {@code port}, {@code routerGroupId}, {@code ttl}, {@code eventType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + backendIp.hashCode();
    h += (h << 5) + backendPort.hashCode();
    h += (h << 5) + Objects.hashCode(isolationSegment);
    h += (h << 5) + modificationTag.hashCode();
    h += (h << 5) + port.hashCode();
    h += (h << 5) + routerGroupId.hashCode();
    h += (h << 5) + ttl.hashCode();
    h += (h << 5) + eventType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TcpRouteEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TcpRouteEvent{"
        + "backendIp=" + backendIp
        + ", backendPort=" + backendPort
        + ", isolationSegment=" + isolationSegment
        + ", modificationTag=" + modificationTag
        + ", port=" + port
        + ", routerGroupId=" + routerGroupId
        + ", ttl=" + ttl
        + ", eventType=" + eventType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_TcpRouteEvent", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.tcproutes._TcpRouteEvent {
    String backendIp;
    Integer backendPort;
    String isolationSegment;
    ModificationTag modificationTag;
    Integer port;
    String routerGroupId;
    Integer ttl;
    EventType eventType;
    @JsonProperty("backend_ip")
    public void setBackendIp(String backendIp) {
      this.backendIp = backendIp;
    }
    @JsonProperty("backend_port")
    public void setBackendPort(Integer backendPort) {
      this.backendPort = backendPort;
    }
    @JsonProperty("isolation_segment")
    public void setIsolationSegment(@Nullable String isolationSegment) {
      this.isolationSegment = isolationSegment;
    }
    @JsonProperty("modification_tag")
    public void setModificationTag(ModificationTag modificationTag) {
      this.modificationTag = modificationTag;
    }
    @JsonProperty("port")
    public void setPort(Integer port) {
      this.port = port;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("ttl")
    public void setTtl(Integer ttl) {
      this.ttl = ttl;
    }
    @JsonProperty("eventType")
    public void setEventType(EventType eventType) {
      this.eventType = eventType;
    }
    @Override
    public String getBackendIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getBackendPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getIsolationSegment() { throw new UnsupportedOperationException(); }
    @Override
    public ModificationTag getModificationTag() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTtl() { throw new UnsupportedOperationException(); }
    @Override
    public EventType getEventType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static TcpRouteEvent fromJson(Json json) {
    TcpRouteEvent.Builder builder = TcpRouteEvent.builder();
    if (json.backendIp != null) {
      builder.backendIp(json.backendIp);
    }
    if (json.backendPort != null) {
      builder.backendPort(json.backendPort);
    }
    if (json.isolationSegment != null) {
      builder.isolationSegment(json.isolationSegment);
    }
    if (json.modificationTag != null) {
      builder.modificationTag(json.modificationTag);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.ttl != null) {
      builder.ttl(json.ttl);
    }
    if (json.eventType != null) {
      builder.eventType(json.eventType);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TcpRouteEvent TcpRouteEvent}.
   * <pre>
   * TcpRouteEvent.builder()
   *    .backendIp(String) // required {@link TcpRouteEvent#getBackendIp() backendIp}
   *    .backendPort(Integer) // required {@link TcpRouteEvent#getBackendPort() backendPort}
   *    .isolationSegment(String | null) // nullable {@link TcpRouteEvent#getIsolationSegment() isolationSegment}
   *    .modificationTag(org.cloudfoundry.routing.v1.ModificationTag) // required {@link TcpRouteEvent#getModificationTag() modificationTag}
   *    .port(Integer) // required {@link TcpRouteEvent#getPort() port}
   *    .routerGroupId(String) // required {@link TcpRouteEvent#getRouterGroupId() routerGroupId}
   *    .ttl(Integer) // required {@link TcpRouteEvent#getTtl() ttl}
   *    .eventType(org.cloudfoundry.routing.v1.tcproutes.EventType) // required {@link TcpRouteEvent#getEventType() eventType}
   *    .build();
   * </pre>
   * @return A new TcpRouteEvent builder
   */
  public static TcpRouteEvent.Builder builder() {
    return new TcpRouteEvent.Builder();
  }

  /**
   * Builds instances of type {@link TcpRouteEvent TcpRouteEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_TcpRouteEvent", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BACKEND_IP = 0x1L;
    private static final long INIT_BIT_BACKEND_PORT = 0x2L;
    private static final long INIT_BIT_MODIFICATION_TAG = 0x4L;
    private static final long INIT_BIT_PORT = 0x8L;
    private static final long INIT_BIT_ROUTER_GROUP_ID = 0x10L;
    private static final long INIT_BIT_TTL = 0x20L;
    private static final long INIT_BIT_EVENT_TYPE = 0x40L;
    private long initBits = 0x7fL;

    private String backendIp;
    private Integer backendPort;
    private String isolationSegment;
    private ModificationTag modificationTag;
    private Integer port;
    private String routerGroupId;
    private Integer ttl;
    private EventType eventType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TcpRouteEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TcpRouteEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _TcpRouteEvent} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_TcpRouteEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.routing.v1.tcproutes.AbstractTcpRoute} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractTcpRoute instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.routing.v1.tcproutes._TcpRouteEvent) {
        org.cloudfoundry.routing.v1.tcproutes._TcpRouteEvent instance = (org.cloudfoundry.routing.v1.tcproutes._TcpRouteEvent) object;
        eventType(instance.getEventType());
      }
      if (object instanceof AbstractTcpRoute) {
        AbstractTcpRoute instance = (AbstractTcpRoute) object;
        backendPort(instance.getBackendPort());
        String isolationSegmentValue = instance.getIsolationSegment();
        if (isolationSegmentValue != null) {
          isolationSegment(isolationSegmentValue);
        }
        port(instance.getPort());
        modificationTag(instance.getModificationTag());
        routerGroupId(instance.getRouterGroupId());
        ttl(instance.getTtl());
        backendIp(instance.getBackendIp());
      }
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getBackendIp() backendIp} attribute.
     * @param backendIp The value for backendIp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_ip")
    public final Builder backendIp(String backendIp) {
      this.backendIp = Objects.requireNonNull(backendIp, "backendIp");
      initBits &= ~INIT_BIT_BACKEND_IP;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getBackendPort() backendPort} attribute.
     * @param backendPort The value for backendPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backend_port")
    public final Builder backendPort(Integer backendPort) {
      this.backendPort = Objects.requireNonNull(backendPort, "backendPort");
      initBits &= ~INIT_BIT_BACKEND_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getIsolationSegment() isolationSegment} attribute.
     * @param isolationSegment The value for isolationSegment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("isolation_segment")
    public final Builder isolationSegment(@Nullable String isolationSegment) {
      this.isolationSegment = isolationSegment;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getModificationTag() modificationTag} attribute.
     * @param modificationTag The value for modificationTag 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("modification_tag")
    public final Builder modificationTag(ModificationTag modificationTag) {
      this.modificationTag = Objects.requireNonNull(modificationTag, "modificationTag");
      initBits &= ~INIT_BIT_MODIFICATION_TAG;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(Integer port) {
      this.port = Objects.requireNonNull(port, "port");
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_guid")
    public final Builder routerGroupId(String routerGroupId) {
      this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
      initBits &= ~INIT_BIT_ROUTER_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getTtl() ttl} attribute.
     * @param ttl The value for ttl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ttl")
    public final Builder ttl(Integer ttl) {
      this.ttl = Objects.requireNonNull(ttl, "ttl");
      initBits &= ~INIT_BIT_TTL;
      return this;
    }

    /**
     * Initializes the value for the {@link TcpRouteEvent#getEventType() eventType} attribute.
     * @param eventType The value for eventType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("eventType")
    public final Builder eventType(EventType eventType) {
      this.eventType = Objects.requireNonNull(eventType, "eventType");
      initBits &= ~INIT_BIT_EVENT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link TcpRouteEvent TcpRouteEvent}.
     * @return An immutable instance of TcpRouteEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TcpRouteEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TcpRouteEvent(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BACKEND_IP) != 0) attributes.add("backendIp");
      if ((initBits & INIT_BIT_BACKEND_PORT) != 0) attributes.add("backendPort");
      if ((initBits & INIT_BIT_MODIFICATION_TAG) != 0) attributes.add("modificationTag");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      if ((initBits & INIT_BIT_ROUTER_GROUP_ID) != 0) attributes.add("routerGroupId");
      if ((initBits & INIT_BIT_TTL) != 0) attributes.add("ttl");
      if ((initBits & INIT_BIT_EVENT_TYPE) != 0) attributes.add("eventType");
      return "Cannot build TcpRouteEvent, some of required attributes are not set " + attributes;
    }
  }
}
