package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the create client
 */
@Generated(from = "_UpdateSecretAction", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateSecretAction extends org.cloudfoundry.uaa.clients._UpdateSecretAction {
  private transient final String action;
  private final String clientId;
  private final String secret;

  private UpdateSecretAction(UpdateSecretAction.Builder builder) {
    this.clientId = builder.clientId;
    this.secret = builder.secret;
    this.action = Objects.requireNonNull(super.getAction(), "action");
  }

  /**
   * @return The computed-at-construction value of the {@code action} attribute
   */
  @Override
  public String getAction() {
    return action;
  }

  /**
   * The client id
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The new secret
   */
  @Override
  public String getSecret() {
    return secret;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSecretAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSecretAction
        && equalTo(0, (UpdateSecretAction) another);
  }

  private boolean equalTo(int synthetic, UpdateSecretAction another) {
    return action.equals(another.action)
        && clientId.equals(another.clientId)
        && secret.equals(another.secret);
  }

  /**
   * Computes a hash code from attributes: {@code action}, {@code clientId}, {@code secret}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + action.hashCode();
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + secret.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSecretAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSecretAction{"
        + "action=" + action
        + ", clientId=" + clientId
        + ", secret=" + secret
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateSecretAction UpdateSecretAction}.
   * <pre>
   * UpdateSecretAction.builder()
   *    .clientId(String) // required {@link UpdateSecretAction#getClientId() clientId}
   *    .secret(String) // required {@link UpdateSecretAction#getSecret() secret}
   *    .build();
   * </pre>
   * @return A new UpdateSecretAction builder
   */
  public static UpdateSecretAction.Builder builder() {
    return new UpdateSecretAction.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSecretAction UpdateSecretAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateSecretAction", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_SECRET = 0x2L;
    private long initBits = 0x3L;

    private String clientId;
    private String secret;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSecretAction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSecretAction instance) {
      return from((_UpdateSecretAction) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSecretAction} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSecretAction instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      secret(instance.getSecret());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSecretAction#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSecretAction#getSecret() secret} attribute.
     * @param secret The value for secret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secret(String secret) {
      this.secret = Objects.requireNonNull(secret, "secret");
      initBits &= ~INIT_BIT_SECRET;
      return this;
    }

    /**
     * Builds a new {@link UpdateSecretAction UpdateSecretAction}.
     * @return An immutable instance of UpdateSecretAction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSecretAction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSecretAction(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_SECRET) != 0) attributes.add("secret");
      return "Cannot build UpdateSecretAction, some of required attributes are not set " + attributes;
    }
  }
}
