package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.*;
import org.immutables.value.Generated;

/**
 * The response from the list external group mappings request
 */
@Generated(from = "_ListExternalGroupMappingsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListExternalGroupMappingsResponse
    extends org.cloudfoundry.uaa.groups._ListExternalGroupMappingsResponse {
  private final Integer itemsPerPage;
  private final List<ExternalGroupResource> resources;
  private final List<String> schemas;
  private final Integer startIndex;
  private final Integer totalResults;

  private ListExternalGroupMappingsResponse(ListExternalGroupMappingsResponse.Builder builder) {
    this.itemsPerPage = builder.itemsPerPage;
    this.resources = createUnmodifiableList(true, builder.resources);
    this.schemas = createUnmodifiableList(true, builder.schemas);
    this.startIndex = builder.startIndex;
    this.totalResults = builder.totalResults;
  }

  /**
   * The itemsPerPage
   */
  @JsonProperty("itemsPerPage")
  @Override
  public Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The resources
   */
  @JsonProperty("resources")
  @Override
  public List<ExternalGroupResource> getResources() {
    return resources;
  }

  /**
   * The schemas
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * The startIndex
   */
  @JsonProperty("startIndex")
  @Override
  public Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The total results
   */
  @JsonProperty("totalResults")
  @Override
  public Integer getTotalResults() {
    return totalResults;
  }

  /**
   * This instance is equal to all instances of {@code ListExternalGroupMappingsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListExternalGroupMappingsResponse
        && equalTo(0, (ListExternalGroupMappingsResponse) another);
  }

  private boolean equalTo(int synthetic, ListExternalGroupMappingsResponse another) {
    return itemsPerPage.equals(another.itemsPerPage)
        && resources.equals(another.resources)
        && schemas.equals(another.schemas)
        && startIndex.equals(another.startIndex)
        && totalResults.equals(another.totalResults);
  }

  /**
   * Computes a hash code from attributes: {@code itemsPerPage}, {@code resources}, {@code schemas}, {@code startIndex}, {@code totalResults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + itemsPerPage.hashCode();
    h += (h << 5) + resources.hashCode();
    h += (h << 5) + schemas.hashCode();
    h += (h << 5) + startIndex.hashCode();
    h += (h << 5) + totalResults.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListExternalGroupMappingsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListExternalGroupMappingsResponse{"
        + "itemsPerPage=" + itemsPerPage
        + ", resources=" + resources
        + ", schemas=" + schemas
        + ", startIndex=" + startIndex
        + ", totalResults=" + totalResults
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListExternalGroupMappingsResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._ListExternalGroupMappingsResponse {
    Integer itemsPerPage;
    List<ExternalGroupResource> resources = Collections.emptyList();
    List<String> schemas = Collections.emptyList();
    Integer startIndex;
    Integer totalResults;
    @JsonProperty("itemsPerPage")
    public void setItemsPerPage(Integer itemsPerPage) {
      this.itemsPerPage = itemsPerPage;
    }
    @JsonProperty("resources")
    public void setResources(List<ExternalGroupResource> resources) {
      this.resources = resources;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("startIndex")
    public void setStartIndex(Integer startIndex) {
      this.startIndex = startIndex;
    }
    @JsonProperty("totalResults")
    public void setTotalResults(Integer totalResults) {
      this.totalResults = totalResults;
    }
    @Override
    public Integer getItemsPerPage() { throw new UnsupportedOperationException(); }
    @Override
    public List<ExternalGroupResource> getResources() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStartIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalResults() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListExternalGroupMappingsResponse fromJson(Json json) {
    ListExternalGroupMappingsResponse.Builder builder = ListExternalGroupMappingsResponse.builder();
    if (json.itemsPerPage != null) {
      builder.itemsPerPage(json.itemsPerPage);
    }
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.startIndex != null) {
      builder.startIndex(json.startIndex);
    }
    if (json.totalResults != null) {
      builder.totalResults(json.totalResults);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListExternalGroupMappingsResponse ListExternalGroupMappingsResponse}.
   * <pre>
   * ListExternalGroupMappingsResponse.builder()
   *    .itemsPerPage(Integer) // required {@link ListExternalGroupMappingsResponse#getItemsPerPage() itemsPerPage}
   *    .resource|addAllResources(ExternalGroupResource) // {@link ListExternalGroupMappingsResponse#getResources() resources} elements
   *    .schema|addAllSchemas(String) // {@link ListExternalGroupMappingsResponse#getSchemas() schemas} elements
   *    .startIndex(Integer) // required {@link ListExternalGroupMappingsResponse#getStartIndex() startIndex}
   *    .totalResults(Integer) // required {@link ListExternalGroupMappingsResponse#getTotalResults() totalResults}
   *    .build();
   * </pre>
   * @return A new ListExternalGroupMappingsResponse builder
   */
  public static ListExternalGroupMappingsResponse.Builder builder() {
    return new ListExternalGroupMappingsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListExternalGroupMappingsResponse ListExternalGroupMappingsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListExternalGroupMappingsResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ITEMS_PER_PAGE = 0x1L;
    private static final long INIT_BIT_START_INDEX = 0x2L;
    private static final long INIT_BIT_TOTAL_RESULTS = 0x4L;
    private long initBits = 0x7L;

    private Integer itemsPerPage;
    private List<ExternalGroupResource> resources = new ArrayList<ExternalGroupResource>();
    private List<String> schemas = new ArrayList<String>();
    private Integer startIndex;
    private Integer totalResults;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListExternalGroupMappingsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListExternalGroupMappingsResponse instance) {
      return from((_ListExternalGroupMappingsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListExternalGroupMappingsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListExternalGroupMappingsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      itemsPerPage(instance.getItemsPerPage());
      addAllResources(instance.getResources());
      addAllSchemas(instance.getSchemas());
      startIndex(instance.getStartIndex());
      totalResults(instance.getTotalResults());
      return this;
    }

    /**
     * Initializes the value for the {@link ListExternalGroupMappingsResponse#getItemsPerPage() itemsPerPage} attribute.
     * @param itemsPerPage The value for itemsPerPage 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("itemsPerPage")
    public final Builder itemsPerPage(Integer itemsPerPage) {
      this.itemsPerPage = Objects.requireNonNull(itemsPerPage, "itemsPerPage");
      initBits &= ~INIT_BIT_ITEMS_PER_PAGE;
      return this;
    }

    /**
     * Adds one element to {@link ListExternalGroupMappingsResponse#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(ExternalGroupResource element) {
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link ListExternalGroupMappingsResponse#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(ExternalGroupResource... elements) {
      for (ExternalGroupResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListExternalGroupMappingsResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resources")
    public final Builder resources(Iterable<? extends ExternalGroupResource> elements) {
      this.resources.clear();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link ListExternalGroupMappingsResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends ExternalGroupResource> elements) {
      for (ExternalGroupResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListExternalGroupMappingsResponse#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link ListExternalGroupMappingsResponse#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemas(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListExternalGroupMappingsResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link ListExternalGroupMappingsResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListExternalGroupMappingsResponse#getStartIndex() startIndex} attribute.
     * @param startIndex The value for startIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("startIndex")
    public final Builder startIndex(Integer startIndex) {
      this.startIndex = Objects.requireNonNull(startIndex, "startIndex");
      initBits &= ~INIT_BIT_START_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link ListExternalGroupMappingsResponse#getTotalResults() totalResults} attribute.
     * @param totalResults The value for totalResults 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("totalResults")
    public final Builder totalResults(Integer totalResults) {
      this.totalResults = Objects.requireNonNull(totalResults, "totalResults");
      initBits &= ~INIT_BIT_TOTAL_RESULTS;
      return this;
    }

    /**
     * Builds a new {@link ListExternalGroupMappingsResponse ListExternalGroupMappingsResponse}.
     * @return An immutable instance of ListExternalGroupMappingsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListExternalGroupMappingsResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListExternalGroupMappingsResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ITEMS_PER_PAGE) != 0) attributes.add("itemsPerPage");
      if ((initBits & INIT_BIT_START_INDEX) != 0) attributes.add("startIndex");
      if ((initBits & INIT_BIT_TOTAL_RESULTS) != 0) attributes.add("totalResults");
      return "Cannot build ListExternalGroupMappingsResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
