package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the keystone identity provider configuration
 */
@Generated(from = "_KeystoneConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class KeystoneConfiguration extends org.cloudfoundry.uaa.identityproviders._KeystoneConfiguration {
  private final @Nullable List<String> emailDomains;
  private final @Nullable String providerDescription;
  private final @Nullable AttributeMappings attributeMappings;
  private final @Nullable List<String> externalGroupsWhitelist;
  private final @Nullable Boolean storeCustomAttributes;

  private KeystoneConfiguration(KeystoneConfiguration.Builder builder) {
    this.emailDomains = builder.emailDomains == null ? null : createUnmodifiableList(true, builder.emailDomains);
    this.providerDescription = builder.providerDescription;
    this.attributeMappings = builder.attributeMappings;
    this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : createUnmodifiableList(true, builder.externalGroupsWhitelist);
    this.storeCustomAttributes = builder.storeCustomAttributes;
  }

  /**
   * List of email domains associated with the provider for the purpose of associating users to the correct origin upon invitation. If empty list, no invitations are accepted. Wildcards supported.
   */
  @JsonProperty("emailDomain")
  @Override
  public @Nullable List<String> getEmailDomains() {
    return emailDomains;
  }

  /**
   * Human readable name/description of this provider
   */
  @JsonProperty("providerDescription")
  @Override
  public @Nullable String getProviderDescription() {
    return providerDescription;
  }

  /**
   * @return The value of the {@code attributeMappings} attribute
   */
  @JsonProperty("attributeMappings")
  @Override
  public @Nullable AttributeMappings getAttributeMappings() {
    return attributeMappings;
  }

  /**
   * The external group white list
   */
  @JsonProperty("externalGroupsWhitelist")
  @Override
  public @Nullable List<String> getExternalGroupsWhitelist() {
    return externalGroupsWhitelist;
  }

  /**
   * Set to true, to store custom user attributes to be fetched from the /userinfo endpoint
   */
  @JsonProperty("storeCustomAttributes")
  @Override
  public @Nullable Boolean getStoreCustomAttributes() {
    return storeCustomAttributes;
  }

  /**
   * This instance is equal to all instances of {@code KeystoneConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof KeystoneConfiguration
        && equalTo(0, (KeystoneConfiguration) another);
  }

  private boolean equalTo(int synthetic, KeystoneConfiguration another) {
    return Objects.equals(emailDomains, another.emailDomains)
        && Objects.equals(providerDescription, another.providerDescription)
        && Objects.equals(attributeMappings, another.attributeMappings)
        && Objects.equals(externalGroupsWhitelist, another.externalGroupsWhitelist)
        && Objects.equals(storeCustomAttributes, another.storeCustomAttributes);
  }

  /**
   * Computes a hash code from attributes: {@code emailDomains}, {@code providerDescription}, {@code attributeMappings}, {@code externalGroupsWhitelist}, {@code storeCustomAttributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(emailDomains);
    h += (h << 5) + Objects.hashCode(providerDescription);
    h += (h << 5) + Objects.hashCode(attributeMappings);
    h += (h << 5) + Objects.hashCode(externalGroupsWhitelist);
    h += (h << 5) + Objects.hashCode(storeCustomAttributes);
    return h;
  }

  /**
   * Prints the immutable value {@code KeystoneConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "KeystoneConfiguration{"
        + "emailDomains=" + emailDomains
        + ", providerDescription=" + providerDescription
        + ", attributeMappings=" + attributeMappings
        + ", externalGroupsWhitelist=" + externalGroupsWhitelist
        + ", storeCustomAttributes=" + storeCustomAttributes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_KeystoneConfiguration", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._KeystoneConfiguration {
    List<String> emailDomains = null;
    String providerDescription;
    AttributeMappings attributeMappings;
    List<String> externalGroupsWhitelist = null;
    Boolean storeCustomAttributes;
    @JsonProperty("emailDomain")
    public void setEmailDomains(@Nullable List<String> emailDomains) {
      this.emailDomains = emailDomains;
    }
    @JsonProperty("providerDescription")
    public void setProviderDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
    }
    @JsonProperty("attributeMappings")
    public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
    }
    @JsonProperty("externalGroupsWhitelist")
    public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
      this.externalGroupsWhitelist = externalGroupsWhitelist;
    }
    @JsonProperty("storeCustomAttributes")
    public void setStoreCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
    }
    @Override
    public List<String> getEmailDomains() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderDescription() { throw new UnsupportedOperationException(); }
    @Override
    public AttributeMappings getAttributeMappings() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getExternalGroupsWhitelist() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getStoreCustomAttributes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static KeystoneConfiguration fromJson(Json json) {
    KeystoneConfiguration.Builder builder = KeystoneConfiguration.builder();
    if (json.emailDomains != null) {
      builder.addAllEmailDomains(json.emailDomains);
    }
    if (json.providerDescription != null) {
      builder.providerDescription(json.providerDescription);
    }
    if (json.attributeMappings != null) {
      builder.attributeMappings(json.attributeMappings);
    }
    if (json.externalGroupsWhitelist != null) {
      builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
    }
    if (json.storeCustomAttributes != null) {
      builder.storeCustomAttributes(json.storeCustomAttributes);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link KeystoneConfiguration KeystoneConfiguration}.
   * <pre>
   * KeystoneConfiguration.builder()
   *    .emailDomains(List&amp;lt;String&amp;gt; | null) // nullable {@link KeystoneConfiguration#getEmailDomains() emailDomains}
   *    .providerDescription(String | null) // nullable {@link KeystoneConfiguration#getProviderDescription() providerDescription}
   *    .attributeMappings(org.cloudfoundry.uaa.identityproviders.AttributeMappings | null) // nullable {@link KeystoneConfiguration#getAttributeMappings() attributeMappings}
   *    .externalGroupsWhitelist(List&amp;lt;String&amp;gt; | null) // nullable {@link KeystoneConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist}
   *    .storeCustomAttributes(Boolean | null) // nullable {@link KeystoneConfiguration#getStoreCustomAttributes() storeCustomAttributes}
   *    .build();
   * </pre>
   * @return A new KeystoneConfiguration builder
   */
  public static KeystoneConfiguration.Builder builder() {
    return new KeystoneConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link KeystoneConfiguration KeystoneConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_KeystoneConfiguration", generator = "Immutables")
  public static final class Builder {
    private List<String> emailDomains = null;
    private String providerDescription;
    private AttributeMappings attributeMappings;
    private List<String> externalGroupsWhitelist = null;
    private Boolean storeCustomAttributes;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeystoneConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(KeystoneConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _KeystoneConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_KeystoneConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractIdentityProviderConfiguration) {
        AbstractIdentityProviderConfiguration instance = (AbstractIdentityProviderConfiguration) object;
        if ((bits & 0x4L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x10L;
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._KeystoneConfiguration) {
        org.cloudfoundry.uaa.identityproviders._KeystoneConfiguration instance = (org.cloudfoundry.uaa.identityproviders._KeystoneConfiguration) object;
        if ((bits & 0x1L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x8L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x8L;
        }
      }
      if (object instanceof AbstractExternalIdentityProviderConfiguration) {
        AbstractExternalIdentityProviderConfiguration instance = (AbstractExternalIdentityProviderConfiguration) object;
        if ((bits & 0x1L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x8L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Adds one element to {@link KeystoneConfiguration#getEmailDomains() emailDomains} list.
     * @param element A emailDomains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String element) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      return this;
    }

    /**
     * Adds elements to {@link KeystoneConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An array of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomains(String... elements) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link KeystoneConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emailDomain")
    public final Builder emailDomains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.emailDomains = null;
        return this;
      }
      this.emailDomains = new ArrayList<String>();
      return addAllEmailDomains(elements);
    }

    /**
     * Adds elements to {@link KeystoneConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmailDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "emailDomains element");
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link KeystoneConfiguration#getProviderDescription() providerDescription} attribute.
     * @param providerDescription The value for providerDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("providerDescription")
    public final Builder providerDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link KeystoneConfiguration#getAttributeMappings() attributeMappings} attribute.
     * @param attributeMappings The value for attributeMappings (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("attributeMappings")
    public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
      return this;
    }

    /**
     * Adds one element to {@link KeystoneConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param element A externalGroupsWhitelist element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String element) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      return this;
    }

    /**
     * Adds elements to {@link KeystoneConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An array of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String... elements) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link KeystoneConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalGroupsWhitelist")
    public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.externalGroupsWhitelist = null;
        return this;
      }
      this.externalGroupsWhitelist = new ArrayList<String>();
      return addAllExternalGroupsWhitelist(elements);
    }

    /**
     * Adds elements to {@link KeystoneConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
      Objects.requireNonNull(elements, "externalGroupsWhitelist element");
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link KeystoneConfiguration#getStoreCustomAttributes() storeCustomAttributes} attribute.
     * @param storeCustomAttributes The value for storeCustomAttributes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("storeCustomAttributes")
    public final Builder storeCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
      return this;
    }

    /**
     * Builds a new {@link KeystoneConfiguration KeystoneConfiguration}.
     * @return An immutable instance of KeystoneConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public KeystoneConfiguration build() {
      return new KeystoneConfiguration(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
