package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the ldap identity provider configuration
 */
@Generated(from = "_LdapConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class LdapConfiguration extends org.cloudfoundry.uaa.identityproviders._LdapConfiguration {
  private final @Nullable List<String> emailDomains;
  private final @Nullable String providerDescription;
  private final @Nullable AttributeMappings attributeMappings;
  private final @Nullable List<String> externalGroupsWhitelist;
  private final @Nullable Boolean storeCustomAttributes;
  private final @Nullable Boolean addShadowUserOnLogin;
  private final @Nullable Boolean autoAddGroups;
  private final @Nullable String baseUrl;
  private final @Nullable String bindPassword;
  private final @Nullable String bindUserDistinguishedName;
  private final @Nullable String groupRoleAttribute;
  private final @Nullable String groupSearchBase;
  private final @Nullable Integer groupSearchDepthLimit;
  private final @Nullable String groupSearchFilter;
  private final @Nullable Boolean groupSearchSubTree;
  private final @Nullable Boolean groupsIgnorePartialResults;
  private final @Nullable LdapGroupFile ldapGroupFile;
  private final @Nullable LdapProfileFile ldapProfileFile;
  private final @Nullable Boolean localPasswordCompare;
  private final @Nullable String mailAttributeName;
  private final @Nullable String mailSubstitute;
  private final @Nullable Boolean mailSubstituteOverridesLdap;
  private final @Nullable String passwordAttributeName;
  private final @Nullable String passwordEncoder;
  private final @Nullable String referral;
  private final @Nullable Boolean skipSSLVerification;
  private final @Nullable TlsConfiguration tlsConfiguration;
  private final @Nullable String userDistinguishedNamePattern;
  private final @Nullable String userDistinguishedNamePatternDelimiter;
  private final @Nullable String userSearchBase;
  private final @Nullable String userSearchFilter;

  private LdapConfiguration(LdapConfiguration.Builder builder) {
    this.emailDomains = builder.emailDomains == null ? null : createUnmodifiableList(true, builder.emailDomains);
    this.providerDescription = builder.providerDescription;
    this.attributeMappings = builder.attributeMappings;
    this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : createUnmodifiableList(true, builder.externalGroupsWhitelist);
    this.storeCustomAttributes = builder.storeCustomAttributes;
    this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
    this.autoAddGroups = builder.autoAddGroups;
    this.baseUrl = builder.baseUrl;
    this.bindPassword = builder.bindPassword;
    this.bindUserDistinguishedName = builder.bindUserDistinguishedName;
    this.groupRoleAttribute = builder.groupRoleAttribute;
    this.groupSearchBase = builder.groupSearchBase;
    this.groupSearchDepthLimit = builder.groupSearchDepthLimit;
    this.groupSearchFilter = builder.groupSearchFilter;
    this.groupSearchSubTree = builder.groupSearchSubTree;
    this.groupsIgnorePartialResults = builder.groupsIgnorePartialResults;
    this.ldapGroupFile = builder.ldapGroupFile;
    this.ldapProfileFile = builder.ldapProfileFile;
    this.localPasswordCompare = builder.localPasswordCompare;
    this.mailAttributeName = builder.mailAttributeName;
    this.mailSubstitute = builder.mailSubstitute;
    this.mailSubstituteOverridesLdap = builder.mailSubstituteOverridesLdap;
    this.passwordAttributeName = builder.passwordAttributeName;
    this.passwordEncoder = builder.passwordEncoder;
    this.referral = builder.referral;
    this.skipSSLVerification = builder.skipSSLVerification;
    this.tlsConfiguration = builder.tlsConfiguration;
    this.userDistinguishedNamePattern = builder.userDistinguishedNamePattern;
    this.userDistinguishedNamePatternDelimiter = builder.userDistinguishedNamePatternDelimiter;
    this.userSearchBase = builder.userSearchBase;
    this.userSearchFilter = builder.userSearchFilter;
  }

  /**
   * List of email domains associated with the provider for the purpose of associating users to the correct origin upon invitation. If empty list, no invitations are accepted. Wildcards supported.
   */
  @JsonProperty("emailDomain")
  @Override
  public @Nullable List<String> getEmailDomains() {
    return emailDomains;
  }

  /**
   * Human readable name/description of this provider
   */
  @JsonProperty("providerDescription")
  @Override
  public @Nullable String getProviderDescription() {
    return providerDescription;
  }

  /**
   * @return The value of the {@code attributeMappings} attribute
   */
  @JsonProperty("attributeMappings")
  @Override
  public @Nullable AttributeMappings getAttributeMappings() {
    return attributeMappings;
  }

  /**
   * The external group white list
   */
  @JsonProperty("externalGroupsWhitelist")
  @Override
  public @Nullable List<String> getExternalGroupsWhitelist() {
    return externalGroupsWhitelist;
  }

  /**
   * Set to true, to store custom user attributes to be fetched from the /userinfo endpoint
   */
  @JsonProperty("storeCustomAttributes")
  @Override
  public @Nullable Boolean getStoreCustomAttributes() {
    return storeCustomAttributes;
  }

  /**
   * Determines whether or not shadow users must be created before login by an administrator.
   */
  @JsonProperty("addShadowUserOnLogin")
  @Override
  public @Nullable Boolean getAddShadowUserOnLogin() {
    return addShadowUserOnLogin;
  }

  /**
   * The auto add group flag
   */
  @JsonProperty("autoAddGroups")
  @Override
  public @Nullable Boolean getAutoAddGroups() {
    return autoAddGroups;
  }

  /**
   * The URL to the ldap server, must start with ldap:// or ldaps://
   */
  @JsonProperty("baseUrl")
  @Override
  public @Nullable String getBaseUrl() {
    return baseUrl;
  }

  /**
   * If you specified BindUserDN, then specify the corresponding password to be used for binding here.
   */
  @JsonProperty("bindPassword")
  @Override
  public @Nullable String getBindPassword() {
    return bindPassword;
  }

  /**
   * The distinguished name the gatekeeper uses to bind to the LDAP server.
   */
  @JsonProperty("bindUserDn")
  @Override
  public @Nullable String getBindUserDistinguishedName() {
    return bindUserDistinguishedName;
  }

  /**
   * The group role attribute
   */
  @JsonProperty("groupRoleAttribute")
  @Override
  public @Nullable String getGroupRoleAttribute() {
    return groupRoleAttribute;
  }

  /**
   * The group search base
   */
  @JsonProperty("groupSearchBase")
  @Override
  public @Nullable String getGroupSearchBase() {
    return groupSearchBase;
  }

  /**
   * The maximum group search depth limit
   */
  @JsonProperty("maxGroupSearchDepth")
  @Override
  public @Nullable Integer getGroupSearchDepthLimit() {
    return groupSearchDepthLimit;
  }

  /**
   * The group search filter
   */
  @JsonProperty("groupSearchFilter")
  @Override
  public @Nullable String getGroupSearchFilter() {
    return groupSearchFilter;
  }

  /**
   * The group search subtree
   */
  @JsonProperty("groupSearchSubTree")
  @Override
  public @Nullable Boolean getGroupSearchSubTree() {
    return groupSearchSubTree;
  }

  /**
   * The group ignore partial search result flag
   */
  @JsonProperty("groupsIgnorePartialResults")
  @Override
  public @Nullable Boolean getGroupsIgnorePartialResults() {
    return groupsIgnorePartialResults;
  }

  /**
   * The file to be used for group integration.
   */
  @JsonProperty("ldapGroupFile")
  @Override
  public @Nullable LdapGroupFile getLdapGroupFile() {
    return ldapGroupFile;
  }

  /**
   * The file to be used for configuring the LDAP authentication.
   */
  @JsonProperty("ldapProfileFile")
  @Override
  public @Nullable LdapProfileFile getLdapProfileFile() {
    return ldapProfileFile;
  }

  /**
   * @return The value of the {@code localPasswordCompare} attribute
   */
  @JsonProperty("localPasswordCompare")
  @Override
  public @Nullable Boolean getLocalPasswordCompare() {
    return localPasswordCompare;
  }

  /**
   * The name of the LDAP attribute that contains the user’s email address
   */
  @JsonProperty("mailAttributeName")
  @Override
  public @Nullable String getMailAttributeName() {
    return mailAttributeName;
  }

  /**
   * Defines an email pattern containing a {0} to generate an email address for an LDAP user during authentication
   */
  @JsonProperty("mailSubstitute")
  @Override
  public @Nullable String getMailSubstitute() {
    return mailSubstitute;
  }

  /**
   * Set to true if you wish to override an LDAP user email address with a generated one
   */
  @JsonProperty("mailSubstituteOverridesLdap")
  @Override
  public @Nullable Boolean getMailSubstituteOverridesLdap() {
    return mailSubstituteOverridesLdap;
  }

  /**
   * The password attribute name
   */
  @JsonProperty("passwordAttributeName")
  @Override
  public @Nullable String getPasswordAttributeName() {
    return passwordAttributeName;
  }

  /**
   * The password encoder
   */
  @JsonProperty("passwordEncoder")
  @Override
  public @Nullable String getPasswordEncoder() {
    return passwordEncoder;
  }

  /**
   * Configures the UAA LDAP referral behavior. The following values are possible: - follow → Referrals are followed - ignore → Referrals are ignored and the partial result is returned - throw → An
   * error is thrown and the authentication is aborted
   */
  @JsonProperty("referral")
  @Override
  public @Nullable String getReferral() {
    return referral;
  }

  /**
   * Skips validation of the LDAP cert if set to true.
   */
  @JsonProperty("skipSSLVerification")
  @Override
  public @Nullable Boolean getSkipSSLVerification() {
    return skipSSLVerification;
  }

  /**
   * The StartTLS options
   */
  @JsonProperty("tlsConfiguration")
  @Override
  public @Nullable TlsConfiguration getTlsConfiguration() {
    return tlsConfiguration;
  }

  /**
   * The user distinguished name pattern
   */
  @JsonProperty("userDNPattern")
  @Override
  public @Nullable String getUserDistinguishedNamePattern() {
    return userDistinguishedNamePattern;
  }

  /**
   * The user distinguished name pattern delimiter
   */
  @JsonProperty("userDNPatternDelimiter")
  @Override
  public @Nullable String getUserDistinguishedNamePatternDelimiter() {
    return userDistinguishedNamePatternDelimiter;
  }

  /**
   * The user search base
   */
  @JsonProperty("userSearchBase")
  @Override
  public @Nullable String getUserSearchBase() {
    return userSearchBase;
  }

  /**
   * The user search filter
   */
  @JsonProperty("userSearchFilter")
  @Override
  public @Nullable String getUserSearchFilter() {
    return userSearchFilter;
  }

  /**
   * This instance is equal to all instances of {@code LdapConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof LdapConfiguration
        && equalTo(0, (LdapConfiguration) another);
  }

  private boolean equalTo(int synthetic, LdapConfiguration another) {
    return Objects.equals(emailDomains, another.emailDomains)
        && Objects.equals(providerDescription, another.providerDescription)
        && Objects.equals(attributeMappings, another.attributeMappings)
        && Objects.equals(externalGroupsWhitelist, another.externalGroupsWhitelist)
        && Objects.equals(storeCustomAttributes, another.storeCustomAttributes)
        && Objects.equals(addShadowUserOnLogin, another.addShadowUserOnLogin)
        && Objects.equals(autoAddGroups, another.autoAddGroups)
        && Objects.equals(baseUrl, another.baseUrl)
        && Objects.equals(bindPassword, another.bindPassword)
        && Objects.equals(bindUserDistinguishedName, another.bindUserDistinguishedName)
        && Objects.equals(groupRoleAttribute, another.groupRoleAttribute)
        && Objects.equals(groupSearchBase, another.groupSearchBase)
        && Objects.equals(groupSearchDepthLimit, another.groupSearchDepthLimit)
        && Objects.equals(groupSearchFilter, another.groupSearchFilter)
        && Objects.equals(groupSearchSubTree, another.groupSearchSubTree)
        && Objects.equals(groupsIgnorePartialResults, another.groupsIgnorePartialResults)
        && Objects.equals(ldapGroupFile, another.ldapGroupFile)
        && Objects.equals(ldapProfileFile, another.ldapProfileFile)
        && Objects.equals(localPasswordCompare, another.localPasswordCompare)
        && Objects.equals(mailAttributeName, another.mailAttributeName)
        && Objects.equals(mailSubstitute, another.mailSubstitute)
        && Objects.equals(mailSubstituteOverridesLdap, another.mailSubstituteOverridesLdap)
        && Objects.equals(passwordAttributeName, another.passwordAttributeName)
        && Objects.equals(passwordEncoder, another.passwordEncoder)
        && Objects.equals(referral, another.referral)
        && Objects.equals(skipSSLVerification, another.skipSSLVerification)
        && Objects.equals(tlsConfiguration, another.tlsConfiguration)
        && Objects.equals(userDistinguishedNamePattern, another.userDistinguishedNamePattern)
        && Objects.equals(userDistinguishedNamePatternDelimiter, another.userDistinguishedNamePatternDelimiter)
        && Objects.equals(userSearchBase, another.userSearchBase)
        && Objects.equals(userSearchFilter, another.userSearchFilter);
  }

  /**
   * Computes a hash code from attributes: {@code emailDomains}, {@code providerDescription}, {@code attributeMappings}, {@code externalGroupsWhitelist}, {@code storeCustomAttributes}, {@code addShadowUserOnLogin}, {@code autoAddGroups}, {@code baseUrl}, {@code bindPassword}, {@code bindUserDistinguishedName}, {@code groupRoleAttribute}, {@code groupSearchBase}, {@code groupSearchDepthLimit}, {@code groupSearchFilter}, {@code groupSearchSubTree}, {@code groupsIgnorePartialResults}, {@code ldapGroupFile}, {@code ldapProfileFile}, {@code localPasswordCompare}, {@code mailAttributeName}, {@code mailSubstitute}, {@code mailSubstituteOverridesLdap}, {@code passwordAttributeName}, {@code passwordEncoder}, {@code referral}, {@code skipSSLVerification}, {@code tlsConfiguration}, {@code userDistinguishedNamePattern}, {@code userDistinguishedNamePatternDelimiter}, {@code userSearchBase}, {@code userSearchFilter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(emailDomains);
    h += (h << 5) + Objects.hashCode(providerDescription);
    h += (h << 5) + Objects.hashCode(attributeMappings);
    h += (h << 5) + Objects.hashCode(externalGroupsWhitelist);
    h += (h << 5) + Objects.hashCode(storeCustomAttributes);
    h += (h << 5) + Objects.hashCode(addShadowUserOnLogin);
    h += (h << 5) + Objects.hashCode(autoAddGroups);
    h += (h << 5) + Objects.hashCode(baseUrl);
    h += (h << 5) + Objects.hashCode(bindPassword);
    h += (h << 5) + Objects.hashCode(bindUserDistinguishedName);
    h += (h << 5) + Objects.hashCode(groupRoleAttribute);
    h += (h << 5) + Objects.hashCode(groupSearchBase);
    h += (h << 5) + Objects.hashCode(groupSearchDepthLimit);
    h += (h << 5) + Objects.hashCode(groupSearchFilter);
    h += (h << 5) + Objects.hashCode(groupSearchSubTree);
    h += (h << 5) + Objects.hashCode(groupsIgnorePartialResults);
    h += (h << 5) + Objects.hashCode(ldapGroupFile);
    h += (h << 5) + Objects.hashCode(ldapProfileFile);
    h += (h << 5) + Objects.hashCode(localPasswordCompare);
    h += (h << 5) + Objects.hashCode(mailAttributeName);
    h += (h << 5) + Objects.hashCode(mailSubstitute);
    h += (h << 5) + Objects.hashCode(mailSubstituteOverridesLdap);
    h += (h << 5) + Objects.hashCode(passwordAttributeName);
    h += (h << 5) + Objects.hashCode(passwordEncoder);
    h += (h << 5) + Objects.hashCode(referral);
    h += (h << 5) + Objects.hashCode(skipSSLVerification);
    h += (h << 5) + Objects.hashCode(tlsConfiguration);
    h += (h << 5) + Objects.hashCode(userDistinguishedNamePattern);
    h += (h << 5) + Objects.hashCode(userDistinguishedNamePatternDelimiter);
    h += (h << 5) + Objects.hashCode(userSearchBase);
    h += (h << 5) + Objects.hashCode(userSearchFilter);
    return h;
  }

  /**
   * Prints the immutable value {@code LdapConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LdapConfiguration{"
        + "emailDomains=" + emailDomains
        + ", providerDescription=" + providerDescription
        + ", attributeMappings=" + attributeMappings
        + ", externalGroupsWhitelist=" + externalGroupsWhitelist
        + ", storeCustomAttributes=" + storeCustomAttributes
        + ", addShadowUserOnLogin=" + addShadowUserOnLogin
        + ", autoAddGroups=" + autoAddGroups
        + ", baseUrl=" + baseUrl
        + ", bindPassword=" + bindPassword
        + ", bindUserDistinguishedName=" + bindUserDistinguishedName
        + ", groupRoleAttribute=" + groupRoleAttribute
        + ", groupSearchBase=" + groupSearchBase
        + ", groupSearchDepthLimit=" + groupSearchDepthLimit
        + ", groupSearchFilter=" + groupSearchFilter
        + ", groupSearchSubTree=" + groupSearchSubTree
        + ", groupsIgnorePartialResults=" + groupsIgnorePartialResults
        + ", ldapGroupFile=" + ldapGroupFile
        + ", ldapProfileFile=" + ldapProfileFile
        + ", localPasswordCompare=" + localPasswordCompare
        + ", mailAttributeName=" + mailAttributeName
        + ", mailSubstitute=" + mailSubstitute
        + ", mailSubstituteOverridesLdap=" + mailSubstituteOverridesLdap
        + ", passwordAttributeName=" + passwordAttributeName
        + ", passwordEncoder=" + passwordEncoder
        + ", referral=" + referral
        + ", skipSSLVerification=" + skipSSLVerification
        + ", tlsConfiguration=" + tlsConfiguration
        + ", userDistinguishedNamePattern=" + userDistinguishedNamePattern
        + ", userDistinguishedNamePatternDelimiter=" + userDistinguishedNamePatternDelimiter
        + ", userSearchBase=" + userSearchBase
        + ", userSearchFilter=" + userSearchFilter
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_LdapConfiguration", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._LdapConfiguration {
    List<String> emailDomains = null;
    String providerDescription;
    AttributeMappings attributeMappings;
    List<String> externalGroupsWhitelist = null;
    Boolean storeCustomAttributes;
    Boolean addShadowUserOnLogin;
    Boolean autoAddGroups;
    String baseUrl;
    String bindPassword;
    String bindUserDistinguishedName;
    String groupRoleAttribute;
    String groupSearchBase;
    Integer groupSearchDepthLimit;
    String groupSearchFilter;
    Boolean groupSearchSubTree;
    Boolean groupsIgnorePartialResults;
    LdapGroupFile ldapGroupFile;
    LdapProfileFile ldapProfileFile;
    Boolean localPasswordCompare;
    String mailAttributeName;
    String mailSubstitute;
    Boolean mailSubstituteOverridesLdap;
    String passwordAttributeName;
    String passwordEncoder;
    String referral;
    Boolean skipSSLVerification;
    TlsConfiguration tlsConfiguration;
    String userDistinguishedNamePattern;
    String userDistinguishedNamePatternDelimiter;
    String userSearchBase;
    String userSearchFilter;
    @JsonProperty("emailDomain")
    public void setEmailDomains(@Nullable List<String> emailDomains) {
      this.emailDomains = emailDomains;
    }
    @JsonProperty("providerDescription")
    public void setProviderDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
    }
    @JsonProperty("attributeMappings")
    public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
    }
    @JsonProperty("externalGroupsWhitelist")
    public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
      this.externalGroupsWhitelist = externalGroupsWhitelist;
    }
    @JsonProperty("storeCustomAttributes")
    public void setStoreCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
    }
    @JsonProperty("addShadowUserOnLogin")
    public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
    }
    @JsonProperty("autoAddGroups")
    public void setAutoAddGroups(@Nullable Boolean autoAddGroups) {
      this.autoAddGroups = autoAddGroups;
    }
    @JsonProperty("baseUrl")
    public void setBaseUrl(@Nullable String baseUrl) {
      this.baseUrl = baseUrl;
    }
    @JsonProperty("bindPassword")
    public void setBindPassword(@Nullable String bindPassword) {
      this.bindPassword = bindPassword;
    }
    @JsonProperty("bindUserDn")
    public void setBindUserDistinguishedName(@Nullable String bindUserDistinguishedName) {
      this.bindUserDistinguishedName = bindUserDistinguishedName;
    }
    @JsonProperty("groupRoleAttribute")
    public void setGroupRoleAttribute(@Nullable String groupRoleAttribute) {
      this.groupRoleAttribute = groupRoleAttribute;
    }
    @JsonProperty("groupSearchBase")
    public void setGroupSearchBase(@Nullable String groupSearchBase) {
      this.groupSearchBase = groupSearchBase;
    }
    @JsonProperty("maxGroupSearchDepth")
    public void setGroupSearchDepthLimit(@Nullable Integer groupSearchDepthLimit) {
      this.groupSearchDepthLimit = groupSearchDepthLimit;
    }
    @JsonProperty("groupSearchFilter")
    public void setGroupSearchFilter(@Nullable String groupSearchFilter) {
      this.groupSearchFilter = groupSearchFilter;
    }
    @JsonProperty("groupSearchSubTree")
    public void setGroupSearchSubTree(@Nullable Boolean groupSearchSubTree) {
      this.groupSearchSubTree = groupSearchSubTree;
    }
    @JsonProperty("groupsIgnorePartialResults")
    public void setGroupsIgnorePartialResults(@Nullable Boolean groupsIgnorePartialResults) {
      this.groupsIgnorePartialResults = groupsIgnorePartialResults;
    }
    @JsonProperty("ldapGroupFile")
    public void setLdapGroupFile(@Nullable LdapGroupFile ldapGroupFile) {
      this.ldapGroupFile = ldapGroupFile;
    }
    @JsonProperty("ldapProfileFile")
    public void setLdapProfileFile(@Nullable LdapProfileFile ldapProfileFile) {
      this.ldapProfileFile = ldapProfileFile;
    }
    @JsonProperty("localPasswordCompare")
    public void setLocalPasswordCompare(@Nullable Boolean localPasswordCompare) {
      this.localPasswordCompare = localPasswordCompare;
    }
    @JsonProperty("mailAttributeName")
    public void setMailAttributeName(@Nullable String mailAttributeName) {
      this.mailAttributeName = mailAttributeName;
    }
    @JsonProperty("mailSubstitute")
    public void setMailSubstitute(@Nullable String mailSubstitute) {
      this.mailSubstitute = mailSubstitute;
    }
    @JsonProperty("mailSubstituteOverridesLdap")
    public void setMailSubstituteOverridesLdap(@Nullable Boolean mailSubstituteOverridesLdap) {
      this.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
    }
    @JsonProperty("passwordAttributeName")
    public void setPasswordAttributeName(@Nullable String passwordAttributeName) {
      this.passwordAttributeName = passwordAttributeName;
    }
    @JsonProperty("passwordEncoder")
    public void setPasswordEncoder(@Nullable String passwordEncoder) {
      this.passwordEncoder = passwordEncoder;
    }
    @JsonProperty("referral")
    public void setReferral(@Nullable String referral) {
      this.referral = referral;
    }
    @JsonProperty("skipSSLVerification")
    public void setSkipSSLVerification(@Nullable Boolean skipSSLVerification) {
      this.skipSSLVerification = skipSSLVerification;
    }
    @JsonProperty("tlsConfiguration")
    public void setTlsConfiguration(@Nullable TlsConfiguration tlsConfiguration) {
      this.tlsConfiguration = tlsConfiguration;
    }
    @JsonProperty("userDNPattern")
    public void setUserDistinguishedNamePattern(@Nullable String userDistinguishedNamePattern) {
      this.userDistinguishedNamePattern = userDistinguishedNamePattern;
    }
    @JsonProperty("userDNPatternDelimiter")
    public void setUserDistinguishedNamePatternDelimiter(@Nullable String userDistinguishedNamePatternDelimiter) {
      this.userDistinguishedNamePatternDelimiter = userDistinguishedNamePatternDelimiter;
    }
    @JsonProperty("userSearchBase")
    public void setUserSearchBase(@Nullable String userSearchBase) {
      this.userSearchBase = userSearchBase;
    }
    @JsonProperty("userSearchFilter")
    public void setUserSearchFilter(@Nullable String userSearchFilter) {
      this.userSearchFilter = userSearchFilter;
    }
    @Override
    public List<String> getEmailDomains() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderDescription() { throw new UnsupportedOperationException(); }
    @Override
    public AttributeMappings getAttributeMappings() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getExternalGroupsWhitelist() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getStoreCustomAttributes() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAddShadowUserOnLogin() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAutoAddGroups() { throw new UnsupportedOperationException(); }
    @Override
    public String getBaseUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getBindPassword() { throw new UnsupportedOperationException(); }
    @Override
    public String getBindUserDistinguishedName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupRoleAttribute() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupSearchBase() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getGroupSearchDepthLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupSearchFilter() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getGroupSearchSubTree() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getGroupsIgnorePartialResults() { throw new UnsupportedOperationException(); }
    @Override
    public LdapGroupFile getLdapGroupFile() { throw new UnsupportedOperationException(); }
    @Override
    public LdapProfileFile getLdapProfileFile() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLocalPasswordCompare() { throw new UnsupportedOperationException(); }
    @Override
    public String getMailAttributeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getMailSubstitute() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getMailSubstituteOverridesLdap() { throw new UnsupportedOperationException(); }
    @Override
    public String getPasswordAttributeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPasswordEncoder() { throw new UnsupportedOperationException(); }
    @Override
    public String getReferral() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getSkipSSLVerification() { throw new UnsupportedOperationException(); }
    @Override
    public TlsConfiguration getTlsConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserDistinguishedNamePattern() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserDistinguishedNamePatternDelimiter() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserSearchBase() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserSearchFilter() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static LdapConfiguration fromJson(Json json) {
    LdapConfiguration.Builder builder = LdapConfiguration.builder();
    if (json.emailDomains != null) {
      builder.addAllEmailDomains(json.emailDomains);
    }
    if (json.providerDescription != null) {
      builder.providerDescription(json.providerDescription);
    }
    if (json.attributeMappings != null) {
      builder.attributeMappings(json.attributeMappings);
    }
    if (json.externalGroupsWhitelist != null) {
      builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
    }
    if (json.storeCustomAttributes != null) {
      builder.storeCustomAttributes(json.storeCustomAttributes);
    }
    if (json.addShadowUserOnLogin != null) {
      builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
    }
    if (json.autoAddGroups != null) {
      builder.autoAddGroups(json.autoAddGroups);
    }
    if (json.baseUrl != null) {
      builder.baseUrl(json.baseUrl);
    }
    if (json.bindPassword != null) {
      builder.bindPassword(json.bindPassword);
    }
    if (json.bindUserDistinguishedName != null) {
      builder.bindUserDistinguishedName(json.bindUserDistinguishedName);
    }
    if (json.groupRoleAttribute != null) {
      builder.groupRoleAttribute(json.groupRoleAttribute);
    }
    if (json.groupSearchBase != null) {
      builder.groupSearchBase(json.groupSearchBase);
    }
    if (json.groupSearchDepthLimit != null) {
      builder.groupSearchDepthLimit(json.groupSearchDepthLimit);
    }
    if (json.groupSearchFilter != null) {
      builder.groupSearchFilter(json.groupSearchFilter);
    }
    if (json.groupSearchSubTree != null) {
      builder.groupSearchSubTree(json.groupSearchSubTree);
    }
    if (json.groupsIgnorePartialResults != null) {
      builder.groupsIgnorePartialResults(json.groupsIgnorePartialResults);
    }
    if (json.ldapGroupFile != null) {
      builder.ldapGroupFile(json.ldapGroupFile);
    }
    if (json.ldapProfileFile != null) {
      builder.ldapProfileFile(json.ldapProfileFile);
    }
    if (json.localPasswordCompare != null) {
      builder.localPasswordCompare(json.localPasswordCompare);
    }
    if (json.mailAttributeName != null) {
      builder.mailAttributeName(json.mailAttributeName);
    }
    if (json.mailSubstitute != null) {
      builder.mailSubstitute(json.mailSubstitute);
    }
    if (json.mailSubstituteOverridesLdap != null) {
      builder.mailSubstituteOverridesLdap(json.mailSubstituteOverridesLdap);
    }
    if (json.passwordAttributeName != null) {
      builder.passwordAttributeName(json.passwordAttributeName);
    }
    if (json.passwordEncoder != null) {
      builder.passwordEncoder(json.passwordEncoder);
    }
    if (json.referral != null) {
      builder.referral(json.referral);
    }
    if (json.skipSSLVerification != null) {
      builder.skipSSLVerification(json.skipSSLVerification);
    }
    if (json.tlsConfiguration != null) {
      builder.tlsConfiguration(json.tlsConfiguration);
    }
    if (json.userDistinguishedNamePattern != null) {
      builder.userDistinguishedNamePattern(json.userDistinguishedNamePattern);
    }
    if (json.userDistinguishedNamePatternDelimiter != null) {
      builder.userDistinguishedNamePatternDelimiter(json.userDistinguishedNamePatternDelimiter);
    }
    if (json.userSearchBase != null) {
      builder.userSearchBase(json.userSearchBase);
    }
    if (json.userSearchFilter != null) {
      builder.userSearchFilter(json.userSearchFilter);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link LdapConfiguration LdapConfiguration}.
   * <pre>
   * LdapConfiguration.builder()
   *    .emailDomains(List&amp;lt;String&amp;gt; | null) // nullable {@link LdapConfiguration#getEmailDomains() emailDomains}
   *    .providerDescription(String | null) // nullable {@link LdapConfiguration#getProviderDescription() providerDescription}
   *    .attributeMappings(org.cloudfoundry.uaa.identityproviders.AttributeMappings | null) // nullable {@link LdapConfiguration#getAttributeMappings() attributeMappings}
   *    .externalGroupsWhitelist(List&amp;lt;String&amp;gt; | null) // nullable {@link LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist}
   *    .storeCustomAttributes(Boolean | null) // nullable {@link LdapConfiguration#getStoreCustomAttributes() storeCustomAttributes}
   *    .addShadowUserOnLogin(Boolean | null) // nullable {@link LdapConfiguration#getAddShadowUserOnLogin() addShadowUserOnLogin}
   *    .autoAddGroups(Boolean | null) // nullable {@link LdapConfiguration#getAutoAddGroups() autoAddGroups}
   *    .baseUrl(String | null) // nullable {@link LdapConfiguration#getBaseUrl() baseUrl}
   *    .bindPassword(String | null) // nullable {@link LdapConfiguration#getBindPassword() bindPassword}
   *    .bindUserDistinguishedName(String | null) // nullable {@link LdapConfiguration#getBindUserDistinguishedName() bindUserDistinguishedName}
   *    .groupRoleAttribute(String | null) // nullable {@link LdapConfiguration#getGroupRoleAttribute() groupRoleAttribute}
   *    .groupSearchBase(String | null) // nullable {@link LdapConfiguration#getGroupSearchBase() groupSearchBase}
   *    .groupSearchDepthLimit(Integer | null) // nullable {@link LdapConfiguration#getGroupSearchDepthLimit() groupSearchDepthLimit}
   *    .groupSearchFilter(String | null) // nullable {@link LdapConfiguration#getGroupSearchFilter() groupSearchFilter}
   *    .groupSearchSubTree(Boolean | null) // nullable {@link LdapConfiguration#getGroupSearchSubTree() groupSearchSubTree}
   *    .groupsIgnorePartialResults(Boolean | null) // nullable {@link LdapConfiguration#getGroupsIgnorePartialResults() groupsIgnorePartialResults}
   *    .ldapGroupFile(org.cloudfoundry.uaa.identityproviders.LdapGroupFile | null) // nullable {@link LdapConfiguration#getLdapGroupFile() ldapGroupFile}
   *    .ldapProfileFile(org.cloudfoundry.uaa.identityproviders.LdapProfileFile | null) // nullable {@link LdapConfiguration#getLdapProfileFile() ldapProfileFile}
   *    .localPasswordCompare(Boolean | null) // nullable {@link LdapConfiguration#getLocalPasswordCompare() localPasswordCompare}
   *    .mailAttributeName(String | null) // nullable {@link LdapConfiguration#getMailAttributeName() mailAttributeName}
   *    .mailSubstitute(String | null) // nullable {@link LdapConfiguration#getMailSubstitute() mailSubstitute}
   *    .mailSubstituteOverridesLdap(Boolean | null) // nullable {@link LdapConfiguration#getMailSubstituteOverridesLdap() mailSubstituteOverridesLdap}
   *    .passwordAttributeName(String | null) // nullable {@link LdapConfiguration#getPasswordAttributeName() passwordAttributeName}
   *    .passwordEncoder(String | null) // nullable {@link LdapConfiguration#getPasswordEncoder() passwordEncoder}
   *    .referral(String | null) // nullable {@link LdapConfiguration#getReferral() referral}
   *    .skipSSLVerification(Boolean | null) // nullable {@link LdapConfiguration#getSkipSSLVerification() skipSSLVerification}
   *    .tlsConfiguration(org.cloudfoundry.uaa.identityproviders.TlsConfiguration | null) // nullable {@link LdapConfiguration#getTlsConfiguration() tlsConfiguration}
   *    .userDistinguishedNamePattern(String | null) // nullable {@link LdapConfiguration#getUserDistinguishedNamePattern() userDistinguishedNamePattern}
   *    .userDistinguishedNamePatternDelimiter(String | null) // nullable {@link LdapConfiguration#getUserDistinguishedNamePatternDelimiter() userDistinguishedNamePatternDelimiter}
   *    .userSearchBase(String | null) // nullable {@link LdapConfiguration#getUserSearchBase() userSearchBase}
   *    .userSearchFilter(String | null) // nullable {@link LdapConfiguration#getUserSearchFilter() userSearchFilter}
   *    .build();
   * </pre>
   * @return A new LdapConfiguration builder
   */
  public static LdapConfiguration.Builder builder() {
    return new LdapConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link LdapConfiguration LdapConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_LdapConfiguration", generator = "Immutables")
  public static final class Builder {
    private List<String> emailDomains = null;
    private String providerDescription;
    private AttributeMappings attributeMappings;
    private List<String> externalGroupsWhitelist = null;
    private Boolean storeCustomAttributes;
    private Boolean addShadowUserOnLogin;
    private Boolean autoAddGroups;
    private String baseUrl;
    private String bindPassword;
    private String bindUserDistinguishedName;
    private String groupRoleAttribute;
    private String groupSearchBase;
    private Integer groupSearchDepthLimit;
    private String groupSearchFilter;
    private Boolean groupSearchSubTree;
    private Boolean groupsIgnorePartialResults;
    private LdapGroupFile ldapGroupFile;
    private LdapProfileFile ldapProfileFile;
    private Boolean localPasswordCompare;
    private String mailAttributeName;
    private String mailSubstitute;
    private Boolean mailSubstituteOverridesLdap;
    private String passwordAttributeName;
    private String passwordEncoder;
    private String referral;
    private Boolean skipSSLVerification;
    private TlsConfiguration tlsConfiguration;
    private String userDistinguishedNamePattern;
    private String userDistinguishedNamePatternDelimiter;
    private String userSearchBase;
    private String userSearchFilter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code LdapConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LdapConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _LdapConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_LdapConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractIdentityProviderConfiguration) {
        AbstractIdentityProviderConfiguration instance = (AbstractIdentityProviderConfiguration) object;
        if ((bits & 0x4L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x10L;
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._LdapConfiguration) {
        org.cloudfoundry.uaa.identityproviders._LdapConfiguration instance = (org.cloudfoundry.uaa.identityproviders._LdapConfiguration) object;
        if ((bits & 0x1L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x1L;
        }
        String bindPasswordValue = instance.getBindPassword();
        if (bindPasswordValue != null) {
          bindPassword(bindPasswordValue);
        }
        Boolean mailSubstituteOverridesLdapValue = instance.getMailSubstituteOverridesLdap();
        if (mailSubstituteOverridesLdapValue != null) {
          mailSubstituteOverridesLdap(mailSubstituteOverridesLdapValue);
        }
        Boolean skipSSLVerificationValue = instance.getSkipSSLVerification();
        if (skipSSLVerificationValue != null) {
          skipSSLVerification(skipSSLVerificationValue);
        }
        LdapGroupFile ldapGroupFileValue = instance.getLdapGroupFile();
        if (ldapGroupFileValue != null) {
          ldapGroupFile(ldapGroupFileValue);
        }
        Boolean autoAddGroupsValue = instance.getAutoAddGroups();
        if (autoAddGroupsValue != null) {
          autoAddGroups(autoAddGroupsValue);
        }
        LdapProfileFile ldapProfileFileValue = instance.getLdapProfileFile();
        if (ldapProfileFileValue != null) {
          ldapProfileFile(ldapProfileFileValue);
        }
        String userSearchBaseValue = instance.getUserSearchBase();
        if (userSearchBaseValue != null) {
          userSearchBase(userSearchBaseValue);
        }
        String groupRoleAttributeValue = instance.getGroupRoleAttribute();
        if (groupRoleAttributeValue != null) {
          groupRoleAttribute(groupRoleAttributeValue);
        }
        String userSearchFilterValue = instance.getUserSearchFilter();
        if (userSearchFilterValue != null) {
          userSearchFilter(userSearchFilterValue);
        }
        String groupSearchFilterValue = instance.getGroupSearchFilter();
        if (groupSearchFilterValue != null) {
          groupSearchFilter(groupSearchFilterValue);
        }
        Integer groupSearchDepthLimitValue = instance.getGroupSearchDepthLimit();
        if (groupSearchDepthLimitValue != null) {
          groupSearchDepthLimit(groupSearchDepthLimitValue);
        }
        if ((bits & 0x2L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x2L;
        }
        String mailSubstituteValue = instance.getMailSubstitute();
        if (mailSubstituteValue != null) {
          mailSubstitute(mailSubstituteValue);
        }
        String bindUserDistinguishedNameValue = instance.getBindUserDistinguishedName();
        if (bindUserDistinguishedNameValue != null) {
          bindUserDistinguishedName(bindUserDistinguishedNameValue);
        }
        TlsConfiguration tlsConfigurationValue = instance.getTlsConfiguration();
        if (tlsConfigurationValue != null) {
          tlsConfiguration(tlsConfigurationValue);
        }
        Boolean groupsIgnorePartialResultsValue = instance.getGroupsIgnorePartialResults();
        if (groupsIgnorePartialResultsValue != null) {
          groupsIgnorePartialResults(groupsIgnorePartialResultsValue);
        }
        String userDistinguishedNamePatternValue = instance.getUserDistinguishedNamePattern();
        if (userDistinguishedNamePatternValue != null) {
          userDistinguishedNamePattern(userDistinguishedNamePatternValue);
        }
        if ((bits & 0x4L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x4L;
        }
        Boolean groupSearchSubTreeValue = instance.getGroupSearchSubTree();
        if (groupSearchSubTreeValue != null) {
          groupSearchSubTree(groupSearchSubTreeValue);
        }
        if ((bits & 0x8L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x8L;
        }
        Boolean addShadowUserOnLoginValue = instance.getAddShadowUserOnLogin();
        if (addShadowUserOnLoginValue != null) {
          addShadowUserOnLogin(addShadowUserOnLoginValue);
        }
        Boolean localPasswordCompareValue = instance.getLocalPasswordCompare();
        if (localPasswordCompareValue != null) {
          localPasswordCompare(localPasswordCompareValue);
        }
        String userDistinguishedNamePatternDelimiterValue = instance.getUserDistinguishedNamePatternDelimiter();
        if (userDistinguishedNamePatternDelimiterValue != null) {
          userDistinguishedNamePatternDelimiter(userDistinguishedNamePatternDelimiterValue);
        }
        String passwordEncoderValue = instance.getPasswordEncoder();
        if (passwordEncoderValue != null) {
          passwordEncoder(passwordEncoderValue);
        }
        String baseUrlValue = instance.getBaseUrl();
        if (baseUrlValue != null) {
          baseUrl(baseUrlValue);
        }
        String groupSearchBaseValue = instance.getGroupSearchBase();
        if (groupSearchBaseValue != null) {
          groupSearchBase(groupSearchBaseValue);
        }
        String referralValue = instance.getReferral();
        if (referralValue != null) {
          referral(referralValue);
        }
        String mailAttributeNameValue = instance.getMailAttributeName();
        if (mailAttributeNameValue != null) {
          mailAttributeName(mailAttributeNameValue);
        }
        String passwordAttributeNameValue = instance.getPasswordAttributeName();
        if (passwordAttributeNameValue != null) {
          passwordAttributeName(passwordAttributeNameValue);
        }
        if ((bits & 0x10L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x10L;
        }
      }
      if (object instanceof AbstractExternalIdentityProviderConfiguration) {
        AbstractExternalIdentityProviderConfiguration instance = (AbstractExternalIdentityProviderConfiguration) object;
        if ((bits & 0x2L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x8L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Adds one element to {@link LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param element A emailDomains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String element) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      return this;
    }

    /**
     * Adds elements to {@link LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An array of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomains(String... elements) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emailDomain")
    public final Builder emailDomains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.emailDomains = null;
        return this;
      }
      this.emailDomains = new ArrayList<String>();
      return addAllEmailDomains(elements);
    }

    /**
     * Adds elements to {@link LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmailDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "emailDomains element");
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getProviderDescription() providerDescription} attribute.
     * @param providerDescription The value for providerDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("providerDescription")
    public final Builder providerDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getAttributeMappings() attributeMappings} attribute.
     * @param attributeMappings The value for attributeMappings (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("attributeMappings")
    public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
      return this;
    }

    /**
     * Adds one element to {@link LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param element A externalGroupsWhitelist element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String element) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      return this;
    }

    /**
     * Adds elements to {@link LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An array of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String... elements) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalGroupsWhitelist")
    public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.externalGroupsWhitelist = null;
        return this;
      }
      this.externalGroupsWhitelist = new ArrayList<String>();
      return addAllExternalGroupsWhitelist(elements);
    }

    /**
     * Adds elements to {@link LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
      Objects.requireNonNull(elements, "externalGroupsWhitelist element");
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getStoreCustomAttributes() storeCustomAttributes} attribute.
     * @param storeCustomAttributes The value for storeCustomAttributes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("storeCustomAttributes")
    public final Builder storeCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getAddShadowUserOnLogin() addShadowUserOnLogin} attribute.
     * @param addShadowUserOnLogin The value for addShadowUserOnLogin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("addShadowUserOnLogin")
    public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getAutoAddGroups() autoAddGroups} attribute.
     * @param autoAddGroups The value for autoAddGroups (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("autoAddGroups")
    public final Builder autoAddGroups(@Nullable Boolean autoAddGroups) {
      this.autoAddGroups = autoAddGroups;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getBaseUrl() baseUrl} attribute.
     * @param baseUrl The value for baseUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("baseUrl")
    public final Builder baseUrl(@Nullable String baseUrl) {
      this.baseUrl = baseUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getBindPassword() bindPassword} attribute.
     * @param bindPassword The value for bindPassword (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bindPassword")
    public final Builder bindPassword(@Nullable String bindPassword) {
      this.bindPassword = bindPassword;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getBindUserDistinguishedName() bindUserDistinguishedName} attribute.
     * @param bindUserDistinguishedName The value for bindUserDistinguishedName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bindUserDn")
    public final Builder bindUserDistinguishedName(@Nullable String bindUserDistinguishedName) {
      this.bindUserDistinguishedName = bindUserDistinguishedName;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getGroupRoleAttribute() groupRoleAttribute} attribute.
     * @param groupRoleAttribute The value for groupRoleAttribute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupRoleAttribute")
    public final Builder groupRoleAttribute(@Nullable String groupRoleAttribute) {
      this.groupRoleAttribute = groupRoleAttribute;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getGroupSearchBase() groupSearchBase} attribute.
     * @param groupSearchBase The value for groupSearchBase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupSearchBase")
    public final Builder groupSearchBase(@Nullable String groupSearchBase) {
      this.groupSearchBase = groupSearchBase;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getGroupSearchDepthLimit() groupSearchDepthLimit} attribute.
     * @param groupSearchDepthLimit The value for groupSearchDepthLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maxGroupSearchDepth")
    public final Builder groupSearchDepthLimit(@Nullable Integer groupSearchDepthLimit) {
      this.groupSearchDepthLimit = groupSearchDepthLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getGroupSearchFilter() groupSearchFilter} attribute.
     * @param groupSearchFilter The value for groupSearchFilter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupSearchFilter")
    public final Builder groupSearchFilter(@Nullable String groupSearchFilter) {
      this.groupSearchFilter = groupSearchFilter;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getGroupSearchSubTree() groupSearchSubTree} attribute.
     * @param groupSearchSubTree The value for groupSearchSubTree (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupSearchSubTree")
    public final Builder groupSearchSubTree(@Nullable Boolean groupSearchSubTree) {
      this.groupSearchSubTree = groupSearchSubTree;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getGroupsIgnorePartialResults() groupsIgnorePartialResults} attribute.
     * @param groupsIgnorePartialResults The value for groupsIgnorePartialResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupsIgnorePartialResults")
    public final Builder groupsIgnorePartialResults(@Nullable Boolean groupsIgnorePartialResults) {
      this.groupsIgnorePartialResults = groupsIgnorePartialResults;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getLdapGroupFile() ldapGroupFile} attribute.
     * @param ldapGroupFile The value for ldapGroupFile (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ldapGroupFile")
    public final Builder ldapGroupFile(@Nullable LdapGroupFile ldapGroupFile) {
      this.ldapGroupFile = ldapGroupFile;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getLdapProfileFile() ldapProfileFile} attribute.
     * @param ldapProfileFile The value for ldapProfileFile (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ldapProfileFile")
    public final Builder ldapProfileFile(@Nullable LdapProfileFile ldapProfileFile) {
      this.ldapProfileFile = ldapProfileFile;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getLocalPasswordCompare() localPasswordCompare} attribute.
     * @param localPasswordCompare The value for localPasswordCompare (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("localPasswordCompare")
    public final Builder localPasswordCompare(@Nullable Boolean localPasswordCompare) {
      this.localPasswordCompare = localPasswordCompare;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getMailAttributeName() mailAttributeName} attribute.
     * @param mailAttributeName The value for mailAttributeName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mailAttributeName")
    public final Builder mailAttributeName(@Nullable String mailAttributeName) {
      this.mailAttributeName = mailAttributeName;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getMailSubstitute() mailSubstitute} attribute.
     * @param mailSubstitute The value for mailSubstitute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mailSubstitute")
    public final Builder mailSubstitute(@Nullable String mailSubstitute) {
      this.mailSubstitute = mailSubstitute;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getMailSubstituteOverridesLdap() mailSubstituteOverridesLdap} attribute.
     * @param mailSubstituteOverridesLdap The value for mailSubstituteOverridesLdap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mailSubstituteOverridesLdap")
    public final Builder mailSubstituteOverridesLdap(@Nullable Boolean mailSubstituteOverridesLdap) {
      this.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getPasswordAttributeName() passwordAttributeName} attribute.
     * @param passwordAttributeName The value for passwordAttributeName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwordAttributeName")
    public final Builder passwordAttributeName(@Nullable String passwordAttributeName) {
      this.passwordAttributeName = passwordAttributeName;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getPasswordEncoder() passwordEncoder} attribute.
     * @param passwordEncoder The value for passwordEncoder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwordEncoder")
    public final Builder passwordEncoder(@Nullable String passwordEncoder) {
      this.passwordEncoder = passwordEncoder;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getReferral() referral} attribute.
     * @param referral The value for referral (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("referral")
    public final Builder referral(@Nullable String referral) {
      this.referral = referral;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getSkipSSLVerification() skipSSLVerification} attribute.
     * @param skipSSLVerification The value for skipSSLVerification (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("skipSSLVerification")
    public final Builder skipSSLVerification(@Nullable Boolean skipSSLVerification) {
      this.skipSSLVerification = skipSSLVerification;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getTlsConfiguration() tlsConfiguration} attribute.
     * @param tlsConfiguration The value for tlsConfiguration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tlsConfiguration")
    public final Builder tlsConfiguration(@Nullable TlsConfiguration tlsConfiguration) {
      this.tlsConfiguration = tlsConfiguration;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getUserDistinguishedNamePattern() userDistinguishedNamePattern} attribute.
     * @param userDistinguishedNamePattern The value for userDistinguishedNamePattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userDNPattern")
    public final Builder userDistinguishedNamePattern(@Nullable String userDistinguishedNamePattern) {
      this.userDistinguishedNamePattern = userDistinguishedNamePattern;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getUserDistinguishedNamePatternDelimiter() userDistinguishedNamePatternDelimiter} attribute.
     * @param userDistinguishedNamePatternDelimiter The value for userDistinguishedNamePatternDelimiter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userDNPatternDelimiter")
    public final Builder userDistinguishedNamePatternDelimiter(@Nullable String userDistinguishedNamePatternDelimiter) {
      this.userDistinguishedNamePatternDelimiter = userDistinguishedNamePatternDelimiter;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getUserSearchBase() userSearchBase} attribute.
     * @param userSearchBase The value for userSearchBase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userSearchBase")
    public final Builder userSearchBase(@Nullable String userSearchBase) {
      this.userSearchBase = userSearchBase;
      return this;
    }

    /**
     * Initializes the value for the {@link LdapConfiguration#getUserSearchFilter() userSearchFilter} attribute.
     * @param userSearchFilter The value for userSearchFilter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userSearchFilter")
    public final Builder userSearchFilter(@Nullable String userSearchFilter) {
      this.userSearchFilter = userSearchFilter;
      return this;
    }

    /**
     * Builds a new {@link LdapConfiguration LdapConfiguration}.
     * @return An immutable instance of LdapConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LdapConfiguration build() {
      return new LdapConfiguration(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
