package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the OpenId Connect (oidc) identity provider configuration
 */
@Generated(from = "_OpenIdConnectConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OpenIdConnectConfiguration
    extends org.cloudfoundry.uaa.identityproviders._OpenIdConnectConfiguration {
  private final @Nullable List<String> emailDomains;
  private final @Nullable String providerDescription;
  private final @Nullable AttributeMappings attributeMappings;
  private final @Nullable List<String> externalGroupsWhitelist;
  private final @Nullable Boolean storeCustomAttributes;
  private final @Nullable Boolean addShadowUserOnLogin;
  private final String authUrl;
  private final @Nullable Boolean linkText;
  private final String relyingPartyId;
  private final @Nullable String relyingPartySecret;
  private final @Nullable List<String> scopes;
  private final @Nullable Boolean showLinkText;
  private final @Nullable Boolean skipSslVerification;
  private final @Nullable String tokenKey;
  private final @Nullable String tokenKeyUrl;
  private final String tokenUrl;
  private final @Nullable String userInfoUrl;

  private OpenIdConnectConfiguration(OpenIdConnectConfiguration.Builder builder) {
    this.emailDomains = builder.emailDomains == null ? null : createUnmodifiableList(true, builder.emailDomains);
    this.providerDescription = builder.providerDescription;
    this.attributeMappings = builder.attributeMappings;
    this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : createUnmodifiableList(true, builder.externalGroupsWhitelist);
    this.storeCustomAttributes = builder.storeCustomAttributes;
    this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
    this.authUrl = builder.authUrl;
    this.linkText = builder.linkText;
    this.relyingPartyId = builder.relyingPartyId;
    this.relyingPartySecret = builder.relyingPartySecret;
    this.scopes = builder.scopes == null ? null : createUnmodifiableList(true, builder.scopes);
    this.showLinkText = builder.showLinkText;
    this.skipSslVerification = builder.skipSslVerification;
    this.tokenKey = builder.tokenKey;
    this.tokenKeyUrl = builder.tokenKeyUrl;
    this.tokenUrl = builder.tokenUrl;
    this.userInfoUrl = builder.userInfoUrl;
  }

  /**
   * List of email domains associated with the provider for the purpose of associating users to the correct origin upon invitation. If empty list, no invitations are accepted. Wildcards supported.
   */
  @JsonProperty("emailDomain")
  @Override
  public @Nullable List<String> getEmailDomains() {
    return emailDomains;
  }

  /**
   * Human readable name/description of this provider
   */
  @JsonProperty("providerDescription")
  @Override
  public @Nullable String getProviderDescription() {
    return providerDescription;
  }

  /**
   * @return The value of the {@code attributeMappings} attribute
   */
  @JsonProperty("attributeMappings")
  @Override
  public @Nullable AttributeMappings getAttributeMappings() {
    return attributeMappings;
  }

  /**
   * The external group white list
   */
  @JsonProperty("externalGroupsWhitelist")
  @Override
  public @Nullable List<String> getExternalGroupsWhitelist() {
    return externalGroupsWhitelist;
  }

  /**
   * Set to true, to store custom user attributes to be fetched from the /userinfo endpoint
   */
  @JsonProperty("storeCustomAttributes")
  @Override
  public @Nullable Boolean getStoreCustomAttributes() {
    return storeCustomAttributes;
  }

  /**
   * Determines whether or not shadow users must be created before login by an administrator.
   */
  @JsonProperty("addShadowUserOnLogin")
  @Override
  public @Nullable Boolean getAddShadowUserOnLogin() {
    return addShadowUserOnLogin;
  }

  /**
   * The OAuth 2.0 authorization endpoint URL
   */
  @JsonProperty("authUrl")
  @Override
  public String getAuthUrl() {
    return authUrl;
  }

  /**
   * Text to use for the login link to the provider
   */
  @JsonProperty("linkText")
  @Override
  public @Nullable Boolean getLinkText() {
    return linkText;
  }

  /**
   * The client ID which is registered with the external OAuth provider for use by the UAA
   */
  @JsonProperty("relyingPartyId")
  @Override
  public String getRelyingPartyId() {
    return relyingPartyId;
  }

  /**
   * The client secret of the relying party at the external OAuth provider
   */
  @JsonProperty("relyingPartySecret")
  @Override
  public @Nullable String getRelyingPartySecret() {
    return relyingPartySecret;
  }

  /**
   * What scopes to request on a call to the external OAuth/OpenID provider. For example, can provide openid, roles, or profile to request ID token, scopes populated in the ID token external groups
   * attribute mappings, or the user profile information, respectively.
   */
  @JsonProperty("scopes")
  @Override
  public @Nullable List<String> getScopes() {
    return scopes;
  }

  /**
   * A flag controlling whether a link to this provider’s login will be shown on the UAA login page
   */
  @JsonProperty("showLinkText")
  @Override
  public @Nullable Boolean getShowLinkText() {
    return showLinkText;
  }

  /**
   * Skips validation of the LDAP cert if set to true.
   */
  @JsonProperty("skipSslValidation")
  @Override
  public @Nullable Boolean getSkipSslVerification() {
    return skipSslVerification;
  }

  /**
   * A verification key for validating token signatures
   */
  @JsonProperty("tokenKey")
  @Override
  public @Nullable String getTokenKey() {
    return tokenKey;
  }

  /**
   * The URL of the token key endpoint which renders a verification key for validating token signatures
   */
  @JsonProperty("tokenKeyUrl")
  @Override
  public @Nullable String getTokenKeyUrl() {
    return tokenKeyUrl;
  }

  /**
   * The OAuth 2.0 authorization endpoint URL
   */
  @JsonProperty("tokenUrl")
  @Override
  public String getTokenUrl() {
    return tokenUrl;
  }

  /**
   * The Open Id user info endpoint URL. Reserved for future OIDC use.
   */
  @JsonProperty("userInfoUrl")
  @Override
  public @Nullable String getUserInfoUrl() {
    return userInfoUrl;
  }

  /**
   * This instance is equal to all instances of {@code OpenIdConnectConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OpenIdConnectConfiguration
        && equalTo(0, (OpenIdConnectConfiguration) another);
  }

  private boolean equalTo(int synthetic, OpenIdConnectConfiguration another) {
    return Objects.equals(emailDomains, another.emailDomains)
        && Objects.equals(providerDescription, another.providerDescription)
        && Objects.equals(attributeMappings, another.attributeMappings)
        && Objects.equals(externalGroupsWhitelist, another.externalGroupsWhitelist)
        && Objects.equals(storeCustomAttributes, another.storeCustomAttributes)
        && Objects.equals(addShadowUserOnLogin, another.addShadowUserOnLogin)
        && authUrl.equals(another.authUrl)
        && Objects.equals(linkText, another.linkText)
        && relyingPartyId.equals(another.relyingPartyId)
        && Objects.equals(relyingPartySecret, another.relyingPartySecret)
        && Objects.equals(scopes, another.scopes)
        && Objects.equals(showLinkText, another.showLinkText)
        && Objects.equals(skipSslVerification, another.skipSslVerification)
        && Objects.equals(tokenKey, another.tokenKey)
        && Objects.equals(tokenKeyUrl, another.tokenKeyUrl)
        && tokenUrl.equals(another.tokenUrl)
        && Objects.equals(userInfoUrl, another.userInfoUrl);
  }

  /**
   * Computes a hash code from attributes: {@code emailDomains}, {@code providerDescription}, {@code attributeMappings}, {@code externalGroupsWhitelist}, {@code storeCustomAttributes}, {@code addShadowUserOnLogin}, {@code authUrl}, {@code linkText}, {@code relyingPartyId}, {@code relyingPartySecret}, {@code scopes}, {@code showLinkText}, {@code skipSslVerification}, {@code tokenKey}, {@code tokenKeyUrl}, {@code tokenUrl}, {@code userInfoUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(emailDomains);
    h += (h << 5) + Objects.hashCode(providerDescription);
    h += (h << 5) + Objects.hashCode(attributeMappings);
    h += (h << 5) + Objects.hashCode(externalGroupsWhitelist);
    h += (h << 5) + Objects.hashCode(storeCustomAttributes);
    h += (h << 5) + Objects.hashCode(addShadowUserOnLogin);
    h += (h << 5) + authUrl.hashCode();
    h += (h << 5) + Objects.hashCode(linkText);
    h += (h << 5) + relyingPartyId.hashCode();
    h += (h << 5) + Objects.hashCode(relyingPartySecret);
    h += (h << 5) + Objects.hashCode(scopes);
    h += (h << 5) + Objects.hashCode(showLinkText);
    h += (h << 5) + Objects.hashCode(skipSslVerification);
    h += (h << 5) + Objects.hashCode(tokenKey);
    h += (h << 5) + Objects.hashCode(tokenKeyUrl);
    h += (h << 5) + tokenUrl.hashCode();
    h += (h << 5) + Objects.hashCode(userInfoUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code OpenIdConnectConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OpenIdConnectConfiguration{"
        + "emailDomains=" + emailDomains
        + ", providerDescription=" + providerDescription
        + ", attributeMappings=" + attributeMappings
        + ", externalGroupsWhitelist=" + externalGroupsWhitelist
        + ", storeCustomAttributes=" + storeCustomAttributes
        + ", addShadowUserOnLogin=" + addShadowUserOnLogin
        + ", authUrl=" + authUrl
        + ", linkText=" + linkText
        + ", relyingPartyId=" + relyingPartyId
        + ", relyingPartySecret=" + relyingPartySecret
        + ", scopes=" + scopes
        + ", showLinkText=" + showLinkText
        + ", skipSslVerification=" + skipSslVerification
        + ", tokenKey=" + tokenKey
        + ", tokenKeyUrl=" + tokenKeyUrl
        + ", tokenUrl=" + tokenUrl
        + ", userInfoUrl=" + userInfoUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_OpenIdConnectConfiguration", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._OpenIdConnectConfiguration {
    List<String> emailDomains = null;
    String providerDescription;
    AttributeMappings attributeMappings;
    List<String> externalGroupsWhitelist = null;
    Boolean storeCustomAttributes;
    Boolean addShadowUserOnLogin;
    String authUrl;
    Boolean linkText;
    String relyingPartyId;
    String relyingPartySecret;
    List<String> scopes = null;
    Boolean showLinkText;
    Boolean skipSslVerification;
    String tokenKey;
    String tokenKeyUrl;
    String tokenUrl;
    String userInfoUrl;
    @JsonProperty("emailDomain")
    public void setEmailDomains(@Nullable List<String> emailDomains) {
      this.emailDomains = emailDomains;
    }
    @JsonProperty("providerDescription")
    public void setProviderDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
    }
    @JsonProperty("attributeMappings")
    public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
    }
    @JsonProperty("externalGroupsWhitelist")
    public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
      this.externalGroupsWhitelist = externalGroupsWhitelist;
    }
    @JsonProperty("storeCustomAttributes")
    public void setStoreCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
    }
    @JsonProperty("addShadowUserOnLogin")
    public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
    }
    @JsonProperty("authUrl")
    public void setAuthUrl(String authUrl) {
      this.authUrl = authUrl;
    }
    @JsonProperty("linkText")
    public void setLinkText(@Nullable Boolean linkText) {
      this.linkText = linkText;
    }
    @JsonProperty("relyingPartyId")
    public void setRelyingPartyId(String relyingPartyId) {
      this.relyingPartyId = relyingPartyId;
    }
    @JsonProperty("relyingPartySecret")
    public void setRelyingPartySecret(@Nullable String relyingPartySecret) {
      this.relyingPartySecret = relyingPartySecret;
    }
    @JsonProperty("scopes")
    public void setScopes(@Nullable List<String> scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("showLinkText")
    public void setShowLinkText(@Nullable Boolean showLinkText) {
      this.showLinkText = showLinkText;
    }
    @JsonProperty("skipSslValidation")
    public void setSkipSslVerification(@Nullable Boolean skipSslVerification) {
      this.skipSslVerification = skipSslVerification;
    }
    @JsonProperty("tokenKey")
    public void setTokenKey(@Nullable String tokenKey) {
      this.tokenKey = tokenKey;
    }
    @JsonProperty("tokenKeyUrl")
    public void setTokenKeyUrl(@Nullable String tokenKeyUrl) {
      this.tokenKeyUrl = tokenKeyUrl;
    }
    @JsonProperty("tokenUrl")
    public void setTokenUrl(String tokenUrl) {
      this.tokenUrl = tokenUrl;
    }
    @JsonProperty("userInfoUrl")
    public void setUserInfoUrl(@Nullable String userInfoUrl) {
      this.userInfoUrl = userInfoUrl;
    }
    @Override
    public List<String> getEmailDomains() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderDescription() { throw new UnsupportedOperationException(); }
    @Override
    public AttributeMappings getAttributeMappings() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getExternalGroupsWhitelist() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getStoreCustomAttributes() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAddShadowUserOnLogin() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLinkText() { throw new UnsupportedOperationException(); }
    @Override
    public String getRelyingPartyId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRelyingPartySecret() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getShowLinkText() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getSkipSslVerification() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenKey() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenKeyUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserInfoUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OpenIdConnectConfiguration fromJson(Json json) {
    OpenIdConnectConfiguration.Builder builder = OpenIdConnectConfiguration.builder();
    if (json.emailDomains != null) {
      builder.addAllEmailDomains(json.emailDomains);
    }
    if (json.providerDescription != null) {
      builder.providerDescription(json.providerDescription);
    }
    if (json.attributeMappings != null) {
      builder.attributeMappings(json.attributeMappings);
    }
    if (json.externalGroupsWhitelist != null) {
      builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
    }
    if (json.storeCustomAttributes != null) {
      builder.storeCustomAttributes(json.storeCustomAttributes);
    }
    if (json.addShadowUserOnLogin != null) {
      builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
    }
    if (json.authUrl != null) {
      builder.authUrl(json.authUrl);
    }
    if (json.linkText != null) {
      builder.linkText(json.linkText);
    }
    if (json.relyingPartyId != null) {
      builder.relyingPartyId(json.relyingPartyId);
    }
    if (json.relyingPartySecret != null) {
      builder.relyingPartySecret(json.relyingPartySecret);
    }
    if (json.scopes != null) {
      builder.addAllScopes(json.scopes);
    }
    if (json.showLinkText != null) {
      builder.showLinkText(json.showLinkText);
    }
    if (json.skipSslVerification != null) {
      builder.skipSslVerification(json.skipSslVerification);
    }
    if (json.tokenKey != null) {
      builder.tokenKey(json.tokenKey);
    }
    if (json.tokenKeyUrl != null) {
      builder.tokenKeyUrl(json.tokenKeyUrl);
    }
    if (json.tokenUrl != null) {
      builder.tokenUrl(json.tokenUrl);
    }
    if (json.userInfoUrl != null) {
      builder.userInfoUrl(json.userInfoUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OpenIdConnectConfiguration OpenIdConnectConfiguration}.
   * <pre>
   * OpenIdConnectConfiguration.builder()
   *    .emailDomains(List&amp;lt;String&amp;gt; | null) // nullable {@link OpenIdConnectConfiguration#getEmailDomains() emailDomains}
   *    .providerDescription(String | null) // nullable {@link OpenIdConnectConfiguration#getProviderDescription() providerDescription}
   *    .attributeMappings(org.cloudfoundry.uaa.identityproviders.AttributeMappings | null) // nullable {@link OpenIdConnectConfiguration#getAttributeMappings() attributeMappings}
   *    .externalGroupsWhitelist(List&amp;lt;String&amp;gt; | null) // nullable {@link OpenIdConnectConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist}
   *    .storeCustomAttributes(Boolean | null) // nullable {@link OpenIdConnectConfiguration#getStoreCustomAttributes() storeCustomAttributes}
   *    .addShadowUserOnLogin(Boolean | null) // nullable {@link OpenIdConnectConfiguration#getAddShadowUserOnLogin() addShadowUserOnLogin}
   *    .authUrl(String) // required {@link OpenIdConnectConfiguration#getAuthUrl() authUrl}
   *    .linkText(Boolean | null) // nullable {@link OpenIdConnectConfiguration#getLinkText() linkText}
   *    .relyingPartyId(String) // required {@link OpenIdConnectConfiguration#getRelyingPartyId() relyingPartyId}
   *    .relyingPartySecret(String | null) // nullable {@link OpenIdConnectConfiguration#getRelyingPartySecret() relyingPartySecret}
   *    .scopes(List&amp;lt;String&amp;gt; | null) // nullable {@link OpenIdConnectConfiguration#getScopes() scopes}
   *    .showLinkText(Boolean | null) // nullable {@link OpenIdConnectConfiguration#getShowLinkText() showLinkText}
   *    .skipSslVerification(Boolean | null) // nullable {@link OpenIdConnectConfiguration#getSkipSslVerification() skipSslVerification}
   *    .tokenKey(String | null) // nullable {@link OpenIdConnectConfiguration#getTokenKey() tokenKey}
   *    .tokenKeyUrl(String | null) // nullable {@link OpenIdConnectConfiguration#getTokenKeyUrl() tokenKeyUrl}
   *    .tokenUrl(String) // required {@link OpenIdConnectConfiguration#getTokenUrl() tokenUrl}
   *    .userInfoUrl(String | null) // nullable {@link OpenIdConnectConfiguration#getUserInfoUrl() userInfoUrl}
   *    .build();
   * </pre>
   * @return A new OpenIdConnectConfiguration builder
   */
  public static OpenIdConnectConfiguration.Builder builder() {
    return new OpenIdConnectConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link OpenIdConnectConfiguration OpenIdConnectConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OpenIdConnectConfiguration", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUTH_URL = 0x1L;
    private static final long INIT_BIT_RELYING_PARTY_ID = 0x2L;
    private static final long INIT_BIT_TOKEN_URL = 0x4L;
    private long initBits = 0x7L;

    private List<String> emailDomains = null;
    private String providerDescription;
    private AttributeMappings attributeMappings;
    private List<String> externalGroupsWhitelist = null;
    private Boolean storeCustomAttributes;
    private Boolean addShadowUserOnLogin;
    private String authUrl;
    private Boolean linkText;
    private String relyingPartyId;
    private String relyingPartySecret;
    private List<String> scopes = null;
    private Boolean showLinkText;
    private Boolean skipSslVerification;
    private String tokenKey;
    private String tokenKeyUrl;
    private String tokenUrl;
    private String userInfoUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code OpenIdConnectConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OpenIdConnectConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _OpenIdConnectConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_OpenIdConnectConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractAuthenticationConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractAuthenticationConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AbstractIdentityProviderConfiguration) {
        AbstractIdentityProviderConfiguration instance = (AbstractIdentityProviderConfiguration) object;
        if ((bits & 0x20L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._OpenIdConnectConfiguration) {
        org.cloudfoundry.uaa.identityproviders._OpenIdConnectConfiguration instance = (org.cloudfoundry.uaa.identityproviders._OpenIdConnectConfiguration) object;
        if ((bits & 0x1L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x1L;
        }
        String userInfoUrlValue = instance.getUserInfoUrl();
        if (userInfoUrlValue != null) {
          userInfoUrl(userInfoUrlValue);
        }
        if ((bits & 0x2L) == 0) {
          Boolean showLinkTextValue = instance.getShowLinkText();
          if (showLinkTextValue != null) {
            showLinkText(showLinkTextValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          String relyingPartySecretValue = instance.getRelyingPartySecret();
          if (relyingPartySecretValue != null) {
            relyingPartySecret(relyingPartySecretValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          tokenUrl(instance.getTokenUrl());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          Boolean linkTextValue = instance.getLinkText();
          if (linkTextValue != null) {
            linkText(linkTextValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          relyingPartyId(instance.getRelyingPartyId());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Boolean addShadowUserOnLoginValue = instance.getAddShadowUserOnLogin();
          if (addShadowUserOnLoginValue != null) {
            addShadowUserOnLogin(addShadowUserOnLoginValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          authUrl(instance.getAuthUrl());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          String tokenKeyValue = instance.getTokenKey();
          if (tokenKeyValue != null) {
            tokenKey(tokenKeyValue);
          }
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          String tokenKeyUrlValue = instance.getTokenKeyUrl();
          if (tokenKeyUrlValue != null) {
            tokenKeyUrl(tokenKeyUrlValue);
          }
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          Boolean skipSslVerificationValue = instance.getSkipSslVerification();
          if (skipSslVerificationValue != null) {
            skipSslVerification(skipSslVerificationValue);
          }
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
        if ((bits & 0x8000L) == 0) {
          List<String> scopesValue = instance.getScopes();
          if (scopesValue != null) {
            addAllScopes(scopesValue);
          }
          bits |= 0x8000L;
        }
      }
      if (object instanceof AbstractAuthenticationConfiguration) {
        AbstractAuthenticationConfiguration instance = (AbstractAuthenticationConfiguration) object;
        if ((bits & 0x1L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          Boolean showLinkTextValue = instance.getShowLinkText();
          if (showLinkTextValue != null) {
            showLinkText(showLinkTextValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          String relyingPartySecretValue = instance.getRelyingPartySecret();
          if (relyingPartySecretValue != null) {
            relyingPartySecret(relyingPartySecretValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          tokenUrl(instance.getTokenUrl());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          Boolean linkTextValue = instance.getLinkText();
          if (linkTextValue != null) {
            linkText(linkTextValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          relyingPartyId(instance.getRelyingPartyId());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Boolean addShadowUserOnLoginValue = instance.getAddShadowUserOnLogin();
          if (addShadowUserOnLoginValue != null) {
            addShadowUserOnLogin(addShadowUserOnLoginValue);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          authUrl(instance.getAuthUrl());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          String tokenKeyValue = instance.getTokenKey();
          if (tokenKeyValue != null) {
            tokenKey(tokenKeyValue);
          }
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          String tokenKeyUrlValue = instance.getTokenKeyUrl();
          if (tokenKeyUrlValue != null) {
            tokenKeyUrl(tokenKeyUrlValue);
          }
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          Boolean skipSslVerificationValue = instance.getSkipSslVerification();
          if (skipSslVerificationValue != null) {
            skipSslVerification(skipSslVerificationValue);
          }
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
        if ((bits & 0x8000L) == 0) {
          List<String> scopesValue = instance.getScopes();
          if (scopesValue != null) {
            addAllScopes(scopesValue);
          }
          bits |= 0x8000L;
        }
      }
      if (object instanceof AbstractExternalIdentityProviderConfiguration) {
        AbstractExternalIdentityProviderConfiguration instance = (AbstractExternalIdentityProviderConfiguration) object;
        if ((bits & 0x1L) == 0) {
          List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
          if (externalGroupsWhitelistValue != null) {
            addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x20L) == 0) {
          List<String> emailDomainsValue = instance.getEmailDomains();
          if (emailDomainsValue != null) {
            addAllEmailDomains(emailDomainsValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x4000L) == 0) {
          String providerDescriptionValue = instance.getProviderDescription();
          if (providerDescriptionValue != null) {
            providerDescription(providerDescriptionValue);
          }
          bits |= 0x4000L;
        }
        if ((bits & 0x4L) == 0) {
          AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
          if (attributeMappingsValue != null) {
            attributeMappings(attributeMappingsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x100L) == 0) {
          Boolean storeCustomAttributesValue = instance.getStoreCustomAttributes();
          if (storeCustomAttributesValue != null) {
            storeCustomAttributes(storeCustomAttributesValue);
          }
          bits |= 0x100L;
        }
      }
    }

    /**
     * Adds one element to {@link OpenIdConnectConfiguration#getEmailDomains() emailDomains} list.
     * @param element A emailDomains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String element) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      return this;
    }

    /**
     * Adds elements to {@link OpenIdConnectConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An array of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomains(String... elements) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OpenIdConnectConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emailDomain")
    public final Builder emailDomains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.emailDomains = null;
        return this;
      }
      this.emailDomains = new ArrayList<String>();
      return addAllEmailDomains(elements);
    }

    /**
     * Adds elements to {@link OpenIdConnectConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmailDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "emailDomains element");
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getProviderDescription() providerDescription} attribute.
     * @param providerDescription The value for providerDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("providerDescription")
    public final Builder providerDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getAttributeMappings() attributeMappings} attribute.
     * @param attributeMappings The value for attributeMappings (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("attributeMappings")
    public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
      return this;
    }

    /**
     * Adds one element to {@link OpenIdConnectConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param element A externalGroupsWhitelist element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String element) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      return this;
    }

    /**
     * Adds elements to {@link OpenIdConnectConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An array of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String... elements) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OpenIdConnectConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalGroupsWhitelist")
    public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.externalGroupsWhitelist = null;
        return this;
      }
      this.externalGroupsWhitelist = new ArrayList<String>();
      return addAllExternalGroupsWhitelist(elements);
    }

    /**
     * Adds elements to {@link OpenIdConnectConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
      Objects.requireNonNull(elements, "externalGroupsWhitelist element");
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getStoreCustomAttributes() storeCustomAttributes} attribute.
     * @param storeCustomAttributes The value for storeCustomAttributes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("storeCustomAttributes")
    public final Builder storeCustomAttributes(@Nullable Boolean storeCustomAttributes) {
      this.storeCustomAttributes = storeCustomAttributes;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getAddShadowUserOnLogin() addShadowUserOnLogin} attribute.
     * @param addShadowUserOnLogin The value for addShadowUserOnLogin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("addShadowUserOnLogin")
    public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getAuthUrl() authUrl} attribute.
     * @param authUrl The value for authUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authUrl")
    public final Builder authUrl(String authUrl) {
      this.authUrl = Objects.requireNonNull(authUrl, "authUrl");
      initBits &= ~INIT_BIT_AUTH_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getLinkText() linkText} attribute.
     * @param linkText The value for linkText (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("linkText")
    public final Builder linkText(@Nullable Boolean linkText) {
      this.linkText = linkText;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getRelyingPartyId() relyingPartyId} attribute.
     * @param relyingPartyId The value for relyingPartyId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relyingPartyId")
    public final Builder relyingPartyId(String relyingPartyId) {
      this.relyingPartyId = Objects.requireNonNull(relyingPartyId, "relyingPartyId");
      initBits &= ~INIT_BIT_RELYING_PARTY_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getRelyingPartySecret() relyingPartySecret} attribute.
     * @param relyingPartySecret The value for relyingPartySecret (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relyingPartySecret")
    public final Builder relyingPartySecret(@Nullable String relyingPartySecret) {
      this.relyingPartySecret = relyingPartySecret;
      return this;
    }

    /**
     * Adds one element to {@link OpenIdConnectConfiguration#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link OpenIdConnectConfiguration#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(String... elements) {
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OpenIdConnectConfiguration#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scopes")
    public final Builder scopes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.scopes = null;
        return this;
      }
      this.scopes = new ArrayList<String>();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link OpenIdConnectConfiguration#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "scopes element");
      if (this.scopes == null) {
        this.scopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getShowLinkText() showLinkText} attribute.
     * @param showLinkText The value for showLinkText (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("showLinkText")
    public final Builder showLinkText(@Nullable Boolean showLinkText) {
      this.showLinkText = showLinkText;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getSkipSslVerification() skipSslVerification} attribute.
     * @param skipSslVerification The value for skipSslVerification (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("skipSslValidation")
    public final Builder skipSslVerification(@Nullable Boolean skipSslVerification) {
      this.skipSslVerification = skipSslVerification;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getTokenKey() tokenKey} attribute.
     * @param tokenKey The value for tokenKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tokenKey")
    public final Builder tokenKey(@Nullable String tokenKey) {
      this.tokenKey = tokenKey;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getTokenKeyUrl() tokenKeyUrl} attribute.
     * @param tokenKeyUrl The value for tokenKeyUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tokenKeyUrl")
    public final Builder tokenKeyUrl(@Nullable String tokenKeyUrl) {
      this.tokenKeyUrl = tokenKeyUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getTokenUrl() tokenUrl} attribute.
     * @param tokenUrl The value for tokenUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tokenUrl")
    public final Builder tokenUrl(String tokenUrl) {
      this.tokenUrl = Objects.requireNonNull(tokenUrl, "tokenUrl");
      initBits &= ~INIT_BIT_TOKEN_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link OpenIdConnectConfiguration#getUserInfoUrl() userInfoUrl} attribute.
     * @param userInfoUrl The value for userInfoUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userInfoUrl")
    public final Builder userInfoUrl(@Nullable String userInfoUrl) {
      this.userInfoUrl = userInfoUrl;
      return this;
    }

    /**
     * Builds a new {@link OpenIdConnectConfiguration OpenIdConnectConfiguration}.
     * @return An immutable instance of OpenIdConnectConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OpenIdConnectConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OpenIdConnectConfiguration(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUTH_URL) != 0) attributes.add("authUrl");
      if ((initBits & INIT_BIT_RELYING_PARTY_ID) != 0) attributes.add("relyingPartyId");
      if ((initBits & INIT_BIT_TOKEN_URL) != 0) attributes.add("tokenUrl");
      return "Cannot build OpenIdConnectConfiguration, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
