package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the update identity provider
 */
@Generated(from = "_UpdateIdentityProviderRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateIdentityProviderRequest
    extends org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final @Nullable Boolean active;
  private final IdentityProviderConfiguration configuration;
  private final String identityProviderId;
  private final String name;
  private final String originKey;
  private final Type type;
  private final Integer version;

  private UpdateIdentityProviderRequest(UpdateIdentityProviderRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.active = builder.active;
    this.configuration = builder.configuration;
    this.identityProviderId = builder.identityProviderId;
    this.name = builder.name;
    this.originKey = builder.originKey;
    this.type = builder.type;
    this.version = builder.version;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * Whether the identity provider is active
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The configuration of this identity provider according to its type.
   */
  @JsonProperty("config")
  @Override
  public IdentityProviderConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The identity provider id
   */
  @JsonProperty("identityProviderId")
  @JsonIgnore
  @Override
  public String getIdentityProviderId() {
    return identityProviderId;
  }

  /**
   * Human-readable name for this provider
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * A unique identifier for the IDP. Cannot be updated.
   */
  @JsonProperty("originKey")
  @Override
  public String getOriginKey() {
    return originKey;
  }

  /**
   * The type of the identity provider. Cannot be updated.
   */
  @JsonProperty("type")
  @Override
  public Type getType() {
    return type;
  }

  /**
   * Version of the identity provider data. Clients can use this to protect against conflicting updates.
   */
  @JsonProperty("version")
  @Override
  public Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code UpdateIdentityProviderRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateIdentityProviderRequest
        && equalTo(0, (UpdateIdentityProviderRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateIdentityProviderRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && Objects.equals(active, another.active)
        && configuration.equals(another.configuration)
        && identityProviderId.equals(another.identityProviderId)
        && name.equals(another.name)
        && originKey.equals(another.originKey)
        && type.equals(another.type)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code active}, {@code configuration}, {@code identityProviderId}, {@code name}, {@code originKey}, {@code type}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + configuration.hashCode();
    h += (h << 5) + identityProviderId.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + originKey.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateIdentityProviderRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateIdentityProviderRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", active=" + active
        + ", configuration=" + configuration
        + ", identityProviderId=" + identityProviderId
        + ", name=" + name
        + ", originKey=" + originKey
        + ", type=" + type
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateIdentityProviderRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    Boolean active;
    IdentityProviderConfiguration configuration;
    String identityProviderId;
    String name;
    String originKey;
    Type type;
    Integer version;
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("config")
    public void setConfiguration(IdentityProviderConfiguration configuration) {
      this.configuration = configuration;
    }
    @JsonProperty("identityProviderId")
    @JsonIgnore
    public void setIdentityProviderId(String identityProviderId) {
      this.identityProviderId = identityProviderId;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("originKey")
    public void setOriginKey(String originKey) {
      this.originKey = originKey;
    }
    @JsonProperty("type")
    public void setType(Type type) {
      this.type = type;
    }
    @JsonProperty("version")
    public void setVersion(Integer version) {
      this.version = version;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public IdentityProviderConfiguration getConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityProviderId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOriginKey() { throw new UnsupportedOperationException(); }
    @Override
    public Type getType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateIdentityProviderRequest fromJson(Json json) {
    UpdateIdentityProviderRequest.Builder builder = UpdateIdentityProviderRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    if (json.identityProviderId != null) {
      builder.identityProviderId(json.identityProviderId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.originKey != null) {
      builder.originKey(json.originKey);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateIdentityProviderRequest UpdateIdentityProviderRequest}.
   * <pre>
   * UpdateIdentityProviderRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link UpdateIdentityProviderRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link UpdateIdentityProviderRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .active(Boolean | null) // nullable {@link UpdateIdentityProviderRequest#getActive() active}
   *    .configuration(org.cloudfoundry.uaa.identityproviders.IdentityProviderConfiguration) // required {@link UpdateIdentityProviderRequest#getConfiguration() configuration}
   *    .identityProviderId(String) // required {@link UpdateIdentityProviderRequest#getIdentityProviderId() identityProviderId}
   *    .name(String) // required {@link UpdateIdentityProviderRequest#getName() name}
   *    .originKey(String) // required {@link UpdateIdentityProviderRequest#getOriginKey() originKey}
   *    .type(org.cloudfoundry.uaa.identityproviders.Type) // required {@link UpdateIdentityProviderRequest#getType() type}
   *    .version(Integer) // required {@link UpdateIdentityProviderRequest#getVersion() version}
   *    .build();
   * </pre>
   * @return A new UpdateIdentityProviderRequest builder
   */
  public static UpdateIdentityProviderRequest.Builder builder() {
    return new UpdateIdentityProviderRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateIdentityProviderRequest UpdateIdentityProviderRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateIdentityProviderRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONFIGURATION = 0x1L;
    private static final long INIT_BIT_IDENTITY_PROVIDER_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_ORIGIN_KEY = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private static final long INIT_BIT_VERSION = 0x20L;
    private long initBits = 0x3fL;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private Boolean active;
    private IdentityProviderConfiguration configuration;
    private String identityProviderId;
    private String name;
    private String originKey;
    private Type type;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateIdentityProviderRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateIdentityProviderRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest) {
        org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest instance = (org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest) object;
        configuration(instance.getConfiguration());
        originKey(instance.getOriginKey());
        name(instance.getName());
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        type(instance.getType());
        version(instance.getVersion());
        identityProviderId(instance.getIdentityProviderId());
      }
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(IdentityProviderConfiguration configuration) {
      this.configuration = Objects.requireNonNull(configuration, "configuration");
      initBits &= ~INIT_BIT_CONFIGURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getIdentityProviderId() identityProviderId} attribute.
     * @param identityProviderId The value for identityProviderId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProviderId(String identityProviderId) {
      this.identityProviderId = Objects.requireNonNull(identityProviderId, "identityProviderId");
      initBits &= ~INIT_BIT_IDENTITY_PROVIDER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getOriginKey() originKey} attribute.
     * @param originKey The value for originKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder originKey(String originKey) {
      this.originKey = Objects.requireNonNull(originKey, "originKey");
      initBits &= ~INIT_BIT_ORIGIN_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityProviderRequest#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link UpdateIdentityProviderRequest UpdateIdentityProviderRequest}.
     * @return An immutable instance of UpdateIdentityProviderRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateIdentityProviderRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateIdentityProviderRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONFIGURATION) != 0) attributes.add("configuration");
      if ((initBits & INIT_BIT_IDENTITY_PROVIDER_ID) != 0) attributes.add("identityProviderId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORIGIN_KEY) != 0) attributes.add("originKey");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build UpdateIdentityProviderRequest, some of required attributes are not set " + attributes;
    }
  }
}
