package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The payload for the identity zone client secret policy
 */
@Generated(from = "_ClientSecretPolicy", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ClientSecretPolicy extends org.cloudfoundry.uaa.identityzones._ClientSecretPolicy {
  private final Integer maximumLength;
  private final Integer minimumLength;
  private final Integer requireDigit;
  private final Integer requireLowerCaseCharacter;
  private final Integer requireSpecialCharacter;
  private final Integer requireUpperCaseCharacter;

  private ClientSecretPolicy(ClientSecretPolicy.Builder builder) {
    this.maximumLength = builder.maximumLength;
    this.minimumLength = builder.minimumLength;
    this.requireDigit = builder.requireDigit;
    this.requireLowerCaseCharacter = builder.requireLowerCaseCharacter;
    this.requireSpecialCharacter = builder.requireSpecialCharacter;
    this.requireUpperCaseCharacter = builder.requireUpperCaseCharacter;
  }

  /**
   * Maximum number of characters required for secret to be considered valid
   */
  @JsonProperty("maxLength")
  @Override
  public Integer getMaximumLength() {
    return maximumLength;
  }

  /**
   * Minimum number of characters required for secret to be considered valid
   */
  @JsonProperty("minLength")
  @Override
  public Integer getMinimumLength() {
    return minimumLength;
  }

  /**
   * Minimum number of digits required for secret to be considered valid
   */
  @JsonProperty("requireDigit")
  @Override
  public Integer getRequireDigit() {
    return requireDigit;
  }

  /**
   * Minimum number of lowercase characters required for secret to be considered valid
   */
  @JsonProperty("requireLowerCaseCharacter")
  @Override
  public Integer getRequireLowerCaseCharacter() {
    return requireLowerCaseCharacter;
  }

  /**
   * Minimum number of special characters required for secret to be considered valid
   */
  @JsonProperty("requireSpecialCharacter")
  @Override
  public Integer getRequireSpecialCharacter() {
    return requireSpecialCharacter;
  }

  /**
   * Minimum number of uppercase characters required for secret to be considered valid
   */
  @JsonProperty("requireUpperCaseCharacter")
  @Override
  public Integer getRequireUpperCaseCharacter() {
    return requireUpperCaseCharacter;
  }

  /**
   * This instance is equal to all instances of {@code ClientSecretPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ClientSecretPolicy
        && equalTo(0, (ClientSecretPolicy) another);
  }

  private boolean equalTo(int synthetic, ClientSecretPolicy another) {
    return maximumLength.equals(another.maximumLength)
        && minimumLength.equals(another.minimumLength)
        && requireDigit.equals(another.requireDigit)
        && requireLowerCaseCharacter.equals(another.requireLowerCaseCharacter)
        && requireSpecialCharacter.equals(another.requireSpecialCharacter)
        && requireUpperCaseCharacter.equals(another.requireUpperCaseCharacter);
  }

  /**
   * Computes a hash code from attributes: {@code maximumLength}, {@code minimumLength}, {@code requireDigit}, {@code requireLowerCaseCharacter}, {@code requireSpecialCharacter}, {@code requireUpperCaseCharacter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + maximumLength.hashCode();
    h += (h << 5) + minimumLength.hashCode();
    h += (h << 5) + requireDigit.hashCode();
    h += (h << 5) + requireLowerCaseCharacter.hashCode();
    h += (h << 5) + requireSpecialCharacter.hashCode();
    h += (h << 5) + requireUpperCaseCharacter.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ClientSecretPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ClientSecretPolicy{"
        + "maximumLength=" + maximumLength
        + ", minimumLength=" + minimumLength
        + ", requireDigit=" + requireDigit
        + ", requireLowerCaseCharacter=" + requireLowerCaseCharacter
        + ", requireSpecialCharacter=" + requireSpecialCharacter
        + ", requireUpperCaseCharacter=" + requireUpperCaseCharacter
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ClientSecretPolicy", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._ClientSecretPolicy {
    Integer maximumLength;
    Integer minimumLength;
    Integer requireDigit;
    Integer requireLowerCaseCharacter;
    Integer requireSpecialCharacter;
    Integer requireUpperCaseCharacter;
    @JsonProperty("maxLength")
    public void setMaximumLength(Integer maximumLength) {
      this.maximumLength = maximumLength;
    }
    @JsonProperty("minLength")
    public void setMinimumLength(Integer minimumLength) {
      this.minimumLength = minimumLength;
    }
    @JsonProperty("requireDigit")
    public void setRequireDigit(Integer requireDigit) {
      this.requireDigit = requireDigit;
    }
    @JsonProperty("requireLowerCaseCharacter")
    public void setRequireLowerCaseCharacter(Integer requireLowerCaseCharacter) {
      this.requireLowerCaseCharacter = requireLowerCaseCharacter;
    }
    @JsonProperty("requireSpecialCharacter")
    public void setRequireSpecialCharacter(Integer requireSpecialCharacter) {
      this.requireSpecialCharacter = requireSpecialCharacter;
    }
    @JsonProperty("requireUpperCaseCharacter")
    public void setRequireUpperCaseCharacter(Integer requireUpperCaseCharacter) {
      this.requireUpperCaseCharacter = requireUpperCaseCharacter;
    }
    @Override
    public Integer getMaximumLength() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMinimumLength() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getRequireDigit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getRequireLowerCaseCharacter() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getRequireSpecialCharacter() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getRequireUpperCaseCharacter() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ClientSecretPolicy fromJson(Json json) {
    ClientSecretPolicy.Builder builder = ClientSecretPolicy.builder();
    if (json.maximumLength != null) {
      builder.maximumLength(json.maximumLength);
    }
    if (json.minimumLength != null) {
      builder.minimumLength(json.minimumLength);
    }
    if (json.requireDigit != null) {
      builder.requireDigit(json.requireDigit);
    }
    if (json.requireLowerCaseCharacter != null) {
      builder.requireLowerCaseCharacter(json.requireLowerCaseCharacter);
    }
    if (json.requireSpecialCharacter != null) {
      builder.requireSpecialCharacter(json.requireSpecialCharacter);
    }
    if (json.requireUpperCaseCharacter != null) {
      builder.requireUpperCaseCharacter(json.requireUpperCaseCharacter);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ClientSecretPolicy ClientSecretPolicy}.
   * <pre>
   * ClientSecretPolicy.builder()
   *    .maximumLength(Integer) // required {@link ClientSecretPolicy#getMaximumLength() maximumLength}
   *    .minimumLength(Integer) // required {@link ClientSecretPolicy#getMinimumLength() minimumLength}
   *    .requireDigit(Integer) // required {@link ClientSecretPolicy#getRequireDigit() requireDigit}
   *    .requireLowerCaseCharacter(Integer) // required {@link ClientSecretPolicy#getRequireLowerCaseCharacter() requireLowerCaseCharacter}
   *    .requireSpecialCharacter(Integer) // required {@link ClientSecretPolicy#getRequireSpecialCharacter() requireSpecialCharacter}
   *    .requireUpperCaseCharacter(Integer) // required {@link ClientSecretPolicy#getRequireUpperCaseCharacter() requireUpperCaseCharacter}
   *    .build();
   * </pre>
   * @return A new ClientSecretPolicy builder
   */
  public static ClientSecretPolicy.Builder builder() {
    return new ClientSecretPolicy.Builder();
  }

  /**
   * Builds instances of type {@link ClientSecretPolicy ClientSecretPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ClientSecretPolicy", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MAXIMUM_LENGTH = 0x1L;
    private static final long INIT_BIT_MINIMUM_LENGTH = 0x2L;
    private static final long INIT_BIT_REQUIRE_DIGIT = 0x4L;
    private static final long INIT_BIT_REQUIRE_LOWER_CASE_CHARACTER = 0x8L;
    private static final long INIT_BIT_REQUIRE_SPECIAL_CHARACTER = 0x10L;
    private static final long INIT_BIT_REQUIRE_UPPER_CASE_CHARACTER = 0x20L;
    private long initBits = 0x3fL;

    private Integer maximumLength;
    private Integer minimumLength;
    private Integer requireDigit;
    private Integer requireLowerCaseCharacter;
    private Integer requireSpecialCharacter;
    private Integer requireUpperCaseCharacter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClientSecretPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ClientSecretPolicy instance) {
      return from((_ClientSecretPolicy) instance);
    }

    /**
     * Copy abstract value type {@code _ClientSecretPolicy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ClientSecretPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      maximumLength(instance.getMaximumLength());
      minimumLength(instance.getMinimumLength());
      requireDigit(instance.getRequireDigit());
      requireLowerCaseCharacter(instance.getRequireLowerCaseCharacter());
      requireSpecialCharacter(instance.getRequireSpecialCharacter());
      requireUpperCaseCharacter(instance.getRequireUpperCaseCharacter());
      return this;
    }

    /**
     * Initializes the value for the {@link ClientSecretPolicy#getMaximumLength() maximumLength} attribute.
     * @param maximumLength The value for maximumLength 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maxLength")
    public final Builder maximumLength(Integer maximumLength) {
      this.maximumLength = Objects.requireNonNull(maximumLength, "maximumLength");
      initBits &= ~INIT_BIT_MAXIMUM_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientSecretPolicy#getMinimumLength() minimumLength} attribute.
     * @param minimumLength The value for minimumLength 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("minLength")
    public final Builder minimumLength(Integer minimumLength) {
      this.minimumLength = Objects.requireNonNull(minimumLength, "minimumLength");
      initBits &= ~INIT_BIT_MINIMUM_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientSecretPolicy#getRequireDigit() requireDigit} attribute.
     * @param requireDigit The value for requireDigit 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requireDigit")
    public final Builder requireDigit(Integer requireDigit) {
      this.requireDigit = Objects.requireNonNull(requireDigit, "requireDigit");
      initBits &= ~INIT_BIT_REQUIRE_DIGIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientSecretPolicy#getRequireLowerCaseCharacter() requireLowerCaseCharacter} attribute.
     * @param requireLowerCaseCharacter The value for requireLowerCaseCharacter 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requireLowerCaseCharacter")
    public final Builder requireLowerCaseCharacter(Integer requireLowerCaseCharacter) {
      this.requireLowerCaseCharacter = Objects.requireNonNull(requireLowerCaseCharacter, "requireLowerCaseCharacter");
      initBits &= ~INIT_BIT_REQUIRE_LOWER_CASE_CHARACTER;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientSecretPolicy#getRequireSpecialCharacter() requireSpecialCharacter} attribute.
     * @param requireSpecialCharacter The value for requireSpecialCharacter 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requireSpecialCharacter")
    public final Builder requireSpecialCharacter(Integer requireSpecialCharacter) {
      this.requireSpecialCharacter = Objects.requireNonNull(requireSpecialCharacter, "requireSpecialCharacter");
      initBits &= ~INIT_BIT_REQUIRE_SPECIAL_CHARACTER;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientSecretPolicy#getRequireUpperCaseCharacter() requireUpperCaseCharacter} attribute.
     * @param requireUpperCaseCharacter The value for requireUpperCaseCharacter 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requireUpperCaseCharacter")
    public final Builder requireUpperCaseCharacter(Integer requireUpperCaseCharacter) {
      this.requireUpperCaseCharacter = Objects.requireNonNull(requireUpperCaseCharacter, "requireUpperCaseCharacter");
      initBits &= ~INIT_BIT_REQUIRE_UPPER_CASE_CHARACTER;
      return this;
    }

    /**
     * Builds a new {@link ClientSecretPolicy ClientSecretPolicy}.
     * @return An immutable instance of ClientSecretPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ClientSecretPolicy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ClientSecretPolicy(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MAXIMUM_LENGTH) != 0) attributes.add("maximumLength");
      if ((initBits & INIT_BIT_MINIMUM_LENGTH) != 0) attributes.add("minimumLength");
      if ((initBits & INIT_BIT_REQUIRE_DIGIT) != 0) attributes.add("requireDigit");
      if ((initBits & INIT_BIT_REQUIRE_LOWER_CASE_CHARACTER) != 0) attributes.add("requireLowerCaseCharacter");
      if ((initBits & INIT_BIT_REQUIRE_SPECIAL_CHARACTER) != 0) attributes.add("requireSpecialCharacter");
      if ((initBits & INIT_BIT_REQUIRE_UPPER_CASE_CHARACTER) != 0) attributes.add("requireUpperCaseCharacter");
      return "Cannot build ClientSecretPolicy, some of required attributes are not set " + attributes;
    }
  }
}
