package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The resource response payload for the Delete Identity Zone Response
 */
@Generated(from = "_DeleteIdentityZoneResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteIdentityZoneResponse
    extends org.cloudfoundry.uaa.identityzones._DeleteIdentityZoneResponse {
  private final @Nullable Boolean active;
  private final @Nullable IdentityZoneConfiguration configuration;
  private final Long createdAt;
  private final @Nullable String description;
  private final String id;
  private final Long lastModified;
  private final String name;
  private final String subdomain;
  private final @Nullable Integer version;

  private DeleteIdentityZoneResponse(DeleteIdentityZoneResponse.Builder builder) {
    this.active = builder.active;
    this.configuration = builder.configuration;
    this.createdAt = builder.createdAt;
    this.description = builder.description;
    this.id = builder.id;
    this.lastModified = builder.lastModified;
    this.name = builder.name;
    this.subdomain = builder.subdomain;
    this.version = builder.version;
  }

  /**
   * Whether the identity zone is active
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The configuration
   */
  @JsonProperty("config")
  @Override
  public @Nullable IdentityZoneConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The creation date of the identity zone
   */
  @JsonProperty("created")
  @Override
  public Long getCreatedAt() {
    return createdAt;
  }

  /**
   * The description of the identity zone
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The id of the identity zone
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The last modification date of the identity zone
   */
  @JsonProperty("last_modified")
  @Override
  public Long getLastModified() {
    return lastModified;
  }

  /**
   * The name of the identity zone
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The unique sub domain. It will be converted into lowercase upon creation.
   */
  @JsonProperty("subdomain")
  @Override
  public String getSubdomain() {
    return subdomain;
  }

  /**
   * The version of the identity zone.
   */
  @JsonProperty("version")
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code DeleteIdentityZoneResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteIdentityZoneResponse
        && equalTo(0, (DeleteIdentityZoneResponse) another);
  }

  private boolean equalTo(int synthetic, DeleteIdentityZoneResponse another) {
    return Objects.equals(active, another.active)
        && Objects.equals(configuration, another.configuration)
        && createdAt.equals(another.createdAt)
        && Objects.equals(description, another.description)
        && id.equals(another.id)
        && lastModified.equals(another.lastModified)
        && name.equals(another.name)
        && subdomain.equals(another.subdomain)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code configuration}, {@code createdAt}, {@code description}, {@code id}, {@code lastModified}, {@code name}, {@code subdomain}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(configuration);
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + lastModified.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + subdomain.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteIdentityZoneResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteIdentityZoneResponse{"
        + "active=" + active
        + ", configuration=" + configuration
        + ", createdAt=" + createdAt
        + ", description=" + description
        + ", id=" + id
        + ", lastModified=" + lastModified
        + ", name=" + name
        + ", subdomain=" + subdomain
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_DeleteIdentityZoneResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._DeleteIdentityZoneResponse {
    Boolean active;
    IdentityZoneConfiguration configuration;
    Long createdAt;
    String description;
    String id;
    Long lastModified;
    String name;
    String subdomain;
    Integer version;
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("config")
    public void setConfiguration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
    }
    @JsonProperty("created")
    public void setCreatedAt(Long createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("last_modified")
    public void setLastModified(Long lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("subdomain")
    public void setSubdomain(String subdomain) {
      this.subdomain = subdomain;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable Integer version) {
      this.version = version;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public IdentityZoneConfiguration getConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public Long getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DeleteIdentityZoneResponse fromJson(Json json) {
    DeleteIdentityZoneResponse.Builder builder = DeleteIdentityZoneResponse.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.subdomain != null) {
      builder.subdomain(json.subdomain);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DeleteIdentityZoneResponse DeleteIdentityZoneResponse}.
   * <pre>
   * DeleteIdentityZoneResponse.builder()
   *    .active(Boolean | null) // nullable {@link DeleteIdentityZoneResponse#getActive() active}
   *    .configuration(org.cloudfoundry.uaa.identityzones.IdentityZoneConfiguration | null) // nullable {@link DeleteIdentityZoneResponse#getConfiguration() configuration}
   *    .createdAt(Long) // required {@link DeleteIdentityZoneResponse#getCreatedAt() createdAt}
   *    .description(String | null) // nullable {@link DeleteIdentityZoneResponse#getDescription() description}
   *    .id(String) // required {@link DeleteIdentityZoneResponse#getId() id}
   *    .lastModified(Long) // required {@link DeleteIdentityZoneResponse#getLastModified() lastModified}
   *    .name(String) // required {@link DeleteIdentityZoneResponse#getName() name}
   *    .subdomain(String) // required {@link DeleteIdentityZoneResponse#getSubdomain() subdomain}
   *    .version(Integer | null) // nullable {@link DeleteIdentityZoneResponse#getVersion() version}
   *    .build();
   * </pre>
   * @return A new DeleteIdentityZoneResponse builder
   */
  public static DeleteIdentityZoneResponse.Builder builder() {
    return new DeleteIdentityZoneResponse.Builder();
  }

  /**
   * Builds instances of type {@link DeleteIdentityZoneResponse DeleteIdentityZoneResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteIdentityZoneResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_LAST_MODIFIED = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_SUBDOMAIN = 0x10L;
    private long initBits = 0x1fL;

    private Boolean active;
    private IdentityZoneConfiguration configuration;
    private Long createdAt;
    private String description;
    private String id;
    private Long lastModified;
    private String name;
    private String subdomain;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityzones.AbstractIdentityZone} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityZone instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteIdentityZoneResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteIdentityZoneResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DeleteIdentityZoneResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_DeleteIdentityZoneResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractIdentityZone) {
        AbstractIdentityZone instance = (AbstractIdentityZone) object;
        createdAt(instance.getCreatedAt());
        IdentityZoneConfiguration configurationValue = instance.getConfiguration();
        if (configurationValue != null) {
          configuration(configurationValue);
        }
        name(instance.getName());
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        subdomain(instance.getSubdomain());
        id(instance.getId());
        lastModified(instance.getLastModified());
        Integer versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("config")
    public final Builder configuration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder createdAt(Long createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_modified")
    public final Builder lastModified(Long lastModified) {
      this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
      initBits &= ~INIT_BIT_LAST_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getSubdomain() subdomain} attribute.
     * @param subdomain The value for subdomain 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("subdomain")
    public final Builder subdomain(String subdomain) {
      this.subdomain = Objects.requireNonNull(subdomain, "subdomain");
      initBits &= ~INIT_BIT_SUBDOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteIdentityZoneResponse#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link DeleteIdentityZoneResponse DeleteIdentityZoneResponse}.
     * @return An immutable instance of DeleteIdentityZoneResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteIdentityZoneResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteIdentityZoneResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_LAST_MODIFIED) != 0) attributes.add("lastModified");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SUBDOMAIN) != 0) attributes.add("subdomain");
      return "Cannot build DeleteIdentityZoneResponse, some of required attributes are not set " + attributes;
    }
  }
}
