package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The response from the check token request
 */
@Generated(from = "_CheckTokenResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CheckTokenResponse extends org.cloudfoundry.uaa.tokens._CheckTokenResponse {
  private final List<String> audiences;
  private final @Nullable List<String> authorities;
  private final @Nullable Long authorizationTime;
  private final String authorizedParty;
  private final String cid;
  private final String clientId;
  private final @Nullable String email;
  private final Long expirationTime;
  private final String grantType;
  private final Long issuedAt;
  private final String issuer;
  private final String jwtId;
  private final @Nullable String origin;
  private final Boolean revocable;
  private final String revocationSignature;
  private final List<String> scopes;
  private final String subject;
  private final @Nullable String userId;
  private final @Nullable String userName;
  private final String zoneId;

  private CheckTokenResponse(CheckTokenResponse.Builder builder) {
    this.audiences = createUnmodifiableList(true, builder.audiences);
    this.authorities = builder.authorities == null ? null : createUnmodifiableList(true, builder.authorities);
    this.authorizationTime = builder.authorizationTime;
    this.authorizedParty = builder.authorizedParty;
    this.cid = builder.cid;
    this.clientId = builder.clientId;
    this.email = builder.email;
    this.expirationTime = builder.expirationTime;
    this.grantType = builder.grantType;
    this.issuedAt = builder.issuedAt;
    this.issuer = builder.issuer;
    this.jwtId = builder.jwtId;
    this.origin = builder.origin;
    this.revocable = builder.revocable;
    this.revocationSignature = builder.revocationSignature;
    this.scopes = createUnmodifiableList(true, builder.scopes);
    this.subject = builder.subject;
    this.userId = builder.userId;
    this.userName = builder.userName;
    this.zoneId = builder.zoneId;
  }

  /**
   * The audience claim
   */
  @JsonProperty("aud")
  @Override
  public List<String> getAudiences() {
    return audiences;
  }

  /**
   * The authorities
   */
  @JsonProperty("authorities")
  @Override
  public @Nullable List<String> getAuthorities() {
    return authorities;
  }

  /**
   * The auth time
   */
  @JsonProperty("auth_time")
  @Override
  public @Nullable Long getAuthorizationTime() {
    return authorizationTime;
  }

  /**
   * The authorized party
   */
  @JsonProperty("azp")
  @Override
  public String getAuthorizedParty() {
    return authorizedParty;
  }

  /**
   * The cid
   */
  @JsonProperty("cid")
  @Override
  public String getCid() {
    return cid;
  }

  /**
   * The client id
   */
  @JsonProperty("client_id")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The email
   */
  @JsonProperty("email")
  @Override
  public @Nullable String getEmail() {
    return email;
  }

  /**
   * The expiration time claim
   */
  @JsonProperty("exp")
  @Override
  public Long getExpirationTime() {
    return expirationTime;
  }

  /**
   * The grant type
   */
  @JsonProperty("grant_type")
  @Override
  public String getGrantType() {
    return grantType;
  }

  /**
   * The issued at claim
   */
  @JsonProperty("iat")
  @Override
  public Long getIssuedAt() {
    return issuedAt;
  }

  /**
   * The issuer claim
   */
  @JsonProperty("iss")
  @Override
  public String getIssuer() {
    return issuer;
  }

  /**
   * The jwt id claim
   */
  @JsonProperty("jti")
  @Override
  public String getJwtId() {
    return jwtId;
  }

  /**
   * The origin
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * Whether token is revocable
   */
  @JsonProperty("revocable")
  @Override
  public Boolean getRevocable() {
    return revocable;
  }

  /**
   * The revocation signature
   */
  @JsonProperty("rev_sig")
  @Override
  public String getRevocationSignature() {
    return revocationSignature;
  }

  /**
   * The scopes authorized by the user for this client
   */
  @JsonProperty("scope")
  @Override
  public List<String> getScopes() {
    return scopes;
  }

  /**
   * The subject claim
   */
  @JsonProperty("sub")
  @Override
  public String getSubject() {
    return subject;
  }

  /**
   * The user id
   */
  @JsonProperty("user_id")
  @Override
  public @Nullable String getUserId() {
    return userId;
  }

  /**
   * The user name
   */
  @JsonProperty("user_name")
  @Override
  public @Nullable String getUserName() {
    return userName;
  }

  /**
   * The zone id
   */
  @JsonProperty("zid")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * This instance is equal to all instances of {@code CheckTokenResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckTokenResponse
        && equalTo(0, (CheckTokenResponse) another);
  }

  private boolean equalTo(int synthetic, CheckTokenResponse another) {
    return audiences.equals(another.audiences)
        && Objects.equals(authorities, another.authorities)
        && Objects.equals(authorizationTime, another.authorizationTime)
        && authorizedParty.equals(another.authorizedParty)
        && cid.equals(another.cid)
        && clientId.equals(another.clientId)
        && Objects.equals(email, another.email)
        && expirationTime.equals(another.expirationTime)
        && grantType.equals(another.grantType)
        && issuedAt.equals(another.issuedAt)
        && issuer.equals(another.issuer)
        && jwtId.equals(another.jwtId)
        && Objects.equals(origin, another.origin)
        && revocable.equals(another.revocable)
        && revocationSignature.equals(another.revocationSignature)
        && scopes.equals(another.scopes)
        && subject.equals(another.subject)
        && Objects.equals(userId, another.userId)
        && Objects.equals(userName, another.userName)
        && zoneId.equals(another.zoneId);
  }

  /**
   * Computes a hash code from attributes: {@code audiences}, {@code authorities}, {@code authorizationTime}, {@code authorizedParty}, {@code cid}, {@code clientId}, {@code email}, {@code expirationTime}, {@code grantType}, {@code issuedAt}, {@code issuer}, {@code jwtId}, {@code origin}, {@code revocable}, {@code revocationSignature}, {@code scopes}, {@code subject}, {@code userId}, {@code userName}, {@code zoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + audiences.hashCode();
    h += (h << 5) + Objects.hashCode(authorities);
    h += (h << 5) + Objects.hashCode(authorizationTime);
    h += (h << 5) + authorizedParty.hashCode();
    h += (h << 5) + cid.hashCode();
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + expirationTime.hashCode();
    h += (h << 5) + grantType.hashCode();
    h += (h << 5) + issuedAt.hashCode();
    h += (h << 5) + issuer.hashCode();
    h += (h << 5) + jwtId.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + revocable.hashCode();
    h += (h << 5) + revocationSignature.hashCode();
    h += (h << 5) + scopes.hashCode();
    h += (h << 5) + subject.hashCode();
    h += (h << 5) + Objects.hashCode(userId);
    h += (h << 5) + Objects.hashCode(userName);
    h += (h << 5) + zoneId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckTokenResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckTokenResponse{"
        + "audiences=" + audiences
        + ", authorities=" + authorities
        + ", authorizationTime=" + authorizationTime
        + ", authorizedParty=" + authorizedParty
        + ", cid=" + cid
        + ", clientId=" + clientId
        + ", email=" + email
        + ", expirationTime=" + expirationTime
        + ", grantType=" + grantType
        + ", issuedAt=" + issuedAt
        + ", issuer=" + issuer
        + ", jwtId=" + jwtId
        + ", origin=" + origin
        + ", revocable=" + revocable
        + ", revocationSignature=" + revocationSignature
        + ", scopes=" + scopes
        + ", subject=" + subject
        + ", userId=" + userId
        + ", userName=" + userName
        + ", zoneId=" + zoneId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CheckTokenResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.tokens._CheckTokenResponse {
    List<String> audiences = Collections.emptyList();
    List<String> authorities = null;
    Long authorizationTime;
    String authorizedParty;
    String cid;
    String clientId;
    String email;
    Long expirationTime;
    String grantType;
    Long issuedAt;
    String issuer;
    String jwtId;
    String origin;
    Boolean revocable;
    String revocationSignature;
    List<String> scopes = Collections.emptyList();
    String subject;
    String userId;
    String userName;
    String zoneId;
    @JsonProperty("aud")
    public void setAudiences(List<String> audiences) {
      this.audiences = audiences;
    }
    @JsonProperty("authorities")
    public void setAuthorities(@Nullable List<String> authorities) {
      this.authorities = authorities;
    }
    @JsonProperty("auth_time")
    public void setAuthorizationTime(@Nullable Long authorizationTime) {
      this.authorizationTime = authorizationTime;
    }
    @JsonProperty("azp")
    public void setAuthorizedParty(String authorizedParty) {
      this.authorizedParty = authorizedParty;
    }
    @JsonProperty("cid")
    public void setCid(String cid) {
      this.cid = cid;
    }
    @JsonProperty("client_id")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("email")
    public void setEmail(@Nullable String email) {
      this.email = email;
    }
    @JsonProperty("exp")
    public void setExpirationTime(Long expirationTime) {
      this.expirationTime = expirationTime;
    }
    @JsonProperty("grant_type")
    public void setGrantType(String grantType) {
      this.grantType = grantType;
    }
    @JsonProperty("iat")
    public void setIssuedAt(Long issuedAt) {
      this.issuedAt = issuedAt;
    }
    @JsonProperty("iss")
    public void setIssuer(String issuer) {
      this.issuer = issuer;
    }
    @JsonProperty("jti")
    public void setJwtId(String jwtId) {
      this.jwtId = jwtId;
    }
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("revocable")
    public void setRevocable(Boolean revocable) {
      this.revocable = revocable;
    }
    @JsonProperty("rev_sig")
    public void setRevocationSignature(String revocationSignature) {
      this.revocationSignature = revocationSignature;
    }
    @JsonProperty("scope")
    public void setScopes(List<String> scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("sub")
    public void setSubject(String subject) {
      this.subject = subject;
    }
    @JsonProperty("user_id")
    public void setUserId(@Nullable String userId) {
      this.userId = userId;
    }
    @JsonProperty("user_name")
    public void setUserName(@Nullable String userName) {
      this.userName = userName;
    }
    @JsonProperty("zid")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @Override
    public List<String> getAudiences() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAuthorities() { throw new UnsupportedOperationException(); }
    @Override
    public Long getAuthorizationTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthorizedParty() { throw new UnsupportedOperationException(); }
    @Override
    public String getCid() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public Long getExpirationTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getGrantType() { throw new UnsupportedOperationException(); }
    @Override
    public Long getIssuedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getIssuer() { throw new UnsupportedOperationException(); }
    @Override
    public String getJwtId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRevocable() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevocationSignature() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getSubject() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CheckTokenResponse fromJson(Json json) {
    CheckTokenResponse.Builder builder = CheckTokenResponse.builder();
    if (json.audiences != null) {
      builder.addAllAudiences(json.audiences);
    }
    if (json.authorities != null) {
      builder.addAllAuthorities(json.authorities);
    }
    if (json.authorizationTime != null) {
      builder.authorizationTime(json.authorizationTime);
    }
    if (json.authorizedParty != null) {
      builder.authorizedParty(json.authorizedParty);
    }
    if (json.cid != null) {
      builder.cid(json.cid);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.expirationTime != null) {
      builder.expirationTime(json.expirationTime);
    }
    if (json.grantType != null) {
      builder.grantType(json.grantType);
    }
    if (json.issuedAt != null) {
      builder.issuedAt(json.issuedAt);
    }
    if (json.issuer != null) {
      builder.issuer(json.issuer);
    }
    if (json.jwtId != null) {
      builder.jwtId(json.jwtId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.revocable != null) {
      builder.revocable(json.revocable);
    }
    if (json.revocationSignature != null) {
      builder.revocationSignature(json.revocationSignature);
    }
    if (json.scopes != null) {
      builder.addAllScopes(json.scopes);
    }
    if (json.subject != null) {
      builder.subject(json.subject);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CheckTokenResponse CheckTokenResponse}.
   * <pre>
   * CheckTokenResponse.builder()
   *    .audience|addAllAudiences(String) // {@link CheckTokenResponse#getAudiences() audiences} elements
   *    .authorities(List&amp;lt;String&amp;gt; | null) // nullable {@link CheckTokenResponse#getAuthorities() authorities}
   *    .authorizationTime(Long | null) // nullable {@link CheckTokenResponse#getAuthorizationTime() authorizationTime}
   *    .authorizedParty(String) // required {@link CheckTokenResponse#getAuthorizedParty() authorizedParty}
   *    .cid(String) // required {@link CheckTokenResponse#getCid() cid}
   *    .clientId(String) // required {@link CheckTokenResponse#getClientId() clientId}
   *    .email(String | null) // nullable {@link CheckTokenResponse#getEmail() email}
   *    .expirationTime(Long) // required {@link CheckTokenResponse#getExpirationTime() expirationTime}
   *    .grantType(String) // required {@link CheckTokenResponse#getGrantType() grantType}
   *    .issuedAt(Long) // required {@link CheckTokenResponse#getIssuedAt() issuedAt}
   *    .issuer(String) // required {@link CheckTokenResponse#getIssuer() issuer}
   *    .jwtId(String) // required {@link CheckTokenResponse#getJwtId() jwtId}
   *    .origin(String | null) // nullable {@link CheckTokenResponse#getOrigin() origin}
   *    .revocable(Boolean) // required {@link CheckTokenResponse#getRevocable() revocable}
   *    .revocationSignature(String) // required {@link CheckTokenResponse#getRevocationSignature() revocationSignature}
   *    .scope|addAllScopes(String) // {@link CheckTokenResponse#getScopes() scopes} elements
   *    .subject(String) // required {@link CheckTokenResponse#getSubject() subject}
   *    .userId(String | null) // nullable {@link CheckTokenResponse#getUserId() userId}
   *    .userName(String | null) // nullable {@link CheckTokenResponse#getUserName() userName}
   *    .zoneId(String) // required {@link CheckTokenResponse#getZoneId() zoneId}
   *    .build();
   * </pre>
   * @return A new CheckTokenResponse builder
   */
  public static CheckTokenResponse.Builder builder() {
    return new CheckTokenResponse.Builder();
  }

  /**
   * Builds instances of type {@link CheckTokenResponse CheckTokenResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CheckTokenResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUTHORIZED_PARTY = 0x1L;
    private static final long INIT_BIT_CID = 0x2L;
    private static final long INIT_BIT_CLIENT_ID = 0x4L;
    private static final long INIT_BIT_EXPIRATION_TIME = 0x8L;
    private static final long INIT_BIT_GRANT_TYPE = 0x10L;
    private static final long INIT_BIT_ISSUED_AT = 0x20L;
    private static final long INIT_BIT_ISSUER = 0x40L;
    private static final long INIT_BIT_JWT_ID = 0x80L;
    private static final long INIT_BIT_REVOCABLE = 0x100L;
    private static final long INIT_BIT_REVOCATION_SIGNATURE = 0x200L;
    private static final long INIT_BIT_SUBJECT = 0x400L;
    private static final long INIT_BIT_ZONE_ID = 0x800L;
    private long initBits = 0xfffL;

    private List<String> audiences = new ArrayList<String>();
    private List<String> authorities = null;
    private Long authorizationTime;
    private String authorizedParty;
    private String cid;
    private String clientId;
    private String email;
    private Long expirationTime;
    private String grantType;
    private Long issuedAt;
    private String issuer;
    private String jwtId;
    private String origin;
    private Boolean revocable;
    private String revocationSignature;
    private List<String> scopes = new ArrayList<String>();
    private String subject;
    private String userId;
    private String userName;
    private String zoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckTokenResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckTokenResponse instance) {
      return from((_CheckTokenResponse) instance);
    }

    /**
     * Copy abstract value type {@code _CheckTokenResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckTokenResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllAudiences(instance.getAudiences());
      List<String> authoritiesValue = instance.getAuthorities();
      if (authoritiesValue != null) {
        addAllAuthorities(authoritiesValue);
      }
      Long authorizationTimeValue = instance.getAuthorizationTime();
      if (authorizationTimeValue != null) {
        authorizationTime(authorizationTimeValue);
      }
      authorizedParty(instance.getAuthorizedParty());
      cid(instance.getCid());
      clientId(instance.getClientId());
      String emailValue = instance.getEmail();
      if (emailValue != null) {
        email(emailValue);
      }
      expirationTime(instance.getExpirationTime());
      grantType(instance.getGrantType());
      issuedAt(instance.getIssuedAt());
      issuer(instance.getIssuer());
      jwtId(instance.getJwtId());
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      revocable(instance.getRevocable());
      revocationSignature(instance.getRevocationSignature());
      addAllScopes(instance.getScopes());
      subject(instance.getSubject());
      String userIdValue = instance.getUserId();
      if (userIdValue != null) {
        userId(userIdValue);
      }
      String userNameValue = instance.getUserName();
      if (userNameValue != null) {
        userName(userNameValue);
      }
      zoneId(instance.getZoneId());
      return this;
    }

    /**
     * Adds one element to {@link CheckTokenResponse#getAudiences() audiences} list.
     * @param element A audiences element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder audience(String element) {
      this.audiences.add(Objects.requireNonNull(element, "audiences element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckTokenResponse#getAudiences() audiences} list.
     * @param elements An array of audiences elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder audiences(String... elements) {
      for (String element : elements) {
        this.audiences.add(Objects.requireNonNull(element, "audiences element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckTokenResponse#getAudiences() audiences} list.
     * @param elements An iterable of audiences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("aud")
    public final Builder audiences(Iterable<String> elements) {
      this.audiences.clear();
      return addAllAudiences(elements);
    }

    /**
     * Adds elements to {@link CheckTokenResponse#getAudiences() audiences} list.
     * @param elements An iterable of audiences elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAudiences(Iterable<String> elements) {
      for (String element : elements) {
        this.audiences.add(Objects.requireNonNull(element, "audiences element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link CheckTokenResponse#getAuthorities() authorities} list.
     * @param element A authorities element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authority(String element) {
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckTokenResponse#getAuthorities() authorities} list.
     * @param elements An array of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorities(String... elements) {
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckTokenResponse#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authorities")
    public final Builder authorities(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.authorities = null;
        return this;
      }
      this.authorities = new ArrayList<String>();
      return addAllAuthorities(elements);
    }

    /**
     * Adds elements to {@link CheckTokenResponse#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorities(Iterable<String> elements) {
      Objects.requireNonNull(elements, "authorities element");
      if (this.authorities == null) {
        this.authorities = new ArrayList<String>();
      }
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getAuthorizationTime() authorizationTime} attribute.
     * @param authorizationTime The value for authorizationTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("auth_time")
    public final Builder authorizationTime(@Nullable Long authorizationTime) {
      this.authorizationTime = authorizationTime;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getAuthorizedParty() authorizedParty} attribute.
     * @param authorizedParty The value for authorizedParty 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("azp")
    public final Builder authorizedParty(String authorizedParty) {
      this.authorizedParty = Objects.requireNonNull(authorizedParty, "authorizedParty");
      initBits &= ~INIT_BIT_AUTHORIZED_PARTY;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getCid() cid} attribute.
     * @param cid The value for cid 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cid")
    public final Builder cid(String cid) {
      this.cid = Objects.requireNonNull(cid, "cid");
      initBits &= ~INIT_BIT_CID;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("client_id")
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getEmail() email} attribute.
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("email")
    public final Builder email(@Nullable String email) {
      this.email = email;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getExpirationTime() expirationTime} attribute.
     * @param expirationTime The value for expirationTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("exp")
    public final Builder expirationTime(Long expirationTime) {
      this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime");
      initBits &= ~INIT_BIT_EXPIRATION_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getGrantType() grantType} attribute.
     * @param grantType The value for grantType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("grant_type")
    public final Builder grantType(String grantType) {
      this.grantType = Objects.requireNonNull(grantType, "grantType");
      initBits &= ~INIT_BIT_GRANT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getIssuedAt() issuedAt} attribute.
     * @param issuedAt The value for issuedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("iat")
    public final Builder issuedAt(Long issuedAt) {
      this.issuedAt = Objects.requireNonNull(issuedAt, "issuedAt");
      initBits &= ~INIT_BIT_ISSUED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getIssuer() issuer} attribute.
     * @param issuer The value for issuer 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("iss")
    public final Builder issuer(String issuer) {
      this.issuer = Objects.requireNonNull(issuer, "issuer");
      initBits &= ~INIT_BIT_ISSUER;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getJwtId() jwtId} attribute.
     * @param jwtId The value for jwtId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jti")
    public final Builder jwtId(String jwtId) {
      this.jwtId = Objects.requireNonNull(jwtId, "jwtId");
      initBits &= ~INIT_BIT_JWT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getRevocable() revocable} attribute.
     * @param revocable The value for revocable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("revocable")
    public final Builder revocable(Boolean revocable) {
      this.revocable = Objects.requireNonNull(revocable, "revocable");
      initBits &= ~INIT_BIT_REVOCABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getRevocationSignature() revocationSignature} attribute.
     * @param revocationSignature The value for revocationSignature 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev_sig")
    public final Builder revocationSignature(String revocationSignature) {
      this.revocationSignature = Objects.requireNonNull(revocationSignature, "revocationSignature");
      initBits &= ~INIT_BIT_REVOCATION_SIGNATURE;
      return this;
    }

    /**
     * Adds one element to {@link CheckTokenResponse#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckTokenResponse#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(String... elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckTokenResponse#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scopes(Iterable<String> elements) {
      this.scopes.clear();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link CheckTokenResponse#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getSubject() subject} attribute.
     * @param subject The value for subject 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sub")
    public final Builder subject(String subject) {
      this.subject = Objects.requireNonNull(subject, "subject");
      initBits &= ~INIT_BIT_SUBJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getUserId() userId} attribute.
     * @param userId The value for userId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user_id")
    public final Builder userId(@Nullable String userId) {
      this.userId = userId;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getUserName() userName} attribute.
     * @param userName The value for userName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user_name")
    public final Builder userName(@Nullable String userName) {
      this.userName = userName;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckTokenResponse#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("zid")
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Builds a new {@link CheckTokenResponse CheckTokenResponse}.
     * @return An immutable instance of CheckTokenResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckTokenResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckTokenResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUTHORIZED_PARTY) != 0) attributes.add("authorizedParty");
      if ((initBits & INIT_BIT_CID) != 0) attributes.add("cid");
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_EXPIRATION_TIME) != 0) attributes.add("expirationTime");
      if ((initBits & INIT_BIT_GRANT_TYPE) != 0) attributes.add("grantType");
      if ((initBits & INIT_BIT_ISSUED_AT) != 0) attributes.add("issuedAt");
      if ((initBits & INIT_BIT_ISSUER) != 0) attributes.add("issuer");
      if ((initBits & INIT_BIT_JWT_ID) != 0) attributes.add("jwtId");
      if ((initBits & INIT_BIT_REVOCABLE) != 0) attributes.add("revocable");
      if ((initBits & INIT_BIT_REVOCATION_SIGNATURE) != 0) attributes.add("revocationSignature");
      if ((initBits & INIT_BIT_SUBJECT) != 0) attributes.add("subject");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      return "Cannot build CheckTokenResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
