package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The approvals for a user
 */
@Generated(from = "_Approval", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Approval extends org.cloudfoundry.uaa.users._Approval {
  private final String clientId;
  private final String expiresAt;
  private final String lastUpdatedAt;
  private final String scope;
  private final ApprovalStatus status;
  private final String userId;

  private Approval(Approval.Builder builder) {
    this.clientId = builder.clientId;
    this.expiresAt = builder.expiresAt;
    this.lastUpdatedAt = builder.lastUpdatedAt;
    this.scope = builder.scope;
    this.status = builder.status;
    this.userId = builder.userId;
  }

  /**
   * The client id
   */
  @JsonProperty("clientId")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * When the approval expires
   */
  @JsonProperty("expiresAt")
  @Override
  public String getExpiresAt() {
    return expiresAt;
  }

  /**
   * When the approval was last updated
   */
  @JsonProperty("lastUpdatedAt")
  @Override
  public String getLastUpdatedAt() {
    return lastUpdatedAt;
  }

  /**
   * The scope on the approval
   */
  @JsonProperty("scope")
  @Override
  public String getScope() {
    return scope;
  }

  /**
   * The status of the approval
   */
  @JsonProperty("status")
  @Override
  public ApprovalStatus getStatus() {
    return status;
  }

  /**
   * The user id
   */
  @JsonProperty("userId")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code Approval} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Approval
        && equalTo(0, (Approval) another);
  }

  private boolean equalTo(int synthetic, Approval another) {
    return clientId.equals(another.clientId)
        && expiresAt.equals(another.expiresAt)
        && lastUpdatedAt.equals(another.lastUpdatedAt)
        && scope.equals(another.scope)
        && status.equals(another.status)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code expiresAt}, {@code lastUpdatedAt}, {@code scope}, {@code status}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + expiresAt.hashCode();
    h += (h << 5) + lastUpdatedAt.hashCode();
    h += (h << 5) + scope.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Approval} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Approval{"
        + "clientId=" + clientId
        + ", expiresAt=" + expiresAt
        + ", lastUpdatedAt=" + lastUpdatedAt
        + ", scope=" + scope
        + ", status=" + status
        + ", userId=" + userId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Approval", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._Approval {
    String clientId;
    String expiresAt;
    String lastUpdatedAt;
    String scope;
    ApprovalStatus status;
    String userId;
    @JsonProperty("clientId")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("expiresAt")
    public void setExpiresAt(String expiresAt) {
      this.expiresAt = expiresAt;
    }
    @JsonProperty("lastUpdatedAt")
    public void setLastUpdatedAt(String lastUpdatedAt) {
      this.lastUpdatedAt = lastUpdatedAt;
    }
    @JsonProperty("scope")
    public void setScope(String scope) {
      this.scope = scope;
    }
    @JsonProperty("status")
    public void setStatus(ApprovalStatus status) {
      this.status = status;
    }
    @JsonProperty("userId")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getExpiresAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getLastUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getScope() { throw new UnsupportedOperationException(); }
    @Override
    public ApprovalStatus getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Approval fromJson(Json json) {
    Approval.Builder builder = Approval.builder();
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.expiresAt != null) {
      builder.expiresAt(json.expiresAt);
    }
    if (json.lastUpdatedAt != null) {
      builder.lastUpdatedAt(json.lastUpdatedAt);
    }
    if (json.scope != null) {
      builder.scope(json.scope);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Approval Approval}.
   * <pre>
   * Approval.builder()
   *    .clientId(String) // required {@link Approval#getClientId() clientId}
   *    .expiresAt(String) // required {@link Approval#getExpiresAt() expiresAt}
   *    .lastUpdatedAt(String) // required {@link Approval#getLastUpdatedAt() lastUpdatedAt}
   *    .scope(String) // required {@link Approval#getScope() scope}
   *    .status(org.cloudfoundry.uaa.users.ApprovalStatus) // required {@link Approval#getStatus() status}
   *    .userId(String) // required {@link Approval#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new Approval builder
   */
  public static Approval.Builder builder() {
    return new Approval.Builder();
  }

  /**
   * Builds instances of type {@link Approval Approval}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Approval", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_EXPIRES_AT = 0x2L;
    private static final long INIT_BIT_LAST_UPDATED_AT = 0x4L;
    private static final long INIT_BIT_SCOPE = 0x8L;
    private static final long INIT_BIT_STATUS = 0x10L;
    private static final long INIT_BIT_USER_ID = 0x20L;
    private long initBits = 0x3fL;

    private String clientId;
    private String expiresAt;
    private String lastUpdatedAt;
    private String scope;
    private ApprovalStatus status;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Approval} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Approval instance) {
      return from((_Approval) instance);
    }

    /**
     * Copy abstract value type {@code _Approval} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Approval instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      expiresAt(instance.getExpiresAt());
      lastUpdatedAt(instance.getLastUpdatedAt());
      scope(instance.getScope());
      status(instance.getStatus());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link Approval#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("clientId")
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Approval#getExpiresAt() expiresAt} attribute.
     * @param expiresAt The value for expiresAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expiresAt")
    public final Builder expiresAt(String expiresAt) {
      this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt");
      initBits &= ~INIT_BIT_EXPIRES_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Approval#getLastUpdatedAt() lastUpdatedAt} attribute.
     * @param lastUpdatedAt The value for lastUpdatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastUpdatedAt")
    public final Builder lastUpdatedAt(String lastUpdatedAt) {
      this.lastUpdatedAt = Objects.requireNonNull(lastUpdatedAt, "lastUpdatedAt");
      initBits &= ~INIT_BIT_LAST_UPDATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Approval#getScope() scope} attribute.
     * @param scope The value for scope 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scope(String scope) {
      this.scope = Objects.requireNonNull(scope, "scope");
      initBits &= ~INIT_BIT_SCOPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Approval#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(ApprovalStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link Approval#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userId")
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link Approval Approval}.
     * @return An immutable instance of Approval
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Approval build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Approval(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_EXPIRES_AT) != 0) attributes.add("expiresAt");
      if ((initBits & INIT_BIT_LAST_UPDATED_AT) != 0) attributes.add("lastUpdatedAt");
      if ((initBits & INIT_BIT_SCOPE) != 0) attributes.add("scope");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build Approval, some of required attributes are not set " + attributes;
    }
  }
}
