package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the expire password operation
 */
@Generated(from = "_ExpirePasswordRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ExpirePasswordRequest extends org.cloudfoundry.uaa.users._ExpirePasswordRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final Boolean passwordChangeRequired;
  private final String userId;

  private ExpirePasswordRequest(ExpirePasswordRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.passwordChangeRequired = builder.passwordChangeRequired;
    this.userId = builder.userId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * Whether to expire the user's password
   */
  @JsonProperty("passwordChangeRequired")
  @Override
  public Boolean getPasswordChangeRequired() {
    return passwordChangeRequired;
  }

  /**
   * The user id
   */
  @JsonProperty("userId")
  @JsonIgnore
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code ExpirePasswordRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ExpirePasswordRequest
        && equalTo(0, (ExpirePasswordRequest) another);
  }

  private boolean equalTo(int synthetic, ExpirePasswordRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && passwordChangeRequired.equals(another.passwordChangeRequired)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code passwordChangeRequired}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + passwordChangeRequired.hashCode();
    h += (h << 5) + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExpirePasswordRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExpirePasswordRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", passwordChangeRequired=" + passwordChangeRequired
        + ", userId=" + userId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ExpirePasswordRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._ExpirePasswordRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    Boolean passwordChangeRequired;
    String userId;
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("passwordChangeRequired")
    public void setPasswordChangeRequired(Boolean passwordChangeRequired) {
      this.passwordChangeRequired = passwordChangeRequired;
    }
    @JsonProperty("userId")
    @JsonIgnore
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPasswordChangeRequired() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ExpirePasswordRequest fromJson(Json json) {
    ExpirePasswordRequest.Builder builder = ExpirePasswordRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.passwordChangeRequired != null) {
      builder.passwordChangeRequired(json.passwordChangeRequired);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ExpirePasswordRequest ExpirePasswordRequest}.
   * <pre>
   * ExpirePasswordRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link ExpirePasswordRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link ExpirePasswordRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .passwordChangeRequired(Boolean) // required {@link ExpirePasswordRequest#getPasswordChangeRequired() passwordChangeRequired}
   *    .userId(String) // required {@link ExpirePasswordRequest#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new ExpirePasswordRequest builder
   */
  public static ExpirePasswordRequest.Builder builder() {
    return new ExpirePasswordRequest.Builder();
  }

  /**
   * Builds instances of type {@link ExpirePasswordRequest ExpirePasswordRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ExpirePasswordRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PASSWORD_CHANGE_REQUIRED = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private Boolean passwordChangeRequired;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExpirePasswordRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExpirePasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ExpirePasswordRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ExpirePasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._ExpirePasswordRequest) {
        org.cloudfoundry.uaa.users._ExpirePasswordRequest instance = (org.cloudfoundry.uaa.users._ExpirePasswordRequest) object;
        userId(instance.getUserId());
        passwordChangeRequired(instance.getPasswordChangeRequired());
      }
    }

    /**
     * Initializes the value for the {@link ExpirePasswordRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpirePasswordRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpirePasswordRequest#getPasswordChangeRequired() passwordChangeRequired} attribute.
     * @param passwordChangeRequired The value for passwordChangeRequired 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passwordChangeRequired(Boolean passwordChangeRequired) {
      this.passwordChangeRequired = Objects.requireNonNull(passwordChangeRequired, "passwordChangeRequired");
      initBits &= ~INIT_BIT_PASSWORD_CHANGE_REQUIRED;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpirePasswordRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link ExpirePasswordRequest ExpirePasswordRequest}.
     * @return An immutable instance of ExpirePasswordRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExpirePasswordRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ExpirePasswordRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PASSWORD_CHANGE_REQUIRED) != 0) attributes.add("passwordChangeRequired");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build ExpirePasswordRequest, some of required attributes are not set " + attributes;
    }
  }
}
