package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response from the get user verification link request
 */
@Generated(from = "_GetUserVerificationLinkResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetUserVerificationLinkResponse
    extends org.cloudfoundry.uaa.users._GetUserVerificationLinkResponse {
  private final String verifyLink;

  private GetUserVerificationLinkResponse(GetUserVerificationLinkResponse.Builder builder) {
    this.verifyLink = builder.verifyLink;
  }

  /**
   * The verification link
   */
  @JsonProperty("verify_link")
  @Override
  public String getVerifyLink() {
    return verifyLink;
  }

  /**
   * This instance is equal to all instances of {@code GetUserVerificationLinkResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetUserVerificationLinkResponse
        && equalTo(0, (GetUserVerificationLinkResponse) another);
  }

  private boolean equalTo(int synthetic, GetUserVerificationLinkResponse another) {
    return verifyLink.equals(another.verifyLink);
  }

  /**
   * Computes a hash code from attributes: {@code verifyLink}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + verifyLink.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetUserVerificationLinkResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetUserVerificationLinkResponse{"
        + "verifyLink=" + verifyLink
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetUserVerificationLinkResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._GetUserVerificationLinkResponse {
    String verifyLink;
    @JsonProperty("verify_link")
    public void setVerifyLink(String verifyLink) {
      this.verifyLink = verifyLink;
    }
    @Override
    public String getVerifyLink() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetUserVerificationLinkResponse fromJson(Json json) {
    GetUserVerificationLinkResponse.Builder builder = GetUserVerificationLinkResponse.builder();
    if (json.verifyLink != null) {
      builder.verifyLink(json.verifyLink);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetUserVerificationLinkResponse GetUserVerificationLinkResponse}.
   * <pre>
   * GetUserVerificationLinkResponse.builder()
   *    .verifyLink(String) // required {@link GetUserVerificationLinkResponse#getVerifyLink() verifyLink}
   *    .build();
   * </pre>
   * @return A new GetUserVerificationLinkResponse builder
   */
  public static GetUserVerificationLinkResponse.Builder builder() {
    return new GetUserVerificationLinkResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetUserVerificationLinkResponse GetUserVerificationLinkResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetUserVerificationLinkResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERIFY_LINK = 0x1L;
    private long initBits = 0x1L;

    private String verifyLink;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetUserVerificationLinkResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetUserVerificationLinkResponse instance) {
      return from((_GetUserVerificationLinkResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetUserVerificationLinkResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetUserVerificationLinkResponse instance) {
      Objects.requireNonNull(instance, "instance");
      verifyLink(instance.getVerifyLink());
      return this;
    }

    /**
     * Initializes the value for the {@link GetUserVerificationLinkResponse#getVerifyLink() verifyLink} attribute.
     * @param verifyLink The value for verifyLink 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("verify_link")
    public final Builder verifyLink(String verifyLink) {
      this.verifyLink = Objects.requireNonNull(verifyLink, "verifyLink");
      initBits &= ~INIT_BIT_VERIFY_LINK;
      return this;
    }

    /**
     * Builds a new {@link GetUserVerificationLinkResponse GetUserVerificationLinkResponse}.
     * @return An immutable instance of GetUserVerificationLinkResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetUserVerificationLinkResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetUserVerificationLinkResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERIFY_LINK) != 0) attributes.add("verifyLink");
      return "Cannot build GetUserVerificationLinkResponse, some of required attributes are not set " + attributes;
    }
  }
}
