package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The groups for a user
 */
@Generated(from = "_Group", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Group extends org.cloudfoundry.uaa.users._Group {
  private final String display;
  private final MembershipType type;
  private final String value;

  private Group(Group.Builder builder) {
    this.display = builder.display;
    this.type = builder.type;
    this.value = builder.value;
  }

  /**
   * The client id
   */
  @JsonProperty("display")
  @Override
  public String getDisplay() {
    return display;
  }

  /**
   * The type of membership
   */
  @JsonProperty("type")
  @Override
  public MembershipType getType() {
    return type;
  }

  /**
   * The group value
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code Group} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Group
        && equalTo(0, (Group) another);
  }

  private boolean equalTo(int synthetic, Group another) {
    return display.equals(another.display)
        && type.equals(another.type)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code display}, {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + display.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Group} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Group{"
        + "display=" + display
        + ", type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Group", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._Group {
    String display;
    MembershipType type;
    String value;
    @JsonProperty("display")
    public void setDisplay(String display) {
      this.display = display;
    }
    @JsonProperty("type")
    public void setType(MembershipType type) {
      this.type = type;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getDisplay() { throw new UnsupportedOperationException(); }
    @Override
    public MembershipType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Group fromJson(Json json) {
    Group.Builder builder = Group.builder();
    if (json.display != null) {
      builder.display(json.display);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Group Group}.
   * <pre>
   * Group.builder()
   *    .display(String) // required {@link Group#getDisplay() display}
   *    .type(org.cloudfoundry.uaa.users.MembershipType) // required {@link Group#getType() type}
   *    .value(String) // required {@link Group#getValue() value}
   *    .build();
   * </pre>
   * @return A new Group builder
   */
  public static Group.Builder builder() {
    return new Group.Builder();
  }

  /**
   * Builds instances of type {@link Group Group}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Group", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DISPLAY = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private String display;
    private MembershipType type;
    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Group} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Group instance) {
      return from((_Group) instance);
    }

    /**
     * Copy abstract value type {@code _Group} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Group instance) {
      Objects.requireNonNull(instance, "instance");
      display(instance.getDisplay());
      type(instance.getType());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getDisplay() display} attribute.
     * @param display The value for display 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("display")
    public final Builder display(String display) {
      this.display = Objects.requireNonNull(display, "display");
      initBits &= ~INIT_BIT_DISPLAY;
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(MembershipType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Group#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link Group Group}.
     * @return An immutable instance of Group
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Group build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Group(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISPLAY) != 0) attributes.add("display");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Group, some of required attributes are not set " + attributes;
    }
  }
}
