package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the change user password operation
 */
@Generated(from = "_InviteUsersRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class InviteUsersRequest extends org.cloudfoundry.uaa.users._InviteUsersRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final @Nullable String clientId;
  private final List<String> emails;
  private final String redirectUri;

  private InviteUsersRequest(InviteUsersRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.clientId = builder.clientId;
    this.emails = createUnmodifiableList(true, builder.emails);
    this.redirectUri = builder.redirectUri;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * The client registration information
   */
  @JsonIgnore
  @Override
  public @Nullable String getClientId() {
    return clientId;
  }

  /**
   * The emails to invite
   */
  @JsonProperty("emails")
  @Override
  public List<String> getEmails() {
    return emails;
  }

  /**
   * The redirect URI
   */
  @JsonIgnore
  @Override
  public String getRedirectUri() {
    return redirectUri;
  }

  /**
   * This instance is equal to all instances of {@code InviteUsersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InviteUsersRequest
        && equalTo(0, (InviteUsersRequest) another);
  }

  private boolean equalTo(int synthetic, InviteUsersRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && Objects.equals(clientId, another.clientId)
        && emails.equals(another.emails)
        && redirectUri.equals(another.redirectUri);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code clientId}, {@code emails}, {@code redirectUri}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + Objects.hashCode(clientId);
    h += (h << 5) + emails.hashCode();
    h += (h << 5) + redirectUri.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InviteUsersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InviteUsersRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", clientId=" + clientId
        + ", emails=" + emails
        + ", redirectUri=" + redirectUri
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_InviteUsersRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._InviteUsersRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    String clientId;
    List<String> emails = Collections.emptyList();
    String redirectUri;
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonIgnore
    public void setClientId(@Nullable String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("emails")
    public void setEmails(List<String> emails) {
      this.emails = emails;
    }
    @JsonIgnore
    public void setRedirectUri(String redirectUri) {
      this.redirectUri = redirectUri;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getEmails() { throw new UnsupportedOperationException(); }
    @Override
    public String getRedirectUri() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static InviteUsersRequest fromJson(Json json) {
    InviteUsersRequest.Builder builder = InviteUsersRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.emails != null) {
      builder.addAllEmails(json.emails);
    }
    if (json.redirectUri != null) {
      builder.redirectUri(json.redirectUri);
    }
    return builder.build();
  }

  private static InviteUsersRequest validate(InviteUsersRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link InviteUsersRequest InviteUsersRequest}.
   * <pre>
   * InviteUsersRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link InviteUsersRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link InviteUsersRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .clientId(String | null) // nullable {@link InviteUsersRequest#getClientId() clientId}
   *    .email|addAllEmails(String) // {@link InviteUsersRequest#getEmails() emails} elements
   *    .redirectUri(String) // required {@link InviteUsersRequest#getRedirectUri() redirectUri}
   *    .build();
   * </pre>
   * @return A new InviteUsersRequest builder
   */
  public static InviteUsersRequest.Builder builder() {
    return new InviteUsersRequest.Builder();
  }

  /**
   * Builds instances of type {@link InviteUsersRequest InviteUsersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_InviteUsersRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_REDIRECT_URI = 0x1L;
    private long initBits = 0x1L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String clientId;
    private List<String> emails = new ArrayList<String>();
    private String redirectUri;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InviteUsersRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InviteUsersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _InviteUsersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_InviteUsersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.uaa.users._InviteUsersRequest) {
        org.cloudfoundry.uaa.users._InviteUsersRequest instance = (org.cloudfoundry.uaa.users._InviteUsersRequest) object;
        redirectUri(instance.getRedirectUri());
        addAllEmails(instance.getEmails());
        String clientIdValue = instance.getClientId();
        if (clientIdValue != null) {
          clientId(clientIdValue);
        }
      }
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link InviteUsersRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link InviteUsersRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link InviteUsersRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(@Nullable String clientId) {
      this.clientId = clientId;
      return this;
    }

    /**
     * Adds one element to {@link InviteUsersRequest#getEmails() emails} list.
     * @param element A emails element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(String element) {
      this.emails.add(Objects.requireNonNull(element, "emails element"));
      return this;
    }

    /**
     * Adds elements to {@link InviteUsersRequest#getEmails() emails} list.
     * @param elements An array of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emails(String... elements) {
      for (String element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InviteUsersRequest#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emails(Iterable<String> elements) {
      this.emails.clear();
      return addAllEmails(elements);
    }

    /**
     * Adds elements to {@link InviteUsersRequest#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmails(Iterable<String> elements) {
      for (String element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link InviteUsersRequest#getRedirectUri() redirectUri} attribute.
     * @param redirectUri The value for redirectUri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUri(String redirectUri) {
      this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
      initBits &= ~INIT_BIT_REDIRECT_URI;
      return this;
    }

    /**
     * Builds a new {@link InviteUsersRequest InviteUsersRequest}.
     * @return An immutable instance of InviteUsersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InviteUsersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return InviteUsersRequest.validate(new InviteUsersRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REDIRECT_URI) != 0) attributes.add("redirectUri");
      return "Cannot build InviteUsersRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
