package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The info for a user
 */
@Generated(from = "_UserInfoResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UserInfoResponse extends org.cloudfoundry.uaa.users._UserInfoResponse {
  private final String email;
  private final @Nullable Boolean emailVerified;
  private final String familyName;
  private final String givenName;
  private final String name;
  private final @Nullable String phoneNumber;
  private final @Nullable Long previousLogonTime;
  private final @Nullable String sub;
  private final String userId;
  private final String userName;

  private UserInfoResponse(UserInfoResponse.Builder builder) {
    this.email = builder.email;
    this.emailVerified = builder.emailVerified;
    this.familyName = builder.familyName;
    this.givenName = builder.givenName;
    this.name = builder.name;
    this.phoneNumber = builder.phoneNumber;
    this.previousLogonTime = builder.previousLogonTime;
    this.sub = builder.sub;
    this.userId = builder.userId;
    this.userName = builder.userName;
  }

  /**
   * The user's email address
   */
  @JsonProperty("email")
  @Override
  public String getEmail() {
    return email;
  }

  /**
   * Whether the user has verified their email address
   */
  @JsonProperty("email_verified")
  @Override
  public @Nullable Boolean getEmailVerified() {
    return emailVerified;
  }

  /**
   * The user's family name
   */
  @JsonProperty("family_name")
  @Override
  public String getFamilyName() {
    return familyName;
  }

  /**
   * The user's given name
   */
  @JsonProperty("given_name")
  @Override
  public String getGivenName() {
    return givenName;
  }

  /**
   * The name of the user
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The user's phone number
   */
  @JsonProperty("phone_number")
  @Override
  public @Nullable String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * When the user last logged on
   */
  @JsonProperty("previous_logon_time")
  @Override
  public @Nullable Long getPreviousLogonTime() {
    return previousLogonTime;
  }

  /**
   * The user subject identifier
   */
  @JsonProperty("sub")
  @Override
  public @Nullable String getSub() {
    return sub;
  }

  /**
   * The user id
   */
  @JsonProperty("user_id")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * The user name
   */
  @JsonProperty("user_name")
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * This instance is equal to all instances of {@code UserInfoResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserInfoResponse
        && equalTo(0, (UserInfoResponse) another);
  }

  private boolean equalTo(int synthetic, UserInfoResponse another) {
    return email.equals(another.email)
        && Objects.equals(emailVerified, another.emailVerified)
        && familyName.equals(another.familyName)
        && givenName.equals(another.givenName)
        && name.equals(another.name)
        && Objects.equals(phoneNumber, another.phoneNumber)
        && Objects.equals(previousLogonTime, another.previousLogonTime)
        && Objects.equals(sub, another.sub)
        && userId.equals(another.userId)
        && userName.equals(another.userName);
  }

  /**
   * Computes a hash code from attributes: {@code email}, {@code emailVerified}, {@code familyName}, {@code givenName}, {@code name}, {@code phoneNumber}, {@code previousLogonTime}, {@code sub}, {@code userId}, {@code userName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + email.hashCode();
    h += (h << 5) + Objects.hashCode(emailVerified);
    h += (h << 5) + familyName.hashCode();
    h += (h << 5) + givenName.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(phoneNumber);
    h += (h << 5) + Objects.hashCode(previousLogonTime);
    h += (h << 5) + Objects.hashCode(sub);
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + userName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UserInfoResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserInfoResponse{"
        + "email=" + email
        + ", emailVerified=" + emailVerified
        + ", familyName=" + familyName
        + ", givenName=" + givenName
        + ", name=" + name
        + ", phoneNumber=" + phoneNumber
        + ", previousLogonTime=" + previousLogonTime
        + ", sub=" + sub
        + ", userId=" + userId
        + ", userName=" + userName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UserInfoResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._UserInfoResponse {
    String email;
    Boolean emailVerified;
    String familyName;
    String givenName;
    String name;
    String phoneNumber;
    Long previousLogonTime;
    String sub;
    String userId;
    String userName;
    @JsonProperty("email")
    public void setEmail(String email) {
      this.email = email;
    }
    @JsonProperty("email_verified")
    public void setEmailVerified(@Nullable Boolean emailVerified) {
      this.emailVerified = emailVerified;
    }
    @JsonProperty("family_name")
    public void setFamilyName(String familyName) {
      this.familyName = familyName;
    }
    @JsonProperty("given_name")
    public void setGivenName(String givenName) {
      this.givenName = givenName;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("phone_number")
    public void setPhoneNumber(@Nullable String phoneNumber) {
      this.phoneNumber = phoneNumber;
    }
    @JsonProperty("previous_logon_time")
    public void setPreviousLogonTime(@Nullable Long previousLogonTime) {
      this.previousLogonTime = previousLogonTime;
    }
    @JsonProperty("sub")
    public void setSub(@Nullable String sub) {
      this.sub = sub;
    }
    @JsonProperty("user_id")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("user_name")
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @Override
    public String getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEmailVerified() { throw new UnsupportedOperationException(); }
    @Override
    public String getFamilyName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGivenName() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPhoneNumber() { throw new UnsupportedOperationException(); }
    @Override
    public Long getPreviousLogonTime() { throw new UnsupportedOperationException(); }
    @Override
    public String getSub() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserInfoResponse fromJson(Json json) {
    UserInfoResponse.Builder builder = UserInfoResponse.builder();
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.emailVerified != null) {
      builder.emailVerified(json.emailVerified);
    }
    if (json.familyName != null) {
      builder.familyName(json.familyName);
    }
    if (json.givenName != null) {
      builder.givenName(json.givenName);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.phoneNumber != null) {
      builder.phoneNumber(json.phoneNumber);
    }
    if (json.previousLogonTime != null) {
      builder.previousLogonTime(json.previousLogonTime);
    }
    if (json.sub != null) {
      builder.sub(json.sub);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserInfoResponse UserInfoResponse}.
   * <pre>
   * UserInfoResponse.builder()
   *    .email(String) // required {@link UserInfoResponse#getEmail() email}
   *    .emailVerified(Boolean | null) // nullable {@link UserInfoResponse#getEmailVerified() emailVerified}
   *    .familyName(String) // required {@link UserInfoResponse#getFamilyName() familyName}
   *    .givenName(String) // required {@link UserInfoResponse#getGivenName() givenName}
   *    .name(String) // required {@link UserInfoResponse#getName() name}
   *    .phoneNumber(String | null) // nullable {@link UserInfoResponse#getPhoneNumber() phoneNumber}
   *    .previousLogonTime(Long | null) // nullable {@link UserInfoResponse#getPreviousLogonTime() previousLogonTime}
   *    .sub(String | null) // nullable {@link UserInfoResponse#getSub() sub}
   *    .userId(String) // required {@link UserInfoResponse#getUserId() userId}
   *    .userName(String) // required {@link UserInfoResponse#getUserName() userName}
   *    .build();
   * </pre>
   * @return A new UserInfoResponse builder
   */
  public static UserInfoResponse.Builder builder() {
    return new UserInfoResponse.Builder();
  }

  /**
   * Builds instances of type {@link UserInfoResponse UserInfoResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UserInfoResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_EMAIL = 0x1L;
    private static final long INIT_BIT_FAMILY_NAME = 0x2L;
    private static final long INIT_BIT_GIVEN_NAME = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_USER_ID = 0x10L;
    private static final long INIT_BIT_USER_NAME = 0x20L;
    private long initBits = 0x3fL;

    private String email;
    private Boolean emailVerified;
    private String familyName;
    private String givenName;
    private String name;
    private String phoneNumber;
    private Long previousLogonTime;
    private String sub;
    private String userId;
    private String userName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserInfoResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserInfoResponse instance) {
      return from((_UserInfoResponse) instance);
    }

    /**
     * Copy abstract value type {@code _UserInfoResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserInfoResponse instance) {
      Objects.requireNonNull(instance, "instance");
      email(instance.getEmail());
      Boolean emailVerifiedValue = instance.getEmailVerified();
      if (emailVerifiedValue != null) {
        emailVerified(emailVerifiedValue);
      }
      familyName(instance.getFamilyName());
      givenName(instance.getGivenName());
      name(instance.getName());
      String phoneNumberValue = instance.getPhoneNumber();
      if (phoneNumberValue != null) {
        phoneNumber(phoneNumberValue);
      }
      Long previousLogonTimeValue = instance.getPreviousLogonTime();
      if (previousLogonTimeValue != null) {
        previousLogonTime(previousLogonTimeValue);
      }
      String subValue = instance.getSub();
      if (subValue != null) {
        sub(subValue);
      }
      userId(instance.getUserId());
      userName(instance.getUserName());
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getEmail() email} attribute.
     * @param email The value for email 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("email")
    public final Builder email(String email) {
      this.email = Objects.requireNonNull(email, "email");
      initBits &= ~INIT_BIT_EMAIL;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getEmailVerified() emailVerified} attribute.
     * @param emailVerified The value for emailVerified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("email_verified")
    public final Builder emailVerified(@Nullable Boolean emailVerified) {
      this.emailVerified = emailVerified;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getFamilyName() familyName} attribute.
     * @param familyName The value for familyName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("family_name")
    public final Builder familyName(String familyName) {
      this.familyName = Objects.requireNonNull(familyName, "familyName");
      initBits &= ~INIT_BIT_FAMILY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getGivenName() givenName} attribute.
     * @param givenName The value for givenName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("given_name")
    public final Builder givenName(String givenName) {
      this.givenName = Objects.requireNonNull(givenName, "givenName");
      initBits &= ~INIT_BIT_GIVEN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getPhoneNumber() phoneNumber} attribute.
     * @param phoneNumber The value for phoneNumber (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("phone_number")
    public final Builder phoneNumber(@Nullable String phoneNumber) {
      this.phoneNumber = phoneNumber;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getPreviousLogonTime() previousLogonTime} attribute.
     * @param previousLogonTime The value for previousLogonTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("previous_logon_time")
    public final Builder previousLogonTime(@Nullable Long previousLogonTime) {
      this.previousLogonTime = previousLogonTime;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getSub() sub} attribute.
     * @param sub The value for sub (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sub")
    public final Builder sub(@Nullable String sub) {
      this.sub = sub;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user_id")
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UserInfoResponse#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user_name")
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Builds a new {@link UserInfoResponse UserInfoResponse}.
     * @return An immutable instance of UserInfoResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserInfoResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UserInfoResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EMAIL) != 0) attributes.add("email");
      if ((initBits & INIT_BIT_FAMILY_NAME) != 0) attributes.add("familyName");
      if ((initBits & INIT_BIT_GIVEN_NAME) != 0) attributes.add("givenName");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build UserInfoResponse, some of required attributes are not set " + attributes;
    }
  }
}
