/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications.DockerCredentials;
import org.cloudfoundry.client.v2.applications._CreateApplicationRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateApplicationRequest", generator="Immutables")
public final class CreateApplicationRequest
extends _CreateApplicationRequest {
    @Nullable
    private final String buildpack;
    @Nullable
    private final String command;
    @Nullable
    private final Boolean console;
    @Nullable
    private final String debug;
    @Nullable
    private final String detectedStartCommand;
    @Nullable
    private final Boolean diego;
    @Nullable
    private final Integer diskQuota;
    @Nullable
    private final DockerCredentials dockerCredentials;
    @Nullable
    private final String dockerImage;
    @Nullable
    private final Boolean enableSsh;
    @Nullable
    private final Map<String, Object> environmentJsons;
    @Nullable
    private final String healthCheckHttpEndpoint;
    @Nullable
    private final Integer healthCheckTimeout;
    @Nullable
    private final String healthCheckType;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memory;
    private final String name;
    @Nullable
    private final List<Integer> ports;
    @Nullable
    private final Boolean production;
    private final String spaceId;
    @Nullable
    private final String stackId;
    @Nullable
    private final String state;

    private CreateApplicationRequest(Builder builder) {
        this.buildpack = builder.buildpack;
        this.command = builder.command;
        this.console = builder.console;
        this.debug = builder.debug;
        this.detectedStartCommand = builder.detectedStartCommand;
        this.diego = builder.diego;
        this.diskQuota = builder.diskQuota;
        this.dockerCredentials = builder.dockerCredentials;
        this.dockerImage = builder.dockerImage;
        this.enableSsh = builder.enableSsh;
        this.environmentJsons = builder.environmentJsons == null ? null : CreateApplicationRequest.createUnmodifiableMap(false, false, builder.environmentJsons);
        this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
        this.healthCheckTimeout = builder.healthCheckTimeout;
        this.healthCheckType = builder.healthCheckType;
        this.instances = builder.instances;
        this.memory = builder.memory;
        this.name = builder.name;
        this.ports = builder.ports == null ? null : CreateApplicationRequest.createUnmodifiableList(true, builder.ports);
        this.production = builder.production;
        this.spaceId = builder.spaceId;
        this.stackId = builder.stackId;
        this.state = builder.state;
    }

    @Override
    @JsonProperty(value="buildpack")
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    @JsonProperty(value="command")
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="console")
    @Deprecated
    @Nullable
    public Boolean getConsole() {
        return this.console;
    }

    @Override
    @JsonProperty(value="debug")
    @Deprecated
    @Nullable
    public String getDebug() {
        return this.debug;
    }

    @Override
    @JsonProperty(value="detected_start_command")
    @Nullable
    public String getDetectedStartCommand() {
        return this.detectedStartCommand;
    }

    @Override
    @JsonProperty(value="diego")
    @Nullable
    public Boolean getDiego() {
        return this.diego;
    }

    @Override
    @JsonProperty(value="disk_quota")
    @Nullable
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @JsonProperty(value="docker_credentials")
    @Nullable
    public DockerCredentials getDockerCredentials() {
        return this.dockerCredentials;
    }

    @Override
    @JsonProperty(value="docker_image")
    @Nullable
    public String getDockerImage() {
        return this.dockerImage;
    }

    @Override
    @JsonProperty(value="enable_ssh")
    @Nullable
    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    @Override
    @JsonProperty(value="environment_json")
    @Nullable
    public Map<String, Object> getEnvironmentJsons() {
        return this.environmentJsons;
    }

    @Override
    @JsonProperty(value="health_check_http_endpoint")
    @Nullable
    public String getHealthCheckHttpEndpoint() {
        return this.healthCheckHttpEndpoint;
    }

    @Override
    @JsonProperty(value="health_check_timeout")
    @Nullable
    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    @Override
    @JsonProperty(value="health_check_type")
    @Nullable
    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    @Override
    @JsonProperty(value="instances")
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @JsonProperty(value="memory")
    @Nullable
    public Integer getMemory() {
        return this.memory;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="ports")
    @Nullable
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="production")
    @Deprecated
    @Nullable
    public Boolean getProduction() {
        return this.production;
    }

    @Override
    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @JsonProperty(value="stack_guid")
    @Nullable
    public String getStackId() {
        return this.stackId;
    }

    @Override
    @JsonProperty(value="state")
    @Nullable
    public String getState() {
        return this.state;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateApplicationRequest && this.equalTo(0, (CreateApplicationRequest)another);
    }

    private boolean equalTo(int synthetic, CreateApplicationRequest another) {
        return Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.command, another.command) && Objects.equals(this.console, another.console) && Objects.equals(this.debug, another.debug) && Objects.equals(this.detectedStartCommand, another.detectedStartCommand) && Objects.equals(this.diego, another.diego) && Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.dockerCredentials, another.dockerCredentials) && Objects.equals(this.dockerImage, another.dockerImage) && Objects.equals(this.enableSsh, another.enableSsh) && Objects.equals(this.environmentJsons, another.environmentJsons) && Objects.equals(this.healthCheckHttpEndpoint, another.healthCheckHttpEndpoint) && Objects.equals(this.healthCheckTimeout, another.healthCheckTimeout) && Objects.equals(this.healthCheckType, another.healthCheckType) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memory, another.memory) && this.name.equals(another.name) && Objects.equals(this.ports, another.ports) && Objects.equals(this.production, another.production) && this.spaceId.equals(another.spaceId) && Objects.equals(this.stackId, another.stackId) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.buildpack);
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.console);
        h += (h << 5) + Objects.hashCode(this.debug);
        h += (h << 5) + Objects.hashCode(this.detectedStartCommand);
        h += (h << 5) + Objects.hashCode(this.diego);
        h += (h << 5) + Objects.hashCode(this.diskQuota);
        h += (h << 5) + Objects.hashCode(this.dockerCredentials);
        h += (h << 5) + Objects.hashCode(this.dockerImage);
        h += (h << 5) + Objects.hashCode(this.enableSsh);
        h += (h << 5) + Objects.hashCode(this.environmentJsons);
        h += (h << 5) + Objects.hashCode(this.healthCheckHttpEndpoint);
        h += (h << 5) + Objects.hashCode(this.healthCheckTimeout);
        h += (h << 5) + Objects.hashCode(this.healthCheckType);
        h += (h << 5) + Objects.hashCode(this.instances);
        h += (h << 5) + Objects.hashCode(this.memory);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.ports);
        h += (h << 5) + Objects.hashCode(this.production);
        h += (h << 5) + this.spaceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.stackId);
        h += (h << 5) + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        return "CreateApplicationRequest{buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentials=" + this.dockerCredentials + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons=" + this.environmentJsons + ", healthCheckHttpEndpoint=" + this.healthCheckHttpEndpoint + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", ports=" + this.ports + ", production=" + this.production + ", spaceId=" + this.spaceId + ", stackId=" + this.stackId + ", state=" + this.state + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateApplicationRequest fromJson(Json json) {
        Builder builder = CreateApplicationRequest.builder();
        if (json.buildpack != null) {
            builder.buildpack(json.buildpack);
        }
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.console != null) {
            builder.console(json.console);
        }
        if (json.debug != null) {
            builder.debug(json.debug);
        }
        if (json.detectedStartCommand != null) {
            builder.detectedStartCommand(json.detectedStartCommand);
        }
        if (json.diego != null) {
            builder.diego(json.diego);
        }
        if (json.diskQuota != null) {
            builder.diskQuota(json.diskQuota);
        }
        if (json.dockerCredentials != null) {
            builder.dockerCredentials(json.dockerCredentials);
        }
        if (json.dockerImage != null) {
            builder.dockerImage(json.dockerImage);
        }
        if (json.enableSsh != null) {
            builder.enableSsh(json.enableSsh);
        }
        if (json.environmentJsons != null) {
            builder.putAllEnvironmentJsons(json.environmentJsons);
        }
        if (json.healthCheckHttpEndpoint != null) {
            builder.healthCheckHttpEndpoint(json.healthCheckHttpEndpoint);
        }
        if (json.healthCheckTimeout != null) {
            builder.healthCheckTimeout(json.healthCheckTimeout);
        }
        if (json.healthCheckType != null) {
            builder.healthCheckType(json.healthCheckType);
        }
        if (json.instances != null) {
            builder.instances(json.instances);
        }
        if (json.memory != null) {
            builder.memory(json.memory);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.ports != null) {
            builder.addAllPorts(json.ports);
        }
        if (json.production != null) {
            builder.production(json.production);
        }
        if (json.spaceId != null) {
            builder.spaceId(json.spaceId);
        }
        if (json.stackId != null) {
            builder.stackId(json.stackId);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_CreateApplicationRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SPACE_ID = 2L;
        private long initBits = 3L;
        private String buildpack;
        private String command;
        private Boolean console;
        private String debug;
        private String detectedStartCommand;
        private Boolean diego;
        private Integer diskQuota;
        private DockerCredentials dockerCredentials;
        private String dockerImage;
        private Boolean enableSsh;
        private Map<String, Object> environmentJsons = null;
        private String healthCheckHttpEndpoint;
        private Integer healthCheckTimeout;
        private String healthCheckType;
        private Integer instances;
        private Integer memory;
        private String name;
        private List<Integer> ports = null;
        private Boolean production;
        private String spaceId;
        private String stackId;
        private String state;

        private Builder() {
        }

        public final Builder from(CreateApplicationRequest instance) {
            return this.from((_CreateApplicationRequest)instance);
        }

        final Builder from(_CreateApplicationRequest instance) {
            String stateValue;
            Boolean productionValue;
            Integer memoryValue;
            Integer instancesValue;
            String healthCheckTypeValue;
            Integer healthCheckTimeoutValue;
            String healthCheckHttpEndpointValue;
            Map<String, Object> environmentJsonsValue;
            Boolean enableSshValue;
            String dockerImageValue;
            DockerCredentials dockerCredentialsValue;
            Integer diskQuotaValue;
            Boolean diegoValue;
            String detectedStartCommandValue;
            String debugValue;
            Boolean consoleValue;
            String commandValue;
            Objects.requireNonNull(instance, "instance");
            String buildpackValue = instance.getBuildpack();
            if (buildpackValue != null) {
                this.buildpack(buildpackValue);
            }
            if ((commandValue = instance.getCommand()) != null) {
                this.command(commandValue);
            }
            if ((consoleValue = instance.getConsole()) != null) {
                this.console(consoleValue);
            }
            if ((debugValue = instance.getDebug()) != null) {
                this.debug(debugValue);
            }
            if ((detectedStartCommandValue = instance.getDetectedStartCommand()) != null) {
                this.detectedStartCommand(detectedStartCommandValue);
            }
            if ((diegoValue = instance.getDiego()) != null) {
                this.diego(diegoValue);
            }
            if ((diskQuotaValue = instance.getDiskQuota()) != null) {
                this.diskQuota(diskQuotaValue);
            }
            if ((dockerCredentialsValue = instance.getDockerCredentials()) != null) {
                this.dockerCredentials(dockerCredentialsValue);
            }
            if ((dockerImageValue = instance.getDockerImage()) != null) {
                this.dockerImage(dockerImageValue);
            }
            if ((enableSshValue = instance.getEnableSsh()) != null) {
                this.enableSsh(enableSshValue);
            }
            if ((environmentJsonsValue = instance.getEnvironmentJsons()) != null) {
                this.putAllEnvironmentJsons(environmentJsonsValue);
            }
            if ((healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint()) != null) {
                this.healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
            }
            if ((healthCheckTimeoutValue = instance.getHealthCheckTimeout()) != null) {
                this.healthCheckTimeout(healthCheckTimeoutValue);
            }
            if ((healthCheckTypeValue = instance.getHealthCheckType()) != null) {
                this.healthCheckType(healthCheckTypeValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryValue = instance.getMemory()) != null) {
                this.memory(memoryValue);
            }
            this.name(instance.getName());
            List<Integer> portsValue = instance.getPorts();
            if (portsValue != null) {
                this.addAllPorts(portsValue);
            }
            if ((productionValue = instance.getProduction()) != null) {
                this.production(productionValue);
            }
            this.spaceId(instance.getSpaceId());
            String stackIdValue = instance.getStackId();
            if (stackIdValue != null) {
                this.stackId(stackIdValue);
            }
            if ((stateValue = instance.getState()) != null) {
                this.state(stateValue);
            }
            return this;
        }

        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        @Deprecated
        public final Builder console(@Nullable Boolean console) {
            this.console = console;
            return this;
        }

        @Deprecated
        public final Builder debug(@Nullable String debug) {
            this.debug = debug;
            return this;
        }

        public final Builder detectedStartCommand(@Nullable String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        public final Builder diego(@Nullable Boolean diego) {
            this.diego = diego;
            return this;
        }

        public final Builder diskQuota(@Nullable Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public final Builder dockerCredentials(@Nullable DockerCredentials dockerCredentials) {
            this.dockerCredentials = dockerCredentials;
            return this;
        }

        public final Builder dockerImage(@Nullable String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public final Builder enableSsh(@Nullable Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        public final Builder environmentJson(String key, Object value) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            this.environmentJsons.put(key, value);
            return this;
        }

        public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentJsons.put(k, v);
            return this;
        }

        public final Builder environmentJsons(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.environmentJsons = null;
                return this;
            }
            this.environmentJsons = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentJsons(entries);
        }

        public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> entries) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.environmentJsons.put(k, v);
            }
            return this;
        }

        public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
            this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
            return this;
        }

        public final Builder healthCheckTimeout(@Nullable Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public final Builder healthCheckType(@Nullable String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memory(@Nullable Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int element) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            this.ports.add(element);
            return this;
        }

        public final Builder ports(int ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(element);
            }
            return this;
        }

        public final Builder ports(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<Integer>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (Integer element : elements) {
                this.ports.add(Objects.requireNonNull(element, "ports element"));
            }
            return this;
        }

        @Deprecated
        public final Builder production(@Nullable Boolean production) {
            this.production = production;
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder stackId(@Nullable String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        public CreateApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("spaceId");
            }
            return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateApplicationRequest", generator="Immutables")
    static final class Json
    extends _CreateApplicationRequest {
        String buildpack;
        String command;
        Boolean console;
        String debug;
        String detectedStartCommand;
        Boolean diego;
        Integer diskQuota;
        DockerCredentials dockerCredentials;
        String dockerImage;
        Boolean enableSsh;
        Map<String, Object> environmentJsons = null;
        String healthCheckHttpEndpoint;
        Integer healthCheckTimeout;
        String healthCheckType;
        Integer instances;
        Integer memory;
        String name;
        List<Integer> ports = null;
        Boolean production;
        String spaceId;
        String stackId;
        String state;

        Json() {
        }

        @JsonProperty(value="buildpack")
        public void setBuildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
        }

        @JsonProperty(value="command")
        public void setCommand(@Nullable String command) {
            this.command = command;
        }

        @JsonProperty(value="console")
        public void setConsole(@Nullable Boolean console) {
            this.console = console;
        }

        @JsonProperty(value="debug")
        public void setDebug(@Nullable String debug) {
            this.debug = debug;
        }

        @JsonProperty(value="detected_start_command")
        public void setDetectedStartCommand(@Nullable String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
        }

        @JsonProperty(value="diego")
        public void setDiego(@Nullable Boolean diego) {
            this.diego = diego;
        }

        @JsonProperty(value="disk_quota")
        public void setDiskQuota(@Nullable Integer diskQuota) {
            this.diskQuota = diskQuota;
        }

        @JsonProperty(value="docker_credentials")
        public void setDockerCredentials(@Nullable DockerCredentials dockerCredentials) {
            this.dockerCredentials = dockerCredentials;
        }

        @JsonProperty(value="docker_image")
        public void setDockerImage(@Nullable String dockerImage) {
            this.dockerImage = dockerImage;
        }

        @JsonProperty(value="enable_ssh")
        public void setEnableSsh(@Nullable Boolean enableSsh) {
            this.enableSsh = enableSsh;
        }

        @JsonProperty(value="environment_json")
        public void setEnvironmentJsons(@Nullable Map<String, Object> environmentJsons) {
            this.environmentJsons = environmentJsons;
        }

        @JsonProperty(value="health_check_http_endpoint")
        public void setHealthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
            this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
        }

        @JsonProperty(value="health_check_timeout")
        public void setHealthCheckTimeout(@Nullable Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
        }

        @JsonProperty(value="health_check_type")
        public void setHealthCheckType(@Nullable String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @JsonProperty(value="instances")
        public void setInstances(@Nullable Integer instances) {
            this.instances = instances;
        }

        @JsonProperty(value="memory")
        public void setMemory(@Nullable Integer memory) {
            this.memory = memory;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="ports")
        public void setPorts(@Nullable List<Integer> ports) {
            this.ports = ports;
        }

        @JsonProperty(value="production")
        public void setProduction(@Nullable Boolean production) {
            this.production = production;
        }

        @JsonProperty(value="space_guid")
        public void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @JsonProperty(value="stack_guid")
        public void setStackId(@Nullable String stackId) {
            this.stackId = stackId;
        }

        @JsonProperty(value="state")
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @Override
        public String getBuildpack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getConsole() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDebug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDetectedStartCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDiego() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDiskQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DockerCredentials getDockerCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDockerImage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getEnableSsh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getEnvironmentJsons() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHealthCheckHttpEndpoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getHealthCheckTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHealthCheckType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> getPorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getProduction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getState() {
            throw new UnsupportedOperationException();
        }
    }
}

