/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.organizations._ListOrganizationSpacesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListOrganizationSpacesRequest", generator="Immutables")
public final class ListOrganizationSpacesRequest
extends _ListOrganizationSpacesRequest {
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;
    @Nullable
    private final List<String> applicationIds;
    @Nullable
    private final List<String> developerIds;
    @Nullable
    private final List<String> names;
    private final String organizationId;

    private ListOrganizationSpacesRequest(Builder builder) {
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
        this.applicationIds = builder.applicationIds == null ? null : ListOrganizationSpacesRequest.createUnmodifiableList(true, builder.applicationIds);
        this.developerIds = builder.developerIds == null ? null : ListOrganizationSpacesRequest.createUnmodifiableList(true, builder.developerIds);
        this.names = builder.names == null ? null : ListOrganizationSpacesRequest.createUnmodifiableList(true, builder.names);
        this.organizationId = builder.organizationId;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    @Nullable
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListOrganizationSpacesRequest && this.equalTo(0, (ListOrganizationSpacesRequest)another);
    }

    private boolean equalTo(int synthetic, ListOrganizationSpacesRequest another) {
        return Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage) && Objects.equals(this.applicationIds, another.applicationIds) && Objects.equals(this.developerIds, another.developerIds) && Objects.equals(this.names, another.names) && this.organizationId.equals(another.organizationId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        h += (h << 5) + Objects.hashCode(this.applicationIds);
        h += (h << 5) + Objects.hashCode(this.developerIds);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + this.organizationId.hashCode();
        return h;
    }

    public String toString() {
        return "ListOrganizationSpacesRequest{orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", developerIds=" + this.developerIds + ", names=" + this.names + ", organizationId=" + this.organizationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListOrganizationSpacesRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private long initBits = 1L;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private List<String> applicationIds = null;
        private List<String> developerIds = null;
        private List<String> names = null;
        private String organizationId;

        private Builder() {
        }

        public final Builder from(ListOrganizationSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListOrganizationSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListOrganizationSpacesRequest) {
                List<String> applicationIdsValue;
                instance = (_ListOrganizationSpacesRequest)object;
                List<String> developerIdsValue = ((_ListOrganizationSpacesRequest)instance).getDeveloperIds();
                if (developerIdsValue != null) {
                    this.addAllDeveloperIds(developerIdsValue);
                }
                this.organizationId(((_ListOrganizationSpacesRequest)instance).getOrganizationId());
                List<String> namesValue = ((_ListOrganizationSpacesRequest)instance).getNames();
                if (namesValue != null) {
                    this.addAllNames(namesValue);
                }
                if ((applicationIdsValue = ((_ListOrganizationSpacesRequest)instance).getApplicationIds()) != null) {
                    this.addAllApplicationIds(applicationIdsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public final Builder applicationId(String element) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.applicationIds = null;
                return this;
            }
            this.applicationIds = new ArrayList<String>();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "applicationIds element");
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder developerId(String element) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            return this;
        }

        public final Builder developerIds(String ... elements) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder developerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.developerIds = null;
                return this;
            }
            this.developerIds = new ArrayList<String>();
            return this.addAllDeveloperIds(elements);
        }

        public final Builder addAllDeveloperIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "developerIds element");
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ListOrganizationSpacesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListOrganizationSpacesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build ListOrganizationSpacesRequest, some of required attributes are not set " + attributes;
        }
    }
}

