/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.servicebrokers._CreateServiceBrokerRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateServiceBrokerRequest", generator="Immutables")
public final class CreateServiceBrokerRequest
extends _CreateServiceBrokerRequest {
    private final String authenticationPassword;
    private final String authenticationUsername;
    private final String brokerUrl;
    private final String name;
    @Nullable
    private final String spaceId;

    private CreateServiceBrokerRequest(Builder builder) {
        this.authenticationPassword = builder.authenticationPassword;
        this.authenticationUsername = builder.authenticationUsername;
        this.brokerUrl = builder.brokerUrl;
        this.name = builder.name;
        this.spaceId = builder.spaceId;
    }

    @Override
    @JsonProperty(value="auth_password")
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    @Override
    @JsonProperty(value="auth_username")
    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    @Override
    @JsonProperty(value="broker_url")
    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="space_guid")
    @Nullable
    public String getSpaceId() {
        return this.spaceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceBrokerRequest && this.equalTo(0, (CreateServiceBrokerRequest)another);
    }

    private boolean equalTo(int synthetic, CreateServiceBrokerRequest another) {
        return this.authenticationPassword.equals(another.authenticationPassword) && this.authenticationUsername.equals(another.authenticationUsername) && this.brokerUrl.equals(another.brokerUrl) && this.name.equals(another.name) && Objects.equals(this.spaceId, another.spaceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authenticationPassword.hashCode();
        h += (h << 5) + this.authenticationUsername.hashCode();
        h += (h << 5) + this.brokerUrl.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.spaceId);
        return h;
    }

    public String toString() {
        return "CreateServiceBrokerRequest{authenticationPassword=" + this.authenticationPassword + ", authenticationUsername=" + this.authenticationUsername + ", brokerUrl=" + this.brokerUrl + ", name=" + this.name + ", spaceId=" + this.spaceId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateServiceBrokerRequest fromJson(Json json) {
        Builder builder = CreateServiceBrokerRequest.builder();
        if (json.authenticationPassword != null) {
            builder.authenticationPassword(json.authenticationPassword);
        }
        if (json.authenticationUsername != null) {
            builder.authenticationUsername(json.authenticationUsername);
        }
        if (json.brokerUrl != null) {
            builder.brokerUrl(json.brokerUrl);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.spaceId != null) {
            builder.spaceId(json.spaceId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CreateServiceBrokerRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_AUTHENTICATION_PASSWORD = 1L;
        private static final long INIT_BIT_AUTHENTICATION_USERNAME = 2L;
        private static final long INIT_BIT_BROKER_URL = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private long initBits = 15L;
        private String authenticationPassword;
        private String authenticationUsername;
        private String brokerUrl;
        private String name;
        private String spaceId;

        private Builder() {
        }

        public final Builder from(CreateServiceBrokerRequest instance) {
            return this.from((_CreateServiceBrokerRequest)instance);
        }

        final Builder from(_CreateServiceBrokerRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.authenticationPassword(instance.getAuthenticationPassword());
            this.authenticationUsername(instance.getAuthenticationUsername());
            this.brokerUrl(instance.getBrokerUrl());
            this.name(instance.getName());
            String spaceIdValue = instance.getSpaceId();
            if (spaceIdValue != null) {
                this.spaceId(spaceIdValue);
            }
            return this;
        }

        public final Builder authenticationPassword(String authenticationPassword) {
            this.authenticationPassword = Objects.requireNonNull(authenticationPassword, "authenticationPassword");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder authenticationUsername(String authenticationUsername) {
            this.authenticationUsername = Objects.requireNonNull(authenticationUsername, "authenticationUsername");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder brokerUrl(String brokerUrl) {
            this.brokerUrl = Objects.requireNonNull(brokerUrl, "brokerUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder spaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public CreateServiceBrokerRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateServiceBrokerRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authenticationPassword");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("authenticationUsername");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("brokerUrl");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateServiceBrokerRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateServiceBrokerRequest", generator="Immutables")
    static final class Json
    extends _CreateServiceBrokerRequest {
        String authenticationPassword;
        String authenticationUsername;
        String brokerUrl;
        String name;
        String spaceId;

        Json() {
        }

        @JsonProperty(value="auth_password")
        public void setAuthenticationPassword(String authenticationPassword) {
            this.authenticationPassword = authenticationPassword;
        }

        @JsonProperty(value="auth_username")
        public void setAuthenticationUsername(String authenticationUsername) {
            this.authenticationUsername = authenticationUsername;
        }

        @JsonProperty(value="broker_url")
        public void setBrokerUrl(String brokerUrl) {
            this.brokerUrl = brokerUrl;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="space_guid")
        public void setSpaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public String getAuthenticationPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthenticationUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBrokerUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceId() {
            throw new UnsupportedOperationException();
        }
    }
}

