/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.spaces._CreateSpaceRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateSpaceRequest", generator="Immutables")
public final class CreateSpaceRequest
extends _CreateSpaceRequest {
    @Nullable
    private final Boolean allowSsh;
    @Nullable
    private final List<String> auditorsIds;
    @Nullable
    private final List<String> developerIds;
    @Nullable
    private final List<String> domainIds;
    @Nullable
    private final List<String> managerIds;
    private final String name;
    private final String organizationId;
    @Nullable
    private final List<String> securityGroupIds;
    @Nullable
    private final String spaceQuotaDefinitionId;

    private CreateSpaceRequest(Builder builder) {
        this.allowSsh = builder.allowSsh;
        this.auditorsIds = builder.auditorsIds == null ? null : CreateSpaceRequest.createUnmodifiableList(true, builder.auditorsIds);
        this.developerIds = builder.developerIds == null ? null : CreateSpaceRequest.createUnmodifiableList(true, builder.developerIds);
        this.domainIds = builder.domainIds == null ? null : CreateSpaceRequest.createUnmodifiableList(true, builder.domainIds);
        this.managerIds = builder.managerIds == null ? null : CreateSpaceRequest.createUnmodifiableList(true, builder.managerIds);
        this.name = builder.name;
        this.organizationId = builder.organizationId;
        this.securityGroupIds = builder.securityGroupIds == null ? null : CreateSpaceRequest.createUnmodifiableList(true, builder.securityGroupIds);
        this.spaceQuotaDefinitionId = builder.spaceQuotaDefinitionId;
    }

    @Override
    @JsonProperty(value="allow_ssh")
    @Nullable
    public Boolean getAllowSsh() {
        return this.allowSsh;
    }

    @Override
    @JsonProperty(value="auditor_guid")
    @Nullable
    public List<String> getAuditorsIds() {
        return this.auditorsIds;
    }

    @Override
    @JsonProperty(value="developer_guid")
    @Nullable
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    @Override
    @JsonProperty(value="domain_guid")
    @Nullable
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @Override
    @JsonProperty(value="manager_guid")
    @Nullable
    public List<String> getManagerIds() {
        return this.managerIds;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="organization_guid")
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @JsonProperty(value="security_group_guids")
    @Nullable
    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    @Override
    @JsonProperty(value="space_quota_definition_guid")
    @Nullable
    public String getSpaceQuotaDefinitionId() {
        return this.spaceQuotaDefinitionId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSpaceRequest && this.equalTo(0, (CreateSpaceRequest)another);
    }

    private boolean equalTo(int synthetic, CreateSpaceRequest another) {
        return Objects.equals(this.allowSsh, another.allowSsh) && Objects.equals(this.auditorsIds, another.auditorsIds) && Objects.equals(this.developerIds, another.developerIds) && Objects.equals(this.domainIds, another.domainIds) && Objects.equals(this.managerIds, another.managerIds) && this.name.equals(another.name) && this.organizationId.equals(another.organizationId) && Objects.equals(this.securityGroupIds, another.securityGroupIds) && Objects.equals(this.spaceQuotaDefinitionId, another.spaceQuotaDefinitionId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.allowSsh);
        h += (h << 5) + Objects.hashCode(this.auditorsIds);
        h += (h << 5) + Objects.hashCode(this.developerIds);
        h += (h << 5) + Objects.hashCode(this.domainIds);
        h += (h << 5) + Objects.hashCode(this.managerIds);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.securityGroupIds);
        h += (h << 5) + Objects.hashCode(this.spaceQuotaDefinitionId);
        return h;
    }

    public String toString() {
        return "CreateSpaceRequest{allowSsh=" + this.allowSsh + ", auditorsIds=" + this.auditorsIds + ", developerIds=" + this.developerIds + ", domainIds=" + this.domainIds + ", managerIds=" + this.managerIds + ", name=" + this.name + ", organizationId=" + this.organizationId + ", securityGroupIds=" + this.securityGroupIds + ", spaceQuotaDefinitionId=" + this.spaceQuotaDefinitionId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateSpaceRequest fromJson(Json json) {
        Builder builder = CreateSpaceRequest.builder();
        if (json.allowSsh != null) {
            builder.allowSsh(json.allowSsh);
        }
        if (json.auditorsIds != null) {
            builder.addAllAuditorsIds(json.auditorsIds);
        }
        if (json.developerIds != null) {
            builder.addAllDeveloperIds(json.developerIds);
        }
        if (json.domainIds != null) {
            builder.addAllDomainIds(json.domainIds);
        }
        if (json.managerIds != null) {
            builder.addAllManagerIds(json.managerIds);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.organizationId != null) {
            builder.organizationId(json.organizationId);
        }
        if (json.securityGroupIds != null) {
            builder.addAllSecurityGroupIds(json.securityGroupIds);
        }
        if (json.spaceQuotaDefinitionId != null) {
            builder.spaceQuotaDefinitionId(json.spaceQuotaDefinitionId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_CreateSpaceRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ORGANIZATION_ID = 2L;
        private long initBits = 3L;
        private Boolean allowSsh;
        private List<String> auditorsIds = null;
        private List<String> developerIds = null;
        private List<String> domainIds = null;
        private List<String> managerIds = null;
        private String name;
        private String organizationId;
        private List<String> securityGroupIds = null;
        private String spaceQuotaDefinitionId;

        private Builder() {
        }

        public final Builder from(CreateSpaceRequest instance) {
            return this.from((_CreateSpaceRequest)instance);
        }

        final Builder from(_CreateSpaceRequest instance) {
            String spaceQuotaDefinitionIdValue;
            List<String> managerIdsValue;
            List<String> domainIdsValue;
            List<String> developerIdsValue;
            List<String> auditorsIdsValue;
            Objects.requireNonNull(instance, "instance");
            Boolean allowSshValue = instance.getAllowSsh();
            if (allowSshValue != null) {
                this.allowSsh(allowSshValue);
            }
            if ((auditorsIdsValue = instance.getAuditorsIds()) != null) {
                this.addAllAuditorsIds(auditorsIdsValue);
            }
            if ((developerIdsValue = instance.getDeveloperIds()) != null) {
                this.addAllDeveloperIds(developerIdsValue);
            }
            if ((domainIdsValue = instance.getDomainIds()) != null) {
                this.addAllDomainIds(domainIdsValue);
            }
            if ((managerIdsValue = instance.getManagerIds()) != null) {
                this.addAllManagerIds(managerIdsValue);
            }
            this.name(instance.getName());
            this.organizationId(instance.getOrganizationId());
            List<String> securityGroupIdsValue = instance.getSecurityGroupIds();
            if (securityGroupIdsValue != null) {
                this.addAllSecurityGroupIds(securityGroupIdsValue);
            }
            if ((spaceQuotaDefinitionIdValue = instance.getSpaceQuotaDefinitionId()) != null) {
                this.spaceQuotaDefinitionId(spaceQuotaDefinitionIdValue);
            }
            return this;
        }

        public final Builder allowSsh(@Nullable Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final Builder auditorsId(String element) {
            if (this.auditorsIds == null) {
                this.auditorsIds = new ArrayList<String>();
            }
            this.auditorsIds.add(Objects.requireNonNull(element, "auditorsIds element"));
            return this;
        }

        public final Builder auditorsIds(String ... elements) {
            if (this.auditorsIds == null) {
                this.auditorsIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditorsIds.add(Objects.requireNonNull(element, "auditorsIds element"));
            }
            return this;
        }

        public final Builder auditorsIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.auditorsIds = null;
                return this;
            }
            this.auditorsIds = new ArrayList<String>();
            return this.addAllAuditorsIds(elements);
        }

        public final Builder addAllAuditorsIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "auditorsIds element");
            if (this.auditorsIds == null) {
                this.auditorsIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditorsIds.add(Objects.requireNonNull(element, "auditorsIds element"));
            }
            return this;
        }

        public final Builder developerId(String element) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            return this;
        }

        public final Builder developerIds(String ... elements) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder developerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.developerIds = null;
                return this;
            }
            this.developerIds = new ArrayList<String>();
            return this.addAllDeveloperIds(elements);
        }

        public final Builder addAllDeveloperIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "developerIds element");
            if (this.developerIds == null) {
                this.developerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
            }
            return this;
        }

        public final Builder domainId(String element) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            return this;
        }

        public final Builder domainIds(String ... elements) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder domainIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.domainIds = null;
                return this;
            }
            this.domainIds = new ArrayList<String>();
            return this.addAllDomainIds(elements);
        }

        public final Builder addAllDomainIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "domainIds element");
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder managerId(String element) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList<String>();
            }
            this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
            return this;
        }

        public final Builder managerIds(String ... elements) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
            }
            return this;
        }

        public final Builder managerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.managerIds = null;
                return this;
            }
            this.managerIds = new ArrayList<String>();
            return this.addAllManagerIds(elements);
        }

        public final Builder addAllManagerIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "managerIds element");
            if (this.managerIds == null) {
                this.managerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder securityGroupId(String element) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>();
            }
            this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            return this;
        }

        public final Builder securityGroupIds(String ... elements) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            }
            return this;
        }

        public final Builder securityGroupIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.securityGroupIds = null;
                return this;
            }
            this.securityGroupIds = new ArrayList<String>();
            return this.addAllSecurityGroupIds(elements);
        }

        public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "securityGroupIds element");
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
            }
            return this;
        }

        public final Builder spaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
            this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
            return this;
        }

        public CreateSpaceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateSpaceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build CreateSpaceRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateSpaceRequest", generator="Immutables")
    static final class Json
    extends _CreateSpaceRequest {
        Boolean allowSsh;
        List<String> auditorsIds = null;
        List<String> developerIds = null;
        List<String> domainIds = null;
        List<String> managerIds = null;
        String name;
        String organizationId;
        List<String> securityGroupIds = null;
        String spaceQuotaDefinitionId;

        Json() {
        }

        @JsonProperty(value="allow_ssh")
        public void setAllowSsh(@Nullable Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        @JsonProperty(value="auditor_guid")
        public void setAuditorsIds(@Nullable List<String> auditorsIds) {
            this.auditorsIds = auditorsIds;
        }

        @JsonProperty(value="developer_guid")
        public void setDeveloperIds(@Nullable List<String> developerIds) {
            this.developerIds = developerIds;
        }

        @JsonProperty(value="domain_guid")
        public void setDomainIds(@Nullable List<String> domainIds) {
            this.domainIds = domainIds;
        }

        @JsonProperty(value="manager_guid")
        public void setManagerIds(@Nullable List<String> managerIds) {
            this.managerIds = managerIds;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="organization_guid")
        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @JsonProperty(value="security_group_guids")
        public void setSecurityGroupIds(@Nullable List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        @JsonProperty(value="space_quota_definition_guid")
        public void setSpaceQuotaDefinitionId(@Nullable String spaceQuotaDefinitionId) {
            this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
        }

        @Override
        public Boolean getAllowSsh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAuditorsIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getDeveloperIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getDomainIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getManagerIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrganizationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSecurityGroupIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceQuotaDefinitionId() {
            throw new UnsupportedOperationException();
        }
    }
}

