/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.applications._ListApplicationRoutesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListApplicationRoutesRequest", generator="Immutables")
public final class ListApplicationRoutesRequest
extends _ListApplicationRoutesRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final String applicationId;
    private final List<String> domainIds;
    private final List<String> hosts;
    @Nullable
    private final String labelSelector;
    private final List<String> organizationIds;
    private final List<String> paths;
    private final List<Integer> ports;
    private final List<String> spaceIds;

    private ListApplicationRoutesRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.applicationId = builder.applicationId;
        this.domainIds = ListApplicationRoutesRequest.createUnmodifiableList(true, builder.domainIds);
        this.hosts = ListApplicationRoutesRequest.createUnmodifiableList(true, builder.hosts);
        this.labelSelector = builder.labelSelector;
        this.organizationIds = ListApplicationRoutesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.paths = ListApplicationRoutesRequest.createUnmodifiableList(true, builder.paths);
        this.ports = ListApplicationRoutesRequest.createUnmodifiableList(true, builder.ports);
        this.spaceIds = ListApplicationRoutesRequest.createUnmodifiableList(true, builder.spaceIds);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    @Nullable
    public String getLabelSelector() {
        return this.labelSelector;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationRoutesRequest && this.equalTo(0, (ListApplicationRoutesRequest)another);
    }

    private boolean equalTo(int synthetic, ListApplicationRoutesRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.applicationId.equals(another.applicationId) && this.domainIds.equals(another.domainIds) && this.hosts.equals(another.hosts) && Objects.equals(this.labelSelector, another.labelSelector) && this.organizationIds.equals(another.organizationIds) && this.paths.equals(another.paths) && this.ports.equals(another.ports) && this.spaceIds.equals(another.spaceIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.domainIds.hashCode();
        h += (h << 5) + this.hosts.hashCode();
        h += (h << 5) + Objects.hashCode(this.labelSelector);
        h += (h << 5) + this.organizationIds.hashCode();
        h += (h << 5) + this.paths.hashCode();
        h += (h << 5) + this.ports.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        return h;
    }

    public String toString() {
        return "ListApplicationRoutesRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", applicationId=" + this.applicationId + ", domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", labelSelector=" + this.labelSelector + ", organizationIds=" + this.organizationIds + ", paths=" + this.paths + ", ports=" + this.ports + ", spaceIds=" + this.spaceIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListApplicationRoutesRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private String applicationId;
        private List<String> domainIds = new ArrayList<String>();
        private List<String> hosts = new ArrayList<String>();
        private String labelSelector;
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> paths = new ArrayList<String>();
        private List<Integer> ports = new ArrayList<Integer>();
        private List<String> spaceIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListApplicationRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListApplicationRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListApplicationRoutesRequest) {
                instance = (_ListApplicationRoutesRequest)object;
                this.addAllDomainIds(((_ListApplicationRoutesRequest)instance).getDomainIds());
                this.addAllOrganizationIds(((_ListApplicationRoutesRequest)instance).getOrganizationIds());
                this.addAllHosts(((_ListApplicationRoutesRequest)instance).getHosts());
                this.addAllPaths(((_ListApplicationRoutesRequest)instance).getPaths());
                String labelSelectorValue = ((_ListApplicationRoutesRequest)instance).getLabelSelector();
                if (labelSelectorValue != null) {
                    this.labelSelector(labelSelectorValue);
                }
                this.addAllSpaceIds(((_ListApplicationRoutesRequest)instance).getSpaceIds());
                this.addAllPorts(((_ListApplicationRoutesRequest)instance).getPorts());
                this.applicationId(((_ListApplicationRoutesRequest)instance).getApplicationId());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder domainId(String element) {
            this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            return this;
        }

        public final Builder domainIds(String ... elements) {
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder domainIds(Iterable<String> elements) {
            this.domainIds.clear();
            return this.addAllDomainIds(elements);
        }

        public final Builder addAllDomainIds(Iterable<String> elements) {
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder host(String element) {
            this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            return this;
        }

        public final Builder hosts(String ... elements) {
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder hosts(Iterable<String> elements) {
            this.hosts.clear();
            return this.addAllHosts(elements);
        }

        public final Builder addAllHosts(Iterable<String> elements) {
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder path(String element) {
            this.paths.add(Objects.requireNonNull(element, "paths element"));
            return this;
        }

        public final Builder paths(String ... elements) {
            for (String element : elements) {
                this.paths.add(Objects.requireNonNull(element, "paths element"));
            }
            return this;
        }

        public final Builder paths(Iterable<String> elements) {
            this.paths.clear();
            return this.addAllPaths(elements);
        }

        public final Builder addAllPaths(Iterable<String> elements) {
            for (String element : elements) {
                this.paths.add(Objects.requireNonNull(element, "paths element"));
            }
            return this;
        }

        public final Builder port(int element) {
            this.ports.add(element);
            return this;
        }

        public final Builder ports(int ... elements) {
            for (int element : elements) {
                this.ports.add(element);
            }
            return this;
        }

        public final Builder ports(Iterable<Integer> elements) {
            this.ports.clear();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.ports.add(Objects.requireNonNull(element, "ports element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public ListApplicationRoutesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListApplicationRoutesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build ListApplicationRoutesRequest, some of required attributes are not set " + attributes;
        }
    }
}

