/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.organizations._ListOrganizationDomainsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListOrganizationDomainsRequest", generator="Immutables")
public final class ListOrganizationDomainsRequest
extends _ListOrganizationDomainsRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    @Nullable
    private final List<String> domainIds;
    @Nullable
    private final String labelSelector;
    @Nullable
    private final List<String> names;
    private final String organizationId;
    @Nullable
    private final List<String> owningOrganizationIds;

    private ListOrganizationDomainsRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.domainIds = builder.domainIds == null ? null : ListOrganizationDomainsRequest.createUnmodifiableList(true, builder.domainIds);
        this.labelSelector = builder.labelSelector;
        this.names = builder.names == null ? null : ListOrganizationDomainsRequest.createUnmodifiableList(true, builder.names);
        this.organizationId = builder.organizationId;
        this.owningOrganizationIds = builder.owningOrganizationIds == null ? null : ListOrganizationDomainsRequest.createUnmodifiableList(true, builder.owningOrganizationIds);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    @Nullable
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @Override
    @Nullable
    public String getLabelSelector() {
        return this.labelSelector;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public List<String> getOwningOrganizationIds() {
        return this.owningOrganizationIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListOrganizationDomainsRequest && this.equalTo(0, (ListOrganizationDomainsRequest)another);
    }

    private boolean equalTo(int synthetic, ListOrganizationDomainsRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && Objects.equals(this.domainIds, another.domainIds) && Objects.equals(this.labelSelector, another.labelSelector) && Objects.equals(this.names, another.names) && this.organizationId.equals(another.organizationId) && Objects.equals(this.owningOrganizationIds, another.owningOrganizationIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + Objects.hashCode(this.domainIds);
        h += (h << 5) + Objects.hashCode(this.labelSelector);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.owningOrganizationIds);
        return h;
    }

    public String toString() {
        return "ListOrganizationDomainsRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", domainIds=" + this.domainIds + ", labelSelector=" + this.labelSelector + ", names=" + this.names + ", organizationId=" + this.organizationId + ", owningOrganizationIds=" + this.owningOrganizationIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListOrganizationDomainsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private long initBits = 1L;
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> domainIds = null;
        private String labelSelector;
        private List<String> names = null;
        private String organizationId;
        private List<String> owningOrganizationIds = null;

        private Builder() {
        }

        public final Builder from(ListOrganizationDomainsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListOrganizationDomainsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListOrganizationDomainsRequest) {
                List<String> namesValue;
                String labelSelectorValue;
                instance = (_ListOrganizationDomainsRequest)object;
                List<String> owningOrganizationIdsValue = ((_ListOrganizationDomainsRequest)instance).getOwningOrganizationIds();
                if (owningOrganizationIdsValue != null) {
                    this.addAllOwningOrganizationIds(owningOrganizationIdsValue);
                }
                if ((labelSelectorValue = ((_ListOrganizationDomainsRequest)instance).getLabelSelector()) != null) {
                    this.labelSelector(labelSelectorValue);
                }
                this.organizationId(((_ListOrganizationDomainsRequest)instance).getOrganizationId());
                List<String> domainIdsValue = ((_ListOrganizationDomainsRequest)instance).getDomainIds();
                if (domainIdsValue != null) {
                    this.addAllDomainIds(domainIdsValue);
                }
                if ((namesValue = ((_ListOrganizationDomainsRequest)instance).getNames()) != null) {
                    this.addAllNames(namesValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder domainId(String element) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            return this;
        }

        public final Builder domainIds(String ... elements) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder domainIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.domainIds = null;
                return this;
            }
            this.domainIds = new ArrayList<String>();
            return this.addAllDomainIds(elements);
        }

        public final Builder addAllDomainIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "domainIds element");
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder owningOrganizationId(String element) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList<String>();
            }
            this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
            return this;
        }

        public final Builder owningOrganizationIds(String ... elements) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
            }
            return this;
        }

        public final Builder owningOrganizationIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.owningOrganizationIds = null;
                return this;
            }
            this.owningOrganizationIds = new ArrayList<String>();
            return this.addAllOwningOrganizationIds(elements);
        }

        public final Builder addAllOwningOrganizationIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "owningOrganizationIds element");
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
            }
            return this;
        }

        public ListOrganizationDomainsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListOrganizationDomainsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build ListOrganizationDomainsRequest, some of required attributes are not set " + attributes;
        }
    }
}

