/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.PortMapping;
import org.cloudfoundry.client.v3.processes.ProcessState;
import org.cloudfoundry.client.v3.processes.ProcessStatistics;
import org.cloudfoundry.client.v3.processes.ProcessUsage;
import org.cloudfoundry.client.v3.processes._ProcessStatisticsResource;
import org.immutables.value.Generated;

@Generated(from="_ProcessStatisticsResource", generator="Immutables")
public final class ProcessStatisticsResource
extends _ProcessStatisticsResource {
    @Nullable
    private final String details;
    @Nullable
    private final Long diskQuota;
    @Nullable
    private final Long fileDescriptorQuota;
    @Nullable
    private final String host;
    private final Integer index;
    private final List<PortMapping> instancePorts;
    @Nullable
    private final String isolationSegment;
    @Nullable
    private final Long memoryQuota;
    @Nullable
    private final ProcessState state;
    private final String type;
    private final Long uptime;
    @Nullable
    private final ProcessUsage usage;

    private ProcessStatisticsResource(Builder builder) {
        this.details = builder.details;
        this.diskQuota = builder.diskQuota;
        this.fileDescriptorQuota = builder.fileDescriptorQuota;
        this.host = builder.host;
        this.index = builder.index;
        this.instancePorts = ProcessStatisticsResource.createUnmodifiableList(true, builder.instancePorts);
        this.isolationSegment = builder.isolationSegment;
        this.memoryQuota = builder.memoryQuota;
        this.state = builder.state;
        this.type = builder.type;
        this.uptime = builder.uptime;
        this.usage = builder.usage;
    }

    @Override
    @JsonProperty(value="details")
    @Nullable
    public String getDetails() {
        return this.details;
    }

    @Override
    @JsonProperty(value="disk_quota")
    @Nullable
    public Long getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @JsonProperty(value="fds_quota")
    @Nullable
    public Long getFileDescriptorQuota() {
        return this.fileDescriptorQuota;
    }

    @Override
    @JsonProperty(value="host")
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="index")
    public Integer getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="instance_ports")
    public List<PortMapping> getInstancePorts() {
        return this.instancePorts;
    }

    @Override
    @JsonProperty(value="isolation_segment")
    @Nullable
    public String getIsolationSegment() {
        return this.isolationSegment;
    }

    @Override
    @JsonProperty(value="mem_quota")
    @Nullable
    public Long getMemoryQuota() {
        return this.memoryQuota;
    }

    @Override
    @JsonProperty(value="state")
    @Nullable
    public ProcessState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="uptime")
    public Long getUptime() {
        return this.uptime;
    }

    @Override
    @JsonProperty(value="usage")
    @Nullable
    public ProcessUsage getUsage() {
        return this.usage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProcessStatisticsResource && this.equalTo(0, (ProcessStatisticsResource)another);
    }

    private boolean equalTo(int synthetic, ProcessStatisticsResource another) {
        return Objects.equals(this.details, another.details) && Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.fileDescriptorQuota, another.fileDescriptorQuota) && Objects.equals(this.host, another.host) && this.index.equals(another.index) && this.instancePorts.equals(another.instancePorts) && Objects.equals(this.isolationSegment, another.isolationSegment) && Objects.equals(this.memoryQuota, another.memoryQuota) && Objects.equals((Object)this.state, (Object)another.state) && this.type.equals(another.type) && this.uptime.equals(another.uptime) && Objects.equals(this.usage, another.usage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.details);
        h += (h << 5) + Objects.hashCode(this.diskQuota);
        h += (h << 5) + Objects.hashCode(this.fileDescriptorQuota);
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + this.index.hashCode();
        h += (h << 5) + this.instancePorts.hashCode();
        h += (h << 5) + Objects.hashCode(this.isolationSegment);
        h += (h << 5) + Objects.hashCode(this.memoryQuota);
        h += (h << 5) + Objects.hashCode((Object)this.state);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.uptime.hashCode();
        h += (h << 5) + Objects.hashCode(this.usage);
        return h;
    }

    public String toString() {
        return "ProcessStatisticsResource{details=" + this.details + ", diskQuota=" + this.diskQuota + ", fileDescriptorQuota=" + this.fileDescriptorQuota + ", host=" + this.host + ", index=" + this.index + ", instancePorts=" + this.instancePorts + ", isolationSegment=" + this.isolationSegment + ", memoryQuota=" + this.memoryQuota + ", state=" + (Object)((Object)this.state) + ", type=" + this.type + ", uptime=" + this.uptime + ", usage=" + this.usage + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ProcessStatisticsResource fromJson(Json json) {
        Builder builder = ProcessStatisticsResource.builder();
        if (json.details != null) {
            builder.details(json.details);
        }
        if (json.diskQuota != null) {
            builder.diskQuota(json.diskQuota);
        }
        if (json.fileDescriptorQuota != null) {
            builder.fileDescriptorQuota(json.fileDescriptorQuota);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        if (json.instancePorts != null) {
            builder.addAllInstancePorts(json.instancePorts);
        }
        if (json.isolationSegment != null) {
            builder.isolationSegment(json.isolationSegment);
        }
        if (json.memoryQuota != null) {
            builder.memoryQuota(json.memoryQuota);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.uptime != null) {
            builder.uptime(json.uptime);
        }
        if (json.usage != null) {
            builder.usage(json.usage);
        }
        return builder.build();
    }

    private static ProcessStatisticsResource validate(ProcessStatisticsResource instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ProcessStatisticsResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_UPTIME = 4L;
        private long initBits = 7L;
        private String details;
        private Long diskQuota;
        private Long fileDescriptorQuota;
        private String host;
        private Integer index;
        private List<PortMapping> instancePorts = new ArrayList<PortMapping>();
        private String isolationSegment;
        private Long memoryQuota;
        private ProcessState state;
        private String type;
        private Long uptime;
        private ProcessUsage usage;

        private Builder() {
        }

        public final Builder from(ProcessStatistics instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ProcessStatisticsResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ProcessStatisticsResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof ProcessStatistics) {
                ProcessState stateValue;
                Long memoryQuotaValue;
                String hostValue;
                ProcessUsage usageValue;
                String isolationSegmentValue;
                ProcessStatistics instance = (ProcessStatistics)object;
                Long fileDescriptorQuotaValue = instance.getFileDescriptorQuota();
                if (fileDescriptorQuotaValue != null) {
                    this.fileDescriptorQuota(fileDescriptorQuotaValue);
                }
                if ((isolationSegmentValue = instance.getIsolationSegment()) != null) {
                    this.isolationSegment(isolationSegmentValue);
                }
                if ((usageValue = instance.getUsage()) != null) {
                    this.usage(usageValue);
                }
                if ((hostValue = instance.getHost()) != null) {
                    this.host(hostValue);
                }
                this.index(instance.getIndex());
                String detailsValue = instance.getDetails();
                if (detailsValue != null) {
                    this.details(detailsValue);
                }
                if ((memoryQuotaValue = instance.getMemoryQuota()) != null) {
                    this.memoryQuota(memoryQuotaValue);
                }
                if ((stateValue = instance.getState()) != null) {
                    this.state(stateValue);
                }
                this.type(instance.getType());
                Long diskQuotaValue = instance.getDiskQuota();
                if (diskQuotaValue != null) {
                    this.diskQuota(diskQuotaValue);
                }
                this.addAllInstancePorts(instance.getInstancePorts());
                this.uptime(instance.getUptime());
            }
        }

        @JsonProperty(value="details")
        public final Builder details(@Nullable String details) {
            this.details = details;
            return this;
        }

        @JsonProperty(value="disk_quota")
        public final Builder diskQuota(@Nullable Long diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        @JsonProperty(value="fds_quota")
        public final Builder fileDescriptorQuota(@Nullable Long fileDescriptorQuota) {
            this.fileDescriptorQuota = fileDescriptorQuota;
            return this;
        }

        @JsonProperty(value="host")
        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        @JsonProperty(value="index")
        public final Builder index(Integer index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder instancePort(PortMapping element) {
            this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
            return this;
        }

        public final Builder instancePorts(PortMapping ... elements) {
            for (PortMapping element : elements) {
                this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
            }
            return this;
        }

        @JsonProperty(value="instance_ports")
        public final Builder instancePorts(Iterable<? extends PortMapping> elements) {
            this.instancePorts.clear();
            return this.addAllInstancePorts(elements);
        }

        public final Builder addAllInstancePorts(Iterable<? extends PortMapping> elements) {
            for (PortMapping portMapping : elements) {
                this.instancePorts.add(Objects.requireNonNull(portMapping, "instancePorts element"));
            }
            return this;
        }

        @JsonProperty(value="isolation_segment")
        public final Builder isolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
            return this;
        }

        @JsonProperty(value="mem_quota")
        public final Builder memoryQuota(@Nullable Long memoryQuota) {
            this.memoryQuota = memoryQuota;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(@Nullable ProcessState state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="uptime")
        public final Builder uptime(Long uptime) {
            this.uptime = Objects.requireNonNull(uptime, "uptime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="usage")
        public final Builder usage(@Nullable ProcessUsage usage) {
            this.usage = usage;
            return this;
        }

        public ProcessStatisticsResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ProcessStatisticsResource.validate(new ProcessStatisticsResource(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uptime");
            }
            return "Cannot build ProcessStatisticsResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ProcessStatisticsResource", generator="Immutables")
    static final class Json
    extends _ProcessStatisticsResource {
        String details;
        Long diskQuota;
        Long fileDescriptorQuota;
        String host;
        Integer index;
        List<PortMapping> instancePorts = Collections.emptyList();
        String isolationSegment;
        Long memoryQuota;
        ProcessState state;
        String type;
        Long uptime;
        ProcessUsage usage;

        Json() {
        }

        @JsonProperty(value="details")
        public void setDetails(@Nullable String details) {
            this.details = details;
        }

        @JsonProperty(value="disk_quota")
        public void setDiskQuota(@Nullable Long diskQuota) {
            this.diskQuota = diskQuota;
        }

        @JsonProperty(value="fds_quota")
        public void setFileDescriptorQuota(@Nullable Long fileDescriptorQuota) {
            this.fileDescriptorQuota = fileDescriptorQuota;
        }

        @JsonProperty(value="host")
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonProperty(value="index")
        public void setIndex(Integer index) {
            this.index = index;
        }

        @JsonProperty(value="instance_ports")
        public void setInstancePorts(List<PortMapping> instancePorts) {
            this.instancePorts = instancePorts;
        }

        @JsonProperty(value="isolation_segment")
        public void setIsolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
        }

        @JsonProperty(value="mem_quota")
        public void setMemoryQuota(@Nullable Long memoryQuota) {
            this.memoryQuota = memoryQuota;
        }

        @JsonProperty(value="state")
        public void setState(@Nullable ProcessState state) {
            this.state = state;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="uptime")
        public void setUptime(Long uptime) {
            this.uptime = uptime;
        }

        @JsonProperty(value="usage")
        public void setUsage(@Nullable ProcessUsage usage) {
            this.usage = usage;
        }

        @Override
        public String getDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getDiskQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getFileDescriptorQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PortMapping> getInstancePorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIsolationSegment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getMemoryQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getUptime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessUsage getUsage() {
            throw new UnsupportedOperationException();
        }
    }
}

