/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.roles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.roles.RoleType;
import org.cloudfoundry.client.v3.roles._ListRolesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListRolesRequest", generator="Immutables")
public final class ListRolesRequest
extends _ListRolesRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> roleIds;
    private final List<String> organizationIds;
    private final List<String> spaceIds;
    private final List<RoleType> types;
    private final List<String> userIds;

    private ListRolesRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.roleIds = ListRolesRequest.createUnmodifiableList(true, builder.roleIds);
        this.organizationIds = ListRolesRequest.createUnmodifiableList(true, builder.organizationIds);
        this.spaceIds = ListRolesRequest.createUnmodifiableList(true, builder.spaceIds);
        this.types = ListRolesRequest.createUnmodifiableList(true, builder.types);
        this.userIds = ListRolesRequest.createUnmodifiableList(true, builder.userIds);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getRoleIds() {
        return this.roleIds;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    public List<RoleType> getTypes() {
        return this.types;
    }

    @Override
    public List<String> getUserIds() {
        return this.userIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListRolesRequest && this.equalTo(0, (ListRolesRequest)another);
    }

    private boolean equalTo(int synthetic, ListRolesRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.roleIds.equals(another.roleIds) && this.organizationIds.equals(another.organizationIds) && this.spaceIds.equals(another.spaceIds) && this.types.equals(another.types) && this.userIds.equals(another.userIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.roleIds.hashCode();
        h += (h << 5) + this.organizationIds.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        h += (h << 5) + this.types.hashCode();
        h += (h << 5) + this.userIds.hashCode();
        return h;
    }

    public String toString() {
        return "ListRolesRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", roleIds=" + this.roleIds + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ", types=" + this.types + ", userIds=" + this.userIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListRolesRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> roleIds = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();
        private List<RoleType> types = new ArrayList<RoleType>();
        private List<String> userIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ListRolesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListRolesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListRolesRequest) {
                instance = (_ListRolesRequest)object;
                this.addAllTypes(((_ListRolesRequest)instance).getTypes());
                this.addAllRoleIds(((_ListRolesRequest)instance).getRoleIds());
                this.addAllSpaceIds(((_ListRolesRequest)instance).getSpaceIds());
                this.addAllOrganizationIds(((_ListRolesRequest)instance).getOrganizationIds());
                this.addAllUserIds(((_ListRolesRequest)instance).getUserIds());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder roleId(String element) {
            this.roleIds.add(Objects.requireNonNull(element, "roleIds element"));
            return this;
        }

        public final Builder roleIds(String ... elements) {
            for (String element : elements) {
                this.roleIds.add(Objects.requireNonNull(element, "roleIds element"));
            }
            return this;
        }

        public final Builder roleIds(Iterable<String> elements) {
            this.roleIds.clear();
            return this.addAllRoleIds(elements);
        }

        public final Builder addAllRoleIds(Iterable<String> elements) {
            for (String element : elements) {
                this.roleIds.add(Objects.requireNonNull(element, "roleIds element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder type(RoleType element) {
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder types(RoleType ... elements) {
            for (RoleType element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(Iterable<? extends RoleType> elements) {
            this.types.clear();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<? extends RoleType> elements) {
            for (RoleType roleType : elements) {
                this.types.add(Objects.requireNonNull(roleType, "types element"));
            }
            return this;
        }

        public final Builder userId(String element) {
            this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            return this;
        }

        public final Builder userIds(String ... elements) {
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public final Builder userIds(Iterable<String> elements) {
            this.userIds.clear();
            return this.addAllUserIds(elements);
        }

        public final Builder addAllUserIds(Iterable<String> elements) {
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public ListRolesRequest build() {
            return new ListRolesRequest(this);
        }
    }
}

