/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.securitygroups.AbstractBindSecurityGroupResponse;
import org.cloudfoundry.client.v3.securitygroups._BindRunningSecurityGroupResponse;
import org.immutables.value.Generated;

@Generated(from="_BindRunningSecurityGroupResponse", generator="Immutables")
public final class BindRunningSecurityGroupResponse
extends _BindRunningSecurityGroupResponse {
    private final List<Relationship> boundSpaces;
    private final Map<String, Link> links;

    private BindRunningSecurityGroupResponse(Builder builder) {
        this.boundSpaces = BindRunningSecurityGroupResponse.createUnmodifiableList(true, builder.boundSpaces);
        this.links = BindRunningSecurityGroupResponse.createUnmodifiableMap(false, false, builder.links);
    }

    @Override
    @JsonProperty(value="data")
    public List<Relationship> getBoundSpaces() {
        return this.boundSpaces;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BindRunningSecurityGroupResponse && this.equalTo(0, (BindRunningSecurityGroupResponse)another);
    }

    private boolean equalTo(int synthetic, BindRunningSecurityGroupResponse another) {
        return this.boundSpaces.equals(another.boundSpaces) && this.links.equals(another.links);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.boundSpaces.hashCode();
        h += (h << 5) + this.links.hashCode();
        return h;
    }

    public String toString() {
        return "BindRunningSecurityGroupResponse{boundSpaces=" + this.boundSpaces + ", links=" + this.links + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BindRunningSecurityGroupResponse fromJson(Json json) {
        Builder builder = BindRunningSecurityGroupResponse.builder();
        if (json.boundSpaces != null) {
            builder.addAllBoundSpaces(json.boundSpaces);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_BindRunningSecurityGroupResponse", generator="Immutables")
    public static final class Builder {
        private List<Relationship> boundSpaces = new ArrayList<Relationship>();
        private Map<String, Link> links = new LinkedHashMap<String, Link>();

        private Builder() {
        }

        public final Builder from(AbstractBindSecurityGroupResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_BindRunningSecurityGroupResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof AbstractBindSecurityGroupResponse) {
                AbstractBindSecurityGroupResponse instance = (AbstractBindSecurityGroupResponse)object;
                this.putAllLinks(instance.getLinks());
                this.addAllBoundSpaces(instance.getBoundSpaces());
            }
        }

        public final Builder boundSpace(Relationship element) {
            this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
            return this;
        }

        public final Builder boundSpaces(Relationship ... elements) {
            for (Relationship element : elements) {
                this.boundSpaces.add(Objects.requireNonNull(element, "boundSpaces element"));
            }
            return this;
        }

        @JsonProperty(value="data")
        public final Builder boundSpaces(Iterable<? extends Relationship> elements) {
            this.boundSpaces.clear();
            return this.addAllBoundSpaces(elements);
        }

        public final Builder addAllBoundSpaces(Iterable<? extends Relationship> elements) {
            for (Relationship relationship : elements) {
                this.boundSpaces.add(Objects.requireNonNull(relationship, "boundSpaces element"));
            }
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        public BindRunningSecurityGroupResponse build() {
            return new BindRunningSecurityGroupResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_BindRunningSecurityGroupResponse", generator="Immutables")
    static final class Json
    extends _BindRunningSecurityGroupResponse {
        List<Relationship> boundSpaces = Collections.emptyList();
        Map<String, Link> links = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="data")
        public void setBoundSpaces(List<Relationship> boundSpaces) {
            this.boundSpaces = boundSpaces;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @Override
        public List<Relationship> getBoundSpaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }
    }
}

