/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.securitygroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.securitygroups.GloballyEnabled;
import org.cloudfoundry.client.v3.securitygroups.Relationships;
import org.cloudfoundry.client.v3.securitygroups.Rule;
import org.cloudfoundry.client.v3.securitygroups.SecurityGroup;
import org.cloudfoundry.client.v3.securitygroups._UpdateSecurityGroupResponse;
import org.immutables.value.Generated;

@Generated(from="_UpdateSecurityGroupResponse", generator="Immutables")
public final class UpdateSecurityGroupResponse
extends _UpdateSecurityGroupResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    private final String name;
    private final GloballyEnabled globallyEnabled;
    private final List<Rule> rules;
    private final Relationships relationships;

    private UpdateSecurityGroupResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = UpdateSecurityGroupResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.name = builder.name;
        this.globallyEnabled = builder.globallyEnabled;
        this.rules = UpdateSecurityGroupResponse.createUnmodifiableList(true, builder.rules);
        this.relationships = builder.relationships;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="globally_enabled")
    public GloballyEnabled getGloballyEnabled() {
        return this.globallyEnabled;
    }

    @Override
    @JsonProperty(value="rules")
    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    @JsonProperty(value="relationships")
    public Relationships getRelationships() {
        return this.relationships;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateSecurityGroupResponse && this.equalTo(0, (UpdateSecurityGroupResponse)another);
    }

    private boolean equalTo(int synthetic, UpdateSecurityGroupResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && this.name.equals(another.name) && this.globallyEnabled.equals(another.globallyEnabled) && this.rules.equals(another.rules) && this.relationships.equals(another.relationships);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.globallyEnabled.hashCode();
        h += (h << 5) + this.rules.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateSecurityGroupResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", name=" + this.name + ", globallyEnabled=" + this.globallyEnabled + ", rules=" + this.rules + ", relationships=" + this.relationships + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateSecurityGroupResponse fromJson(Json json) {
        Builder builder = UpdateSecurityGroupResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.globallyEnabled != null) {
            builder.globallyEnabled(json.globallyEnabled);
        }
        if (json.rules != null) {
            builder.addAllRules(json.rules);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_UpdateSecurityGroupResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_GLOBALLY_ENABLED = 8L;
        private static final long INIT_BIT_RELATIONSHIPS = 16L;
        private long initBits = 31L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private String name;
        private GloballyEnabled globallyEnabled;
        private List<Rule> rules = new ArrayList<Rule>();
        private Relationships relationships;

        private Builder() {
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SecurityGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(UpdateSecurityGroupResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_UpdateSecurityGroupResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String updatedAtValue;
            Resource instance;
            long bits = 0L;
            if (object instanceof Resource) {
                instance = (Resource)object;
                if ((bits & 2L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x80L;
                }
            }
            if (object instanceof SecurityGroup) {
                instance = (SecurityGroup)object;
                if ((bits & 2L) == 0L) {
                    this.createdAt(instance.getCreatedAt());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.relationships(((SecurityGroup)instance).getRelationships());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.globallyEnabled(((SecurityGroup)instance).getGloballyEnabled());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.name(((SecurityGroup)instance).getName());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllRules(((SecurityGroup)instance).getRules());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.putAllLinks(instance.getLinks());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.id(instance.getId());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    updatedAtValue = instance.getUpdatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 0x80L;
                }
            }
            if (object instanceof _UpdateSecurityGroupResponse) {
                instance = (_UpdateSecurityGroupResponse)object;
                if ((bits & 0x10L) == 0L) {
                    this.name(((SecurityGroup)instance).getName());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.relationships(((SecurityGroup)instance).getRelationships());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllRules(((SecurityGroup)instance).getRules());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.globallyEnabled(((SecurityGroup)instance).getGloballyEnabled());
                    bits |= 8L;
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="globally_enabled")
        public final Builder globallyEnabled(GloballyEnabled globallyEnabled) {
            this.globallyEnabled = Objects.requireNonNull(globallyEnabled, "globallyEnabled");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder rule(Rule element) {
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder rules(Rule ... elements) {
            for (Rule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        @JsonProperty(value="rules")
        public final Builder rules(Iterable<? extends Rule> elements) {
            this.rules.clear();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends Rule> elements) {
            for (Rule rule : elements) {
                this.rules.add(Objects.requireNonNull(rule, "rules element"));
            }
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(Relationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public UpdateSecurityGroupResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateSecurityGroupResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("globallyEnabled");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("relationships");
            }
            return "Cannot build UpdateSecurityGroupResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateSecurityGroupResponse", generator="Immutables")
    static final class Json
    extends _UpdateSecurityGroupResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        String name;
        GloballyEnabled globallyEnabled;
        List<Rule> rules = Collections.emptyList();
        Relationships relationships;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="globally_enabled")
        public void setGloballyEnabled(GloballyEnabled globallyEnabled) {
            this.globallyEnabled = globallyEnabled;
        }

        @JsonProperty(value="rules")
        public void setRules(List<Rule> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(Relationships relationships) {
            this.relationships = relationships;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GloballyEnabled getGloballyEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Rule> getRules() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationships getRelationships() {
            throw new UnsupportedOperationException();
        }
    }
}

