/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingRelationships;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingType;
import org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateServiceBindingRequest", generator="Immutables")
public final class CreateServiceBindingRequest
extends _CreateServiceBindingRequest {
    @Nullable
    private final String name;
    private final ServiceBindingRelationships relationships;
    private final ServiceBindingType type;
    @Nullable
    private final Map<String, Object> parameters;
    @Nullable
    private final Metadata metadata;

    private CreateServiceBindingRequest(Builder builder) {
        this.name = builder.name;
        this.relationships = builder.relationships;
        this.type = builder.type;
        this.parameters = builder.parameters == null ? null : CreateServiceBindingRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="relationships")
    public ServiceBindingRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="type")
    public ServiceBindingType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="parameters")
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServiceBindingRequest && this.equalTo(0, (CreateServiceBindingRequest)another);
    }

    private boolean equalTo(int synthetic, CreateServiceBindingRequest another) {
        return Objects.equals(this.name, another.name) && this.relationships.equals(another.relationships) && this.type.equals((Object)another.type) && Objects.equals(this.parameters, another.parameters) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "CreateServiceBindingRequest{name=" + this.name + ", relationships=" + this.relationships + ", type=" + (Object)((Object)this.type) + ", parameters=" + this.parameters + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateServiceBindingRequest fromJson(Json json) {
        Builder builder = CreateServiceBindingRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.parameters != null) {
            builder.putAllParameters(json.parameters);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    private static CreateServiceBindingRequest validate(CreateServiceBindingRequest instance) {
        instance.validateParameters();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_CreateServiceBindingRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIPS = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private String name;
        private ServiceBindingRelationships relationships;
        private ServiceBindingType type;
        private Map<String, Object> parameters = null;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(CreateServiceBindingRequest instance) {
            return this.from((_CreateServiceBindingRequest)instance);
        }

        final Builder from(_CreateServiceBindingRequest instance) {
            Metadata metadataValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.getName();
            if (nameValue != null) {
                this.name(nameValue);
            }
            this.relationships(instance.getRelationships());
            this.type(instance.getType());
            Map<String, Object> parametersValue = instance.getParameters();
            if (parametersValue != null) {
                this.putAllParameters(parametersValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder relationships(ServiceBindingRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(ServiceBindingType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public CreateServiceBindingRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CreateServiceBindingRequest.validate(new CreateServiceBindingRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreateServiceBindingRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateServiceBindingRequest", generator="Immutables")
    static final class Json
    extends _CreateServiceBindingRequest {
        String name;
        ServiceBindingRelationships relationships;
        ServiceBindingType type;
        Map<String, Object> parameters = null;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(ServiceBindingRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="type")
        public void setType(ServiceBindingType type) {
            this.type = type;
        }

        @JsonProperty(value="parameters")
        public void setParameters(@Nullable Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceBindingRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceBindingType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

