/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.servicebindings._GetServiceBindingDetailsResponse;
import org.immutables.value.Generated;

@Generated(from="_GetServiceBindingDetailsResponse", generator="Immutables")
public final class GetServiceBindingDetailsResponse
extends _GetServiceBindingDetailsResponse {
    private final Map<String, Object> credentials;
    @Nullable
    private final String syslogDrainUrl;
    private final List<String> volumeMounts;

    private GetServiceBindingDetailsResponse(Builder builder) {
        this.credentials = GetServiceBindingDetailsResponse.createUnmodifiableMap(false, false, builder.credentials);
        this.syslogDrainUrl = builder.syslogDrainUrl;
        this.volumeMounts = GetServiceBindingDetailsResponse.createUnmodifiableList(true, builder.volumeMounts);
    }

    @Override
    @JsonProperty(value="credentials")
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="syslog_drain_url")
    @Nullable
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    @Override
    @JsonProperty(value="volume_mounts")
    public List<String> getVolumeMounts() {
        return this.volumeMounts;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetServiceBindingDetailsResponse && this.equalTo(0, (GetServiceBindingDetailsResponse)another);
    }

    private boolean equalTo(int synthetic, GetServiceBindingDetailsResponse another) {
        return this.credentials.equals(another.credentials) && Objects.equals(this.syslogDrainUrl, another.syslogDrainUrl) && this.volumeMounts.equals(another.volumeMounts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + Objects.hashCode(this.syslogDrainUrl);
        h += (h << 5) + this.volumeMounts.hashCode();
        return h;
    }

    public String toString() {
        return "GetServiceBindingDetailsResponse{credentials=" + this.credentials + ", syslogDrainUrl=" + this.syslogDrainUrl + ", volumeMounts=" + this.volumeMounts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetServiceBindingDetailsResponse fromJson(Json json) {
        Builder builder = GetServiceBindingDetailsResponse.builder();
        if (json.credentials != null) {
            builder.putAllCredentials(json.credentials);
        }
        if (json.syslogDrainUrl != null) {
            builder.syslogDrainUrl(json.syslogDrainUrl);
        }
        if (json.volumeMounts != null) {
            builder.addAllVolumeMounts(json.volumeMounts);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_GetServiceBindingDetailsResponse", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> credentials = new LinkedHashMap<String, Object>();
        private String syslogDrainUrl;
        private List<String> volumeMounts = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(GetServiceBindingDetailsResponse instance) {
            return this.from((_GetServiceBindingDetailsResponse)instance);
        }

        final Builder from(_GetServiceBindingDetailsResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCredentials(instance.getCredentials());
            String syslogDrainUrlValue = instance.getSyslogDrainUrl();
            if (syslogDrainUrlValue != null) {
                this.syslogDrainUrl(syslogDrainUrlValue);
            }
            this.addAllVolumeMounts(instance.getVolumeMounts());
            return this;
        }

        public final Builder credential(String key, Object value) {
            this.credentials.put(key, value);
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(k, v);
            return this;
        }

        @JsonProperty(value="credentials")
        public final Builder credentials(Map<String, ? extends Object> entries) {
            this.credentials.clear();
            return this.putAllCredentials(entries);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.credentials.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="syslog_drain_url")
        public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public final Builder volumeMount(String element) {
            this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            return this;
        }

        public final Builder volumeMounts(String ... elements) {
            for (String element : elements) {
                this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            }
            return this;
        }

        @JsonProperty(value="volume_mounts")
        public final Builder volumeMounts(Iterable<String> elements) {
            this.volumeMounts.clear();
            return this.addAllVolumeMounts(elements);
        }

        public final Builder addAllVolumeMounts(Iterable<String> elements) {
            for (String element : elements) {
                this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            }
            return this;
        }

        public GetServiceBindingDetailsResponse build() {
            return new GetServiceBindingDetailsResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_GetServiceBindingDetailsResponse", generator="Immutables")
    static final class Json
    extends _GetServiceBindingDetailsResponse {
        Map<String, Object> credentials = Collections.emptyMap();
        String syslogDrainUrl;
        List<String> volumeMounts = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="credentials")
        public void setCredentials(Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="syslog_drain_url")
        public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
        }

        @JsonProperty(value="volume_mounts")
        public void setVolumeMounts(List<String> volumeMounts) {
            this.volumeMounts = volumeMounts;
        }

        @Override
        public Map<String, Object> getCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSyslogDrainUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getVolumeMounts() {
            throw new UnsupportedOperationException();
        }
    }
}

