/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.serviceinstances._ListServiceInstancesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListServiceInstancesRequest", generator="Immutables")
public final class ListServiceInstancesRequest
extends _ListServiceInstancesRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    @Nullable
    private final String labelSelector;
    private final List<String> serviceInstanceNames;
    private final List<String> spaceIds;

    private ListServiceInstancesRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.labelSelector = builder.labelSelector;
        this.serviceInstanceNames = ListServiceInstancesRequest.createUnmodifiableList(true, builder.serviceInstanceNames);
        this.spaceIds = ListServiceInstancesRequest.createUnmodifiableList(true, builder.spaceIds);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    @Nullable
    public String getLabelSelector() {
        return this.labelSelector;
    }

    @Override
    public List<String> getServiceInstanceNames() {
        return this.serviceInstanceNames;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceInstancesRequest && this.equalTo(0, (ListServiceInstancesRequest)another);
    }

    private boolean equalTo(int synthetic, ListServiceInstancesRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && Objects.equals(this.labelSelector, another.labelSelector) && this.serviceInstanceNames.equals(another.serviceInstanceNames) && this.spaceIds.equals(another.spaceIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + Objects.hashCode(this.labelSelector);
        h += (h << 5) + this.serviceInstanceNames.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        return h;
    }

    public String toString() {
        return "ListServiceInstancesRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", labelSelector=" + this.labelSelector + ", serviceInstanceNames=" + this.serviceInstanceNames + ", spaceIds=" + this.spaceIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServiceInstancesRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private String labelSelector;
        private List<String> serviceInstanceNames = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ListServiceInstancesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_ListServiceInstancesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServiceInstancesRequest) {
                instance = (_ListServiceInstancesRequest)object;
                String labelSelectorValue = ((_ListServiceInstancesRequest)instance).getLabelSelector();
                if (labelSelectorValue != null) {
                    this.labelSelector(labelSelectorValue);
                }
                this.addAllServiceInstanceNames(((_ListServiceInstancesRequest)instance).getServiceInstanceNames());
                this.addAllSpaceIds(((_ListServiceInstancesRequest)instance).getSpaceIds());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder labelSelector(@Nullable String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public final Builder serviceInstanceName(String element) {
            this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
            return this;
        }

        public final Builder serviceInstanceNames(String ... elements) {
            for (String element : elements) {
                this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
            }
            return this;
        }

        public final Builder serviceInstanceNames(Iterable<String> elements) {
            this.serviceInstanceNames.clear();
            return this.addAllServiceInstanceNames(elements);
        }

        public final Builder addAllServiceInstanceNames(Iterable<String> elements) {
            for (String element : elements) {
                this.serviceInstanceNames.add(Objects.requireNonNull(element, "serviceInstanceNames element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public ListServiceInstancesRequest build() {
            return new ListServiceInstancesRequest(this);
        }
    }
}

