/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.MaintenanceInfo;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.serviceinstances.ServiceInstanceRelationships;
import org.cloudfoundry.client.v3.serviceinstances._UpdateServiceInstanceRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
public final class UpdateServiceInstanceRequest
extends _UpdateServiceInstanceRequest {
    private final String serviceInstanceId;
    @Nullable
    private final Metadata metadata;
    @Nullable
    private final String name;
    @Nullable
    private final ServiceInstanceRelationships relationships;
    @Nullable
    private final List<String> tags;
    @Nullable
    private final Map<String, Object> parameters;
    @Nullable
    private final Map<String, Object> credentials;
    @Nullable
    private final String syslogDrainUrl;
    @Nullable
    private final String routeServiceUrl;
    @Nullable
    private final MaintenanceInfo maintenanceInfo;

    private UpdateServiceInstanceRequest(Builder builder) {
        this.serviceInstanceId = builder.serviceInstanceId;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.relationships = builder.relationships;
        this.tags = builder.tags == null ? null : UpdateServiceInstanceRequest.createUnmodifiableList(true, builder.tags);
        this.parameters = builder.parameters == null ? null : UpdateServiceInstanceRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.credentials = builder.credentials == null ? null : UpdateServiceInstanceRequest.createUnmodifiableMap(false, false, builder.credentials);
        this.syslogDrainUrl = builder.syslogDrainUrl;
        this.routeServiceUrl = builder.routeServiceUrl;
        this.maintenanceInfo = builder.maintenanceInfo;
    }

    @Override
    @JsonProperty(value="serviceInstanceId")
    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public ServiceInstanceRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="parameters")
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="credentials")
    @Nullable
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="syslog_drain_url")
    @Nullable
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    @Override
    @JsonProperty(value="route_service_url")
    @Nullable
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    @Override
    @JsonProperty(value="maintenance_info")
    @Nullable
    public MaintenanceInfo maintenanceInfo() {
        return this.maintenanceInfo;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServiceInstanceRequest && this.equalTo(0, (UpdateServiceInstanceRequest)another);
    }

    private boolean equalTo(int synthetic, UpdateServiceInstanceRequest another) {
        return this.serviceInstanceId.equals(another.serviceInstanceId) && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.name, another.name) && Objects.equals(this.relationships, another.relationships) && Objects.equals(this.tags, another.tags) && Objects.equals(this.parameters, another.parameters) && Objects.equals(this.credentials, another.credentials) && Objects.equals(this.syslogDrainUrl, another.syslogDrainUrl) && Objects.equals(this.routeServiceUrl, another.routeServiceUrl) && Objects.equals(this.maintenanceInfo, another.maintenanceInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.serviceInstanceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.relationships);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + Objects.hashCode(this.syslogDrainUrl);
        h += (h << 5) + Objects.hashCode(this.routeServiceUrl);
        h += (h << 5) + Objects.hashCode(this.maintenanceInfo);
        return h;
    }

    public String toString() {
        return "UpdateServiceInstanceRequest{serviceInstanceId=" + this.serviceInstanceId + ", metadata=" + this.metadata + ", name=" + this.name + ", relationships=" + this.relationships + ", tags=" + this.tags + ", parameters=" + this.parameters + ", credentials=" + this.credentials + ", syslogDrainUrl=" + this.syslogDrainUrl + ", routeServiceUrl=" + this.routeServiceUrl + ", maintenanceInfo=" + this.maintenanceInfo + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateServiceInstanceRequest fromJson(Json json) {
        Builder builder = UpdateServiceInstanceRequest.builder();
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.parameters != null) {
            builder.putAllParameters(json.parameters);
        }
        if (json.credentials != null) {
            builder.putAllCredentials(json.credentials);
        }
        if (json.syslogDrainUrl != null) {
            builder.syslogDrainUrl(json.syslogDrainUrl);
        }
        if (json.routeServiceUrl != null) {
            builder.routeServiceUrl(json.routeServiceUrl);
        }
        if (json.maintenanceInfo != null) {
            builder.maintenanceInfo(json.maintenanceInfo);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 1L;
        private long initBits = 1L;
        private String serviceInstanceId;
        private Metadata metadata;
        private String name;
        private ServiceInstanceRelationships relationships;
        private List<String> tags = null;
        private Map<String, Object> parameters = null;
        private Map<String, Object> credentials = null;
        private String syslogDrainUrl;
        private String routeServiceUrl;
        private MaintenanceInfo maintenanceInfo;

        private Builder() {
        }

        public final Builder from(UpdateServiceInstanceRequest instance) {
            return this.from((_UpdateServiceInstanceRequest)instance);
        }

        final Builder from(_UpdateServiceInstanceRequest instance) {
            MaintenanceInfo maintenanceInfoValue;
            String routeServiceUrlValue;
            String syslogDrainUrlValue;
            Map<String, Object> credentialsValue;
            Map<String, Object> parametersValue;
            List<String> tagsValue;
            ServiceInstanceRelationships relationshipsValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            this.serviceInstanceId(instance.getServiceInstanceId());
            Metadata metadataValue = instance.getMetadata();
            if (metadataValue != null) {
                this.metadata(metadataValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((relationshipsValue = instance.getRelationships()) != null) {
                this.relationships(relationshipsValue);
            }
            if ((tagsValue = instance.getTags()) != null) {
                this.addAllTags(tagsValue);
            }
            if ((parametersValue = instance.getParameters()) != null) {
                this.putAllParameters(parametersValue);
            }
            if ((credentialsValue = instance.getCredentials()) != null) {
                this.putAllCredentials(credentialsValue);
            }
            if ((syslogDrainUrlValue = instance.getSyslogDrainUrl()) != null) {
                this.syslogDrainUrl(syslogDrainUrlValue);
            }
            if ((routeServiceUrlValue = instance.getRouteServiceUrl()) != null) {
                this.routeServiceUrl(routeServiceUrlValue);
            }
            if ((maintenanceInfoValue = instance.maintenanceInfo()) != null) {
                this.maintenanceInfo(maintenanceInfoValue);
            }
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder relationships(@Nullable ServiceInstanceRelationships relationships) {
            this.relationships = relationships;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, value == null ? "parameters value for key: " + key : null));
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
            }
            return this;
        }

        public final Builder credential(String key, Object value) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            this.credentials.put(Objects.requireNonNull(key, "credentials key"), Objects.requireNonNull(value, value == null ? "credentials value for key: " + key : null));
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(Objects.requireNonNull(k, "credentials key"), Objects.requireNonNull(v, v == null ? "credentials value for key: " + k : null));
            return this;
        }

        public final Builder credentials(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.credentials = null;
                return this;
            }
            this.credentials = new LinkedHashMap<String, Object>();
            return this.putAllCredentials(entries);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.credentials.put(Objects.requireNonNull(k, "credentials key"), Objects.requireNonNull(v, v == null ? "credentials value for key: " + k : null));
            }
            return this;
        }

        public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
            this.maintenanceInfo = maintenanceInfo;
            return this;
        }

        public UpdateServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build UpdateServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
    static final class Json
    extends _UpdateServiceInstanceRequest {
        String serviceInstanceId;
        Metadata metadata;
        String name;
        ServiceInstanceRelationships relationships;
        List<String> tags = null;
        Map<String, Object> parameters = null;
        Map<String, Object> credentials = null;
        String syslogDrainUrl;
        String routeServiceUrl;
        MaintenanceInfo maintenanceInfo;

        Json() {
        }

        @JsonProperty(value="serviceInstanceId")
        @JsonIgnore
        public void setServiceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable ServiceInstanceRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="tags")
        public void setTags(@Nullable List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="parameters")
        public void setParameters(@Nullable Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        @JsonProperty(value="credentials")
        public void setCredentials(@Nullable Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="syslog_drain_url")
        public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
        }

        @JsonProperty(value="route_service_url")
        public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
        }

        @JsonProperty(value="maintenance_info")
        public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
            this.maintenanceInfo = maintenanceInfo;
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceInstanceRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSyslogDrainUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteServiceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MaintenanceInfo maintenanceInfo() {
            throw new UnsupportedOperationException();
        }
    }
}

