/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.doppler._ContainerMetric;
import org.immutables.value.Generated;

@Generated(from="_ContainerMetric", generator="Immutables")
public final class ContainerMetric
extends _ContainerMetric {
    private final String applicationId;
    private final Double cpuPercentage;
    private final Long diskBytes;
    @Nullable
    private final Long diskBytesQuota;
    private final Integer instanceIndex;
    private final Long memoryBytes;
    @Nullable
    private final Long memoryBytesQuota;

    private ContainerMetric(Builder builder) {
        this.applicationId = builder.applicationId;
        this.cpuPercentage = builder.cpuPercentage;
        this.diskBytes = builder.diskBytes;
        this.diskBytesQuota = builder.diskBytesQuota;
        this.instanceIndex = builder.instanceIndex;
        this.memoryBytes = builder.memoryBytes;
        this.memoryBytesQuota = builder.memoryBytesQuota;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public Double getCpuPercentage() {
        return this.cpuPercentage;
    }

    @Override
    public Long getDiskBytes() {
        return this.diskBytes;
    }

    @Override
    @Nullable
    public Long getDiskBytesQuota() {
        return this.diskBytesQuota;
    }

    @Override
    public Integer getInstanceIndex() {
        return this.instanceIndex;
    }

    @Override
    public Long getMemoryBytes() {
        return this.memoryBytes;
    }

    @Override
    @Nullable
    public Long getMemoryBytesQuota() {
        return this.memoryBytesQuota;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ContainerMetric && this.equalTo(0, (ContainerMetric)another);
    }

    private boolean equalTo(int synthetic, ContainerMetric another) {
        return this.applicationId.equals(another.applicationId) && this.cpuPercentage.equals(another.cpuPercentage) && this.diskBytes.equals(another.diskBytes) && Objects.equals(this.diskBytesQuota, another.diskBytesQuota) && this.instanceIndex.equals(another.instanceIndex) && this.memoryBytes.equals(another.memoryBytes) && Objects.equals(this.memoryBytesQuota, another.memoryBytesQuota);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.cpuPercentage.hashCode();
        h += (h << 5) + this.diskBytes.hashCode();
        h += (h << 5) + Objects.hashCode(this.diskBytesQuota);
        h += (h << 5) + this.instanceIndex.hashCode();
        h += (h << 5) + this.memoryBytes.hashCode();
        h += (h << 5) + Objects.hashCode(this.memoryBytesQuota);
        return h;
    }

    public String toString() {
        return "ContainerMetric{applicationId=" + this.applicationId + ", cpuPercentage=" + this.cpuPercentage + ", diskBytes=" + this.diskBytes + ", diskBytesQuota=" + this.diskBytesQuota + ", instanceIndex=" + this.instanceIndex + ", memoryBytes=" + this.memoryBytes + ", memoryBytesQuota=" + this.memoryBytesQuota + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ContainerMetric", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_CPU_PERCENTAGE = 2L;
        private static final long INIT_BIT_DISK_BYTES = 4L;
        private static final long INIT_BIT_INSTANCE_INDEX = 8L;
        private static final long INIT_BIT_MEMORY_BYTES = 16L;
        private long initBits = 31L;
        private String applicationId;
        private Double cpuPercentage;
        private Long diskBytes;
        private Long diskBytesQuota;
        private Integer instanceIndex;
        private Long memoryBytes;
        private Long memoryBytesQuota;

        private Builder() {
        }

        public final Builder from(ContainerMetric instance) {
            return this.from((_ContainerMetric)instance);
        }

        final Builder from(_ContainerMetric instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.cpuPercentage(instance.getCpuPercentage());
            this.diskBytes(instance.getDiskBytes());
            Long diskBytesQuotaValue = instance.getDiskBytesQuota();
            if (diskBytesQuotaValue != null) {
                this.diskBytesQuota(diskBytesQuotaValue);
            }
            this.instanceIndex(instance.getInstanceIndex());
            this.memoryBytes(instance.getMemoryBytes());
            Long memoryBytesQuotaValue = instance.getMemoryBytesQuota();
            if (memoryBytesQuotaValue != null) {
                this.memoryBytesQuota(memoryBytesQuotaValue);
            }
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder cpuPercentage(Double cpuPercentage) {
            this.cpuPercentage = Objects.requireNonNull(cpuPercentage, "cpuPercentage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder diskBytes(Long diskBytes) {
            this.diskBytes = Objects.requireNonNull(diskBytes, "diskBytes");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder diskBytesQuota(@Nullable Long diskBytesQuota) {
            this.diskBytesQuota = diskBytesQuota;
            return this;
        }

        public final Builder instanceIndex(Integer instanceIndex) {
            this.instanceIndex = Objects.requireNonNull(instanceIndex, "instanceIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder memoryBytes(Long memoryBytes) {
            this.memoryBytes = Objects.requireNonNull(memoryBytes, "memoryBytes");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder memoryBytesQuota(@Nullable Long memoryBytesQuota) {
            this.memoryBytesQuota = memoryBytesQuota;
            return this;
        }

        public ContainerMetric build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ContainerMetric(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cpuPercentage");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("diskBytes");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("instanceIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("memoryBytes");
            }
            return "Cannot build ContainerMetric, some of required attributes are not set " + attributes;
        }
    }
}

