/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.clients.AbstractUpdateClient;
import org.cloudfoundry.uaa.clients._UpdateClientAction;
import org.cloudfoundry.uaa.tokens.GrantType;
import org.immutables.value.Generated;

@Generated(from="_UpdateClientAction", generator="Immutables")
public final class UpdateClientAction
extends _UpdateClientAction {
    @Nullable
    private final List<String> allowedProviders;
    @Nullable
    private final Boolean approvalsDeleted;
    @Nullable
    private final List<String> authorities;
    @Nullable
    private final List<GrantType> authorizedGrantTypes;
    @Nullable
    private final List<String> autoApproves;
    private final String clientId;
    @Nullable
    private final String createdWith;
    @Nullable
    private final String name;
    @Nullable
    private final List<String> redirectUriPatterns;
    @Nullable
    private final List<String> resourceIds;
    @Nullable
    private final List<String> scopes;
    @Nullable
    private final String tokenSalt;
    private final transient String action;

    private UpdateClientAction(Builder builder) {
        this.allowedProviders = builder.allowedProviders == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.allowedProviders);
        this.approvalsDeleted = builder.approvalsDeleted;
        this.authorities = builder.authorities == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.authorities);
        this.authorizedGrantTypes = builder.authorizedGrantTypes == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.authorizedGrantTypes);
        this.autoApproves = builder.autoApproves == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.autoApproves);
        this.clientId = builder.clientId;
        this.createdWith = builder.createdWith;
        this.name = builder.name;
        this.redirectUriPatterns = builder.redirectUriPatterns == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.redirectUriPatterns);
        this.resourceIds = builder.resourceIds == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.resourceIds);
        this.scopes = builder.scopes == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.scopes);
        this.tokenSalt = builder.tokenSalt;
        this.action = Objects.requireNonNull(super.getAction(), "action");
    }

    @Override
    @Nullable
    public List<String> getAllowedProviders() {
        return this.allowedProviders;
    }

    @Override
    @Nullable
    public Boolean getApprovalsDeleted() {
        return this.approvalsDeleted;
    }

    @Override
    @Nullable
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    @Nullable
    public List<GrantType> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    @Override
    @Nullable
    public List<String> getAutoApproves() {
        return this.autoApproves;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String getCreatedWith() {
        return this.createdWith;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public List<String> getRedirectUriPatterns() {
        return this.redirectUriPatterns;
    }

    @Override
    @Nullable
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    @Override
    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    @Nullable
    public String getTokenSalt() {
        return this.tokenSalt;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateClientAction && this.equalTo(0, (UpdateClientAction)another);
    }

    private boolean equalTo(int synthetic, UpdateClientAction another) {
        return Objects.equals(this.allowedProviders, another.allowedProviders) && Objects.equals(this.approvalsDeleted, another.approvalsDeleted) && Objects.equals(this.authorities, another.authorities) && Objects.equals(this.authorizedGrantTypes, another.authorizedGrantTypes) && Objects.equals(this.autoApproves, another.autoApproves) && this.clientId.equals(another.clientId) && Objects.equals(this.createdWith, another.createdWith) && Objects.equals(this.name, another.name) && Objects.equals(this.redirectUriPatterns, another.redirectUriPatterns) && Objects.equals(this.resourceIds, another.resourceIds) && Objects.equals(this.scopes, another.scopes) && Objects.equals(this.tokenSalt, another.tokenSalt) && this.action.equals(another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.allowedProviders);
        h += (h << 5) + Objects.hashCode(this.approvalsDeleted);
        h += (h << 5) + Objects.hashCode(this.authorities);
        h += (h << 5) + Objects.hashCode(this.authorizedGrantTypes);
        h += (h << 5) + Objects.hashCode(this.autoApproves);
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.createdWith);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.redirectUriPatterns);
        h += (h << 5) + Objects.hashCode(this.resourceIds);
        h += (h << 5) + Objects.hashCode(this.scopes);
        h += (h << 5) + Objects.hashCode(this.tokenSalt);
        h += (h << 5) + this.action.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateClientAction{allowedProviders=" + this.allowedProviders + ", approvalsDeleted=" + this.approvalsDeleted + ", authorities=" + this.authorities + ", authorizedGrantTypes=" + this.authorizedGrantTypes + ", autoApproves=" + this.autoApproves + ", clientId=" + this.clientId + ", createdWith=" + this.createdWith + ", name=" + this.name + ", redirectUriPatterns=" + this.redirectUriPatterns + ", resourceIds=" + this.resourceIds + ", scopes=" + this.scopes + ", tokenSalt=" + this.tokenSalt + ", action=" + this.action + "}";
    }

    private static UpdateClientAction validate(UpdateClientAction instance) {
        instance.checkAuthorizedGrantType();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_UpdateClientAction", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        private List<String> allowedProviders = null;
        private Boolean approvalsDeleted;
        private List<String> authorities = null;
        private List<GrantType> authorizedGrantTypes = null;
        private List<String> autoApproves = null;
        private String clientId;
        private String createdWith;
        private String name;
        private List<String> redirectUriPatterns = null;
        private List<String> resourceIds = null;
        private List<String> scopes = null;
        private String tokenSalt;

        private Builder() {
        }

        public final Builder from(UpdateClientAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(_UpdateClientAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractUpdateClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            List<String> resourceIdsValue;
            List<String> allowedProvidersValue;
            List<String> authoritiesValue;
            List<String> autoApprovesValue;
            List<String> scopesValue;
            Boolean approvalsDeletedValue;
            String nameValue;
            List<String> redirectUriPatternsValue;
            String createdWithValue;
            String tokenSaltValue;
            List<GrantType> authorizedGrantTypesValue;
            AbstractUpdateClient instance;
            long bits = 0L;
            if (object instanceof _UpdateClientAction) {
                instance = (_UpdateClientAction)object;
                if ((bits & 1L) == 0L) {
                    authorizedGrantTypesValue = instance.getAuthorizedGrantTypes();
                    if (authorizedGrantTypesValue != null) {
                        this.addAllAuthorizedGrantTypes(authorizedGrantTypesValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    tokenSaltValue = instance.getTokenSalt();
                    if (tokenSaltValue != null) {
                        this.tokenSalt(tokenSaltValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.clientId(instance.getClientId());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    createdWithValue = instance.getCreatedWith();
                    if (createdWithValue != null) {
                        this.createdWith(createdWithValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    redirectUriPatternsValue = instance.getRedirectUriPatterns();
                    if (redirectUriPatternsValue != null) {
                        this.addAllRedirectUriPatterns(redirectUriPatternsValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x40L) == 0L) {
                    nameValue = instance.getName();
                    if (nameValue != null) {
                        this.name(nameValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    approvalsDeletedValue = instance.getApprovalsDeleted();
                    if (approvalsDeletedValue != null) {
                        this.approvalsDeleted(approvalsDeletedValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    scopesValue = instance.getScopes();
                    if (scopesValue != null) {
                        this.addAllScopes(scopesValue);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    autoApprovesValue = instance.getAutoApproves();
                    if (autoApprovesValue != null) {
                        this.addAllAutoApproves(autoApprovesValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x20L) == 0L) {
                    authoritiesValue = instance.getAuthorities();
                    if (authoritiesValue != null) {
                        this.addAllAuthorities(authoritiesValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x400L) == 0L) {
                    allowedProvidersValue = instance.getAllowedProviders();
                    if (allowedProvidersValue != null) {
                        this.addAllAllowedProviders(allowedProvidersValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    resourceIdsValue = instance.getResourceIds();
                    if (resourceIdsValue != null) {
                        this.addAllResourceIds(resourceIdsValue);
                    }
                    bits |= 0x800L;
                }
            }
            if (object instanceof AbstractUpdateClient) {
                instance = (AbstractUpdateClient)object;
                if ((bits & 1L) == 0L) {
                    authorizedGrantTypesValue = instance.getAuthorizedGrantTypes();
                    if (authorizedGrantTypesValue != null) {
                        this.addAllAuthorizedGrantTypes(authorizedGrantTypesValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    tokenSaltValue = instance.getTokenSalt();
                    if (tokenSaltValue != null) {
                        this.tokenSalt(tokenSaltValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.clientId(instance.getClientId());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    createdWithValue = instance.getCreatedWith();
                    if (createdWithValue != null) {
                        this.createdWith(createdWithValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    redirectUriPatternsValue = instance.getRedirectUriPatterns();
                    if (redirectUriPatternsValue != null) {
                        this.addAllRedirectUriPatterns(redirectUriPatternsValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x40L) == 0L) {
                    nameValue = instance.getName();
                    if (nameValue != null) {
                        this.name(nameValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    approvalsDeletedValue = instance.getApprovalsDeleted();
                    if (approvalsDeletedValue != null) {
                        this.approvalsDeleted(approvalsDeletedValue);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    scopesValue = instance.getScopes();
                    if (scopesValue != null) {
                        this.addAllScopes(scopesValue);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    autoApprovesValue = instance.getAutoApproves();
                    if (autoApprovesValue != null) {
                        this.addAllAutoApproves(autoApprovesValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x20L) == 0L) {
                    authoritiesValue = instance.getAuthorities();
                    if (authoritiesValue != null) {
                        this.addAllAuthorities(authoritiesValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x400L) == 0L) {
                    allowedProvidersValue = instance.getAllowedProviders();
                    if (allowedProvidersValue != null) {
                        this.addAllAllowedProviders(allowedProvidersValue);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    resourceIdsValue = instance.getResourceIds();
                    if (resourceIdsValue != null) {
                        this.addAllResourceIds(resourceIdsValue);
                    }
                    bits |= 0x800L;
                }
            }
        }

        public final Builder allowedProvider(String element) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            return this;
        }

        public final Builder allowedProviders(String ... elements) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder allowedProviders(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.allowedProviders = null;
                return this;
            }
            this.allowedProviders = new ArrayList<String>();
            return this.addAllAllowedProviders(elements);
        }

        public final Builder addAllAllowedProviders(Iterable<String> elements) {
            Objects.requireNonNull(elements, "allowedProviders element");
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder approvalsDeleted(@Nullable Boolean approvalsDeleted) {
            this.approvalsDeleted = approvalsDeleted;
            return this;
        }

        public final Builder authority(String element) {
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            return this;
        }

        public final Builder authorities(String ... elements) {
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorities(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.authorities = null;
                return this;
            }
            this.authorities = new ArrayList<String>();
            return this.addAllAuthorities(elements);
        }

        public final Builder addAllAuthorities(Iterable<String> elements) {
            Objects.requireNonNull(elements, "authorities element");
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorizedGrantType(GrantType element) {
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            return this;
        }

        public final Builder authorizedGrantTypes(GrantType ... elements) {
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            for (GrantType element : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder authorizedGrantTypes(@Nullable Iterable<? extends GrantType> elements) {
            if (elements == null) {
                this.authorizedGrantTypes = null;
                return this;
            }
            this.authorizedGrantTypes = new ArrayList<GrantType>();
            return this.addAllAuthorizedGrantTypes(elements);
        }

        public final Builder addAllAuthorizedGrantTypes(Iterable<? extends GrantType> elements) {
            Objects.requireNonNull(elements, "authorizedGrantTypes element");
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            for (GrantType grantType : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(grantType, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder autoApprove(String element) {
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            return this;
        }

        public final Builder autoApproves(String ... elements) {
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder autoApproves(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.autoApproves = null;
                return this;
            }
            this.autoApproves = new ArrayList<String>();
            return this.addAllAutoApproves(elements);
        }

        public final Builder addAllAutoApproves(Iterable<String> elements) {
            Objects.requireNonNull(elements, "autoApproves element");
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder createdWith(@Nullable String createdWith) {
            this.createdWith = createdWith;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder redirectUriPattern(String element) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            return this;
        }

        public final Builder redirectUriPatterns(String ... elements) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder redirectUriPatterns(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.redirectUriPatterns = null;
                return this;
            }
            this.redirectUriPatterns = new ArrayList<String>();
            return this.addAllRedirectUriPatterns(elements);
        }

        public final Builder addAllRedirectUriPatterns(Iterable<String> elements) {
            Objects.requireNonNull(elements, "redirectUriPatterns element");
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder resourceId(String element) {
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            return this;
        }

        public final Builder resourceIds(String ... elements) {
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder resourceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.resourceIds = null;
                return this;
            }
            this.resourceIds = new ArrayList<String>();
            return this.addAllResourceIds(elements);
        }

        public final Builder addAllResourceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "resourceIds element");
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder scope(String element) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scopes(String ... elements) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder scopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.scopes = null;
                return this;
            }
            this.scopes = new ArrayList<String>();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "scopes element");
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder tokenSalt(@Nullable String tokenSalt) {
            this.tokenSalt = tokenSalt;
            return this;
        }

        public UpdateClientAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return UpdateClientAction.validate(new UpdateClientAction(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build UpdateClientAction, some of required attributes are not set " + attributes;
        }
    }
}

