/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityproviders._PasswordPolicy;
import org.immutables.value.Generated;

@Generated(from="_PasswordPolicy", generator="Immutables")
public final class PasswordPolicy
extends _PasswordPolicy {
    private final Integer maximumLength;
    private final Integer minimumDigit;
    private final Integer minimumLength;
    private final Integer minimumLowerCaseCharacter;
    private final Integer minimumSpecialCharacter;
    private final Integer minimumUpperCaseCharacter;
    private final Integer passwordExpirationInMonth;
    @Nullable
    private final Integer passwordNewerThan;

    private PasswordPolicy(Builder builder) {
        this.maximumLength = builder.maximumLength;
        this.minimumDigit = builder.minimumDigit;
        this.minimumLength = builder.minimumLength;
        this.minimumLowerCaseCharacter = builder.minimumLowerCaseCharacter;
        this.minimumSpecialCharacter = builder.minimumSpecialCharacter;
        this.minimumUpperCaseCharacter = builder.minimumUpperCaseCharacter;
        this.passwordExpirationInMonth = builder.passwordExpirationInMonth;
        this.passwordNewerThan = builder.passwordNewerThan;
    }

    @Override
    @JsonProperty(value="maxLength")
    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    @JsonProperty(value="requireDigit")
    public Integer getMinimumDigit() {
        return this.minimumDigit;
    }

    @Override
    @JsonProperty(value="minLength")
    public Integer getMinimumLength() {
        return this.minimumLength;
    }

    @Override
    @JsonProperty(value="requireLowerCaseCharacter")
    public Integer getMinimumLowerCaseCharacter() {
        return this.minimumLowerCaseCharacter;
    }

    @Override
    @JsonProperty(value="requireSpecialCharacter")
    public Integer getMinimumSpecialCharacter() {
        return this.minimumSpecialCharacter;
    }

    @Override
    @JsonProperty(value="requireUpperCaseCharacter")
    public Integer getMinimumUpperCaseCharacter() {
        return this.minimumUpperCaseCharacter;
    }

    @Override
    @JsonProperty(value="expirePasswordInMonths")
    public Integer getPasswordExpirationInMonth() {
        return this.passwordExpirationInMonth;
    }

    @Override
    @JsonProperty(value="passwordNewerThan")
    @Nullable
    public Integer getPasswordNewerThan() {
        return this.passwordNewerThan;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PasswordPolicy && this.equalTo(0, (PasswordPolicy)another);
    }

    private boolean equalTo(int synthetic, PasswordPolicy another) {
        return this.maximumLength.equals(another.maximumLength) && this.minimumDigit.equals(another.minimumDigit) && this.minimumLength.equals(another.minimumLength) && this.minimumLowerCaseCharacter.equals(another.minimumLowerCaseCharacter) && this.minimumSpecialCharacter.equals(another.minimumSpecialCharacter) && this.minimumUpperCaseCharacter.equals(another.minimumUpperCaseCharacter) && this.passwordExpirationInMonth.equals(another.passwordExpirationInMonth) && Objects.equals(this.passwordNewerThan, another.passwordNewerThan);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.maximumLength.hashCode();
        h += (h << 5) + this.minimumDigit.hashCode();
        h += (h << 5) + this.minimumLength.hashCode();
        h += (h << 5) + this.minimumLowerCaseCharacter.hashCode();
        h += (h << 5) + this.minimumSpecialCharacter.hashCode();
        h += (h << 5) + this.minimumUpperCaseCharacter.hashCode();
        h += (h << 5) + this.passwordExpirationInMonth.hashCode();
        h += (h << 5) + Objects.hashCode(this.passwordNewerThan);
        return h;
    }

    public String toString() {
        return "PasswordPolicy{maximumLength=" + this.maximumLength + ", minimumDigit=" + this.minimumDigit + ", minimumLength=" + this.minimumLength + ", minimumLowerCaseCharacter=" + this.minimumLowerCaseCharacter + ", minimumSpecialCharacter=" + this.minimumSpecialCharacter + ", minimumUpperCaseCharacter=" + this.minimumUpperCaseCharacter + ", passwordExpirationInMonth=" + this.passwordExpirationInMonth + ", passwordNewerThan=" + this.passwordNewerThan + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static PasswordPolicy fromJson(Json json) {
        Builder builder = PasswordPolicy.builder();
        if (json.maximumLength != null) {
            builder.maximumLength(json.maximumLength);
        }
        if (json.minimumDigit != null) {
            builder.minimumDigit(json.minimumDigit);
        }
        if (json.minimumLength != null) {
            builder.minimumLength(json.minimumLength);
        }
        if (json.minimumLowerCaseCharacter != null) {
            builder.minimumLowerCaseCharacter(json.minimumLowerCaseCharacter);
        }
        if (json.minimumSpecialCharacter != null) {
            builder.minimumSpecialCharacter(json.minimumSpecialCharacter);
        }
        if (json.minimumUpperCaseCharacter != null) {
            builder.minimumUpperCaseCharacter(json.minimumUpperCaseCharacter);
        }
        if (json.passwordExpirationInMonth != null) {
            builder.passwordExpirationInMonth(json.passwordExpirationInMonth);
        }
        if (json.passwordNewerThan != null) {
            builder.passwordNewerThan(json.passwordNewerThan);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_PasswordPolicy", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MAXIMUM_LENGTH = 1L;
        private static final long INIT_BIT_MINIMUM_DIGIT = 2L;
        private static final long INIT_BIT_MINIMUM_LENGTH = 4L;
        private static final long INIT_BIT_MINIMUM_LOWER_CASE_CHARACTER = 8L;
        private static final long INIT_BIT_MINIMUM_SPECIAL_CHARACTER = 16L;
        private static final long INIT_BIT_MINIMUM_UPPER_CASE_CHARACTER = 32L;
        private static final long INIT_BIT_PASSWORD_EXPIRATION_IN_MONTH = 64L;
        private long initBits = 127L;
        private Integer maximumLength;
        private Integer minimumDigit;
        private Integer minimumLength;
        private Integer minimumLowerCaseCharacter;
        private Integer minimumSpecialCharacter;
        private Integer minimumUpperCaseCharacter;
        private Integer passwordExpirationInMonth;
        private Integer passwordNewerThan;

        private Builder() {
        }

        public final Builder from(PasswordPolicy instance) {
            return this.from((_PasswordPolicy)instance);
        }

        final Builder from(_PasswordPolicy instance) {
            Objects.requireNonNull(instance, "instance");
            this.maximumLength(instance.getMaximumLength());
            this.minimumDigit(instance.getMinimumDigit());
            this.minimumLength(instance.getMinimumLength());
            this.minimumLowerCaseCharacter(instance.getMinimumLowerCaseCharacter());
            this.minimumSpecialCharacter(instance.getMinimumSpecialCharacter());
            this.minimumUpperCaseCharacter(instance.getMinimumUpperCaseCharacter());
            this.passwordExpirationInMonth(instance.getPasswordExpirationInMonth());
            Integer passwordNewerThanValue = instance.getPasswordNewerThan();
            if (passwordNewerThanValue != null) {
                this.passwordNewerThan(passwordNewerThanValue);
            }
            return this;
        }

        @JsonProperty(value="maxLength")
        public final Builder maximumLength(Integer maximumLength) {
            this.maximumLength = Objects.requireNonNull(maximumLength, "maximumLength");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="requireDigit")
        public final Builder minimumDigit(Integer minimumDigit) {
            this.minimumDigit = Objects.requireNonNull(minimumDigit, "minimumDigit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="minLength")
        public final Builder minimumLength(Integer minimumLength) {
            this.minimumLength = Objects.requireNonNull(minimumLength, "minimumLength");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="requireLowerCaseCharacter")
        public final Builder minimumLowerCaseCharacter(Integer minimumLowerCaseCharacter) {
            this.minimumLowerCaseCharacter = Objects.requireNonNull(minimumLowerCaseCharacter, "minimumLowerCaseCharacter");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="requireSpecialCharacter")
        public final Builder minimumSpecialCharacter(Integer minimumSpecialCharacter) {
            this.minimumSpecialCharacter = Objects.requireNonNull(minimumSpecialCharacter, "minimumSpecialCharacter");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="requireUpperCaseCharacter")
        public final Builder minimumUpperCaseCharacter(Integer minimumUpperCaseCharacter) {
            this.minimumUpperCaseCharacter = Objects.requireNonNull(minimumUpperCaseCharacter, "minimumUpperCaseCharacter");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="expirePasswordInMonths")
        public final Builder passwordExpirationInMonth(Integer passwordExpirationInMonth) {
            this.passwordExpirationInMonth = Objects.requireNonNull(passwordExpirationInMonth, "passwordExpirationInMonth");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="passwordNewerThan")
        public final Builder passwordNewerThan(@Nullable Integer passwordNewerThan) {
            this.passwordNewerThan = passwordNewerThan;
            return this;
        }

        public PasswordPolicy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PasswordPolicy(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maximumLength");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minimumDigit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("minimumLength");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("minimumLowerCaseCharacter");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("minimumSpecialCharacter");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("minimumUpperCaseCharacter");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("passwordExpirationInMonth");
            }
            return "Cannot build PasswordPolicy, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_PasswordPolicy", generator="Immutables")
    static final class Json
    extends _PasswordPolicy {
        Integer maximumLength;
        Integer minimumDigit;
        Integer minimumLength;
        Integer minimumLowerCaseCharacter;
        Integer minimumSpecialCharacter;
        Integer minimumUpperCaseCharacter;
        Integer passwordExpirationInMonth;
        Integer passwordNewerThan;

        Json() {
        }

        @JsonProperty(value="maxLength")
        public void setMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
        }

        @JsonProperty(value="requireDigit")
        public void setMinimumDigit(Integer minimumDigit) {
            this.minimumDigit = minimumDigit;
        }

        @JsonProperty(value="minLength")
        public void setMinimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
        }

        @JsonProperty(value="requireLowerCaseCharacter")
        public void setMinimumLowerCaseCharacter(Integer minimumLowerCaseCharacter) {
            this.minimumLowerCaseCharacter = minimumLowerCaseCharacter;
        }

        @JsonProperty(value="requireSpecialCharacter")
        public void setMinimumSpecialCharacter(Integer minimumSpecialCharacter) {
            this.minimumSpecialCharacter = minimumSpecialCharacter;
        }

        @JsonProperty(value="requireUpperCaseCharacter")
        public void setMinimumUpperCaseCharacter(Integer minimumUpperCaseCharacter) {
            this.minimumUpperCaseCharacter = minimumUpperCaseCharacter;
        }

        @JsonProperty(value="expirePasswordInMonths")
        public void setPasswordExpirationInMonth(Integer passwordExpirationInMonth) {
            this.passwordExpirationInMonth = passwordExpirationInMonth;
        }

        @JsonProperty(value="passwordNewerThan")
        public void setPasswordNewerThan(@Nullable Integer passwordNewerThan) {
            this.passwordNewerThan = passwordNewerThan;
        }

        @Override
        public Integer getMaximumLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMinimumDigit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMinimumLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMinimumLowerCaseCharacter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMinimumSpecialCharacter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMinimumUpperCaseCharacter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPasswordExpirationInMonth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPasswordNewerThan() {
            throw new UnsupportedOperationException();
        }
    }
}

