package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for the Application resource
 */
@Generated(from = "_ApplicationEntity", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplicationEntity extends org.cloudfoundry.client.v2.applications._ApplicationEntity {
  private final @Nullable String buildpack;
  private final @Nullable String command;
  private final @Nullable Boolean console;
  private final @Nullable String debug;
  private final @Nullable String detectedStartCommand;
  private final @Nullable Boolean diego;
  private final @Nullable Integer diskQuota;
  private final @Nullable DockerCredentials dockerCredentials;
  private final @Nullable String dockerImage;
  private final @Nullable Map<String, Object> environmentJsons;
  private final @Nullable String healthCheckHttpEndpoint;
  private final @Nullable Integer healthCheckTimeout;
  private final @Nullable String healthCheckType;
  private final @Nullable Integer instances;
  private final @Nullable Integer memory;
  private final @Nullable String name;
  private final @Nullable Boolean production;
  private final @Nullable String spaceId;
  private final @Nullable String stackId;
  private final @Nullable String stagingFailedDescription;
  private final @Nullable String stagingFailedReason;
  private final @Nullable String stagingTaskId;
  private final @Nullable String state;
  private final @Nullable String detectedBuildpack;
  private final @Nullable String detectedBuildpackId;
  private final @Nullable Boolean enableSsh;
  private final @Nullable String eventsUrl;
  private final @Nullable String packageState;
  private final @Nullable String packageUpdatedAt;
  private final @Nullable List<Integer> ports;
  private final @Nullable String routeMappingsUrl;
  private final @Nullable String routesUrl;
  private final @Nullable String serviceBindingsUrl;
  private final @Nullable String spaceUrl;
  private final @Nullable String stackUrl;
  private final @Nullable String version;
  private final @Nullable Integer logRateLimit;

  private ApplicationEntity(ApplicationEntity.Builder builder) {
    this.buildpack = builder.buildpack;
    this.command = builder.command;
    this.console = builder.console;
    this.debug = builder.debug;
    this.detectedStartCommand = builder.detectedStartCommand;
    this.diego = builder.diego;
    this.diskQuota = builder.diskQuota;
    this.dockerCredentials = builder.dockerCredentials;
    this.dockerImage = builder.dockerImage;
    this.environmentJsons = builder.environmentJsons == null ? null : createUnmodifiableMap(false, false, builder.environmentJsons);
    this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
    this.healthCheckTimeout = builder.healthCheckTimeout;
    this.healthCheckType = builder.healthCheckType;
    this.instances = builder.instances;
    this.memory = builder.memory;
    this.name = builder.name;
    this.production = builder.production;
    this.spaceId = builder.spaceId;
    this.stackId = builder.stackId;
    this.stagingFailedDescription = builder.stagingFailedDescription;
    this.stagingFailedReason = builder.stagingFailedReason;
    this.stagingTaskId = builder.stagingTaskId;
    this.state = builder.state;
    this.detectedBuildpack = builder.detectedBuildpack;
    this.detectedBuildpackId = builder.detectedBuildpackId;
    this.enableSsh = builder.enableSsh;
    this.eventsUrl = builder.eventsUrl;
    this.packageState = builder.packageState;
    this.packageUpdatedAt = builder.packageUpdatedAt;
    this.ports = builder.ports == null ? null : createUnmodifiableList(true, builder.ports);
    this.routeMappingsUrl = builder.routeMappingsUrl;
    this.routesUrl = builder.routesUrl;
    this.serviceBindingsUrl = builder.serviceBindingsUrl;
    this.spaceUrl = builder.spaceUrl;
    this.stackUrl = builder.stackUrl;
    this.version = builder.version;
    this.logRateLimit = builder.logRateLimit;
  }

  /**
   * The buildpack
   */
  @JsonProperty("buildpack")
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * The command
   */
  @JsonProperty("command")
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The console
   */
  @JsonProperty("console")
  @Deprecated
  @Override
  public @Nullable Boolean getConsole() {
    return console;
  }

  /**
   * Debug
   */
  @JsonProperty("debug")
  @Deprecated
  @Override
  public @Nullable String getDebug() {
    return debug;
  }

  /**
   * The detected start command
   */
  @JsonProperty("detected_start_command")
  @Override
  public @Nullable String getDetectedStartCommand() {
    return detectedStartCommand;
  }

  /**
   * Diego
   */
  @JsonProperty("diego")
  @Override
  public @Nullable Boolean getDiego() {
    return diego;
  }

  /**
   * The disk quota in megabytes
   */
  @JsonProperty("disk_quota")
  @Override
  public @Nullable Integer getDiskQuota() {
    return diskQuota;
  }

  /**
   * The docker credentials
   */
  @JsonProperty("docker_credentials")
  @Override
  public @Nullable DockerCredentials getDockerCredentials() {
    return dockerCredentials;
  }

  /**
   * The docker image
   */
  @JsonProperty("docker_image")
  @Override
  public @Nullable String getDockerImage() {
    return dockerImage;
  }

  /**
   * The environment JSONs
   */
  @JsonProperty("environment_json")
  @Override
  public @Nullable Map<String, Object> getEnvironmentJsons() {
    return environmentJsons;
  }

  /**
   * The health check HTTP endpoint
   */
  @JsonProperty("health_check_http_endpoint")
  @Override
  public @Nullable String getHealthCheckHttpEndpoint() {
    return healthCheckHttpEndpoint;
  }

  /**
   * The health check timeout
   */
  @JsonProperty("health_check_timeout")
  @Override
  public @Nullable Integer getHealthCheckTimeout() {
    return healthCheckTimeout;
  }

  /**
   * The health check type
   */
  @JsonProperty("health_check_type")
  @Override
  public @Nullable String getHealthCheckType() {
    return healthCheckType;
  }

  /**
   * The instances
   */
  @JsonProperty("instances")
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory in megabytes
   */
  @JsonProperty("memory")
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Production
   */
  @JsonProperty("production")
  @Deprecated
  @Override
  public @Nullable Boolean getProduction() {
    return production;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The stack id
   */
  @JsonProperty("stack_guid")
  @Override
  public @Nullable String getStackId() {
    return stackId;
  }

  /**
   * The staging failed description
   */
  @JsonProperty("staging_failed_description")
  @Override
  public @Nullable String getStagingFailedDescription() {
    return stagingFailedDescription;
  }

  /**
   * The staging failed reason
   */
  @JsonProperty("staging_failed_reason")
  @Override
  public @Nullable String getStagingFailedReason() {
    return stagingFailedReason;
  }

  /**
   * The staging task id
   */
  @JsonProperty("staging_task_id")
  @Override
  public @Nullable String getStagingTaskId() {
    return stagingTaskId;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * The detected buildpack
   */
  @JsonProperty("detected_buildpack")
  @Override
  public @Nullable String getDetectedBuildpack() {
    return detectedBuildpack;
  }

  /**
   * The detected buildpack id
   */
  @JsonProperty("detected_buildpack_guid")
  @Override
  public @Nullable String getDetectedBuildpackId() {
    return detectedBuildpackId;
  }

  /**
   * Whether SSH is enabled
   */
  @JsonProperty("enable_ssh")
  @Override
  public @Nullable Boolean getEnableSsh() {
    return enableSsh;
  }

  /**
   * The events url
   */
  @JsonProperty("events_url")
  @Override
  public @Nullable String getEventsUrl() {
    return eventsUrl;
  }

  /**
   * The package state
   */
  @JsonProperty("package_state")
  @Override
  public @Nullable String getPackageState() {
    return packageState;
  }

  /**
   * When the package was update
   */
  @JsonProperty("package_updated_at")
  @Override
  public @Nullable String getPackageUpdatedAt() {
    return packageUpdatedAt;
  }

  /**
   * The ports
   */
  @JsonProperty("ports")
  @Override
  public @Nullable List<Integer> getPorts() {
    return ports;
  }

  /**
   * The route mappings url
   */
  @JsonProperty("route_mappings_url")
  @Override
  public @Nullable String getRouteMappingsUrl() {
    return routeMappingsUrl;
  }

  /**
   * The routes url
   */
  @JsonProperty("routes_url")
  @Override
  public @Nullable String getRoutesUrl() {
    return routesUrl;
  }

  /**
   * The service bindings url
   */
  @JsonProperty("service_bindings_url")
  @Override
  public @Nullable String getServiceBindingsUrl() {
    return serviceBindingsUrl;
  }

  /**
   * The space url
   */
  @JsonProperty("space_url")
  @Override
  public @Nullable String getSpaceUrl() {
    return spaceUrl;
  }

  /**
   * The stack url
   */
  @JsonProperty("stack_url")
  @Override
  public @Nullable String getStackUrl() {
    return stackUrl;
  }

  /**
   * The version
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * The log rate limit
   */
  @JsonProperty("log_rate_limit")
  @Override
  public @Nullable Integer getLogRateLimit() {
    return logRateLimit;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationEntity
        && equalTo(0, (ApplicationEntity) another);
  }

  private boolean equalTo(int synthetic, ApplicationEntity another) {
    return Objects.equals(buildpack, another.buildpack)
        && Objects.equals(command, another.command)
        && Objects.equals(console, another.console)
        && Objects.equals(debug, another.debug)
        && Objects.equals(detectedStartCommand, another.detectedStartCommand)
        && Objects.equals(diego, another.diego)
        && Objects.equals(diskQuota, another.diskQuota)
        && Objects.equals(dockerCredentials, another.dockerCredentials)
        && Objects.equals(dockerImage, another.dockerImage)
        && Objects.equals(environmentJsons, another.environmentJsons)
        && Objects.equals(healthCheckHttpEndpoint, another.healthCheckHttpEndpoint)
        && Objects.equals(healthCheckTimeout, another.healthCheckTimeout)
        && Objects.equals(healthCheckType, another.healthCheckType)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memory, another.memory)
        && Objects.equals(name, another.name)
        && Objects.equals(production, another.production)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(stackId, another.stackId)
        && Objects.equals(stagingFailedDescription, another.stagingFailedDescription)
        && Objects.equals(stagingFailedReason, another.stagingFailedReason)
        && Objects.equals(stagingTaskId, another.stagingTaskId)
        && Objects.equals(state, another.state)
        && Objects.equals(detectedBuildpack, another.detectedBuildpack)
        && Objects.equals(detectedBuildpackId, another.detectedBuildpackId)
        && Objects.equals(enableSsh, another.enableSsh)
        && Objects.equals(eventsUrl, another.eventsUrl)
        && Objects.equals(packageState, another.packageState)
        && Objects.equals(packageUpdatedAt, another.packageUpdatedAt)
        && Objects.equals(ports, another.ports)
        && Objects.equals(routeMappingsUrl, another.routeMappingsUrl)
        && Objects.equals(routesUrl, another.routesUrl)
        && Objects.equals(serviceBindingsUrl, another.serviceBindingsUrl)
        && Objects.equals(spaceUrl, another.spaceUrl)
        && Objects.equals(stackUrl, another.stackUrl)
        && Objects.equals(version, another.version)
        && Objects.equals(logRateLimit, another.logRateLimit);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code command}, {@code console}, {@code debug}, {@code detectedStartCommand}, {@code diego}, {@code diskQuota}, {@code dockerCredentials}, {@code dockerImage}, {@code environmentJsons}, {@code healthCheckHttpEndpoint}, {@code healthCheckTimeout}, {@code healthCheckType}, {@code instances}, {@code memory}, {@code name}, {@code production}, {@code spaceId}, {@code stackId}, {@code stagingFailedDescription}, {@code stagingFailedReason}, {@code stagingTaskId}, {@code state}, {@code detectedBuildpack}, {@code detectedBuildpackId}, {@code enableSsh}, {@code eventsUrl}, {@code packageState}, {@code packageUpdatedAt}, {@code ports}, {@code routeMappingsUrl}, {@code routesUrl}, {@code serviceBindingsUrl}, {@code spaceUrl}, {@code stackUrl}, {@code version}, {@code logRateLimit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpack);
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(console);
    h += (h << 5) + Objects.hashCode(debug);
    h += (h << 5) + Objects.hashCode(detectedStartCommand);
    h += (h << 5) + Objects.hashCode(diego);
    h += (h << 5) + Objects.hashCode(diskQuota);
    h += (h << 5) + Objects.hashCode(dockerCredentials);
    h += (h << 5) + Objects.hashCode(dockerImage);
    h += (h << 5) + Objects.hashCode(environmentJsons);
    h += (h << 5) + Objects.hashCode(healthCheckHttpEndpoint);
    h += (h << 5) + Objects.hashCode(healthCheckTimeout);
    h += (h << 5) + Objects.hashCode(healthCheckType);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(production);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(stackId);
    h += (h << 5) + Objects.hashCode(stagingFailedDescription);
    h += (h << 5) + Objects.hashCode(stagingFailedReason);
    h += (h << 5) + Objects.hashCode(stagingTaskId);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(detectedBuildpack);
    h += (h << 5) + Objects.hashCode(detectedBuildpackId);
    h += (h << 5) + Objects.hashCode(enableSsh);
    h += (h << 5) + Objects.hashCode(eventsUrl);
    h += (h << 5) + Objects.hashCode(packageState);
    h += (h << 5) + Objects.hashCode(packageUpdatedAt);
    h += (h << 5) + Objects.hashCode(ports);
    h += (h << 5) + Objects.hashCode(routeMappingsUrl);
    h += (h << 5) + Objects.hashCode(routesUrl);
    h += (h << 5) + Objects.hashCode(serviceBindingsUrl);
    h += (h << 5) + Objects.hashCode(spaceUrl);
    h += (h << 5) + Objects.hashCode(stackUrl);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(logRateLimit);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationEntity{"
        + "buildpack=" + buildpack
        + ", command=" + command
        + ", console=" + console
        + ", debug=" + debug
        + ", detectedStartCommand=" + detectedStartCommand
        + ", diego=" + diego
        + ", diskQuota=" + diskQuota
        + ", dockerCredentials=" + dockerCredentials
        + ", dockerImage=" + dockerImage
        + ", environmentJsons=" + environmentJsons
        + ", healthCheckHttpEndpoint=" + healthCheckHttpEndpoint
        + ", healthCheckTimeout=" + healthCheckTimeout
        + ", healthCheckType=" + healthCheckType
        + ", instances=" + instances
        + ", memory=" + memory
        + ", name=" + name
        + ", production=" + production
        + ", spaceId=" + spaceId
        + ", stackId=" + stackId
        + ", stagingFailedDescription=" + stagingFailedDescription
        + ", stagingFailedReason=" + stagingFailedReason
        + ", stagingTaskId=" + stagingTaskId
        + ", state=" + state
        + ", detectedBuildpack=" + detectedBuildpack
        + ", detectedBuildpackId=" + detectedBuildpackId
        + ", enableSsh=" + enableSsh
        + ", eventsUrl=" + eventsUrl
        + ", packageState=" + packageState
        + ", packageUpdatedAt=" + packageUpdatedAt
        + ", ports=" + ports
        + ", routeMappingsUrl=" + routeMappingsUrl
        + ", routesUrl=" + routesUrl
        + ", serviceBindingsUrl=" + serviceBindingsUrl
        + ", spaceUrl=" + spaceUrl
        + ", stackUrl=" + stackUrl
        + ", version=" + version
        + ", logRateLimit=" + logRateLimit
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ApplicationEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._ApplicationEntity {
    String buildpack;
    String command;
    Boolean console;
    String debug;
    String detectedStartCommand;
    Boolean diego;
    Integer diskQuota;
    DockerCredentials dockerCredentials;
    String dockerImage;
    Map<String, Object> environmentJsons = null;
    String healthCheckHttpEndpoint;
    Integer healthCheckTimeout;
    String healthCheckType;
    Integer instances;
    Integer memory;
    String name;
    Boolean production;
    String spaceId;
    String stackId;
    String stagingFailedDescription;
    String stagingFailedReason;
    String stagingTaskId;
    String state;
    String detectedBuildpack;
    String detectedBuildpackId;
    Boolean enableSsh;
    String eventsUrl;
    String packageState;
    String packageUpdatedAt;
    List<Integer> ports = null;
    String routeMappingsUrl;
    String routesUrl;
    String serviceBindingsUrl;
    String spaceUrl;
    String stackUrl;
    String version;
    Integer logRateLimit;
    @JsonProperty("buildpack")
    public void setBuildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
    }
    @JsonProperty("command")
    public void setCommand(@Nullable String command) {
      this.command = command;
    }
    @JsonProperty("console")
    public void setConsole(@Nullable Boolean console) {
      this.console = console;
    }
    @JsonProperty("debug")
    public void setDebug(@Nullable String debug) {
      this.debug = debug;
    }
    @JsonProperty("detected_start_command")
    public void setDetectedStartCommand(@Nullable String detectedStartCommand) {
      this.detectedStartCommand = detectedStartCommand;
    }
    @JsonProperty("diego")
    public void setDiego(@Nullable Boolean diego) {
      this.diego = diego;
    }
    @JsonProperty("disk_quota")
    public void setDiskQuota(@Nullable Integer diskQuota) {
      this.diskQuota = diskQuota;
    }
    @JsonProperty("docker_credentials")
    public void setDockerCredentials(@Nullable DockerCredentials dockerCredentials) {
      this.dockerCredentials = dockerCredentials;
    }
    @JsonProperty("docker_image")
    public void setDockerImage(@Nullable String dockerImage) {
      this.dockerImage = dockerImage;
    }
    @JsonProperty("environment_json")
    public void setEnvironmentJsons(@Nullable Map<String, Object> environmentJsons) {
      this.environmentJsons = environmentJsons;
    }
    @JsonProperty("health_check_http_endpoint")
    public void setHealthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
    }
    @JsonProperty("health_check_timeout")
    public void setHealthCheckTimeout(@Nullable Integer healthCheckTimeout) {
      this.healthCheckTimeout = healthCheckTimeout;
    }
    @JsonProperty("health_check_type")
    public void setHealthCheckType(@Nullable String healthCheckType) {
      this.healthCheckType = healthCheckType;
    }
    @JsonProperty("instances")
    public void setInstances(@Nullable Integer instances) {
      this.instances = instances;
    }
    @JsonProperty("memory")
    public void setMemory(@Nullable Integer memory) {
      this.memory = memory;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("production")
    public void setProduction(@Nullable Boolean production) {
      this.production = production;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("stack_guid")
    public void setStackId(@Nullable String stackId) {
      this.stackId = stackId;
    }
    @JsonProperty("staging_failed_description")
    public void setStagingFailedDescription(@Nullable String stagingFailedDescription) {
      this.stagingFailedDescription = stagingFailedDescription;
    }
    @JsonProperty("staging_failed_reason")
    public void setStagingFailedReason(@Nullable String stagingFailedReason) {
      this.stagingFailedReason = stagingFailedReason;
    }
    @JsonProperty("staging_task_id")
    public void setStagingTaskId(@Nullable String stagingTaskId) {
      this.stagingTaskId = stagingTaskId;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("detected_buildpack")
    public void setDetectedBuildpack(@Nullable String detectedBuildpack) {
      this.detectedBuildpack = detectedBuildpack;
    }
    @JsonProperty("detected_buildpack_guid")
    public void setDetectedBuildpackId(@Nullable String detectedBuildpackId) {
      this.detectedBuildpackId = detectedBuildpackId;
    }
    @JsonProperty("enable_ssh")
    public void setEnableSsh(@Nullable Boolean enableSsh) {
      this.enableSsh = enableSsh;
    }
    @JsonProperty("events_url")
    public void setEventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
    }
    @JsonProperty("package_state")
    public void setPackageState(@Nullable String packageState) {
      this.packageState = packageState;
    }
    @JsonProperty("package_updated_at")
    public void setPackageUpdatedAt(@Nullable String packageUpdatedAt) {
      this.packageUpdatedAt = packageUpdatedAt;
    }
    @JsonProperty("ports")
    public void setPorts(@Nullable List<Integer> ports) {
      this.ports = ports;
    }
    @JsonProperty("route_mappings_url")
    public void setRouteMappingsUrl(@Nullable String routeMappingsUrl) {
      this.routeMappingsUrl = routeMappingsUrl;
    }
    @JsonProperty("routes_url")
    public void setRoutesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
    }
    @JsonProperty("service_bindings_url")
    public void setServiceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
    }
    @JsonProperty("space_url")
    public void setSpaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
    }
    @JsonProperty("stack_url")
    public void setStackUrl(@Nullable String stackUrl) {
      this.stackUrl = stackUrl;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @JsonProperty("log_rate_limit")
    public void setLogRateLimit(@Nullable Integer logRateLimit) {
      this.logRateLimit = logRateLimit;
    }
    @Override
    public String getBuildpack() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getConsole() { throw new UnsupportedOperationException(); }
    @Override
    public String getDebug() { throw new UnsupportedOperationException(); }
    @Override
    public String getDetectedStartCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDiego() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskQuota() { throw new UnsupportedOperationException(); }
    @Override
    public DockerCredentials getDockerCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getDockerImage() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getEnvironmentJsons() { throw new UnsupportedOperationException(); }
    @Override
    public String getHealthCheckHttpEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getHealthCheckTimeout() { throw new UnsupportedOperationException(); }
    @Override
    public String getHealthCheckType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemory() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getProduction() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getStackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getStagingFailedDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getStagingFailedReason() { throw new UnsupportedOperationException(); }
    @Override
    public String getStagingTaskId() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getDetectedBuildpack() { throw new UnsupportedOperationException(); }
    @Override
    public String getDetectedBuildpackId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEnableSsh() { throw new UnsupportedOperationException(); }
    @Override
    public String getEventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getPackageState() { throw new UnsupportedOperationException(); }
    @Override
    public String getPackageUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public List<Integer> getPorts() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteMappingsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBindingsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getStackUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLogRateLimit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationEntity fromJson(Json json) {
    ApplicationEntity.Builder builder = ApplicationEntity.builder();
    if (json.buildpack != null) {
      builder.buildpack(json.buildpack);
    }
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.console != null) {
      builder.console(json.console);
    }
    if (json.debug != null) {
      builder.debug(json.debug);
    }
    if (json.detectedStartCommand != null) {
      builder.detectedStartCommand(json.detectedStartCommand);
    }
    if (json.diego != null) {
      builder.diego(json.diego);
    }
    if (json.diskQuota != null) {
      builder.diskQuota(json.diskQuota);
    }
    if (json.dockerCredentials != null) {
      builder.dockerCredentials(json.dockerCredentials);
    }
    if (json.dockerImage != null) {
      builder.dockerImage(json.dockerImage);
    }
    if (json.environmentJsons != null) {
      builder.putAllEnvironmentJsons(json.environmentJsons);
    }
    if (json.healthCheckHttpEndpoint != null) {
      builder.healthCheckHttpEndpoint(json.healthCheckHttpEndpoint);
    }
    if (json.healthCheckTimeout != null) {
      builder.healthCheckTimeout(json.healthCheckTimeout);
    }
    if (json.healthCheckType != null) {
      builder.healthCheckType(json.healthCheckType);
    }
    if (json.instances != null) {
      builder.instances(json.instances);
    }
    if (json.memory != null) {
      builder.memory(json.memory);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.production != null) {
      builder.production(json.production);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.stackId != null) {
      builder.stackId(json.stackId);
    }
    if (json.stagingFailedDescription != null) {
      builder.stagingFailedDescription(json.stagingFailedDescription);
    }
    if (json.stagingFailedReason != null) {
      builder.stagingFailedReason(json.stagingFailedReason);
    }
    if (json.stagingTaskId != null) {
      builder.stagingTaskId(json.stagingTaskId);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.detectedBuildpack != null) {
      builder.detectedBuildpack(json.detectedBuildpack);
    }
    if (json.detectedBuildpackId != null) {
      builder.detectedBuildpackId(json.detectedBuildpackId);
    }
    if (json.enableSsh != null) {
      builder.enableSsh(json.enableSsh);
    }
    if (json.eventsUrl != null) {
      builder.eventsUrl(json.eventsUrl);
    }
    if (json.packageState != null) {
      builder.packageState(json.packageState);
    }
    if (json.packageUpdatedAt != null) {
      builder.packageUpdatedAt(json.packageUpdatedAt);
    }
    if (json.ports != null) {
      builder.addAllPorts(json.ports);
    }
    if (json.routeMappingsUrl != null) {
      builder.routeMappingsUrl(json.routeMappingsUrl);
    }
    if (json.routesUrl != null) {
      builder.routesUrl(json.routesUrl);
    }
    if (json.serviceBindingsUrl != null) {
      builder.serviceBindingsUrl(json.serviceBindingsUrl);
    }
    if (json.spaceUrl != null) {
      builder.spaceUrl(json.spaceUrl);
    }
    if (json.stackUrl != null) {
      builder.stackUrl(json.stackUrl);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.logRateLimit != null) {
      builder.logRateLimit(json.logRateLimit);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationEntity ApplicationEntity}.
   * <pre>
   * ApplicationEntity.builder()
   *    .buildpack(String | null) // nullable {@link ApplicationEntity#getBuildpack() buildpack}
   *    .command(String | null) // nullable {@link ApplicationEntity#getCommand() command}
   *    .console(Boolean | null) // nullable {@link ApplicationEntity#getConsole() console}
   *    .debug(String | null) // nullable {@link ApplicationEntity#getDebug() debug}
   *    .detectedStartCommand(String | null) // nullable {@link ApplicationEntity#getDetectedStartCommand() detectedStartCommand}
   *    .diego(Boolean | null) // nullable {@link ApplicationEntity#getDiego() diego}
   *    .diskQuota(Integer | null) // nullable {@link ApplicationEntity#getDiskQuota() diskQuota}
   *    .dockerCredentials(org.cloudfoundry.client.v2.applications.DockerCredentials | null) // nullable {@link ApplicationEntity#getDockerCredentials() dockerCredentials}
   *    .dockerImage(String | null) // nullable {@link ApplicationEntity#getDockerImage() dockerImage}
   *    .environmentJsons(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link ApplicationEntity#getEnvironmentJsons() environmentJsons}
   *    .healthCheckHttpEndpoint(String | null) // nullable {@link ApplicationEntity#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint}
   *    .healthCheckTimeout(Integer | null) // nullable {@link ApplicationEntity#getHealthCheckTimeout() healthCheckTimeout}
   *    .healthCheckType(String | null) // nullable {@link ApplicationEntity#getHealthCheckType() healthCheckType}
   *    .instances(Integer | null) // nullable {@link ApplicationEntity#getInstances() instances}
   *    .memory(Integer | null) // nullable {@link ApplicationEntity#getMemory() memory}
   *    .name(String | null) // nullable {@link ApplicationEntity#getName() name}
   *    .production(Boolean | null) // nullable {@link ApplicationEntity#getProduction() production}
   *    .spaceId(String | null) // nullable {@link ApplicationEntity#getSpaceId() spaceId}
   *    .stackId(String | null) // nullable {@link ApplicationEntity#getStackId() stackId}
   *    .stagingFailedDescription(String | null) // nullable {@link ApplicationEntity#getStagingFailedDescription() stagingFailedDescription}
   *    .stagingFailedReason(String | null) // nullable {@link ApplicationEntity#getStagingFailedReason() stagingFailedReason}
   *    .stagingTaskId(String | null) // nullable {@link ApplicationEntity#getStagingTaskId() stagingTaskId}
   *    .state(String | null) // nullable {@link ApplicationEntity#getState() state}
   *    .detectedBuildpack(String | null) // nullable {@link ApplicationEntity#getDetectedBuildpack() detectedBuildpack}
   *    .detectedBuildpackId(String | null) // nullable {@link ApplicationEntity#getDetectedBuildpackId() detectedBuildpackId}
   *    .enableSsh(Boolean | null) // nullable {@link ApplicationEntity#getEnableSsh() enableSsh}
   *    .eventsUrl(String | null) // nullable {@link ApplicationEntity#getEventsUrl() eventsUrl}
   *    .packageState(String | null) // nullable {@link ApplicationEntity#getPackageState() packageState}
   *    .packageUpdatedAt(String | null) // nullable {@link ApplicationEntity#getPackageUpdatedAt() packageUpdatedAt}
   *    .ports(List&amp;lt;Integer&amp;gt; | null) // nullable {@link ApplicationEntity#getPorts() ports}
   *    .routeMappingsUrl(String | null) // nullable {@link ApplicationEntity#getRouteMappingsUrl() routeMappingsUrl}
   *    .routesUrl(String | null) // nullable {@link ApplicationEntity#getRoutesUrl() routesUrl}
   *    .serviceBindingsUrl(String | null) // nullable {@link ApplicationEntity#getServiceBindingsUrl() serviceBindingsUrl}
   *    .spaceUrl(String | null) // nullable {@link ApplicationEntity#getSpaceUrl() spaceUrl}
   *    .stackUrl(String | null) // nullable {@link ApplicationEntity#getStackUrl() stackUrl}
   *    .version(String | null) // nullable {@link ApplicationEntity#getVersion() version}
   *    .logRateLimit(Integer | null) // nullable {@link ApplicationEntity#getLogRateLimit() logRateLimit}
   *    .build();
   * </pre>
   * @return A new ApplicationEntity builder
   */
  public static ApplicationEntity.Builder builder() {
    return new ApplicationEntity.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationEntity ApplicationEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplicationEntity", generator = "Immutables")
  public static final class Builder {
    private String buildpack;
    private String command;
    private Boolean console;
    private String debug;
    private String detectedStartCommand;
    private Boolean diego;
    private Integer diskQuota;
    private DockerCredentials dockerCredentials;
    private String dockerImage;
    private Map<String, Object> environmentJsons = null;
    private String healthCheckHttpEndpoint;
    private Integer healthCheckTimeout;
    private String healthCheckType;
    private Integer instances;
    private Integer memory;
    private String name;
    private Boolean production;
    private String spaceId;
    private String stackId;
    private String stagingFailedDescription;
    private String stagingFailedReason;
    private String stagingTaskId;
    private String state;
    private String detectedBuildpack;
    private String detectedBuildpackId;
    private Boolean enableSsh;
    private String eventsUrl;
    private String packageState;
    private String packageUpdatedAt;
    private List<Integer> ports = null;
    private String routeMappingsUrl;
    private String routesUrl;
    private String serviceBindingsUrl;
    private String spaceUrl;
    private String stackUrl;
    private String version;
    private Integer logRateLimit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ApplicationEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ApplicationEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.applications.AbstractApplicationEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractApplicationEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof org.cloudfoundry.client.v2.applications._ApplicationEntity) {
        org.cloudfoundry.client.v2.applications._ApplicationEntity instance = (org.cloudfoundry.client.v2.applications._ApplicationEntity) object;
        String spaceUrlValue = instance.getSpaceUrl();
        if (spaceUrlValue != null) {
          spaceUrl(spaceUrlValue);
        }
        String routeMappingsUrlValue = instance.getRouteMappingsUrl();
        if (routeMappingsUrlValue != null) {
          routeMappingsUrl(routeMappingsUrlValue);
        }
        String stackUrlValue = instance.getStackUrl();
        if (stackUrlValue != null) {
          stackUrl(stackUrlValue);
        }
        String detectedBuildpackValue = instance.getDetectedBuildpack();
        if (detectedBuildpackValue != null) {
          detectedBuildpack(detectedBuildpackValue);
        }
        Integer logRateLimitValue = instance.getLogRateLimit();
        if (logRateLimitValue != null) {
          logRateLimit(logRateLimitValue);
        }
        String packageUpdatedAtValue = instance.getPackageUpdatedAt();
        if (packageUpdatedAtValue != null) {
          packageUpdatedAt(packageUpdatedAtValue);
        }
        List<Integer> portsValue = instance.getPorts();
        if (portsValue != null) {
          addAllPorts(portsValue);
        }
        String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
        String routesUrlValue = instance.getRoutesUrl();
        if (routesUrlValue != null) {
          routesUrl(routesUrlValue);
        }
        String serviceBindingsUrlValue = instance.getServiceBindingsUrl();
        if (serviceBindingsUrlValue != null) {
          serviceBindingsUrl(serviceBindingsUrlValue);
        }
        String detectedBuildpackIdValue = instance.getDetectedBuildpackId();
        if (detectedBuildpackIdValue != null) {
          detectedBuildpackId(detectedBuildpackIdValue);
        }
        String eventsUrlValue = instance.getEventsUrl();
        if (eventsUrlValue != null) {
          eventsUrl(eventsUrlValue);
        }
        Boolean enableSshValue = instance.getEnableSsh();
        if (enableSshValue != null) {
          enableSsh(enableSshValue);
        }
        String packageStateValue = instance.getPackageState();
        if (packageStateValue != null) {
          packageState(packageStateValue);
        }
      }
      if (object instanceof AbstractApplicationEntity) {
        AbstractApplicationEntity instance = (AbstractApplicationEntity) object;
        Integer healthCheckTimeoutValue = instance.getHealthCheckTimeout();
        if (healthCheckTimeoutValue != null) {
          healthCheckTimeout(healthCheckTimeoutValue);
        }
        String healthCheckTypeValue = instance.getHealthCheckType();
        if (healthCheckTypeValue != null) {
          healthCheckType(healthCheckTypeValue);
        }
        Boolean consoleValue = instance.getConsole();
        if (consoleValue != null) {
          console(consoleValue);
        }
        String stagingFailedReasonValue = instance.getStagingFailedReason();
        if (stagingFailedReasonValue != null) {
          stagingFailedReason(stagingFailedReasonValue);
        }
        String dockerImageValue = instance.getDockerImage();
        if (dockerImageValue != null) {
          dockerImage(dockerImageValue);
        }
        Integer memoryValue = instance.getMemory();
        if (memoryValue != null) {
          memory(memoryValue);
        }
        String debugValue = instance.getDebug();
        if (debugValue != null) {
          debug(debugValue);
        }
        Integer instancesValue = instance.getInstances();
        if (instancesValue != null) {
          instances(instancesValue);
        }
        Boolean productionValue = instance.getProduction();
        if (productionValue != null) {
          production(productionValue);
        }
        String stackIdValue = instance.getStackId();
        if (stackIdValue != null) {
          stackId(stackIdValue);
        }
        String detectedStartCommandValue = instance.getDetectedStartCommand();
        if (detectedStartCommandValue != null) {
          detectedStartCommand(detectedStartCommandValue);
        }
        DockerCredentials dockerCredentialsValue = instance.getDockerCredentials();
        if (dockerCredentialsValue != null) {
          dockerCredentials(dockerCredentialsValue);
        }
        String buildpackValue = instance.getBuildpack();
        if (buildpackValue != null) {
          buildpack(buildpackValue);
        }
        String stagingFailedDescriptionValue = instance.getStagingFailedDescription();
        if (stagingFailedDescriptionValue != null) {
          stagingFailedDescription(stagingFailedDescriptionValue);
        }
        String commandValue = instance.getCommand();
        if (commandValue != null) {
          command(commandValue);
        }
        String spaceIdValue = instance.getSpaceId();
        if (spaceIdValue != null) {
          spaceId(spaceIdValue);
        }
        String healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint();
        if (healthCheckHttpEndpointValue != null) {
          healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Boolean diegoValue = instance.getDiego();
        if (diegoValue != null) {
          diego(diegoValue);
        }
        Map<String, Object> environmentJsonsValue = instance.getEnvironmentJsons();
        if (environmentJsonsValue != null) {
          putAllEnvironmentJsons(environmentJsonsValue);
        }
        String stateValue = instance.getState();
        if (stateValue != null) {
          state(stateValue);
        }
        String stagingTaskIdValue = instance.getStagingTaskId();
        if (stagingTaskIdValue != null) {
          stagingTaskId(stagingTaskIdValue);
        }
        Integer diskQuotaValue = instance.getDiskQuota();
        if (diskQuotaValue != null) {
          diskQuota(diskQuotaValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("buildpack")
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("command")
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getConsole() console} attribute.
     * @param console The value for console (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("console")
    @Deprecated
    public final Builder console(@Nullable Boolean console) {
      this.console = console;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDebug() debug} attribute.
     * @param debug The value for debug (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("debug")
    @Deprecated
    public final Builder debug(@Nullable String debug) {
      this.debug = debug;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDetectedStartCommand() detectedStartCommand} attribute.
     * @param detectedStartCommand The value for detectedStartCommand (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("detected_start_command")
    public final Builder detectedStartCommand(@Nullable String detectedStartCommand) {
      this.detectedStartCommand = detectedStartCommand;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDiego() diego} attribute.
     * @param diego The value for diego (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("diego")
    public final Builder diego(@Nullable Boolean diego) {
      this.diego = diego;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk_quota")
    public final Builder diskQuota(@Nullable Integer diskQuota) {
      this.diskQuota = diskQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDockerCredentials() dockerCredentials} attribute.
     * @param dockerCredentials The value for dockerCredentials (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("docker_credentials")
    public final Builder dockerCredentials(@Nullable DockerCredentials dockerCredentials) {
      this.dockerCredentials = dockerCredentials;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDockerImage() dockerImage} attribute.
     * @param dockerImage The value for dockerImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("docker_image")
    public final Builder dockerImage(@Nullable String dockerImage) {
      this.dockerImage = dockerImage;
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEntity#getEnvironmentJsons() environmentJsons} map.
     * @param key The key in the environmentJsons map
     * @param value The associated value in the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(String key, Object value) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      this.environmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ApplicationEntity#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ApplicationEntity#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("environment_json")
    public final Builder environmentJsons(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.environmentJsons = null;
        return this;
      }
      this.environmentJsons = new LinkedHashMap<String, Object>();
      return putAllEnvironmentJsons(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ApplicationEntity#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> entries) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.environmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint} attribute.
     * @param healthCheckHttpEndpoint The value for healthCheckHttpEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("health_check_http_endpoint")
    public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getHealthCheckTimeout() healthCheckTimeout} attribute.
     * @param healthCheckTimeout The value for healthCheckTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("health_check_timeout")
    public final Builder healthCheckTimeout(@Nullable Integer healthCheckTimeout) {
      this.healthCheckTimeout = healthCheckTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getHealthCheckType() healthCheckType} attribute.
     * @param healthCheckType The value for healthCheckType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("health_check_type")
    public final Builder healthCheckType(@Nullable String healthCheckType) {
      this.healthCheckType = healthCheckType;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instances")
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory")
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getProduction() production} attribute.
     * @param production The value for production (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("production")
    @Deprecated
    public final Builder production(@Nullable Boolean production) {
      this.production = production;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getStackId() stackId} attribute.
     * @param stackId The value for stackId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stack_guid")
    public final Builder stackId(@Nullable String stackId) {
      this.stackId = stackId;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getStagingFailedDescription() stagingFailedDescription} attribute.
     * @param stagingFailedDescription The value for stagingFailedDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_failed_description")
    public final Builder stagingFailedDescription(@Nullable String stagingFailedDescription) {
      this.stagingFailedDescription = stagingFailedDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getStagingFailedReason() stagingFailedReason} attribute.
     * @param stagingFailedReason The value for stagingFailedReason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_failed_reason")
    public final Builder stagingFailedReason(@Nullable String stagingFailedReason) {
      this.stagingFailedReason = stagingFailedReason;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getStagingTaskId() stagingTaskId} attribute.
     * @param stagingTaskId The value for stagingTaskId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("staging_task_id")
    public final Builder stagingTaskId(@Nullable String stagingTaskId) {
      this.stagingTaskId = stagingTaskId;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDetectedBuildpack() detectedBuildpack} attribute.
     * @param detectedBuildpack The value for detectedBuildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("detected_buildpack")
    public final Builder detectedBuildpack(@Nullable String detectedBuildpack) {
      this.detectedBuildpack = detectedBuildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getDetectedBuildpackId() detectedBuildpackId} attribute.
     * @param detectedBuildpackId The value for detectedBuildpackId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("detected_buildpack_guid")
    public final Builder detectedBuildpackId(@Nullable String detectedBuildpackId) {
      this.detectedBuildpackId = detectedBuildpackId;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getEnableSsh() enableSsh} attribute.
     * @param enableSsh The value for enableSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enable_ssh")
    public final Builder enableSsh(@Nullable Boolean enableSsh) {
      this.enableSsh = enableSsh;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getEventsUrl() eventsUrl} attribute.
     * @param eventsUrl The value for eventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("events_url")
    public final Builder eventsUrl(@Nullable String eventsUrl) {
      this.eventsUrl = eventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getPackageState() packageState} attribute.
     * @param packageState The value for packageState (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("package_state")
    public final Builder packageState(@Nullable String packageState) {
      this.packageState = packageState;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getPackageUpdatedAt() packageUpdatedAt} attribute.
     * @param packageUpdatedAt The value for packageUpdatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("package_updated_at")
    public final Builder packageUpdatedAt(@Nullable String packageUpdatedAt) {
      this.packageUpdatedAt = packageUpdatedAt;
      return this;
    }

    /**
     * Adds one element to {@link ApplicationEntity#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int element) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      this.ports.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ApplicationEntity#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(int... elements) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ApplicationEntity#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ports")
    public final Builder ports(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.ports = null;
        return this;
      }
      this.ports = new ArrayList<Integer>();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link ApplicationEntity#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ports element");
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (Integer element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getRouteMappingsUrl() routeMappingsUrl} attribute.
     * @param routeMappingsUrl The value for routeMappingsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("route_mappings_url")
    public final Builder routeMappingsUrl(@Nullable String routeMappingsUrl) {
      this.routeMappingsUrl = routeMappingsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getRoutesUrl() routesUrl} attribute.
     * @param routesUrl The value for routesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routes_url")
    public final Builder routesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getServiceBindingsUrl() serviceBindingsUrl} attribute.
     * @param serviceBindingsUrl The value for serviceBindingsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_bindings_url")
    public final Builder serviceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getSpaceUrl() spaceUrl} attribute.
     * @param spaceUrl The value for spaceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_url")
    public final Builder spaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getStackUrl() stackUrl} attribute.
     * @param stackUrl The value for stackUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stack_url")
    public final Builder stackUrl(@Nullable String stackUrl) {
      this.stackUrl = stackUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationEntity#getLogRateLimit() logRateLimit} attribute.
     * @param logRateLimit The value for logRateLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("log_rate_limit")
    public final Builder logRateLimit(@Nullable Integer logRateLimit) {
      this.logRateLimit = logRateLimit;
      return this;
    }

    /**
     * Builds a new {@link ApplicationEntity ApplicationEntity}.
     * @return An immutable instance of ApplicationEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationEntity build() {
      return new ApplicationEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
