package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Instance information in Get Application Instance response.
 */
@Generated(from = "_ApplicationInstanceInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplicationInstanceInfo
    extends org.cloudfoundry.client.v2.applications._ApplicationInstanceInfo {
  private final @Nullable String consoleIp;
  private final @Nullable Integer consolePort;
  private final @Nullable String debugIp;
  private final @Nullable Integer debugPort;
  private final @Nullable String details;
  private final @Nullable Double since;
  private final @Nullable String state;
  private final @Nullable Long uptime;
  private final @Nullable String routable;

  private ApplicationInstanceInfo(ApplicationInstanceInfo.Builder builder) {
    this.consoleIp = builder.consoleIp;
    this.consolePort = builder.consolePort;
    this.debugIp = builder.debugIp;
    this.debugPort = builder.debugPort;
    this.details = builder.details;
    this.since = builder.since;
    this.state = builder.state;
    this.uptime = builder.uptime;
    this.routable = builder.routable;
  }

  /**
   * The console IP
   */
  @JsonProperty("console_ip")
  @Override
  public @Nullable String getConsoleIp() {
    return consoleIp;
  }

  /**
   * The console port
   */
  @JsonProperty("console_port")
  @Override
  public @Nullable Integer getConsolePort() {
    return consolePort;
  }

  /**
   * The debug IP
   */
  @JsonProperty("debug_ip")
  @Override
  public @Nullable String getDebugIp() {
    return debugIp;
  }

  /**
   * The debug port
   */
  @JsonProperty("debug_port")
  @Override
  public @Nullable Integer getDebugPort() {
    return debugPort;
  }

  /**
   * The details
   */
  @JsonProperty("details")
  @Override
  public @Nullable String getDetails() {
    return details;
  }

  /**
   * The since
   */
  @JsonProperty("since")
  @Override
  public @Nullable Double getSince() {
    return since;
  }

  /**
   * The state
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * The update
   */
  @JsonProperty("uptime")
  @Override
  public @Nullable Long getUptime() {
    return uptime;
  }

  /**
   * Routable
   */
  @JsonProperty("routable")
  @Override
  public @Nullable String getRoutable() {
    return routable;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationInstanceInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationInstanceInfo
        && equalTo(0, (ApplicationInstanceInfo) another);
  }

  private boolean equalTo(int synthetic, ApplicationInstanceInfo another) {
    return Objects.equals(consoleIp, another.consoleIp)
        && Objects.equals(consolePort, another.consolePort)
        && Objects.equals(debugIp, another.debugIp)
        && Objects.equals(debugPort, another.debugPort)
        && Objects.equals(details, another.details)
        && Objects.equals(since, another.since)
        && Objects.equals(state, another.state)
        && Objects.equals(uptime, another.uptime)
        && Objects.equals(routable, another.routable);
  }

  /**
   * Computes a hash code from attributes: {@code consoleIp}, {@code consolePort}, {@code debugIp}, {@code debugPort}, {@code details}, {@code since}, {@code state}, {@code uptime}, {@code routable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(consoleIp);
    h += (h << 5) + Objects.hashCode(consolePort);
    h += (h << 5) + Objects.hashCode(debugIp);
    h += (h << 5) + Objects.hashCode(debugPort);
    h += (h << 5) + Objects.hashCode(details);
    h += (h << 5) + Objects.hashCode(since);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(uptime);
    h += (h << 5) + Objects.hashCode(routable);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationInstanceInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationInstanceInfo{"
        + "consoleIp=" + consoleIp
        + ", consolePort=" + consolePort
        + ", debugIp=" + debugIp
        + ", debugPort=" + debugPort
        + ", details=" + details
        + ", since=" + since
        + ", state=" + state
        + ", uptime=" + uptime
        + ", routable=" + routable
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ApplicationInstanceInfo", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._ApplicationInstanceInfo {
    String consoleIp;
    Integer consolePort;
    String debugIp;
    Integer debugPort;
    String details;
    Double since;
    String state;
    Long uptime;
    String routable;
    @JsonProperty("console_ip")
    public void setConsoleIp(@Nullable String consoleIp) {
      this.consoleIp = consoleIp;
    }
    @JsonProperty("console_port")
    public void setConsolePort(@Nullable Integer consolePort) {
      this.consolePort = consolePort;
    }
    @JsonProperty("debug_ip")
    public void setDebugIp(@Nullable String debugIp) {
      this.debugIp = debugIp;
    }
    @JsonProperty("debug_port")
    public void setDebugPort(@Nullable Integer debugPort) {
      this.debugPort = debugPort;
    }
    @JsonProperty("details")
    public void setDetails(@Nullable String details) {
      this.details = details;
    }
    @JsonProperty("since")
    public void setSince(@Nullable Double since) {
      this.since = since;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("uptime")
    public void setUptime(@Nullable Long uptime) {
      this.uptime = uptime;
    }
    @JsonProperty("routable")
    public void setRoutable(@Nullable String routable) {
      this.routable = routable;
    }
    @Override
    public String getConsoleIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getConsolePort() { throw new UnsupportedOperationException(); }
    @Override
    public String getDebugIp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDebugPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getDetails() { throw new UnsupportedOperationException(); }
    @Override
    public Double getSince() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public Long getUptime() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationInstanceInfo fromJson(Json json) {
    ApplicationInstanceInfo.Builder builder = ApplicationInstanceInfo.builder();
    if (json.consoleIp != null) {
      builder.consoleIp(json.consoleIp);
    }
    if (json.consolePort != null) {
      builder.consolePort(json.consolePort);
    }
    if (json.debugIp != null) {
      builder.debugIp(json.debugIp);
    }
    if (json.debugPort != null) {
      builder.debugPort(json.debugPort);
    }
    if (json.details != null) {
      builder.details(json.details);
    }
    if (json.since != null) {
      builder.since(json.since);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.uptime != null) {
      builder.uptime(json.uptime);
    }
    if (json.routable != null) {
      builder.routable(json.routable);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationInstanceInfo ApplicationInstanceInfo}.
   * <pre>
   * ApplicationInstanceInfo.builder()
   *    .consoleIp(String | null) // nullable {@link ApplicationInstanceInfo#getConsoleIp() consoleIp}
   *    .consolePort(Integer | null) // nullable {@link ApplicationInstanceInfo#getConsolePort() consolePort}
   *    .debugIp(String | null) // nullable {@link ApplicationInstanceInfo#getDebugIp() debugIp}
   *    .debugPort(Integer | null) // nullable {@link ApplicationInstanceInfo#getDebugPort() debugPort}
   *    .details(String | null) // nullable {@link ApplicationInstanceInfo#getDetails() details}
   *    .since(Double | null) // nullable {@link ApplicationInstanceInfo#getSince() since}
   *    .state(String | null) // nullable {@link ApplicationInstanceInfo#getState() state}
   *    .uptime(Long | null) // nullable {@link ApplicationInstanceInfo#getUptime() uptime}
   *    .routable(String | null) // nullable {@link ApplicationInstanceInfo#getRoutable() routable}
   *    .build();
   * </pre>
   * @return A new ApplicationInstanceInfo builder
   */
  public static ApplicationInstanceInfo.Builder builder() {
    return new ApplicationInstanceInfo.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationInstanceInfo ApplicationInstanceInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplicationInstanceInfo", generator = "Immutables")
  public static final class Builder {
    private String consoleIp;
    private Integer consolePort;
    private String debugIp;
    private Integer debugPort;
    private String details;
    private Double since;
    private String state;
    private Long uptime;
    private String routable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationInstanceInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationInstanceInfo instance) {
      return from((_ApplicationInstanceInfo) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationInstanceInfo} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationInstanceInfo instance) {
      Objects.requireNonNull(instance, "instance");
      String consoleIpValue = instance.getConsoleIp();
      if (consoleIpValue != null) {
        consoleIp(consoleIpValue);
      }
      Integer consolePortValue = instance.getConsolePort();
      if (consolePortValue != null) {
        consolePort(consolePortValue);
      }
      String debugIpValue = instance.getDebugIp();
      if (debugIpValue != null) {
        debugIp(debugIpValue);
      }
      Integer debugPortValue = instance.getDebugPort();
      if (debugPortValue != null) {
        debugPort(debugPortValue);
      }
      String detailsValue = instance.getDetails();
      if (detailsValue != null) {
        details(detailsValue);
      }
      Double sinceValue = instance.getSince();
      if (sinceValue != null) {
        since(sinceValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      Long uptimeValue = instance.getUptime();
      if (uptimeValue != null) {
        uptime(uptimeValue);
      }
      String routableValue = instance.getRoutable();
      if (routableValue != null) {
        routable(routableValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getConsoleIp() consoleIp} attribute.
     * @param consoleIp The value for consoleIp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("console_ip")
    public final Builder consoleIp(@Nullable String consoleIp) {
      this.consoleIp = consoleIp;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getConsolePort() consolePort} attribute.
     * @param consolePort The value for consolePort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("console_port")
    public final Builder consolePort(@Nullable Integer consolePort) {
      this.consolePort = consolePort;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getDebugIp() debugIp} attribute.
     * @param debugIp The value for debugIp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("debug_ip")
    public final Builder debugIp(@Nullable String debugIp) {
      this.debugIp = debugIp;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getDebugPort() debugPort} attribute.
     * @param debugPort The value for debugPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("debug_port")
    public final Builder debugPort(@Nullable Integer debugPort) {
      this.debugPort = debugPort;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getDetails() details} attribute.
     * @param details The value for details (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("details")
    public final Builder details(@Nullable String details) {
      this.details = details;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getSince() since} attribute.
     * @param since The value for since (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("since")
    public final Builder since(@Nullable Double since) {
      this.since = since;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getUptime() uptime} attribute.
     * @param uptime The value for uptime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("uptime")
    public final Builder uptime(@Nullable Long uptime) {
      this.uptime = uptime;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInstanceInfo#getRoutable() routable} attribute.
     * @param routable The value for routable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routable")
    public final Builder routable(@Nullable String routable) {
      this.routable = routable;
      return this;
    }

    /**
     * Builds a new {@link ApplicationInstanceInfo ApplicationInstanceInfo}.
     * @return An immutable instance of ApplicationInstanceInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationInstanceInfo build() {
      return new ApplicationInstanceInfo(this);
    }
  }
}
