package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the v2 Create Application request
 */
@Generated(from = "_CreateApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateApplicationRequest
    extends org.cloudfoundry.client.v2.applications._CreateApplicationRequest {
  private final @Nullable String buildpack;
  private final @Nullable String command;
  private final @Nullable Boolean console;
  private final @Nullable String debug;
  private final @Nullable String detectedStartCommand;
  private final @Nullable Boolean diego;
  private final @Nullable Integer diskQuota;
  private final @Nullable DockerCredentials dockerCredentials;
  private final @Nullable String dockerImage;
  private final @Nullable Boolean enableSsh;
  private final @Nullable Map<String, Object> environmentJsons;
  private final @Nullable String healthCheckHttpEndpoint;
  private final @Nullable Integer healthCheckTimeout;
  private final @Nullable String healthCheckType;
  private final @Nullable Integer instances;
  private final @Nullable Integer memory;
  private final String name;
  private final @Nullable List<Integer> ports;
  private final @Nullable Boolean production;
  private final String spaceId;
  private final @Nullable String stackId;
  private final @Nullable String state;

  private CreateApplicationRequest(CreateApplicationRequest.Builder builder) {
    this.buildpack = builder.buildpack;
    this.command = builder.command;
    this.console = builder.console;
    this.debug = builder.debug;
    this.detectedStartCommand = builder.detectedStartCommand;
    this.diego = builder.diego;
    this.diskQuota = builder.diskQuota;
    this.dockerCredentials = builder.dockerCredentials;
    this.dockerImage = builder.dockerImage;
    this.enableSsh = builder.enableSsh;
    this.environmentJsons = builder.environmentJsons == null ? null : createUnmodifiableMap(false, false, builder.environmentJsons);
    this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
    this.healthCheckTimeout = builder.healthCheckTimeout;
    this.healthCheckType = builder.healthCheckType;
    this.instances = builder.instances;
    this.memory = builder.memory;
    this.name = builder.name;
    this.ports = builder.ports == null ? null : createUnmodifiableList(true, builder.ports);
    this.production = builder.production;
    this.spaceId = builder.spaceId;
    this.stackId = builder.stackId;
    this.state = builder.state;
  }

  /**
   * Buildpack to build the application
   */
  @JsonProperty("buildpack")
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * The command to start the application after it is staged
   */
  @JsonProperty("command")
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * Open the console port for the application (at $CONSOLE_PORT)
   */
  @JsonProperty("console")
  @Deprecated
  @Override
  public @Nullable Boolean getConsole() {
    return console;
  }

  /**
   * Open the debug port for the application (at $DEBUG_PORT)
   */
  @JsonProperty("debug")
  @Deprecated
  @Override
  public @Nullable String getDebug() {
    return debug;
  }

  /**
   * The command detected by the buildpack during staging
   */
  @JsonProperty("detected_start_command")
  @Override
  public @Nullable String getDetectedStartCommand() {
    return detectedStartCommand;
  }

  /**
   * Use diego to stage and to run when available
   */
  @JsonProperty("diego")
  @Override
  public @Nullable Boolean getDiego() {
    return diego;
  }

  /**
   * The maximum amount of disk available to an instance of an application. In megabytes.
   */
  @JsonProperty("disk_quota")
  @Override
  public @Nullable Integer getDiskQuota() {
    return diskQuota;
  }

  /**
   * Docker credentials for pulling docker image
   */
  @JsonProperty("docker_credentials")
  @Override
  public @Nullable DockerCredentials getDockerCredentials() {
    return dockerCredentials;
  }

  /**
   * Name of the Docker image containing the application
   */
  @JsonProperty("docker_image")
  @Override
  public @Nullable String getDockerImage() {
    return dockerImage;
  }

  /**
   * Enable SSHing into the application
   */
  @JsonProperty("enable_ssh")
  @Override
  public @Nullable Boolean getEnableSsh() {
    return enableSsh;
  }

  /**
   * Key/value pairs of all the environment variables to run in your application. Does not include any system or service variables.
   */
  @JsonProperty("environment_json")
  @Override
  public @Nullable Map<String, Object> getEnvironmentJsons() {
    return environmentJsons;
  }

  /**
   * The HTTP endpoint to check for health
   */
  @JsonProperty("health_check_http_endpoint")
  @Override
  public @Nullable String getHealthCheckHttpEndpoint() {
    return healthCheckHttpEndpoint;
  }

  /**
   * Timeout for health checking of an staged applcation when starting up
   */
  @JsonProperty("health_check_timeout")
  @Override
  public @Nullable Integer getHealthCheckTimeout() {
    return healthCheckTimeout;
  }

  /**
   * Type of health check to perform
   */
  @JsonProperty("health_check_type")
  @Override
  public @Nullable String getHealthCheckType() {
    return healthCheckType;
  }

  /**
   * The number of instances of the application to run. To ensure optimal availability, ensure there are at least 2 instances.
   */
  @JsonProperty("instances")
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The amount of memory each instance should have. In megabytes.
   */
  @JsonProperty("memory")
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The name of the application
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The ports on which the application may listen
   */
  @JsonProperty("ports")
  @Override
  public @Nullable List<Integer> getPorts() {
    return ports;
  }

  /**
   * Whether to open the production port
   */
  @JsonProperty("production")
  @Deprecated
  @Override
  public @Nullable Boolean getProduction() {
    return production;
  }

  /**
   * The id of the associated space
   */
  @JsonProperty("space_guid")
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The id of the associated stack
   */
  @JsonProperty("stack_guid")
  @Override
  public @Nullable String getStackId() {
    return stackId;
  }

  /**
   * The current desired state of the application
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code CreateApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateApplicationRequest
        && equalTo(0, (CreateApplicationRequest) another);
  }

  private boolean equalTo(int synthetic, CreateApplicationRequest another) {
    return Objects.equals(buildpack, another.buildpack)
        && Objects.equals(command, another.command)
        && Objects.equals(console, another.console)
        && Objects.equals(debug, another.debug)
        && Objects.equals(detectedStartCommand, another.detectedStartCommand)
        && Objects.equals(diego, another.diego)
        && Objects.equals(diskQuota, another.diskQuota)
        && Objects.equals(dockerCredentials, another.dockerCredentials)
        && Objects.equals(dockerImage, another.dockerImage)
        && Objects.equals(enableSsh, another.enableSsh)
        && Objects.equals(environmentJsons, another.environmentJsons)
        && Objects.equals(healthCheckHttpEndpoint, another.healthCheckHttpEndpoint)
        && Objects.equals(healthCheckTimeout, another.healthCheckTimeout)
        && Objects.equals(healthCheckType, another.healthCheckType)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memory, another.memory)
        && name.equals(another.name)
        && Objects.equals(ports, another.ports)
        && Objects.equals(production, another.production)
        && spaceId.equals(another.spaceId)
        && Objects.equals(stackId, another.stackId)
        && Objects.equals(state, another.state);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code command}, {@code console}, {@code debug}, {@code detectedStartCommand}, {@code diego}, {@code diskQuota}, {@code dockerCredentials}, {@code dockerImage}, {@code enableSsh}, {@code environmentJsons}, {@code healthCheckHttpEndpoint}, {@code healthCheckTimeout}, {@code healthCheckType}, {@code instances}, {@code memory}, {@code name}, {@code ports}, {@code production}, {@code spaceId}, {@code stackId}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpack);
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(console);
    h += (h << 5) + Objects.hashCode(debug);
    h += (h << 5) + Objects.hashCode(detectedStartCommand);
    h += (h << 5) + Objects.hashCode(diego);
    h += (h << 5) + Objects.hashCode(diskQuota);
    h += (h << 5) + Objects.hashCode(dockerCredentials);
    h += (h << 5) + Objects.hashCode(dockerImage);
    h += (h << 5) + Objects.hashCode(enableSsh);
    h += (h << 5) + Objects.hashCode(environmentJsons);
    h += (h << 5) + Objects.hashCode(healthCheckHttpEndpoint);
    h += (h << 5) + Objects.hashCode(healthCheckTimeout);
    h += (h << 5) + Objects.hashCode(healthCheckType);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(ports);
    h += (h << 5) + Objects.hashCode(production);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + Objects.hashCode(stackId);
    h += (h << 5) + Objects.hashCode(state);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateApplicationRequest{"
        + "buildpack=" + buildpack
        + ", command=" + command
        + ", console=" + console
        + ", debug=" + debug
        + ", detectedStartCommand=" + detectedStartCommand
        + ", diego=" + diego
        + ", diskQuota=" + diskQuota
        + ", dockerCredentials=" + dockerCredentials
        + ", dockerImage=" + dockerImage
        + ", enableSsh=" + enableSsh
        + ", environmentJsons=" + environmentJsons
        + ", healthCheckHttpEndpoint=" + healthCheckHttpEndpoint
        + ", healthCheckTimeout=" + healthCheckTimeout
        + ", healthCheckType=" + healthCheckType
        + ", instances=" + instances
        + ", memory=" + memory
        + ", name=" + name
        + ", ports=" + ports
        + ", production=" + production
        + ", spaceId=" + spaceId
        + ", stackId=" + stackId
        + ", state=" + state
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateApplicationRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._CreateApplicationRequest {
    String buildpack;
    String command;
    Boolean console;
    String debug;
    String detectedStartCommand;
    Boolean diego;
    Integer diskQuota;
    DockerCredentials dockerCredentials;
    String dockerImage;
    Boolean enableSsh;
    Map<String, Object> environmentJsons = null;
    String healthCheckHttpEndpoint;
    Integer healthCheckTimeout;
    String healthCheckType;
    Integer instances;
    Integer memory;
    String name;
    List<Integer> ports = null;
    Boolean production;
    String spaceId;
    String stackId;
    String state;
    @JsonProperty("buildpack")
    public void setBuildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
    }
    @JsonProperty("command")
    public void setCommand(@Nullable String command) {
      this.command = command;
    }
    @JsonProperty("console")
    public void setConsole(@Nullable Boolean console) {
      this.console = console;
    }
    @JsonProperty("debug")
    public void setDebug(@Nullable String debug) {
      this.debug = debug;
    }
    @JsonProperty("detected_start_command")
    public void setDetectedStartCommand(@Nullable String detectedStartCommand) {
      this.detectedStartCommand = detectedStartCommand;
    }
    @JsonProperty("diego")
    public void setDiego(@Nullable Boolean diego) {
      this.diego = diego;
    }
    @JsonProperty("disk_quota")
    public void setDiskQuota(@Nullable Integer diskQuota) {
      this.diskQuota = diskQuota;
    }
    @JsonProperty("docker_credentials")
    public void setDockerCredentials(@Nullable DockerCredentials dockerCredentials) {
      this.dockerCredentials = dockerCredentials;
    }
    @JsonProperty("docker_image")
    public void setDockerImage(@Nullable String dockerImage) {
      this.dockerImage = dockerImage;
    }
    @JsonProperty("enable_ssh")
    public void setEnableSsh(@Nullable Boolean enableSsh) {
      this.enableSsh = enableSsh;
    }
    @JsonProperty("environment_json")
    public void setEnvironmentJsons(@Nullable Map<String, Object> environmentJsons) {
      this.environmentJsons = environmentJsons;
    }
    @JsonProperty("health_check_http_endpoint")
    public void setHealthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
    }
    @JsonProperty("health_check_timeout")
    public void setHealthCheckTimeout(@Nullable Integer healthCheckTimeout) {
      this.healthCheckTimeout = healthCheckTimeout;
    }
    @JsonProperty("health_check_type")
    public void setHealthCheckType(@Nullable String healthCheckType) {
      this.healthCheckType = healthCheckType;
    }
    @JsonProperty("instances")
    public void setInstances(@Nullable Integer instances) {
      this.instances = instances;
    }
    @JsonProperty("memory")
    public void setMemory(@Nullable Integer memory) {
      this.memory = memory;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("ports")
    public void setPorts(@Nullable List<Integer> ports) {
      this.ports = ports;
    }
    @JsonProperty("production")
    public void setProduction(@Nullable Boolean production) {
      this.production = production;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("stack_guid")
    public void setStackId(@Nullable String stackId) {
      this.stackId = stackId;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @Override
    public String getBuildpack() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getConsole() { throw new UnsupportedOperationException(); }
    @Override
    public String getDebug() { throw new UnsupportedOperationException(); }
    @Override
    public String getDetectedStartCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDiego() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskQuota() { throw new UnsupportedOperationException(); }
    @Override
    public DockerCredentials getDockerCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getDockerImage() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEnableSsh() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getEnvironmentJsons() { throw new UnsupportedOperationException(); }
    @Override
    public String getHealthCheckHttpEndpoint() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getHealthCheckTimeout() { throw new UnsupportedOperationException(); }
    @Override
    public String getHealthCheckType() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemory() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<Integer> getPorts() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getProduction() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getStackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateApplicationRequest fromJson(Json json) {
    CreateApplicationRequest.Builder builder = CreateApplicationRequest.builder();
    if (json.buildpack != null) {
      builder.buildpack(json.buildpack);
    }
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.console != null) {
      builder.console(json.console);
    }
    if (json.debug != null) {
      builder.debug(json.debug);
    }
    if (json.detectedStartCommand != null) {
      builder.detectedStartCommand(json.detectedStartCommand);
    }
    if (json.diego != null) {
      builder.diego(json.diego);
    }
    if (json.diskQuota != null) {
      builder.diskQuota(json.diskQuota);
    }
    if (json.dockerCredentials != null) {
      builder.dockerCredentials(json.dockerCredentials);
    }
    if (json.dockerImage != null) {
      builder.dockerImage(json.dockerImage);
    }
    if (json.enableSsh != null) {
      builder.enableSsh(json.enableSsh);
    }
    if (json.environmentJsons != null) {
      builder.putAllEnvironmentJsons(json.environmentJsons);
    }
    if (json.healthCheckHttpEndpoint != null) {
      builder.healthCheckHttpEndpoint(json.healthCheckHttpEndpoint);
    }
    if (json.healthCheckTimeout != null) {
      builder.healthCheckTimeout(json.healthCheckTimeout);
    }
    if (json.healthCheckType != null) {
      builder.healthCheckType(json.healthCheckType);
    }
    if (json.instances != null) {
      builder.instances(json.instances);
    }
    if (json.memory != null) {
      builder.memory(json.memory);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.ports != null) {
      builder.addAllPorts(json.ports);
    }
    if (json.production != null) {
      builder.production(json.production);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.stackId != null) {
      builder.stackId(json.stackId);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateApplicationRequest CreateApplicationRequest}.
   * <pre>
   * CreateApplicationRequest.builder()
   *    .buildpack(String | null) // nullable {@link CreateApplicationRequest#getBuildpack() buildpack}
   *    .command(String | null) // nullable {@link CreateApplicationRequest#getCommand() command}
   *    .console(Boolean | null) // nullable {@link CreateApplicationRequest#getConsole() console}
   *    .debug(String | null) // nullable {@link CreateApplicationRequest#getDebug() debug}
   *    .detectedStartCommand(String | null) // nullable {@link CreateApplicationRequest#getDetectedStartCommand() detectedStartCommand}
   *    .diego(Boolean | null) // nullable {@link CreateApplicationRequest#getDiego() diego}
   *    .diskQuota(Integer | null) // nullable {@link CreateApplicationRequest#getDiskQuota() diskQuota}
   *    .dockerCredentials(org.cloudfoundry.client.v2.applications.DockerCredentials | null) // nullable {@link CreateApplicationRequest#getDockerCredentials() dockerCredentials}
   *    .dockerImage(String | null) // nullable {@link CreateApplicationRequest#getDockerImage() dockerImage}
   *    .enableSsh(Boolean | null) // nullable {@link CreateApplicationRequest#getEnableSsh() enableSsh}
   *    .environmentJsons(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link CreateApplicationRequest#getEnvironmentJsons() environmentJsons}
   *    .healthCheckHttpEndpoint(String | null) // nullable {@link CreateApplicationRequest#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint}
   *    .healthCheckTimeout(Integer | null) // nullable {@link CreateApplicationRequest#getHealthCheckTimeout() healthCheckTimeout}
   *    .healthCheckType(String | null) // nullable {@link CreateApplicationRequest#getHealthCheckType() healthCheckType}
   *    .instances(Integer | null) // nullable {@link CreateApplicationRequest#getInstances() instances}
   *    .memory(Integer | null) // nullable {@link CreateApplicationRequest#getMemory() memory}
   *    .name(String) // required {@link CreateApplicationRequest#getName() name}
   *    .ports(List&amp;lt;Integer&amp;gt; | null) // nullable {@link CreateApplicationRequest#getPorts() ports}
   *    .production(Boolean | null) // nullable {@link CreateApplicationRequest#getProduction() production}
   *    .spaceId(String) // required {@link CreateApplicationRequest#getSpaceId() spaceId}
   *    .stackId(String | null) // nullable {@link CreateApplicationRequest#getStackId() stackId}
   *    .state(String | null) // nullable {@link CreateApplicationRequest#getState() state}
   *    .build();
   * </pre>
   * @return A new CreateApplicationRequest builder
   */
  public static CreateApplicationRequest.Builder builder() {
    return new CreateApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateApplicationRequest CreateApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String buildpack;
    private String command;
    private Boolean console;
    private String debug;
    private String detectedStartCommand;
    private Boolean diego;
    private Integer diskQuota;
    private DockerCredentials dockerCredentials;
    private String dockerImage;
    private Boolean enableSsh;
    private Map<String, Object> environmentJsons = null;
    private String healthCheckHttpEndpoint;
    private Integer healthCheckTimeout;
    private String healthCheckType;
    private Integer instances;
    private Integer memory;
    private String name;
    private List<Integer> ports = null;
    private Boolean production;
    private String spaceId;
    private String stackId;
    private String state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateApplicationRequest instance) {
      return from((_CreateApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String buildpackValue = instance.getBuildpack();
      if (buildpackValue != null) {
        buildpack(buildpackValue);
      }
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      Boolean consoleValue = instance.getConsole();
      if (consoleValue != null) {
        console(consoleValue);
      }
      String debugValue = instance.getDebug();
      if (debugValue != null) {
        debug(debugValue);
      }
      String detectedStartCommandValue = instance.getDetectedStartCommand();
      if (detectedStartCommandValue != null) {
        detectedStartCommand(detectedStartCommandValue);
      }
      Boolean diegoValue = instance.getDiego();
      if (diegoValue != null) {
        diego(diegoValue);
      }
      Integer diskQuotaValue = instance.getDiskQuota();
      if (diskQuotaValue != null) {
        diskQuota(diskQuotaValue);
      }
      DockerCredentials dockerCredentialsValue = instance.getDockerCredentials();
      if (dockerCredentialsValue != null) {
        dockerCredentials(dockerCredentialsValue);
      }
      String dockerImageValue = instance.getDockerImage();
      if (dockerImageValue != null) {
        dockerImage(dockerImageValue);
      }
      Boolean enableSshValue = instance.getEnableSsh();
      if (enableSshValue != null) {
        enableSsh(enableSshValue);
      }
      Map<String, Object> environmentJsonsValue = instance.getEnvironmentJsons();
      if (environmentJsonsValue != null) {
        putAllEnvironmentJsons(environmentJsonsValue);
      }
      String healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint();
      if (healthCheckHttpEndpointValue != null) {
        healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
      }
      Integer healthCheckTimeoutValue = instance.getHealthCheckTimeout();
      if (healthCheckTimeoutValue != null) {
        healthCheckTimeout(healthCheckTimeoutValue);
      }
      String healthCheckTypeValue = instance.getHealthCheckType();
      if (healthCheckTypeValue != null) {
        healthCheckType(healthCheckTypeValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      this.name(instance.getName());
      List<Integer> portsValue = instance.getPorts();
      if (portsValue != null) {
        addAllPorts(portsValue);
      }
      Boolean productionValue = instance.getProduction();
      if (productionValue != null) {
        production(productionValue);
      }
      this.spaceId(instance.getSpaceId());
      String stackIdValue = instance.getStackId();
      if (stackIdValue != null) {
        stackId(stackIdValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getConsole() console} attribute.
     * @param console The value for console (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder console(@Nullable Boolean console) {
      this.console = console;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getDebug() debug} attribute.
     * @param debug The value for debug (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder debug(@Nullable String debug) {
      this.debug = debug;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getDetectedStartCommand() detectedStartCommand} attribute.
     * @param detectedStartCommand The value for detectedStartCommand (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder detectedStartCommand(@Nullable String detectedStartCommand) {
      this.detectedStartCommand = detectedStartCommand;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getDiego() diego} attribute.
     * @param diego The value for diego (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diego(@Nullable Boolean diego) {
      this.diego = diego;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(@Nullable Integer diskQuota) {
      this.diskQuota = diskQuota;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getDockerCredentials() dockerCredentials} attribute.
     * @param dockerCredentials The value for dockerCredentials (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerCredentials(@Nullable DockerCredentials dockerCredentials) {
      this.dockerCredentials = dockerCredentials;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getDockerImage() dockerImage} attribute.
     * @param dockerImage The value for dockerImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerImage(@Nullable String dockerImage) {
      this.dockerImage = dockerImage;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getEnableSsh() enableSsh} attribute.
     * @param enableSsh The value for enableSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableSsh(@Nullable Boolean enableSsh) {
      this.enableSsh = enableSsh;
      return this;
    }

    /**
     * Put one entry to the {@link CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map.
     * @param key The key in the environmentJsons map
     * @param value The associated value in the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(String key, Object value) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      this.environmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJsons(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.environmentJsons = null;
        return this;
      }
      this.environmentJsons = new LinkedHashMap<String, Object>();
      return putAllEnvironmentJsons(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> entries) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.environmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint} attribute.
     * @param healthCheckHttpEndpoint The value for healthCheckHttpEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getHealthCheckTimeout() healthCheckTimeout} attribute.
     * @param healthCheckTimeout The value for healthCheckTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckTimeout(@Nullable Integer healthCheckTimeout) {
      this.healthCheckTimeout = healthCheckTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getHealthCheckType() healthCheckType} attribute.
     * @param healthCheckType The value for healthCheckType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckType(@Nullable String healthCheckType) {
      this.healthCheckType = healthCheckType;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link CreateApplicationRequest#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int element) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      this.ports.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateApplicationRequest#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(int... elements) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateApplicationRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.ports = null;
        return this;
      }
      this.ports = new ArrayList<Integer>();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link CreateApplicationRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ports element");
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (Integer element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getProduction() production} attribute.
     * @param production The value for production (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder production(@Nullable Boolean production) {
      this.production = production;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getStackId() stackId} attribute.
     * @param stackId The value for stackId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(@Nullable String stackId) {
      this.stackId = stackId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Builds a new {@link CreateApplicationRequest CreateApplicationRequest}.
     * @return An immutable instance of CreateApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
