package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Application operation.
 */
@Generated(from = "_DeleteApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteApplicationRequest
    extends org.cloudfoundry.client.v2.applications._DeleteApplicationRequest {
  private final String applicationId;

  private DeleteApplicationRequest(DeleteApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteApplicationRequest
        && equalTo(0, (DeleteApplicationRequest) another);
  }

  private boolean equalTo(int synthetic, DeleteApplicationRequest another) {
    return applicationId.equals(another.applicationId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteApplicationRequest{"
        + "applicationId=" + applicationId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteApplicationRequest DeleteApplicationRequest}.
   * <pre>
   * DeleteApplicationRequest.builder()
   *    .applicationId(String) // required {@link DeleteApplicationRequest#getApplicationId() applicationId}
   *    .build();
   * </pre>
   * @return A new DeleteApplicationRequest builder
   */
  public static DeleteApplicationRequest.Builder builder() {
    return new DeleteApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteApplicationRequest DeleteApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteApplicationRequest instance) {
      return from((_DeleteApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.applicationId(instance.getApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteApplicationRequest DeleteApplicationRequest}.
     * @return An immutable instance of DeleteApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build DeleteApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
