package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Application instance usage info
 */
@Generated(from = "_Usage", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Usage extends org.cloudfoundry.client.v2.applications._Usage {
  private final @Nullable Double cpu;
  private final @Nullable Double cpuEntitlement;
  private final @Nullable Long disk;
  private final @Nullable Long memory;
  private final @Nullable String time;
  private final @Nullable Integer logRate;

  private Usage(Usage.Builder builder) {
    this.cpu = builder.cpu;
    this.cpuEntitlement = builder.cpuEntitlement;
    this.disk = builder.disk;
    this.memory = builder.memory;
    this.time = builder.time;
    this.logRate = builder.logRate;
  }

  /**
   * The CPU usage
   */
  @JsonProperty("cpu")
  @Override
  public @Nullable Double getCpu() {
    return cpu;
  }

  /**
   * The CPU entitlement
   */
  @JsonProperty("cpu_entitlement")
  @Override
  public @Nullable Double getCpuEntitlement() {
    return cpuEntitlement;
  }

  /**
   * The disk usage
   */
  @JsonProperty("disk")
  @Override
  public @Nullable Long getDisk() {
    return disk;
  }

  /**
   * The memory usage
   */
  @JsonProperty("mem")
  @Override
  public @Nullable Long getMemory() {
    return memory;
  }

  /**
   * The time since start
   */
  @JsonProperty("time")
  @Override
  public @Nullable String getTime() {
    return time;
  }

  /**
   * The log rate limit
   */
  @JsonProperty("log_rate")
  @Override
  public @Nullable Integer getLogRate() {
    return logRate;
  }

  /**
   * This instance is equal to all instances of {@code Usage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Usage
        && equalTo(0, (Usage) another);
  }

  private boolean equalTo(int synthetic, Usage another) {
    return Objects.equals(cpu, another.cpu)
        && Objects.equals(cpuEntitlement, another.cpuEntitlement)
        && Objects.equals(disk, another.disk)
        && Objects.equals(memory, another.memory)
        && Objects.equals(time, another.time)
        && Objects.equals(logRate, another.logRate);
  }

  /**
   * Computes a hash code from attributes: {@code cpu}, {@code cpuEntitlement}, {@code disk}, {@code memory}, {@code time}, {@code logRate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(cpu);
    h += (h << 5) + Objects.hashCode(cpuEntitlement);
    h += (h << 5) + Objects.hashCode(disk);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + Objects.hashCode(time);
    h += (h << 5) + Objects.hashCode(logRate);
    return h;
  }

  /**
   * Prints the immutable value {@code Usage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Usage{"
        + "cpu=" + cpu
        + ", cpuEntitlement=" + cpuEntitlement
        + ", disk=" + disk
        + ", memory=" + memory
        + ", time=" + time
        + ", logRate=" + logRate
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Usage", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._Usage {
    Double cpu;
    Double cpuEntitlement;
    Long disk;
    Long memory;
    String time;
    Integer logRate;
    @JsonProperty("cpu")
    public void setCpu(@Nullable Double cpu) {
      this.cpu = cpu;
    }
    @JsonProperty("cpu_entitlement")
    public void setCpuEntitlement(@Nullable Double cpuEntitlement) {
      this.cpuEntitlement = cpuEntitlement;
    }
    @JsonProperty("disk")
    public void setDisk(@Nullable Long disk) {
      this.disk = disk;
    }
    @JsonProperty("mem")
    public void setMemory(@Nullable Long memory) {
      this.memory = memory;
    }
    @JsonProperty("time")
    public void setTime(@Nullable String time) {
      this.time = time;
    }
    @JsonProperty("log_rate")
    public void setLogRate(@Nullable Integer logRate) {
      this.logRate = logRate;
    }
    @Override
    public Double getCpu() { throw new UnsupportedOperationException(); }
    @Override
    public Double getCpuEntitlement() { throw new UnsupportedOperationException(); }
    @Override
    public Long getDisk() { throw new UnsupportedOperationException(); }
    @Override
    public Long getMemory() { throw new UnsupportedOperationException(); }
    @Override
    public String getTime() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getLogRate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Usage fromJson(Json json) {
    Usage.Builder builder = Usage.builder();
    if (json.cpu != null) {
      builder.cpu(json.cpu);
    }
    if (json.cpuEntitlement != null) {
      builder.cpuEntitlement(json.cpuEntitlement);
    }
    if (json.disk != null) {
      builder.disk(json.disk);
    }
    if (json.memory != null) {
      builder.memory(json.memory);
    }
    if (json.time != null) {
      builder.time(json.time);
    }
    if (json.logRate != null) {
      builder.logRate(json.logRate);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Usage Usage}.
   * <pre>
   * Usage.builder()
   *    .cpu(Double | null) // nullable {@link Usage#getCpu() cpu}
   *    .cpuEntitlement(Double | null) // nullable {@link Usage#getCpuEntitlement() cpuEntitlement}
   *    .disk(Long | null) // nullable {@link Usage#getDisk() disk}
   *    .memory(Long | null) // nullable {@link Usage#getMemory() memory}
   *    .time(String | null) // nullable {@link Usage#getTime() time}
   *    .logRate(Integer | null) // nullable {@link Usage#getLogRate() logRate}
   *    .build();
   * </pre>
   * @return A new Usage builder
   */
  public static Usage.Builder builder() {
    return new Usage.Builder();
  }

  /**
   * Builds instances of type {@link Usage Usage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Usage", generator = "Immutables")
  public static final class Builder {
    private Double cpu;
    private Double cpuEntitlement;
    private Long disk;
    private Long memory;
    private String time;
    private Integer logRate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Usage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Usage instance) {
      return from((_Usage) instance);
    }

    /**
     * Copy abstract value type {@code _Usage} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Usage instance) {
      Objects.requireNonNull(instance, "instance");
      Double cpuValue = instance.getCpu();
      if (cpuValue != null) {
        cpu(cpuValue);
      }
      Double cpuEntitlementValue = instance.getCpuEntitlement();
      if (cpuEntitlementValue != null) {
        cpuEntitlement(cpuEntitlementValue);
      }
      Long diskValue = instance.getDisk();
      if (diskValue != null) {
        disk(diskValue);
      }
      Long memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      String timeValue = instance.getTime();
      if (timeValue != null) {
        time(timeValue);
      }
      Integer logRateValue = instance.getLogRate();
      if (logRateValue != null) {
        logRate(logRateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Usage#getCpu() cpu} attribute.
     * @param cpu The value for cpu (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cpu")
    public final Builder cpu(@Nullable Double cpu) {
      this.cpu = cpu;
      return this;
    }

    /**
     * Initializes the value for the {@link Usage#getCpuEntitlement() cpuEntitlement} attribute.
     * @param cpuEntitlement The value for cpuEntitlement (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cpu_entitlement")
    public final Builder cpuEntitlement(@Nullable Double cpuEntitlement) {
      this.cpuEntitlement = cpuEntitlement;
      return this;
    }

    /**
     * Initializes the value for the {@link Usage#getDisk() disk} attribute.
     * @param disk The value for disk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk")
    public final Builder disk(@Nullable Long disk) {
      this.disk = disk;
      return this;
    }

    /**
     * Initializes the value for the {@link Usage#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mem")
    public final Builder memory(@Nullable Long memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link Usage#getTime() time} attribute.
     * @param time The value for time (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("time")
    public final Builder time(@Nullable String time) {
      this.time = time;
      return this;
    }

    /**
     * Initializes the value for the {@link Usage#getLogRate() logRate} attribute.
     * @param logRate The value for logRate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("log_rate")
    public final Builder logRate(@Nullable Integer logRate) {
      this.logRate = logRate;
      return this;
    }

    /**
     * Builds a new {@link Usage Usage}.
     * @return An immutable instance of Usage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Usage build() {
      return new Usage(this);
    }
  }
}
